/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import aliview.AliViewWindow;
import aliview.MemoryUtils;
import aliview.gui.AliViewJMenuBarFactory;
import aliview.messenges.Messenger;
import aliview.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import utils.DialogUtils;
import utils.FileUtilities;
import utils.OSNativeUtils;

public class AliView
implements ApplicationListener {
    private static final String LF = System.getProperty("line.separator");
    private static final AliViewJMenuBarFactory menuBarFactory = new AliViewJMenuBarFactory();
    private static AliView aliView;
    private static ArrayList<AliViewWindow> aliViewWindows;
    private static AliViewWindow activeWindow;
    private static final Logger logger;
    private static File savedInitialArgumentAlignmentForMac;
    private static boolean debugMode;

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        Logger.getRootLogger().setLevel(Level.ALL);
        AliView.logAllLogs();
        long time = AliView.getTime(AliView.class);
        logger.info("version time " + new Date(time));
        System.out.println("Time to here in ms = " + (System.currentTimeMillis() - startTime));
        Properties props = System.getProperties();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] value = (String[])props.get(key);
            logger.debug(key + "=" + (String)value);
        }
        try {
            Object fontObj;
            boolean hasDebugArg = false;
            if (args != null && args.length >= 1) {
                for (String arg : args) {
                    if (!"debug".equalsIgnoreCase(arg)) continue;
                    hasDebugArg = true;
                }
            }
            String debugEnv = System.getenv("ALIVIEW_DEBUG");
            logger.info("debugEnv" + debugEnv);
            debugEnv = null;
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    e.printStackTrace();
                    if (e instanceof OutOfMemoryError) {
                        Messenger.showOKOnlyMessage(Messenger.OUT_OF_MEMORY_ERROR, activeWindow);
                    }
                }
            });
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = bean.getInputArguments();
            for (int i = 0; i < aList.size(); ++i) {
                logger.info("" + aList.get(i));
            }
            logger.info(" " + System.getProperty("sun.java.command"));
            logger.info("java.vendor" + System.getProperty("java.vendor"));
            logger.info("java.version" + System.getProperty("java.version"));
            if (args != null) {
                logger.info("args.length=" + args.length);
                for (String arg : args) {
                    logger.info("arg=" + arg);
                }
            } else {
                logger.info("args(null)=" + args);
            }
            if (hasDebugArg || debugEnv != null) {
                AliView.setDebug(true);
            } else {
                AliView.setDebug(false);
            }
            ToolTipManager.sharedInstance().setInitialDelay(100);
            ToolTipManager.sharedInstance().setDismissDelay(3000);
            if (OSNativeUtils.isMac()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "AliView");
                logger.info("apple.awt.antialiasing" + System.getProperty("apple.awt.antialiasing"));
                logger.info("apple.awt.graphics.UseQuartz" + System.getProperty("apple.awt.graphics.UseQuartz"));
                logger.info("apple.awt.graphics.EnableQ2DX" + System.getProperty("apple.awt.graphics.EnableQ2DX"));
                logger.info("apple.awt.rendering" + System.getProperty("apple.awt.rendering"));
                logger.info("apple.awt.antialiasing" + System.getProperty("apple.awt.antialiasing"));
                logger.info("apple.awt.graphics.UseQuartz" + System.getProperty("apple.awt.graphics.UseQuartz"));
                logger.info("apple.awt.graphics.EnableQ2DX" + System.getProperty("apple.awt.graphics.EnableQ2DX"));
                logger.info("apple.awt.rendering" + System.getProperty("apple.awt.rendering"));
            } else if (OSNativeUtils.isLinuxOrUnix()) {
                try {
                    boolean uiFound = false;
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        uiFound = true;
                        break;
                    }
                    if (!uiFound) {
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!"com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(info.getClassName())) continue;
                            UIManager.setLookAndFeel(info.getClassName());
                            OSNativeUtils.installGtkPopupBugWorkaround();
                            uiFound = true;
                            break;
                        }
                    }
                    if (!uiFound) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        uiFound = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Settings.getUseCustomFontSize().getBooleanValue()) {
                logger.info("user font size");
                float userSize = Settings.getCustomFontSize().getIntValue();
                Object obj = UIManager.getLookAndFeelDefaults().get("defaultFont");
                if (obj != null && obj instanceof Font) {
                    Font defaultFont = (Font)obj;
                    UIManager.getLookAndFeelDefaults().put("defaultFont", defaultFont.deriveFont(userSize));
                }
                AliView.setUIFontSize(userSize);
            }
            if (!Settings.getUseCustomFontSize().getBooleanValue() && !OSNativeUtils.isWindows() && (fontObj = UIManager.getLookAndFeelDefaults().get("Label.font")) != null && fontObj instanceof Font) {
                Font defaultFont = (Font)fontObj;
                UIManager.getLookAndFeelDefaults().put("Label.font", defaultFont.deriveFont(12.0f));
            }
            File alignmentFile = null;
            if (args != null && args.length >= 1) {
                alignmentFile = new File(args[0]);
            }
            if (alignmentFile != null && !alignmentFile.exists()) {
                alignmentFile = null;
            }
            aliView = new AliView();
            if (AliView.isDebugMode() && alignmentFile == null && !(alignmentFile = new File("/home/anders/projekt/alignments/Woodsia_chloroplast_min1_20131029.fasta")).exists()) {
                alignmentFile = null;
            }
            if (!OSNativeUtils.isMac()) {
                AliView.createNewAliViewWindow(alignmentFile);
            } else if (OSNativeUtils.isMac()) {
                AliView.createNewAliViewWindow(alignmentFile);
            }
            if (OSNativeUtils.isMac()) {
                OSNativeUtils.registerMacAdapter(aliView);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error err) {
            logger.info("error was caught");
            err.printStackTrace();
        }
        if (AliView.isDebugMode()) {
            Logger.getRootLogger().setLevel(Level.ALL);
        } else {
            Logger.getRootLogger().setLevel(Level.ERROR);
        }
        logger.info("done with main method");
    }

    private static void debugUIDefaults() {
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        Enumeration enumer = def.keys();
        while (enumer.hasMoreElements()) {
            Object item = enumer.nextElement();
            System.out.println(item + " " + def.get(item));
        }
    }

    private static void setDebug(boolean b) {
        debugMode = b;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void openAlignmentFileViaChooser(Component parent) {
        String suggestedDir = Settings.getLoadAlignmentDirectory();
        File suggestedFile = new File(suggestedDir);
        File selectedFile = FileUtilities.selectOpenFileViaChooser(suggestedFile, parent);
        if (selectedFile != null) {
            AliView.openAlignmentFile(selectedFile);
            Settings.putLoadAlignmentDirectory(selectedFile.getParent());
        }
    }

    private static boolean souldBreakBecauseOfLowMemory(File alignmentFile) {
        double fileSize = alignmentFile.length();
        double fileSizeMB = fileSize / 1000000.0;
        double presumableFreeMemory = MemoryUtils.getPresumableFreeMemoryMB();
        MemoryUtils.logMem();
        logger.info("getPresumableFreeMemory()=" + MemoryUtils.getPresumableFreeMemoryMB());
        logger.info("fileSizeMB=" + fileSizeMB);
        boolean isBreakBecauseOfLowMemory = false;
        if (presumableFreeMemory < 1.5 * fileSizeMB) {
            String message = "Memory is running low, if you open this Alignment before closing some" + LF + "other Alignments the program might run out of Memory." + LF + "" + LF + "Do you want to continue and open the new Alignment?";
            int retVal = JOptionPane.showConfirmDialog(DialogUtils.getDialogParent(), message, "Continue?", 1);
            if (retVal != 0) {
                isBreakBecauseOfLowMemory = true;
            }
        }
        return isBreakBecauseOfLowMemory;
    }

    public static void openAlignmentFile(File alignmentFile) {
        try {
            logger.info("activeWindow=" + activeWindow);
            if (AliView.hasNonEmptyWindows() && AliView.souldBreakBecauseOfLowMemory(alignmentFile)) {
                return;
            }
            if (activeWindow != null && activeWindow.isEmpty()) {
                activeWindow.loadNewAlignmentFile(alignmentFile);
            } else {
                AliView.createNewAliViewWindow(alignmentFile);
            }
            Settings.putLoadAlignmentDirectory(alignmentFile.getAbsoluteFile().getParent());
            Settings.addRecentFile(alignmentFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError memoryErr) {
            logger.info("memory err");
            memoryErr.printStackTrace();
            Messenger.showOKOnlyMessage(Messenger.OUT_OF_MEMORY_ERROR, activeWindow);
        }
        catch (Error err) {
            err.printStackTrace();
        }
    }

    private static boolean hasNonEmptyWindows() {
        boolean hasNonEmptyWin = false;
        for (AliViewWindow aliWin : aliViewWindows) {
            if (aliWin == null || aliWin.isEmpty()) continue;
            hasNonEmptyWin = true;
        }
        return hasNonEmptyWin;
    }

    public static void createNewWindow() {
        logger.info("new win");
        AliView.createNewAliViewWindow(null);
    }

    public static AliViewWindow getActiveWindow() {
        return activeWindow;
    }

    private static void createNewAliViewWindow(File alignmentFile) {
        try {
            AliViewWindow newWin = new AliViewWindow(alignmentFile, menuBarFactory);
            newWin.setDefaultCloseOperation(3);
            newWin.setDefaultCloseOperation(0);
            newWin.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    AliViewWindow thisWin = (AliViewWindow)e.getWindow();
                    activeWindow = thisWin;
                    logger.info("window activated");
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    AliViewWindow thisWin = (AliViewWindow)e.getWindow();
                    AliView.closeWindow(thisWin);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    boolean hideMessage;
                    AliViewWindow thisWin = (AliViewWindow)e.getWindow();
                    if (thisWin.getAlignment() != null && !thisWin.getAlignment().isEmptyAlignment() && thisWin.getAlignment().isUnknownAlignment() && !(hideMessage = Settings.getHideUnknownAlignmentType().getBooleanValue())) {
                        boolean hideMessageNextTime = Messenger.showOKOnlyMessageWithCbx(Messenger.FAILED_SEQUENCE_DETECTION, false, thisWin);
                        Settings.getHideUnknownAlignmentType().putBooleanValue(hideMessageNextTime);
                    }
                }
            });
            if (activeWindow != null) {
                activeWindow.saveWindowGeometry();
            }
            aliViewWindows.add(newWin);
            activeWindow = newWin;
            newWin.restoreWindowGeometry();
            if (aliViewWindows.size() > 1) {
                newWin.setLocation(newWin.getX() + 20, newWin.getY() + 10);
            }
            AliView.placeWithinDesktop(newWin);
            newWin.setVisible(true);
            newWin.toFront();
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        catch (OutOfMemoryError memoryErr) {
            logger.error(memoryErr, memoryErr);
            logger.info("memory err");
            Messenger.showOKOnlyMessage(Messenger.OUT_OF_MEMORY_ERROR, activeWindow);
        }
        catch (Error err) {
            logger.error(err, err);
        }
    }

    public static void closeWindow(AliViewWindow thisWin) {
        boolean isCloseOK = thisWin.requestWindowClose();
        if (isCloseOK) {
            thisWin.dispose();
            aliViewWindows.remove(thisWin);
            if (aliViewWindows.size() == 0) {
                AliView.quitProgram();
            }
        }
    }

    public static void setUIFontSize(float newSize) {
        Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof Font)) continue;
            Font derivFont = ((Font)value).deriveFont(newSize);
            FontUIResource fontRes = new FontUIResource(derivFont);
            UIManager.getLookAndFeelDefaults().put(key, fontRes);
        }
    }

    private static void placeWithinDesktop(AliViewWindow newWin) {
        logger.debug("Inside placeWithinDesktop");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screen = new Rectangle(screenSize);
        Rectangle intersection = screen.intersection(newWin.getBounds());
        if (intersection.getWidth() < 100.0 || intersection.getHeight() < 100.0) {
            newWin.setBounds(0, 0, 200, 200);
        } else {
            newWin.setBounds(intersection);
        }
    }

    public static boolean quitProgram() {
        boolean isQuitOK = true;
        for (int n = aliViewWindows.size() - 1; n >= 0; --n) {
            AliViewWindow window = aliViewWindows.get(n);
            boolean isCloseOK = window.requestWindowClose();
            if (!isCloseOK) {
                return false;
            }
            window.dispose();
            aliViewWindows.remove(window);
        }
        logger.info("System exit");
        System.exit(0);
        return isQuitOK;
    }

    public static void logAllLogs() {
        Enumeration enumer = Logger.getRootLogger().getAllAppenders();
        while (enumer.hasMoreElements()) {
            Appender app = (Appender)enumer.nextElement();
            if (!(app instanceof FileAppender)) continue;
            System.out.println("File: " + ((FileAppender)app).getFile());
        }
    }

    public static String getVersion() {
        Properties versionProp = new Properties();
        InputStream in = AliView.class.getResourceAsStream("/version.properties");
        String version = "";
        try {
            versionProp.load(in);
            version = (String)versionProp.get("version");
        }
        catch (Exception exc) {
            logger.error("error loading version config");
            exc.printStackTrace();
            version = "?";
        }
        return version;
    }

    public static long getTime(Class<?> cl) {
        try {
            String rn = cl.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(rn).openConnection();
            return j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static void focusNextWin() {
        int activeWinIndex = 0;
        for (int n = 0; n < aliViewWindows.size(); ++n) {
            if (activeWindow != aliViewWindows.get(n)) continue;
            activeWinIndex = n;
        }
        int nextWin = activeWinIndex + 1;
        if (nextWin >= aliViewWindows.size()) {
            nextWin = 0;
        }
        aliViewWindows.get(nextWin).requestFocus();
    }

    @Override
    public void handleAbout(ApplicationEvent event) {
        logger.info("inside handle About");
    }

    @Override
    public void handleOpenApplication(ApplicationEvent event) {
        event.setHandled(true);
    }

    @Override
    public void handleOpenFile(ApplicationEvent event) {
        logger.info("inside handle open file" + event.getSource());
        String fileName = event.getFilename();
        logger.info("fileName" + fileName);
        AliView.doMacOpenFile(new File(fileName));
        event.setHandled(true);
    }

    @Override
    public void handlePreferences(ApplicationEvent event) {
        AliView.doMacPreferences();
    }

    @Override
    public void handlePrintFile(ApplicationEvent event) {
        AliView.doMacPrintFile();
    }

    @Override
    public void handleQuit(ApplicationEvent event) {
        logger.info("inside handle quit");
        boolean isNotInterruptedByUser = AliView.doMacQuit();
        event.setHandled(isNotInterruptedByUser);
    }

    @Override
    public void handleReOpenApplication(ApplicationEvent event) {
        logger.info("inside handle RE-open application");
    }

    public static void doMacPrintFile() {
        activeWindow.printAlignment();
    }

    public static void doMacPreferences() {
        activeWindow.openPreferencesGeneral();
    }

    public static void doMacOpenFile(File aFile) {
        AliView.openAlignmentFile(aFile);
    }

    public static void doMacOpenFiles(List<File> oFiles) {
        for (File aFile : oFiles) {
            AliView.doMacOpenFile(aFile);
        }
    }

    public static boolean doMacQuit() {
        boolean isNotInterruptedByUser = AliView.quitProgram();
        return isNotInterruptedByUser;
    }

    public static void doMacAbout() {
        activeWindow.showAbout();
    }

    static {
        aliViewWindows = new ArrayList();
        activeWindow = null;
        logger = Logger.getLogger(AliView.class);
        savedInitialArgumentAlignmentForMac = null;
        debugMode = false;
    }
}

