/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import aliview.AliView;
import aliview.EmptyUndoControler;
import aliview.GeneticCode;
import aliview.HelpUtils;
import aliview.MemoryUtils;
import aliview.NucleotideUtilities;
import aliview.PrintUtils;
import aliview.UndoControler;
import aliview.UndoList;
import aliview.alignment.Alignment;
import aliview.alignment.AlignmentEvent;
import aliview.alignment.AlignmentFile;
import aliview.alignment.AlignmentListener;
import aliview.alignment.AlignmentMeta;
import aliview.color.ColorScheme;
import aliview.exporter.ImageExporter;
import aliview.externalcommands.CommandItem;
import aliview.externalcommands.ExternalCommandExecutor;
import aliview.gui.AliToolBar;
import aliview.gui.AliViewJMenuBar;
import aliview.gui.AliViewJMenuBarFactory;
import aliview.gui.AlignmentPopupMenu;
import aliview.gui.AppIcons;
import aliview.gui.GlassPaneKeyListener;
import aliview.gui.GlassPaneMouseListener;
import aliview.gui.ListTopOffsetJPanel;
import aliview.gui.MessageLogFrame;
import aliview.gui.ScrollBarModelSyncChangeListener;
import aliview.gui.SearchPanel;
import aliview.gui.StatusPanel;
import aliview.gui.TextEditDialog;
import aliview.gui.TextEditFrame;
import aliview.gui.TextEditPanelCharsets;
import aliview.gui.TranslationToolPanel;
import aliview.gui.pane.AlignmentPane;
import aliview.gui.pane.InvalidAlignmentPositionException;
import aliview.importer.AlignmentFactory;
import aliview.importer.AlignmentImportException;
import aliview.importer.FileFormat;
import aliview.importer.SequencesFactory;
import aliview.messenges.Messenger;
import aliview.phenotype2genotype.Phenotype2Genootype;
import aliview.primer.Primer;
import aliview.primer.PrimerResultsFrame;
import aliview.sequencelist.AlignmentDataEvent;
import aliview.sequencelist.AlignmentDataListener;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.AlignmentSelectionEvent;
import aliview.sequencelist.AlignmentSelectionListener;
import aliview.sequencelist.FindObject;
import aliview.sequencelist.SequenceJList;
import aliview.sequencelist.SequenceListMouseListener;
import aliview.sequencelist.SequenceListMouseWheelListener;
import aliview.sequences.Sequence;
import aliview.sequences.SequenceUtils;
import aliview.settings.Settings;
import aliview.settings.SettingsFrame;
import aliview.subprocesses.SubProcessWindow;
import aliview.undo.UndoSavedState;
import aliview.undo.UndoSavedStateEditedSequences;
import aliview.undo.UndoSavedStateEverything;
import aliview.undo.UndoSavedStateMetaOnly;
import aliview.undo.UndoSavedStateSequenceOrder;
import aliview.utils.FileDrop;
import aliview.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import utils.DialogUtils;
import utils.FileUtilities;
import utils.OSNativeUtils;
import utils.nexus.CharSet;
import utils.nexus.CodonPos;

public class AliViewWindow
extends JFrame
implements UndoControler,
AlignmentListener,
AlignmentSelectionListener,
AlignmentDataListener,
Printable {
    private static final String LF = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger(AliViewWindow.class);
    private static final SequencesFactory seqFactory = new SequencesFactory();
    private AliViewWindow aliViewWindow;
    private Preferences prefs = Preferences.userNodeForPackage(AliViewWindow.class);
    private static final Rectangle DEFAULT_WIN_GEOMETRY = new Rectangle(20, 20, 600, 400);
    private static final int DEFAULT_WIN_EXTENDED_STATE = 0;
    protected JViewport viewport;
    protected AlignmentPane alignmentPane;
    JScrollPane alignmentScrollPane;
    private SequenceJList sequenceJList;
    private Alignment alignment;
    private SearchPanel searchPanel;
    private StatusPanel statusPanel;
    private JTextField primer1txtField;
    private JTextField primer2txtField;
    private PrimerResultsFrame primerResultsFrame;
    private int nextNameFindSequenceNumber;
    private int pastedSeqCounter = 1;
    UndoList undoList = new UndoList();
    private boolean hasUnsavedUndoableEdits;
    private static Component glassPane;
    private AliViewJMenuBarFactory menuBarFactory;
    private JMenu mnFilePages;
    private UndoControler undoControler;
    private FindObject findObj;
    private AliCursor aliCursor = new AliCursor(0, 0);
    private JScrollPane listScrollPane;
    private ScrollBarModelSyncChangeListener scrollBarListener;
    private ButtonModel editModeModel;
    private AliViewJMenuBar aliViewMenuBar;
    private TranslationToolPanel translationPanel;
    private AliToolBar aliToolbar;
    private ListTopOffsetJPanel listTopOffset;
    private boolean hasNotifiedUserAboutLimitedUndo;
    private JPanel alignmentAndRulerPanel;
    private JPanel listAndTopOffset;
    private JPanel rulerPanel;
    private String goToPosTextFieldValue = "";

    public long getLastPaneEndTime() {
        return this.alignmentPane.getEndTime();
    }

    public AliViewWindow(File alignmentFile, AliViewJMenuBarFactory menuBarFactory) {
        this.aliViewWindow = this;
        this.menuBarFactory = menuBarFactory;
        glassPane = this.getGlassPane();
        glassPane.addMouseListener(new GlassPaneMouseListener());
        glassPane.addKeyListener(new GlassPaneKeyListener());
        Alignment newAlignment = null;
        if (alignmentFile != null) {
            if (alignmentFile.exists()) {
                newAlignment = AlignmentFactory.createNewAlignment(alignmentFile);
                Settings.putLoadAlignmentDirectory(alignmentFile.getAbsoluteFile().getParent());
                Settings.putLoadAlignmentDirectory(alignmentFile.getAbsoluteFile().getParent());
                Settings.addRecentFile(alignmentFile);
            } else {
                Messenger.showOKOnlyMessage(Messenger.FILE_OPEN_NOT_EXISTS, "Filename: " + alignmentFile, this.aliViewWindow);
            }
        } else {
            logger.info("no file");
        }
        if (newAlignment == null) {
            logger.info("alignment was null creating new");
            newAlignment = AlignmentFactory.createNewEmptyAlignment();
        }
        new FileDrop((Component)this.getRootPane(), true, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files, DropTargetDropEvent evt) {
                AliViewWindow.this.aliViewWindow.filesDropped(files, evt.getDropAction());
            }
        });
        this.restoreWindowGeometry();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AliViewWindow.this.saveWindowGeometry();
            }
        });
        AbstractAction closeWinAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AliView.closeWindow(AliViewWindow.this.aliViewWindow);
            }
        };
        this.getRootPane().getInputMap(2).put(OSNativeUtils.getCloseWinKeyAccelerator(), "CloseWin");
        this.getRootPane().getActionMap().put("CloseWin", closeWinAction);
        AbstractAction doNothing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info("doing nothing");
            }
        };
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("F2"), "doNothing");
        this.getRootPane().getActionMap().put("doNothing", doNothing);
        this.setIconImage(AppIcons.getProgramIconImage());
        DialogUtils.init(this);
        this.initWindow(newAlignment);
    }

    public void fileDropped(List<File> fileList, int dropAction) {
        File[] filesArray = new File[fileList.size()];
        fileList.toArray(filesArray);
        this.filesDropped(filesArray, dropAction);
    }

    public void filesDropped(File[] files, int dropAction) {
        logger.info("DnDConstants.ACTION_COPY1");
        logger.info("DnDConstants.ACTION_MOVE2");
        logger.info("dropAction" + dropAction);
        if (OSNativeUtils.isLinuxOrUnix()) {
            if (dropAction == 2) {
                dropAction = 1;
            } else if (dropAction == 1) {
                dropAction = 2;
            }
        }
        if (dropAction == 1) {
            int n = 0;
            File[] fileArray = files;
            int n2 = fileArray.length;
            if (n < n2) {
                File droppedFile = fileArray[n];
                logger.info("file dropped");
                this.addSequencesFromFile(droppedFile, 0);
            }
        } else {
            if (files.length > 10) {
                Messenger.showOKCancelMessage(Messenger.MULTI_FILE_DROP_WARNING, this.aliViewWindow);
                int choise = Messenger.getLastSelectedOption();
                if (choise == 2) {
                    return;
                }
            }
            for (File droppedFile : files) {
                logger.info("file dropped");
                AliView.openAlignmentFile(droppedFile);
            }
        }
    }

    public UndoControler getUndoControler() {
        return this.undoControler;
    }

    public static Component getAliViewWindowGlassPane() {
        return glassPane;
    }

    public void logScrollPane() {
        logger.info(this.alignmentScrollPane.getViewport().getSize());
    }

    private void initWindow(Alignment newAlignment) {
        MouseMotionListener[] oldMMOnes;
        MouseListener[] oldOnes;
        logger.info("inside init()");
        this.alignment = newAlignment;
        this.alignment.addAlignmentListener(this);
        this.alignment.addAlignmentDataListener(this);
        this.alignment.addAlignmentSelectionListener(this);
        this.undoControler = this.alignment.isUndoable() ? this.aliViewWindow : new EmptyUndoControler();
        logger.info("here");
        this.alignmentPane = new AlignmentPane();
        AlignmentPaneMouseListener ml = new AlignmentPaneMouseListener();
        this.alignmentPane.addMouseListener(ml);
        this.alignmentPane.addMouseMotionListener(ml);
        this.alignmentPane.addMouseWheelListener(ml);
        AlignmentRulerMouseListener rl = new AlignmentRulerMouseListener();
        this.alignmentPane.getRulerComponent().addMouseListener(rl);
        this.alignmentPane.getRulerComponent().addMouseMotionListener(rl);
        AlignmentKeyListener kl = new AlignmentKeyListener();
        this.alignmentPane.addKeyListener(kl);
        this.alignmentPane.setAlignment(this.alignment);
        this.updateWindowTitle();
        this.alignmentScrollPane = new JScrollPane(this.alignmentPane, 20, 32);
        this.alignmentScrollPane.setAutoscrolls(true);
        this.alignmentScrollPane.setMinimumSize(new Dimension(150, 150));
        logger.info("alignmentPane.isDoubleBuffered()" + this.alignmentPane.isDoubleBuffered());
        boolean paneDoubleBuff = true;
        this.alignmentScrollPane.setDoubleBuffered(paneDoubleBuff);
        this.alignmentScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.alignmentScrollPane.getHorizontalScrollBar().setUnitIncrement(160);
        this.alignmentPane.setDoubleBuffered(paneDoubleBuff);
        this.alignmentScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.viewport = this.alignmentScrollPane.getViewport();
        this.viewport.setAutoscrolls(true);
        this.sequenceJList = new SequenceJList(this.alignment.getSequences(), this.alignmentPane.getCharHeight(), this);
        for (MouseListener oldMl : oldOnes = this.sequenceJList.getMouseListeners()) {
            this.sequenceJList.removeMouseListener(oldMl);
        }
        for (MouseMotionListener oldMl : oldMMOnes = this.sequenceJList.getMouseMotionListeners()) {
            this.sequenceJList.removeMouseMotionListener(oldMl);
        }
        SequenceListMouseListener ourSeqListML = new SequenceListMouseListener(this);
        this.sequenceJList.addMouseListener(ourSeqListML);
        this.sequenceJList.addMouseMotionListener(ourSeqListML);
        SequenceListMouseWheelListener ourSeqListMWL = new SequenceListMouseWheelListener(this);
        this.sequenceJList.addMouseWheelListener(ourSeqListMWL);
        for (MouseListener mouseListener : oldOnes) {
            this.sequenceJList.addMouseListener(mouseListener);
        }
        for (EventListener eventListener : oldMMOnes) {
            this.sequenceJList.addMouseMotionListener((MouseMotionListener)eventListener);
        }
        this.listScrollPane = new JScrollPane(this.sequenceJList, 20, 32);
        this.listScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrollBarListener = new ScrollBarModelSyncChangeListener(this.listScrollPane.getVerticalScrollBar().getModel());
        this.alignmentScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.scrollBarListener);
        this.sequenceJList.addSynchPanes(this.listScrollPane, this.alignmentScrollPane);
        JComponent alignmentRuler = this.alignmentPane.getRulerComponent();
        Dimension alignmentRulerDimension = new Dimension(1000, 20);
        alignmentRuler.setPreferredSize(alignmentRulerDimension);
        JComponent charsetRuler = this.alignmentPane.getCharsetRulerComponent();
        Dimension dimension = new Dimension(0, 0);
        charsetRuler.setPreferredSize(dimension);
        this.rulerPanel = new JPanel();
        this.rulerPanel.setLayout(new BoxLayout(this.rulerPanel, 1));
        this.rulerPanel.add(alignmentRuler);
        this.rulerPanel.add(charsetRuler);
        this.alignmentAndRulerPanel = new JPanel(new BorderLayout());
        this.alignmentAndRulerPanel.add((Component)this.alignmentScrollPane, "Center");
        this.alignmentAndRulerPanel.add((Component)this.rulerPanel, "North");
        this.listTopOffset = new ListTopOffsetJPanel(this.rulerPanel);
        this.listTopOffset.setPreferredSize(new Dimension(100, this.rulerPanel.getPreferredSize().height));
        this.listAndTopOffset = new JPanel(new BorderLayout());
        this.listAndTopOffset.add((Component)this.listScrollPane, "Center");
        this.listAndTopOffset.add((Component)this.listTopOffset, "North");
        JSplitPane splitPane = new JSplitPane(1, this.listAndTopOffset, this.alignmentAndRulerPanel);
        splitPane.setDividerSize(6);
        splitPane.setDividerLocation(200);
        this.getContentPane().add((Component)splitPane, "Center");
        this.statusPanel = new StatusPanel(this.alignmentPane, this.alignment);
        this.alignment.addAlignmentListener(this.statusPanel);
        this.alignment.addAlignmentDataListener(this.statusPanel);
        this.alignment.addAlignmentSelectionListener(this.statusPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        this.getContentPane().add((Component)bottomPanel, "South");
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.statusPanel);
        logger.info("middle of GUI");
        this.aliViewMenuBar = this.menuBarFactory.create(this);
        logger.info("done create menubar");
        this.setJMenuBar(this.aliViewMenuBar);
        this.aliViewMenuBar.disableAllButEssentialButtons();
        Settings.addSettingsListener(this.aliViewMenuBar);
        AlignmentPopupMenu poupMenu = new AlignmentPopupMenu(this.aliViewWindow, this.aliViewMenuBar);
        this.alignmentPane.addMouseListener(poupMenu);
        this.sequenceJList.addMouseListener(poupMenu);
        this.translationPanel = new TranslationToolPanel(this.aliViewWindow);
        this.alignment.addAlignmentListener(this.translationPanel);
        this.alignment.addAlignmentDataListener(this.translationPanel);
        this.alignment.addAlignmentSelectionListener(this.translationPanel);
        this.searchPanel = new SearchPanel();
        this.searchPanel.getSearchField().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AliViewWindow.this.performFind();
            }
        });
        this.searchPanel.getSearchField().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                AliViewWindow.this.alignment.clearSelection();
            }
        });
        this.aliToolbar = new AliToolBar(this.aliViewMenuBar, this.searchPanel, this.translationPanel);
        this.aliToolbar.setFloatable(false);
        this.aliToolbar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.getContentPane().add((Component)this.aliToolbar, "North");
        this.aliViewMenuBar.rebuildSelectCharsetsSubmenu();
        this.aliViewMenuBar.updateAllMenuEnabled();
        this.alignment.addAlignmentListener(this.aliViewMenuBar);
        this.alignment.addAlignmentDataListener(this.aliViewMenuBar);
        this.alignment.addAlignmentSelectionListener(this.aliViewMenuBar);
        this.setColorSchemeNucleotide(Settings.getColorSchemeNucleotide());
        logger.info("init() finished");
    }

    public AliViewJMenuBar getAliMenuBar() {
        return this.aliViewMenuBar;
    }

    public void findNamesFromClipboard() {
        String clipboard = AliViewWindow.getClipboard();
        if (clipboard != null) {
            String[] lines = clipboard.split(LF);
            ArrayList<Integer> allFoundIndices = new ArrayList<Integer>();
            for (String line : lines) {
                FindObject findObj = new FindObject(line, true);
                findObj = this.alignment.findInNames(findObj);
                allFoundIndices.addAll(findObj.getFoundIndices());
            }
            this.alignment.clearSelection();
            if (allFoundIndices.size() > 0) {
                this.alignment.selectIndices(allFoundIndices);
                this.sequenceJList.ensureIndexIsVisible((Integer)allFoundIndices.get(0));
            }
        }
    }

    public void reverseComplementClipboard() {
        String clipData = AliViewWindow.getClipboard();
        if (clipData == null) {
            return;
        }
        clipData = clipData.trim();
        String revComp = "";
        if (clipData.startsWith(">")) {
            try {
                AlignmentListModel sequences = seqFactory.createFastaSequences(new StringReader(clipData));
                for (Sequence seq : sequences) {
                    seq.reverseComplement();
                    revComp = revComp + ">" + seq.getName() + LF;
                    revComp = revComp + seq.getBasesAsString() + LF;
                }
            }
            catch (AlignmentImportException e) {
                e.printStackTrace();
                Messenger.showOKOnlyMessage(Messenger.COMPLEMENT_FUNCTION_ERROR, LF + e.getLocalizedMessage(), this);
            }
        } else {
            revComp = NucleotideUtilities.reverse(clipData);
            revComp = NucleotideUtilities.complement(revComp);
        }
        StringSelection ss = new StringSelection(revComp);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public void saveAlignmentFile() {
        if (this.alignment.getAlignmentFile().isAliViewTempFile()) {
            this.saveAlignmentAsFileViaChooser();
        } else {
            this.saveAlignmentAsFile();
        }
    }

    public void showMessageLog() {
        this.startDebug();
        MessageLogFrame messFrame = new MessageLogFrame(this);
        messFrame.setVisible(true);
    }

    public void updateWindowTitle() {
        AlignmentFile aliFile = this.alignment.getAlignmentFile();
        if (aliFile == null || aliFile.getName().length() == 0) {
            this.setTitle("AliView");
        } else if (this.hasUnsavedUndoableEdits()) {
            this.setTitle("AliView - *" + aliFile.getNameWithoutTempPrefix());
        } else {
            this.setTitle("AliView - " + aliFile.getNameWithoutTempPrefix());
        }
    }

    private boolean hasUnsavedUndoableEdits() {
        if (this.hasUnsavedUndoableEdits) {
            return true;
        }
        return this.alignment.getAlignmentFile() != null && this.alignment.getAlignmentFile().isAliViewTempFile();
    }

    protected boolean hasUnsavedEdits() {
        return this.hasUnsavedUndoableEdits();
    }

    public void performFind(String searchText) {
        this.searchPanel.setText(searchText);
        this.alignment.clearFindLastPos();
        this.performFind();
    }

    public void performFind() {
        this.alignment.clearSelection();
        String searchTerm = this.searchPanel.getText();
        if (this.findObj == null) {
            this.findObj = new FindObject(searchTerm);
            this.findObj.setFindNextInNames(true);
        }
        if (!this.findObj.getSearchTerm().equalsIgnoreCase(searchTerm)) {
            this.findObj = new FindObject(searchTerm);
            this.findObj.setFindNextInNames(true);
        }
        this.findObj.setIsFound(false);
        this.findObj.setFindAll(false);
        if (this.findObj.findNextInNames()) {
            this.findObj = this.alignment.findInNames(this.findObj);
            if (this.findObj.isFound()) {
                this.searchPanel.setFoundMessage();
                this.alignment.selectSequencesWithIndex(this.findObj.getFoundIndices());
                this.sequenceJList.ensureIndexIsVisible(this.findObj.getFoundIndices().get(0));
            } else {
                this.findObj.setFindNextInSequences(true);
            }
        }
        if (this.findObj.findNextInSequences()) {
            this.alignment.clearSelection();
            this.findObj = this.alignment.findAndSelectInSequences(this.findObj);
            if (this.findObj.isFound()) {
                this.searchPanel.setFoundMessage();
                this.alignmentPane.scrollRectToSelectionCenter();
            } else {
                this.findObj.setFindNextInNames(true);
            }
        }
        if (!this.findObj.isFound()) {
            this.searchPanel.setNoFoundMessage();
        }
    }

    public void requestPaneRepaint() {
        this.alignmentPane.revalidate();
        this.alignmentPane.repaint();
    }

    public void requestPaneAndRulerRepaint() {
        this.alignmentPane.revalidate();
        this.alignmentPane.repaintAndForceRuler();
    }

    public void requestScrollToVisibleSelection() {
        this.alignmentPane.scrollRectToSelection();
    }

    public void requestRepaintAndRevalidateALL() {
        this.alignmentAndRulerPanel.revalidate();
        this.listAndTopOffset.revalidate();
        this.rulerPanel.revalidate();
        this.alignmentPane.getCharsetRulerComponent().revalidate();
        this.alignmentPane.validateSequenceOrder();
        this.alignmentPane.validateSize();
        this.alignmentPane.revalidate();
        this.sequenceJList.revalidate();
        this.alignmentPane.repaintAndForceRuler();
        this.sequenceJList.repaint();
        this.listAndTopOffset.repaint();
    }

    public static final String getClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void zoomInAt(Point mousePos) {
        Dimension oldSize = this.alignmentPane.getPreferredSize();
        Point viewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
        Point mousePosInScrollPaneCoord = new Point(mousePos.x - viewPoint.x, mousePos.y - viewPoint.y);
        logger.info("oldSize" + oldSize);
        logger.info("mousePosInScrollPaneCoord" + mousePosInScrollPaneCoord);
        logger.info("mousePosOnPane" + mousePos);
        this.incCharSize();
        Dimension newSize = this.alignmentPane.getPreferredSize();
        this.alignmentPane.setSize(newSize);
        logger.info("pane-newSize" + newSize);
        double paneRelSizeX = newSize.getWidth() / oldSize.getWidth();
        double paneRelSizeY = newSize.getHeight() / oldSize.getHeight();
        int mousePosXOnResizedPane = (int)(mousePos.getX() * paneRelSizeX);
        int mousePosYOnResizedPane = (int)(mousePos.getY() * paneRelSizeY);
        Point mousePosOnResizedPane = new Point(mousePosXOnResizedPane, mousePosYOnResizedPane);
        int newX = mousePosOnResizedPane.x - mousePosInScrollPaneCoord.x;
        int newY = mousePosOnResizedPane.y - mousePosInScrollPaneCoord.y;
        logger.info("newX" + newX);
        logger.info("newY" + newY);
        Point newViewPoint = new Point(newX, newY);
        viewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
        logger.info("beforeViewPoint" + viewPoint);
        logger.info("newViewPoint" + newViewPoint);
        this.alignmentScrollPane.getViewport().setViewPosition(newViewPoint);
        Point afterViewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
        logger.info("afterViewPoint" + viewPoint);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AliViewWindow.this.scrollBarListener.stateChanged(new ChangeEvent(AliViewWindow.this.alignmentScrollPane.getVerticalScrollBar().getModel()));
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void zoomOutAt(Point mousePos) {
        Dimension oldSize = this.alignmentPane.getPreferredSize();
        Point viewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
        Point mousePosInScrollPaneCoord = new Point(mousePos.x - viewPoint.x, mousePos.y - viewPoint.y);
        Point mouseInMatrixCoord = this.alignmentPane.paneCoordToMatrixCoord(mousePosInScrollPaneCoord);
        logger.info("oldSize" + oldSize);
        boolean didChangeSize = this.decCharSize();
        if (didChangeSize) {
            Dimension newSize = this.alignmentPane.getPreferredSize();
            this.alignmentPane.setSize(newSize);
            logger.info("newSize" + newSize);
            double paneRelSizeX = newSize.getWidth() / oldSize.getWidth();
            double paneRelSizeY = newSize.getHeight() / oldSize.getHeight();
            int mousePosXOnResizedPane = (int)(mousePos.getX() * paneRelSizeX);
            int mousePosYOnResizedPane = (int)(mousePos.getY() * paneRelSizeY);
            Point mousePosOnResizedPane = new Point(mousePosXOnResizedPane, mousePosYOnResizedPane);
            int newX = mousePosOnResizedPane.x - mousePosInScrollPaneCoord.x;
            int newY = mousePosOnResizedPane.y - mousePosInScrollPaneCoord.y;
            Point newViewPoint = new Point(newX, newY);
            this.alignmentScrollPane.setViewport(null);
            this.alignmentScrollPane.setViewportView(this.alignmentPane);
            this.alignmentScrollPane.getViewport().setViewPosition(newViewPoint);
            Point afterViewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
            logger.info("afterViewPoint" + viewPoint);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AliViewWindow.this.scrollBarListener.stateChanged(new ChangeEvent(AliViewWindow.this.alignmentScrollPane.getVerticalScrollBar().getModel()));
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public boolean saveAlignmentAsFileViaChooser() {
        return this.saveAlignmentAsFileViaChooser(this.alignment.getFileFormat(), false);
    }

    public boolean saveAlignmentAsFileViaChooser(FileFormat fileFormat, boolean saveAsCopy) {
        Container parent;
        File suggestedFile;
        File selectedFile;
        String suggestedDir = null;
        String suggestedFileName = null;
        if (this.alignment.getAlignmentFile().isAliViewTempFile()) {
            File lastRecent = Settings.getLastRecentFile();
            File lastRecentDir = null;
            lastRecentDir = lastRecent == null ? AlignmentFile.createUserHomeFile() : lastRecent.getParentFile();
            suggestedDir = lastRecentDir.getAbsolutePath();
            suggestedFileName = this.alignment.getAlignmentFile().getNameWithoutTempPrefix();
        } else {
            suggestedDir = this.alignment.getAlignmentFile().getParent();
            suggestedFileName = this.alignment.getFileName();
        }
        if (fileFormat != this.alignment.getFileFormat()) {
            suggestedFileName = FileFormat.stripFileSuffixFromName(suggestedFileName);
            suggestedFileName = suggestedFileName + "." + fileFormat.getSuffix();
        }
        if (suggestedFileName == null || suggestedFileName.length() < 1) {
            suggestedFileName = "alignment." + fileFormat.getSuffix();
        }
        if ((selectedFile = FileUtilities.selectSaveFileViaChooser(suggestedFile = new File(suggestedDir, suggestedFileName), parent = this.getParent())) != null) {
            String message;
            int retVal;
            if (selectedFile.exists() && (retVal = JOptionPane.showConfirmDialog(this, message = "File already exists - do you want to overwrite?", "Overwrite?", 2)) != 0) {
                return false;
            }
            try {
                if (fileFormat == FileFormat.IMAGE_PNG) {
                    ImageExporter.writeComponentAsImageToFile(selectedFile, fileFormat.getSuffix(), this.alignmentPane);
                } else {
                    this.saveAlignmentAsFileAskIfNotEqualLength(selectedFile, fileFormat);
                }
                if (!saveAsCopy) {
                    this.alignment.setAlignmentFile(selectedFile);
                    this.alignment.setAlignmentFormat(fileFormat);
                    this.aliViewWindow.updateWindowTitle();
                    Settings.putSaveAlignmentDirectory(selectedFile.getParent());
                    this.hasUnsavedUndoableEdits = false;
                    this.updateWindowTitle();
                    if (fileFormat == FileFormat.NEXUS_SIMPLE) {
                        this.reloadCurrentFile();
                    }
                }
                if (fileFormat != FileFormat.IMAGE_PNG) {
                    Settings.addRecentFile(selectedFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Messenger.showOKOnlyMessage(Messenger.FILE_SAVE_ERROR, LF + e.getLocalizedMessage(), this);
            }
        } else {
            return false;
        }
        return true;
    }

    public void exportRaxMLFile() {
        this.exportRaxMLFileViaChooser();
    }

    public boolean exportRaxMLFileViaChooser() {
        Container parent;
        String suggestedDir = null;
        String suggestedFileName = null;
        if (this.alignment.getAlignmentFile().isAliViewTempFile()) {
            File lastRecent = Settings.getLastRecentFile();
            File lastRecentDir = null;
            lastRecentDir = lastRecent == null ? AlignmentFile.createUserHomeFile() : lastRecent.getParentFile();
            suggestedDir = lastRecentDir.getAbsolutePath();
            suggestedFileName = this.alignment.getAlignmentFile().getNameWithoutTempPrefix();
        } else {
            suggestedDir = this.alignment.getAlignmentFile().getParent();
            suggestedFileName = this.alignment.getFileName();
        }
        if (suggestedFileName == null) {
            suggestedFileName = "";
        }
        suggestedFileName = FileFormat.stripFileSuffixFromName(suggestedFileName);
        File suggestedFile = new File(suggestedDir, suggestedFileName = suggestedFileName + ".partitions");
        File selectedFile = FileUtilities.selectSaveFileViaChooser(suggestedFile, parent = this.getParent());
        if (selectedFile != null) {
            String message;
            int retVal;
            if (selectedFile.exists() && (retVal = JOptionPane.showConfirmDialog(this, message = "File already exists - do you want to overwrite?", "Overwrite?", 2)) != 0) {
                return false;
            }
            try {
                this.alignment.exportPartitionsFileRaxMLFormat(selectedFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                Messenger.showOKOnlyMessage(Messenger.FILE_SAVE_ERROR, LF + e.getLocalizedMessage(), this);
            }
        } else {
            return false;
        }
        return true;
    }

    public void saveAlignmentAsFile() {
        String saveDir = this.alignment.getAlignmentFile().getParent();
        String saveFileName = this.alignment.getFileName();
        if (saveFileName == null || saveFileName.length() < 1) {
            Messenger.showOKOnlyMessage(Messenger.SAVE_NOT_POSSIBLE_TRY_SAVE_AS, this.aliViewWindow);
            return;
        }
        File saveFile = new File(saveDir, saveFileName);
        try {
            this.saveAlignmentAsFileAskIfNotEqualLength(saveFile, this.alignment.getFileFormat());
            this.alignment.setAlignmentFile(saveFile);
            this.alignment.setAlignmentFormat(this.alignment.getFileFormat());
            this.aliViewWindow.updateWindowTitle();
            Settings.putSaveAlignmentDirectory(saveFile.getAbsoluteFile().getParent());
            this.hasUnsavedUndoableEdits = false;
            this.updateWindowTitle();
        }
        catch (IOException e) {
            e.printStackTrace();
            Messenger.showOKOnlyMessage(Messenger.FILE_SAVE_ERROR, LF + e.getLocalizedMessage(), this);
        }
    }

    private void saveAlignmentAsFileAskIfNotEqualLength(File outFile, FileFormat fileFormat) throws IOException {
        boolean hideMessage;
        boolean rightPadOrTrimIfNeeded = false;
        if (this.alignment.isEditable() && !this.alignment.isSequencesEqualLength() && !(hideMessage = Settings.getHidePadOrTrimToEqualLength().getBooleanValue())) {
            boolean hideMessageNextTime = Messenger.showYesNoCancelMessageWithCbx(Messenger.PAD_OR_TRIM_ALIGNMENT_TO_EQUAL_LENGTH, false, this.aliViewWindow);
            Settings.getHidePadOrTrimToEqualLength().putBooleanValue(hideMessageNextTime);
            int choise = Messenger.getLastSelectedOption();
            if (choise == 2) {
                return;
            }
            rightPadOrTrimIfNeeded = choise == 0 ? true : (choise == 1 ? false : false);
        }
        this.alignment.saveAlignmentAsFile(outFile, fileFormat, rightPadOrTrimIfNeeded);
    }

    public void saveSelectionAsFastaFileViaChooser() {
        Container parentComponent;
        String suggestedDir = this.alignment.getAlignmentFile().getParent();
        String suggestedFileName = this.alignment.getAlignmentFile().getName();
        suggestedFileName = FileFormat.stripFileSuffixFromName(suggestedFileName);
        File suggestedFile = new File(suggestedDir, suggestedFileName = suggestedFileName + ".selection." + FileFormat.FASTA.getSuffix());
        File selectedFile = FileUtilities.selectSaveFileViaChooser(suggestedFile, parentComponent = this.getParent());
        if (selectedFile != null) {
            this.alignment.saveSelectionAsFastaFile(selectedFile);
            Settings.putSaveSelectionDirectory(selectedFile.getParent());
        }
    }

    public void reloadCurrentFile() {
        boolean isOKGoAhead = this.requestReloadWindow();
        if (isOKGoAhead) {
            this.getUndoControler().pushUndoState();
            AlignmentFile currentFile = this.alignment.getAlignmentFile();
            this.loadNewAlignmentFile(currentFile);
            this.hasUnsavedUndoableEdits = false;
            this.updateWindowTitle();
        }
    }

    public void loadNewAlignmentFile(File selectedFile) {
        this.loadNewAlignmentFile(selectedFile, SequenceUtils.TYPE_UNKNOWN);
    }

    public void loadNewAlignmentFile(File selectedFile, int sequenceType) {
        this.alignment = AlignmentFactory.createNewAlignment(selectedFile, sequenceType);
        this.setupNewAlignment(this.alignment);
        this.hasUnsavedUndoableEdits = false;
        this.updateWindowTitle();
    }

    private void setupNewAlignment(Alignment newAlignment) {
        boolean hideMessage;
        this.alignment = newAlignment;
        this.alignment.addAlignmentListener(this);
        this.alignment.addAlignmentDataListener(this);
        this.alignment.addAlignmentSelectionListener(this);
        this.alignment.addAlignmentListener(this.statusPanel);
        this.alignment.addAlignmentDataListener(this.statusPanel);
        this.alignment.addAlignmentSelectionListener(this.statusPanel);
        this.alignment.addAlignmentListener(this.aliViewMenuBar);
        this.alignment.addAlignmentDataListener(this.aliViewMenuBar);
        this.alignment.addAlignmentSelectionListener(this.aliViewMenuBar);
        this.alignment.addAlignmentListener(this.translationPanel);
        this.alignment.addAlignmentDataListener(this.translationPanel);
        this.alignment.addAlignmentSelectionListener(this.translationPanel);
        this.alignmentPane.setAlignment(this.alignment);
        this.sequenceJList.setModel(this.alignment.getSequences());
        this.sequenceJList.setSelectionModel(this.alignment.getSequences().getAlignmentSelectionModel().getSequenceListSelectionModel());
        this.statusPanel.setAlignment(this.alignment);
        this.statusPanel.updateAll();
        this.alignmentPane.validateSize();
        this.aliViewWindow.updateWindowTitle();
        this.aliViewMenuBar.rebuildSelectCharsetsSubmenu();
        this.aliViewMenuBar.updateAllMenuEnabled();
        if (this.alignment != null && this.alignment.isEmptyAlignment() && this.alignment.isUnknownAlignment() && !(hideMessage = Settings.getHideUnknownAlignmentType().getBooleanValue())) {
            boolean hideMessageNextTime = Messenger.showOKOnlyMessageWithCbx(Messenger.FAILED_SEQUENCE_DETECTION, false, this.aliViewWindow);
            Settings.getHideUnknownAlignmentType().putBooleanValue(hideMessageNextTime);
        }
    }

    public void zoomIn() {
        Point zoomPoint = this.alignmentPane.getMousePosition();
        if (zoomPoint == null) {
            Point centerPos;
            Point viewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
            Dimension dimension = this.alignmentScrollPane.getViewport().getExtentSize();
            zoomPoint = centerPos = new Point(viewPoint.x + dimension.width / 2, viewPoint.y + dimension.height / 2);
        }
        this.zoomInAt(zoomPoint);
    }

    public void zoomOut() {
        Point zoomPoint = this.alignmentPane.getMousePosition();
        if (zoomPoint == null) {
            Point centerPos;
            Point viewPoint = this.alignmentScrollPane.getViewport().getViewPosition();
            Dimension dimension = this.alignmentScrollPane.getViewport().getExtentSize();
            zoomPoint = centerPos = new Point(viewPoint.x + dimension.width / 2, viewPoint.y + dimension.height / 2);
        }
        this.zoomOutAt(zoomPoint);
    }

    protected void incCharSize() {
        this.alignmentPane.incCharSize();
        this.sequenceJList.setCharSize(this.alignmentPane.getCharHeight());
    }

    protected boolean decCharSize() {
        boolean didChange = this.alignmentPane.decCharSize();
        this.sequenceJList.setCharSize(this.alignmentPane.getCharHeight());
        return didChange;
    }

    public void restoreWindowGeometry() {
        Rectangle bounds = new Rectangle();
        bounds.x = this.prefs.getInt("window.x", AliViewWindow.DEFAULT_WIN_GEOMETRY.x);
        bounds.y = this.prefs.getInt("window.y", AliViewWindow.DEFAULT_WIN_GEOMETRY.y);
        bounds.width = this.prefs.getInt("window.width", AliViewWindow.DEFAULT_WIN_GEOMETRY.width);
        bounds.height = this.prefs.getInt("window.height", AliViewWindow.DEFAULT_WIN_GEOMETRY.height);
        this.setExtendedState(this.prefs.getInt("window.extendedState", 0));
        this.setBounds(bounds);
    }

    public void saveWindowGeometry() {
        Rectangle bounds = this.getBounds();
        this.prefs.putInt("window.x", bounds.x);
        this.prefs.putInt("window.y", bounds.y);
        this.prefs.putInt("window.width", bounds.width);
        this.prefs.putInt("window.height", bounds.height);
        this.prefs.putInt("window.extendedState", this.getExtendedState());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public synchronized void reAlignSelectedSequences() {
        if (this.alignment.isTranslatedOnePos()) {
            Messenger.showOKOnlyMessage(Messenger.SUGGEST_ALIGN_AS_TRANSLATED, this.aliViewWindow);
            return;
        }
        CommandItem firstSelected = null;
        for (CommandItem item : Settings.getAlignADDCommands()) {
            if (!item.isActivated()) continue;
            firstSelected = item;
            firstSelected.reParseCommand();
            break;
        }
        if (firstSelected != null) {
            try {
                if (this.alignment.hasFullySelectedSequences()) {
                    AlignmentFile unselectedAlignmentTempFile = AlignmentFile.createAliViewTempFile("unselected-alignment", FileFormat.FASTA.getSuffix());
                    AlignmentFile selectedAlignmentTempFile = AlignmentFile.createAliViewTempFile("selected-alignment", FileFormat.FASTA.getSuffix());
                    this.alignment.saveSelectedSequencesAsFastaFile(selectedAlignmentTempFile, false);
                    this.alignment.saveUnSelectedSequencesAsFastaFile(unselectedAlignmentTempFile, false);
                    this.alignAndAddSequences(firstSelected, unselectedAlignmentTempFile, selectedAlignmentTempFile);
                } else {
                    Messenger.showOKOnlyMessage(Messenger.NO_FULLY_SELECTED_SEQUENCES, this);
                }
            }
            catch (IOException e) {
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Message: " + e.getLocalizedMessage(), this.aliViewWindow);
                e.printStackTrace();
            }
        }
    }

    public synchronized void alignAndAddSequences(File additionalSequencesFile) throws IOException {
        if (this.alignment.isTranslatedOnePos()) {
            Messenger.showOKOnlyMessage(Messenger.SUGGEST_ALIGN_AS_TRANSLATED, this.aliViewWindow);
            return;
        }
        CommandItem firstSelected = null;
        for (CommandItem item : Settings.getAlignADDCommands()) {
            if (!item.isActivated()) continue;
            firstSelected = item;
            firstSelected.reParseCommand();
            break;
        }
        if (firstSelected != null) {
            FileFormat currentTempFileFormat = firstSelected.getCurrentAlignmentFileFormat();
            AlignmentFile currentAlignmentTempFile = AlignmentFile.createAliViewTempFile("current-alignment", currentTempFileFormat.getSuffix());
            this.alignment.saveAlignmentAsFile(currentAlignmentTempFile, currentTempFileFormat, true);
            this.alignAndAddSequences(firstSelected, currentAlignmentTempFile, additionalSequencesFile);
        }
    }

    public synchronized void alignAndAddSequences(final CommandItem alignItem, File origSequences, File newSeqs) {
        String invalidChars;
        boolean hideMessage;
        if (this.alignment.isTranslatedOnePos()) {
            Messenger.showOKOnlyMessage(Messenger.SUGGEST_ALIGN_AS_TRANSLATED, this.aliViewWindow);
            return;
        }
        if (StringUtils.containsIgnoreCase(alignItem.getCommand(), "profile") && !(hideMessage = Settings.getHideMuscleProfileAlignInfoMessage().getBooleanValue())) {
            boolean hideMessageNextTime = Messenger.showOKOnlyMessageWithCbx(Messenger.MUSCLE_PROFILE_INFO_MESSAGE, true, this);
            Settings.getHideMuscleProfileAlignInfoMessage().putBooleanValue(hideMessageNextTime);
        }
        if ((invalidChars = this.alignment.getFirstAlignmentProgInvalidCharacter()).length() > 0) {
            Messenger.showHideAlignmentProgramInvalidCharsInfoMessage(invalidChars);
            int choise = Messenger.getLastSelectedOption();
            if (choise == 2) {
                return;
            }
        }
        try {
            final AlignmentFile newAlignmentTempFile = AlignmentFile.createAliViewTempFile("alignment", ".fasta");
            final SubProcessWindow subProcessWin = SubProcessWindow.getProcessProgressWindow(this.aliViewWindow, true);
            subProcessWin.setCloseWhenDoneCbxSelection(Settings.getHideProcessProgressWindowWhenDone().getBooleanValue());
            subProcessWin.setTitle("Align and add sequences with " + alignItem.getName());
            subProcessWin.setAlwaysOnTop(false);
            subProcessWin.show();
            alignItem.setParameterCurrentFile(origSequences);
            alignItem.setParameterSecondFile(newSeqs);
            alignItem.setParameterOutputFile(newAlignmentTempFile);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExternalCommandExecutor.executeMultiple(alignItem, subProcessWin);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean wasProcessInterruptedByUser = subProcessWin.wasSubProcessDestrouedByUser();
                                AliViewWindow.this.aliViewWindow.realignmentOfSelectedSeqsDone(wasProcessInterruptedByUser, newAlignmentTempFile);
                                subProcessWin.appendOutput(LF + "Done" + LF);
                                if (Settings.getHideProcessProgressWindowWhenDone().getBooleanValue()) {
                                    subProcessWin.dispose();
                                }
                                AliViewWindow.this.setSoftLockGUIThroughMenuDisable(false);
                            }
                        });
                    }
                    catch (Exception e) {
                        AliViewWindow.this.setSoftLockGUIThroughMenuDisable(false);
                        subProcessWin.appendOutput(e.getMessage());
                        Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Message: " + e.getLocalizedMessage(), AliViewWindow.this.aliViewWindow);
                        e.printStackTrace();
                    }
                    finally {
                        AliViewWindow.this.setSoftLockGUIThroughMenuDisable(false);
                    }
                }
            });
            this.setSoftLockGUIThroughMenuDisable(true);
            thread.start();
        }
        catch (Exception e) {
            this.setSoftLockGUIThroughMenuDisable(false);
            Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Message: " + e.getLocalizedMessage(), this.aliViewWindow);
            e.printStackTrace();
        }
    }

    public void reAlignEverythingWithDefaultProgram() {
        if (this.alignment.isTranslatedOnePos()) {
            Messenger.showOKOnlyMessage(Messenger.SUGGEST_ALIGN_AS_TRANSLATED, this.aliViewWindow);
            return;
        }
        CommandItem firstSelected = null;
        for (CommandItem item : Settings.getAlignALLCommands()) {
            if (!item.isActivated()) continue;
            firstSelected = item;
            firstSelected.reParseCommand();
            break;
        }
        if (firstSelected != null) {
            this.reAlignEverythingWithAlignCommand(firstSelected, false, false);
        }
    }

    public void reAlignEverythingAsTranslatedAA() {
        CommandItem firstSelected = null;
        for (CommandItem item : Settings.getAlignALLCommands()) {
            if (!item.isActivated()) continue;
            firstSelected = item;
            firstSelected.reParseCommand();
            break;
        }
        if (firstSelected != null) {
            this.reAlignEverythingWithAlignCommand(firstSelected, true, false);
        }
    }

    public synchronized void reAlignSelectionInSeparateThread() {
        if (this.alignment.isTranslatedOnePos()) {
            Messenger.showOKOnlyMessage(Messenger.SUGGEST_ALIGN_AS_TRANSLATED, this.aliViewWindow);
            return;
        }
        CommandItem firstSelected = null;
        for (CommandItem item : Settings.getAlignALLCommands()) {
            if (!item.isActivated()) continue;
            firstSelected = item;
            firstSelected.reParseCommand();
            break;
        }
        if (firstSelected != null) {
            this.reAlignEverythingWithAlignCommand(firstSelected, false, true);
        }
    }

    public void reAlignEverythingWithAlignCommand(final CommandItem alignItem, final boolean asTranslatedAA, final boolean selection) {
        String invalCharMessage;
        String invalidChars;
        int choise;
        boolean hideMessage;
        if (!selection && !(hideMessage = Settings.getHideRealignEverythingMessage().getBooleanValue())) {
            boolean hideMessageNextTime = Messenger.showOKCancelMessageWithCbx(Messenger.REALIGN_EVERYTHING, hideMessage, this.aliViewWindow);
            Settings.getHideRealignEverythingMessage().putBooleanValue(hideMessageNextTime);
            choise = Messenger.getLastSelectedOption();
            if (choise == 2) {
                return;
            }
        }
        if ((invalidChars = this.alignment.getFirstAlignmentProgInvalidCharacter()).length() > 0 && (choise = JOptionPane.showConfirmDialog(this, invalCharMessage = "Some aligners (e.g. Muscle, Mafft) are sensiteive to invalid characters," + LF + "the following were found and you might need to replace them with X in your alignment: " + invalidChars, "Problem characters", 2)) == 2) {
            return;
        }
        try {
            logger.info("alignWithDefault");
            FileFormat currentTempFileFormat = alignItem.getCurrentAlignmentFileFormat();
            AlignmentFile currentAlignmentTempFile = AlignmentFile.createAliViewTempFile("current-alignment", currentTempFileFormat.getSuffix());
            final Rectangle selectionBounds = this.alignment.getSelectionAsMinRect();
            if (asTranslatedAA) {
                this.alignment.saveAlignmentAsFile(currentAlignmentTempFile, FileFormat.FASTA_TRANSLATED_AMINO_ACID, true);
            } else if (selection) {
                this.alignment.saveSelectionAsFastaFile(currentAlignmentTempFile);
            } else {
                this.alignment.saveAlignmentAsFile(currentAlignmentTempFile, currentTempFileFormat, true);
            }
            final AlignmentFile newAlignmentTempFile = AlignmentFile.createAliViewTempFile("alignment", ".fasta");
            alignItem.setParameterCurrentFile(currentAlignmentTempFile);
            alignItem.setParameterOutputFile(newAlignmentTempFile);
            final SubProcessWindow subProcessWin = SubProcessWindow.getProcessProgressWindow(this.aliViewWindow, true);
            subProcessWin.setCloseWhenDoneCbxSelection(Settings.getHideProcessProgressWindowWhenDone().getBooleanValue());
            subProcessWin.setTitle("Align with " + alignItem.getName());
            subProcessWin.setAlwaysOnTop(false);
            subProcessWin.show();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExternalCommandExecutor.executeMultiple(alignItem, subProcessWin);
                        logger.info("donerealign");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean wasProcessInterruptedByUser = subProcessWin.wasSubProcessDestrouedByUser();
                                if (asTranslatedAA) {
                                    AliViewWindow.this.aliViewWindow.realignmentAsAADone(wasProcessInterruptedByUser, newAlignmentTempFile);
                                } else if (selection) {
                                    AliViewWindow.this.aliViewWindow.realignmentOfSelectionDone(wasProcessInterruptedByUser, newAlignmentTempFile, selectionBounds);
                                } else {
                                    AliViewWindow.this.aliViewWindow.realignmentDone(wasProcessInterruptedByUser, newAlignmentTempFile);
                                }
                                subProcessWin.appendOutput(LF + "Done" + LF);
                                logger.info("before-set-visible-false");
                                if (Settings.getHideProcessProgressWindowWhenDone().getBooleanValue()) {
                                    subProcessWin.dispose();
                                }
                                AliViewWindow.this.setSoftLockGUIThroughMenuDisable(false);
                            }
                        });
                    }
                    catch (Exception e) {
                        AliViewWindow.this.setSoftLockGUIThroughMenuDisable(false);
                        subProcessWin.appendOutput(e.getMessage());
                        Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Message: " + e.getLocalizedMessage(), AliViewWindow.this.aliViewWindow);
                        e.printStackTrace();
                    }
                    finally {
                        AliViewWindow.this.setSoftLockGUIThroughMenuDisable(false);
                    }
                }
            });
            this.setSoftLockGUIThroughMenuDisable(true);
            thread.start();
        }
        catch (Exception e) {
            this.setSoftLockGUIThroughMenuDisable(false);
            Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Error message:" + e.getLocalizedMessage(), this.aliViewWindow);
            e.printStackTrace();
        }
    }

    private void setSoftLockGUIThroughMenuDisable(boolean lock) {
        this.aliViewMenuBar.setMenuLock(lock);
    }

    private void realignmentOfSelectionDone(boolean wasProcessInterruptedByUser, File newRealignedSelectionTempFile, Rectangle selectionBounds) {
        if (!wasProcessInterruptedByUser) {
            if (newRealignedSelectionTempFile.length() > 0L) {
                this.aliViewWindow.getUndoControler().pushUndoState();
                Alignment realignment = AlignmentFactory.createNewAlignment(newRealignedSelectionTempFile);
                this.alignment.setSelectionWithin(selectionBounds);
                this.alignment.replaceSelectedCharactersWithThis(realignment);
                this.alignment.padAndTrimSequences();
                this.requestPaneRepaint();
            } else {
                this.setSoftLockGUIThroughMenuDisable(false);
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, this.aliViewWindow);
            }
        }
        logger.info("Finished realignmentOfSelection");
    }

    private void realignmentAsAADone(boolean wasProcessInterruptedByUser, File newRealignedTempFile) {
        if (!wasProcessInterruptedByUser) {
            if (newRealignedTempFile.length() > 0L) {
                try {
                    this.aliViewWindow.getUndoControler().pushUndoState();
                    Alignment realignment = AlignmentFactory.createNewAlignment(newRealignedTempFile);
                    this.alignment.realignNucleotidesUseThisAAAlignmentAsTemplate(realignment);
                    this.alignment.padAndTrimSequences();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.setSoftLockGUIThroughMenuDisable(false);
                    Messenger.showGeneralExceptionMessage(exc, this.aliViewWindow);
                }
            } else {
                this.setSoftLockGUIThroughMenuDisable(false);
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, this.aliViewWindow);
            }
        }
        logger.info("Finished realignmentAsAADone");
    }

    protected void realignmentOfSelectedSeqsDone(boolean wasProcessInterruptedByUser, File newRealignedTempFile) {
        if (!wasProcessInterruptedByUser) {
            if (newRealignedTempFile.length() > 0L) {
                this.aliViewWindow.getUndoControler().pushUndoState();
                AlignmentFile storedAlignmentFile = this.alignment.getAlignmentFile();
                AlignmentListModel prevSeqOrder = this.alignment.getSequences();
                AlignmentMeta storedMeta = this.alignment.getAlignentMetaCopy();
                this.loadNewAlignmentFile(newRealignedTempFile);
                this.alignment.setAlignmentFile(storedAlignmentFile);
                this.updateWindowTitle();
                this.alignment.setAlignentMeta(storedMeta);
                this.alignment.sortSequencesByThisModel(prevSeqOrder);
                this.alignment.padAndTrimSequences();
            } else {
                this.setSoftLockGUIThroughMenuDisable(false);
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, this.aliViewWindow);
            }
        }
        logger.info("Finished reAlignWithDefault");
    }

    public void changeAlignmentType(int forcedSequenceType) {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.loadNewAlignmentFile(this.alignment.getAlignmentFile(), forcedSequenceType);
        logger.info("Finished changeAlignmentType");
    }

    protected void realignmentDone(boolean wasProcessInterruptedByUser, File newRealignedTempFile) {
        if (!wasProcessInterruptedByUser) {
            if (newRealignedTempFile.length() > 0L) {
                this.aliViewWindow.getUndoControler().pushUndoState();
                AlignmentFile storedAlignmentFile = this.alignment.getAlignmentFile();
                this.loadNewAlignmentFile(newRealignedTempFile);
                this.alignment.setAlignmentFile(storedAlignmentFile);
                this.updateWindowTitle();
                this.alignment.padAndTrimSequences();
            } else {
                this.setSoftLockGUIThroughMenuDisable(false);
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, this.aliViewWindow);
            }
        }
        logger.info("Finished reAlignWithDefault");
    }

    public static void logAllLogs() {
        Enumeration enumer = Logger.getRootLogger().getAllAppenders();
        while (enumer.hasMoreElements()) {
            Appender app = (Appender)enumer.nextElement();
            if (!(app instanceof FileAppender)) continue;
            System.out.println("File: " + ((FileAppender)app).getFile());
        }
    }

    public static void flushAllLogs() {
        try {
            HashSet<FileAppender> flushedFileAppenders = new HashSet<FileAppender>();
            Enumeration currentLoggers = LogManager.getLoggerRepository().getCurrentLoggers();
            while (currentLoggers.hasMoreElements()) {
                Object nextLogger = currentLoggers.nextElement();
                if (!(nextLogger instanceof Logger)) continue;
                Logger currentLogger = (Logger)nextLogger;
                Enumeration allAppenders = currentLogger.getAllAppenders();
                while (allAppenders.hasMoreElements()) {
                    FileAppender fileAppender;
                    Object nextElement = allAppenders.nextElement();
                    if (!(nextElement instanceof FileAppender) || flushedFileAppenders.contains(fileAppender = (FileAppender)nextElement) || fileAppender.getImmediateFlush()) continue;
                    flushedFileAppenders.add(fileAppender);
                    fileAppender.setImmediateFlush(true);
                    currentLogger.info("FLUSH");
                    fileAppender.setImmediateFlush(false);
                }
            }
        }
        catch (RuntimeException e) {
            logger.error("Failed flushing logs", e);
        }
    }

    public void clearSelectedBases() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.clearSelectedBases(this.isUndoable());
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
    }

    private boolean isUndoable() {
        double alignmentSize;
        double memoryLimit;
        double presumableFreeMemory = MemoryUtils.getPresumableFreeMemoryMB();
        if (presumableFreeMemory < (memoryLimit = 2.0 * (alignmentSize = this.alignment.getApproximateMemorySizeMB()) + 100.0)) {
            if (!this.hasNotifiedUserAboutLimitedUndo) {
                Messenger.showOKOnlyMessage(Messenger.LIMITED_UNDO_CAPABILITIES, this);
                this.hasNotifiedUserAboutLimitedUndo = true;
            }
            return false;
        }
        return true;
    }

    public void findPrimerInCurrentSelection() {
        String message;
        int retVal;
        long selectionSize = this.alignment.getSelectionSize();
        if (selectionSize == 0L) {
            Messenger.showOKOnlyMessage(Messenger.NO_SELECTION, this);
            return;
        }
        if (selectionSize > 100000L && (retVal = JOptionPane.showConfirmDialog(this, message = "In a large selection finding primers might take some time, " + LF + "Do you want to go ahead?", "Continue?", 2)) != 0) {
            return;
        }
        ArrayList<Primer> primerResult = this.alignment.findPrimerInSelection();
        if (this.primerResultsFrame != null) {
            this.primerResultsFrame.dispose();
        }
        if (primerResult != null && primerResult.size() > 0) {
            this.primerResultsFrame = new PrimerResultsFrame(primerResult, this.aliViewWindow);
            this.primerResultsFrame.setDefaultCloseOperation(2);
        } else {
            Messenger.showOKOnlyMessage(Messenger.NO_PRIMERS_FOUND, this);
        }
    }

    public void addAndAlignMultipleSeqFromClipOneByOne() {
        String clipData = AliViewWindow.getClipboard();
        if (clipData != null && FileFormat.isThisFasta(clipData)) {
            try {
                AlignmentListModel sequences = seqFactory.createFastaSequences(new StringReader(clipData));
                for (Sequence seq : sequences) {
                    try {
                        AlignmentFile clipboardSequenceFile = AlignmentFile.createAliViewTempFile("clipboard_selection", ".fasta");
                        BufferedWriter buffWriter = new BufferedWriter(new FileWriter(clipboardSequenceFile));
                        String fastaSeqName = ">" + seq.getName() + LF + seq.getBasesAsString();
                        buffWriter.append(fastaSeqName);
                        seq.writeBases(buffWriter);
                        buffWriter.flush();
                        buffWriter.close();
                        this.aliViewWindow.alignAndAddSequences(clipboardSequenceFile);
                    }
                    catch (IOException e) {
                        Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Error message:" + e.getLocalizedMessage(), this.aliViewWindow);
                        e.printStackTrace();
                    }
                }
            }
            catch (AlignmentImportException e) {
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Error message:" + e.getLocalizedMessage(), this.aliViewWindow);
                e.printStackTrace();
            }
        } else {
            Messenger.showOKOnlyMessage(Messenger.NO_FASTA_IN_CLIPBOARD, this.aliViewWindow);
        }
    }

    public void addAndAlignSeqFromFile() {
        String suggestedDir = Settings.getLoadAlignmentDirectory();
        File suggestedFile = new File(suggestedDir);
        File selectedFile = FileUtilities.selectOpenFileViaChooser(suggestedFile, this.aliViewWindow);
        if (selectedFile != null) {
            try {
                this.alignAndAddSequences(selectedFile);
            }
            catch (IOException e) {
                Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Message: " + e.getLocalizedMessage(), this.aliViewWindow);
                e.printStackTrace();
            }
        }
    }

    public void addAndAlignSeqFromClipboard() {
        try {
            String clipboardSelection = AliViewWindow.getClipboard();
            logger.info(clipboardSelection);
            if (clipboardSelection != null && clipboardSelection.length() > 0) {
                File clipboardSequenceFile = new File(clipboardSelection);
                if (!clipboardSequenceFile.exists()) {
                    if (!clipboardSelection.startsWith(">")) {
                        Messenger.showOKOnlyMessage(Messenger.NO_FASTA_IN_CLIPBOARD, this.aliViewWindow);
                        return;
                    }
                    clipboardSequenceFile = AlignmentFile.createAliViewTempFile("clipboard_selection", ".fasta");
                    FileUtils.writeStringToFile(clipboardSequenceFile, clipboardSelection);
                }
                File newSequenceFile = clipboardSequenceFile;
                this.alignAndAddSequences(newSequenceFile);
            }
        }
        catch (IOException e1) {
            Messenger.showOKOnlyMessage(Messenger.ALIGNER_SOMETHING_PROBLEM_ERROR, LF + "Message: " + e1.getLocalizedMessage(), this.aliViewWindow);
            e1.printStackTrace();
        }
    }

    public void toggleDrawCodonpos() {
        this.alignmentPane.setDrawCodonPosOnRuler(!this.alignmentPane.getDrawCodonPosOnRuler());
        this.requestPaneAndRulerRepaint();
    }

    public void toggleIgnoreGapInTranslation() {
        this.alignmentPane.setIgnoreGapInTranslation(!this.alignmentPane.getIgnoreGapInTranslation());
        this.requestPaneAndRulerRepaint();
    }

    public void toggleTranslationShowBoth() {
        this.alignmentPane.setShowTranslationAndNuc(!this.alignmentPane.getShowTranslationAndNuc());
        this.requestPaneAndRulerRepaint();
    }

    public void decReadingFrame() {
        this.alignment.decReadingFrame();
        this.requestPaneAndRulerRepaint();
    }

    public void incReadingFrame() {
        this.alignment.incReadingFrame();
        this.requestPaneAndRulerRepaint();
    }

    public void setReadingFrame(int readingFrame) {
        this.alignment.setReadingFrame(readingFrame);
        this.requestPaneAndRulerRepaint();
    }

    public void toggleDrawAminoAcidCode() {
        this.alignmentPane.setDrawAminoAcidCode(!this.alignmentPane.isDrawAminoAcidCode());
        this.requestPaneAndRulerRepaint();
    }

    public void setEditMode(boolean allowEdit) {
        this.alignment.setEditMode(allowEdit);
        this.fireEditModeChanged();
    }

    public void setShowTranslation(boolean selected) {
        this.alignmentPane.setShowTranslation(selected);
        if (!selected) {
            // empty if block
        }
        this.alignmentPane.setDrawCodonPosOnRuler(this.alignmentPane.isShowTranslation());
        if (this.translationPanel != null) {
            this.translationPanel.setVisible(this.alignmentPane.isShowTranslation());
        }
        this.requestPaneAndRulerRepaint();
    }

    public void setHighlightNonConsensus(boolean selected) {
        this.alignmentPane.setHighlightNonCons(selected);
        this.requestPaneRepaint();
    }

    public void setHighlightConsensus(boolean selected) {
        this.alignmentPane.setHighlightCons(selected);
        this.requestPaneRepaint();
    }

    public void setHighlightDiff(boolean selected) {
        this.alignmentPane.setHighlightDiffTrace(selected);
        this.requestPaneRepaint();
    }

    public void mntmToggleTranslationOnePos() {
        logger.info("toggleOnePos");
        Point oldTransPosTopLeft = this.alignmentPane.getVisibleUpperLeftMatrixPos();
        Point oldNucPosTopLeft = this.alignmentPane.getVisibleUpperLeftMatrixPos();
        Rectangle oldSelectRect = this.alignment.getSelectionAsMinRect();
        boolean isPrevShowTransOnePos = this.alignment.isTranslatedOnePos();
        this.alignment.setTranslationOnePos(!this.alignment.isTranslatedOnePos());
        boolean isNowShowTransOnePos = this.alignmentPane.isShowTranslationOnePos();
        this.aliViewMenuBar.setEditFunctionsEnabled(this.alignment.isEditable());
        if (isPrevShowTransOnePos != isNowShowTransOnePos) {
            if (isPrevShowTransOnePos) {
                int selectionDiff = 0;
                if (oldSelectRect != null) {
                    selectionDiff = oldSelectRect.x - oldTransPosTopLeft.x;
                    selectionDiff = selectionDiff > 0 && selectionDiff < 1000 ? (int)(2.01 * (double)selectionDiff) : 0;
                }
                CodonPos codonPos = this.alignment.getAlignmentMeta().getCodonPositions().getCodonInTranslatedPos(oldTransPosTopLeft.x);
                Point nucPosUpperLeft = new Point(codonPos.startPos + selectionDiff, oldTransPosTopLeft.y);
                this.alignmentPane.scrollToVisibleUpperLeftMatrixPos(nucPosUpperLeft);
            } else {
                int selectionDiff = 0;
                if (oldSelectRect != null) {
                    selectionDiff = oldSelectRect.x - oldNucPosTopLeft.x;
                    selectionDiff = selectionDiff > 0 && selectionDiff < 1000 ? (int)(0.685 * (double)selectionDiff) : 0;
                }
                int aaPos = this.alignment.getAlignmentMeta().getCodonPositions().getAminoAcidPosFromNucleotidePos(oldNucPosTopLeft.x);
                Point translatedUpperLeft = new Point(aaPos - selectionDiff, oldNucPosTopLeft.y);
                this.alignmentPane.scrollToVisibleUpperLeftMatrixPos(translatedUpperLeft);
            }
        }
    }

    public void sortSequencesByName() {
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.sortSequencesByName();
        this.alignmentPane.validateSequenceOrder();
    }

    public void sortSequencesByCharColumn() {
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.sortSequencesByCharInSelectedColumn();
        this.alignmentPane.validateSequenceOrder();
    }

    public void setSelectionAsNonCoding() {
        this.alignment.setSelectionAsNonCoding();
        this.requestPaneAndRulerRepaint();
    }

    public void setSelectionAsCoding(int startPos) {
        this.alignment.setSelectionAsCoding(startPos);
        this.requestPaneAndRulerRepaint();
    }

    public void addOrRemoveSelectionToExcludes() {
        this.alignment.addOrRemoveSelectionToExcludes();
        this.requestPaneRepaint();
    }

    public void moveSelectedToBottom() {
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.moveSelectedSequencesToBottom();
    }

    public void moveSelectedToTop() {
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.moveSelectedSequencesToTop();
    }

    public void moveSelectedDown() {
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.moveSelectedSequencesDown();
        this.requestScrollToVisibleSelection();
    }

    public void moveSelectedUp() {
        logger.info("move sel up");
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.moveSelectedSequencesUp();
        this.requestScrollToVisibleSelection();
    }

    public void moveSelectedTo(int index) {
        this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
        this.alignment.moveSelectedSequencesTo(index);
        this.requestScrollToVisibleSelection();
    }

    public void selectEverythingWithinGaps(Point point) {
        this.alignment.selectEverythingWithinGaps(point);
    }

    public void selectAll() {
        int size = this.sequenceJList.getModel().getSize();
        if (size > 0) {
            this.sequenceJList.setSelectionInterval(0, size - 1);
        }
    }

    public void deleteSelected() {
        if (!this.requestEditMode()) {
            return;
        }
        if (this.alignment.hasFullySelectedSequences()) {
            boolean hideMessage = Settings.getHideDeleteAllSelectedSequences().getBooleanValue();
            if (!hideMessage) {
                boolean hideMessageNextTime = Messenger.showOKCancelMessageWithCbx(Messenger.DELETE_SELECTED_SEQUENCES, false, this.aliViewWindow);
                Settings.getHideDeleteAllSelectedSequences().putBooleanValue(hideMessageNextTime);
                int choise = Messenger.getLastSelectedOption();
                if (choise == 2) {
                    return;
                }
            }
            if (this.isUndoable()) {
                this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateSequenceOrder(this.alignment.getSequences().getDelegateSequencesCopy(), this.alignment.getAlignentMetaCopy()));
            }
            this.alignment.deleteFullySelectedSequences();
        } else if (this.alignment.hasSelection()) {
            boolean hideMessage = Settings.getHideDeleteAllSelectedBases().getBooleanValue();
            if (!hideMessage) {
                boolean hideMessageNextTime = Messenger.showOKCancelMessageWithCbx(Messenger.DELETE_SELECTED_BASES, false, this.aliViewWindow);
                Settings.getHideDeleteAllSelectedBases().putBooleanValue(hideMessageNextTime);
                int choise = Messenger.getLastSelectedOption();
                if (choise == 2) {
                    return;
                }
            }
            if (this.isUndoable()) {
                this.aliViewWindow.getUndoControler().pushUndoState();
            }
            this.alignment.deleteSelectedBases();
        }
        MemoryUtils.logMem();
        this.requestRepaintAndRevalidateALL();
    }

    public void deleteExludedBases() {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.deleteAllExsetBases();
    }

    public void deleteEmptySequences() {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.deleteEmptySequences();
    }

    public void copySelectionAsFasta() {
        logger.info("copy selection as fasta");
        this.alignment.copySelectionToClipboardAsFasta();
    }

    public void copyNames() {
        this.alignment.copySelectionNames();
    }

    public void copySelectionAsNucleotides() {
        this.alignment.copySelectionToClipboardAsNucleotides();
    }

    public void renameFirstSelected() {
        String name = this.alignment.getFirstSelectedSequenceName();
        if (name != null) {
            Point pos = this.sequenceJList.getFirstSelectedCellPos();
            pos.translate(130, -60);
            TextEditDialog txtEdit = new TextEditDialog(pos);
            txtEdit.showOKCancelTextEditor(name, "Rename sequence", this);
            if (txtEdit.getSelectedValue() == 0) {
                String newName = txtEdit.getEditText();
                List<Sequence> prevState = this.alignment.setFirstSelectedSequenceName(newName);
                if (this.isUndoable()) {
                    this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignmentMeta()));
                }
                this.requestRepaintAndRevalidateALL();
            }
        }
    }

    public void addSequencesFromFile(int atIndex) {
        String suggestedDir = Settings.getLoadAlignmentDirectory();
        File suggestedFile = new File(suggestedDir);
        File selectedFile = FileUtilities.selectOpenFileViaChooser(suggestedFile, this.aliViewWindow);
        if (selectedFile != null) {
            this.addSequencesFromFile(selectedFile, atIndex);
        }
    }

    public void addSequencesFromFile(File seqFile, int atIndex) {
        if (seqFile == null || !seqFile.exists()) {
            return;
        }
        this.aliViewWindow.getUndoControler().pushUndoState();
        if (this.alignment.getSize() == 0) {
            Alignment newAlignment = AlignmentFactory.createNewAlignment(seqFile);
            if (newAlignment != null) {
                this.setupNewAlignment(newAlignment);
            }
        } else {
            this.alignment.addSequences(seqFile, atIndex);
        }
    }

    public void pasteFasta(int pasteAtIndex) {
        String clipboardSelection = AliViewWindow.getClipboard();
        if (clipboardSelection == null || clipboardSelection.length() == 0) {
            Messenger.showOKOnlyMessage(Messenger.CLIPBOARD_EMPTY, this.aliViewWindow);
            return;
        }
        try {
            File clipAsFile = AlignmentFile.createAliViewTempFile("clipboard-alignment", ".fasta");
            if (FileFormat.isThisFasta(clipboardSelection) || FileFormat.isThisSequenceFile(clipboardSelection)) {
                if (FileFormat.isThisSequenceFile(clipboardSelection)) {
                    clipAsFile = new File(clipboardSelection);
                } else {
                    FileUtils.writeStringToFile(clipAsFile, clipboardSelection);
                }
            } else {
                String[] lines;
                boolean hideMessage = Settings.getHidePasteAnywayMessage().getBooleanValue();
                if (!hideMessage) {
                    boolean hideMessageNextTime = Messenger.showOKCancelMessageWithCbx(Messenger.NO_FASTA_IN_CLIPBOARD_PASTE_ANYWAY, false, this.aliViewWindow);
                    Settings.getHidePasteAnywayMessage().putBooleanValue(hideMessageNextTime);
                    int choise = Messenger.getLastSelectedOption();
                    if (choise == 2) {
                        return;
                    }
                }
                StringBuffer newClip = new StringBuffer();
                for (String line : lines = clipboardSelection.split(LF)) {
                    newClip.append(">pasted-seq_" + this.pastedSeqCounter + LF);
                    newClip.append(line + LF);
                    ++this.pastedSeqCounter;
                }
                FileUtils.writeStringToFile(clipAsFile, newClip.toString());
            }
            this.addSequencesFromFile(clipAsFile, pasteAtIndex);
        }
        catch (IOException e) {
            e.printStackTrace();
            Messenger.showOKOnlyMessage(Messenger.ERROR_PASTE, LF + e.getLocalizedMessage(), this.aliViewWindow);
        }
    }

    public void pasteFasta() {
        this.pasteFasta(0);
    }

    public void merge2SelectedSequences() {
        List<Sequence> selected = this.alignment.getSelectedSequences();
        if (selected.size() == 2) {
            this.aliViewWindow.getUndoControler().pushUndoState();
            boolean isMerged = this.alignment.mergeTwoSequences(selected, true);
            if (isMerged) {
                this.alignment.deleteSequence(selected.get(1));
            }
        }
    }

    public void deleteVerticalGaps() {
        boolean hideMessage = Settings.getHideDeleteVerticalGapsMessage().getBooleanValue();
        if (!hideMessage) {
            boolean hideMessageNextTime = Messenger.showOKCancelMessageWithCbx(Messenger.DELETE_VERTICAL_GAPS, false, this.aliViewWindow);
            Settings.getHideDeleteVerticalGapsMessage().putBooleanValue(hideMessageNextTime);
            int choise = Messenger.getLastSelectedOption();
            if (choise == 2) {
                return;
            }
        }
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.deleteVerticalGaps();
        this.requestPaneRepaint();
    }

    public void find() {
        this.searchPanel.getSearchField().requestFocus();
        this.searchPanel.getSearchField().selectAll();
    }

    public void reverseComplementSelectedSequences() {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.reverseComplementFullySelectedSequences();
    }

    public void reverseComplementAlignment() {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.reverseComplementAlignment();
    }

    public void complementAlignment() {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.complementAlignment();
    }

    public void clearSelection() {
        if (this.aliCursor != null) {
            this.aliCursor.restorePosition();
        }
        this.alignment.clearSelection();
    }

    public void invertSelection() {
        this.alignment.invertSelection();
    }

    public void replaceSelectedWithChar(char typed) {
        this.aliViewWindow.getUndoControler().pushUndoState();
        this.alignment.replaceSelectedWithChar(typed);
    }

    public void deleteAllGaps() {
        if (!this.requestEditMode()) {
            return;
        }
        boolean hideMessage = Settings.getHideDeleteAllGapsMessage().getBooleanValue();
        if (!hideMessage) {
            boolean hideMessageNextTime = Messenger.showOKCancelMessageWithCbx(Messenger.DELETE_ALL_GAPS, false, this.aliViewWindow);
            Settings.getHideDeleteAllGapsMessage().putBooleanValue(hideMessageNextTime);
            int choise = Messenger.getLastSelectedOption();
            if (choise == 2) {
                return;
            }
        }
        this.undoControler.pushUndoState();
        this.alignment.deleteAllGaps();
    }

    public void trimSequences() {
        this.undoControler.pushUndoState();
        this.alignment.trimSequences();
    }

    public void moveSelectionRight() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.moveSelectionRight(this.isUndoable());
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
        this.requestScrollToVisibleSelection();
    }

    public void moveSelectionLeft() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.moveSelectionLeft(this.isUndoable());
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
        this.requestScrollToVisibleSelection();
    }

    public void deleteGapMoveLeft() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.deleteGapMoveLeft(this.isUndoable());
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
        this.alignmentPane.validateSize();
        this.requestScrollToVisibleSelection();
    }

    public void deleteGapMoveRight() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.deleteGapMoveRight(this.isUndoable());
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
        this.alignmentPane.validateSize();
        this.requestScrollToVisibleSelection();
    }

    public void insertGapMoveRight() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.insertGapLeftOfSelectionMoveRight(this.isUndoable());
        logger.debug("prevState" + prevState);
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
        this.alignmentPane.validateSize();
        this.requestScrollToVisibleSelection();
    }

    public void insertGapMoveLeft() {
        if (!this.requestEditMode()) {
            return;
        }
        List<Sequence> prevState = this.alignment.insertGapRightOfSelectionMoveLeft(this.isUndoable());
        if (this.isUndoable()) {
            this.aliViewWindow.getUndoControler().pushUndoState(new UndoSavedStateEditedSequences(prevState, this.alignment.getAlignentMetaCopy()));
        }
        this.alignmentPane.validateSize();
        this.alignmentPane.scrollMatrixX(-1);
        this.requestScrollToVisibleSelection();
    }

    public boolean requestReloadWindow() {
        boolean isReloadOK = true;
        if (this.hasUnsavedEdits()) {
            String message = "There might be unsaved edits - do you want to reload and loose changes?";
            this.toFront();
            int retVal = JOptionPane.showConfirmDialog(this, message, "Reload and loose changes?", 1);
            if (retVal == 0) {
                isReloadOK = true;
            }
            if (retVal == 1) {
                isReloadOK = false;
            }
            if (retVal == 2) {
                isReloadOK = false;
            }
        } else {
            isReloadOK = true;
        }
        return isReloadOK;
    }

    public boolean requestWindowClose() {
        boolean isCloseOK = true;
        if (this.hasUnsavedEdits()) {
            String message = "There might be unsaved edits - save before close?";
            this.toFront();
            int retVal = JOptionPane.showConfirmDialog(this, message, "Save edits?", 1);
            if (retVal == 0) {
                boolean wasFileSaved = this.saveAlignmentAsFileViaChooser();
                isCloseOK = wasFileSaved;
            }
            if (retVal == 1) {
                isCloseOK = true;
            }
            if (retVal == 2) {
                isCloseOK = false;
            }
        } else {
            isCloseOK = true;
        }
        return isCloseOK;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        if (this.alignment != null && this.alignment.getSequences() != null && this.alignment.getSequences().getSize() > 0) {
            isEmpty = false;
        }
        return isEmpty;
    }

    public void selectDuplicates() {
        this.alignment.clearSelection();
        this.alignment.selectDuplicates();
    }

    private void setPaneAndListBGColor(Color color) {
        this.listTopOffset.setBackground(color);
        this.sequenceJList.setBackground(color);
        this.alignmentPane.setBackground(color);
        this.alignmentPane.getRulerComponent().setBackground(color);
        this.alignmentPane.getCharsetRulerComponent().setBackground(color);
    }

    public void setColorSchemeNucleotide(ColorScheme aScheme) {
        this.setPaneAndListBGColor(aScheme.getBaseBackgroundColor(0));
        this.alignmentPane.setColorSchemeNucleotide(aScheme);
        this.requestPaneRepaint();
        Settings.setColorSchemeNucleotide(aScheme);
    }

    public void setColorSchemeAminoAcid(ColorScheme aScheme) {
        this.setPaneAndListBGColor(aScheme.getBaseBackgroundColor(0));
        this.alignmentPane.setColorSchemeAminoAcid(aScheme);
        this.requestPaneRepaint();
        Settings.setColorSchemeAminoAcid(aScheme);
    }

    public void setGeneticCode(GeneticCode genCode) {
        this.alignment.setGeneticCode(genCode);
        this.requestPaneRepaint();
    }

    public void setDifferenceTraceSequence(Point alignmentPanePos) {
        Point matrixPos = this.alignmentPane.paneCoordToMatrixCoord(alignmentPanePos);
        this.alignmentPane.setDifferenceTraceSequence((int)matrixPos.getY());
        this.requestPaneRepaint();
    }

    public void createStats() {
        this.alignment.getStats();
        MemoryUtils.logMem();
    }

    public void selectAll(CharSet aCharSet) {
        this.alignment.selectAll(aCharSet);
    }

    private void fireEditModeChanged() {
        this.aliViewMenuBar.editModeChanged();
    }

    public void createOrUpdateDynamicLoadFileMenu() {
        logger.info("create");
    }

    @Override
    public void pushUndoState() {
        if (this.isUndoable()) {
            UndoSavedStateEverything state = new UndoSavedStateEverything(this.alignment.getSequences().getCopy(), this.alignment.getAlignentMetaCopy());
            this.pushUndoState(state);
        }
    }

    @Override
    public void pushUndoState(UndoSavedState state) {
        this.undoList.add(state);
        this.hasUnsavedUndoableEdits = true;
        this.updateWindowTitle();
        this.fireUndoRedoChange();
    }

    private void fireUndoRedoChange() {
        this.aliViewMenuBar.setUndoButtonEnabled(!this.isUndoStackEmpty());
        this.aliViewMenuBar.setRedoButtonEnabled(!this.isRedoStackEmpty());
    }

    public boolean isUndoStackEmpty() {
        return !this.undoList.hasAvailableUndos();
    }

    public boolean isRedoStackEmpty() {
        return !this.undoList.hasAvailableRedos();
    }

    private void undoSequenceEdit(UndoSavedStateEditedSequences undoObj) {
        logger.info("undoSequenceEdit");
        for (Sequence previous : undoObj.editedSequences) {
            int index = this.alignment.getSequenceIndex(this.alignment.getSequenceByID(previous.getID()));
            this.alignment.getSequences().set(index, previous);
        }
    }

    private void undoMetaOnly(UndoSavedStateMetaOnly state) {
        logger.info("undoMetaOnly");
        this.alignment.setAlignentMeta(state.meta);
    }

    private void undoSequenceOrder(UndoSavedStateSequenceOrder state) {
        logger.info("undoSequenceOrder");
        this.alignment.getSequences().setSequences(state.sequencesBackend);
        this.alignment.setAlignentMeta(state.meta);
    }

    private void undoEverything(UndoSavedStateEverything state) throws AlignmentImportException {
        logger.info("undoEverything");
        this.alignment.setNewSequencesFromUndo(state.sequences);
        this.alignment.setAlignentMeta(state.meta);
    }

    @Override
    public void undo() {
        if (this.undoList.hasAvailableUndos()) {
            if (this.undoList.isCurrentStateNeeded()) {
                this.undoList.addCurrentState(new UndoSavedStateEverything(this.alignment.getSequences().getCopy(), this.alignment.getAlignentMetaCopy()));
            }
            UndoSavedState undoObj = this.undoList.getUndoState();
            logger.info("inne i undo");
            if (undoObj instanceof UndoSavedStateEverything) {
                try {
                    logger.info("undo everyt");
                    this.undoEverything((UndoSavedStateEverything)undoObj);
                }
                catch (AlignmentImportException e) {
                    Messenger.showOKOnlyMessage(Messenger.UNDO_REDO_PROBLEM, LF + e.getLocalizedMessage(), this.aliViewWindow);
                    e.printStackTrace();
                }
            } else if (undoObj instanceof UndoSavedStateSequenceOrder) {
                this.undoSequenceOrder((UndoSavedStateSequenceOrder)undoObj);
            } else if (undoObj instanceof UndoSavedStateEditedSequences) {
                this.undoSequenceEdit((UndoSavedStateEditedSequences)undoObj);
            } else if (undoObj instanceof UndoSavedStateMetaOnly) {
                this.undoMetaOnly((UndoSavedStateMetaOnly)undoObj);
            }
            this.requestRepaintAndRevalidateALL();
        }
        if (this.isUndoStackEmpty()) {
            logger.info("updatingTitl");
            this.hasUnsavedUndoableEdits = false;
            this.updateWindowTitle();
        }
        this.fireUndoRedoChange();
    }

    @Override
    public void redo() {
        if (this.undoList.hasAvailableRedos()) {
            UndoSavedState redoObj = this.undoList.getRedoState();
            if (redoObj instanceof UndoSavedStateEverything) {
                try {
                    this.undoEverything((UndoSavedStateEverything)redoObj);
                }
                catch (AlignmentImportException e) {
                    e.printStackTrace();
                    Messenger.showOKOnlyMessage(Messenger.UNDO_REDO_PROBLEM, LF + e.getLocalizedMessage(), this.aliViewWindow);
                }
            } else if (redoObj instanceof UndoSavedStateSequenceOrder) {
                this.undoSequenceOrder((UndoSavedStateSequenceOrder)redoObj);
            } else if (redoObj instanceof UndoSavedStateEditedSequences) {
                this.undoSequenceEdit((UndoSavedStateEditedSequences)redoObj);
            } else if (redoObj instanceof UndoSavedStateMetaOnly) {
                this.undoMetaOnly((UndoSavedStateMetaOnly)redoObj);
            }
            this.requestRepaintAndRevalidateALL();
        }
        this.fireUndoRedoChange();
    }

    private AliCursor createNewAliCursor() {
        Point center = this.alignmentPane.matrixCoordToPaneCoord(new Point((int)this.alignmentPane.getVisibleRect().getCenterX(), (int)this.alignmentPane.getVisibleRect().getCenterY()));
        AliCursor newAliCursor = new AliCursor(center.x, center.y);
        return newAliCursor;
    }

    public boolean isReverseHorizontalRotation() {
        return Settings.getReverseHorizontalMouseWheel().getBooleanValue();
    }

    public boolean isReverseVerticalRotation() {
        return Settings.getReverseVerticalMouseWheel().getBooleanValue();
    }

    public void scrollToPos(Point matrixPos) {
        this.alignmentPane.scrollToPos(matrixPos);
    }

    public void scrollToCursor(int keyDirection) {
        AliCursor aliCursor = this.getAliCursor();
        if (aliCursor != null) {
            Point pointInPaneCoord = this.alignmentPane.matrixCoordToPaneCoord(new Point(aliCursor.x, aliCursor.y));
            Rectangle visiRect = new Rectangle(pointInPaneCoord);
            if (keyDirection == 37) {
                visiRect.add(visiRect.getMinX() - 40.0, visiRect.getCenterY());
            }
            if (keyDirection == 39) {
                visiRect.add(visiRect.getMaxX() + 40.0, visiRect.getCenterY());
            }
            if (keyDirection == 38) {
                visiRect.add(visiRect.getCenterX(), visiRect.getMinY() - 40.0);
            }
            if (keyDirection == 40) {
                visiRect.add(visiRect.getCenterX(), visiRect.getMaxY() + 40.0);
            }
            if (!this.alignmentPane.getVisibleRect().contains(visiRect)) {
                this.alignmentPane.scrollRectToVisible(visiRect);
            }
        }
    }

    public void scrollToVisibleCursor() {
        AliCursor aliCursor = this.getAliCursor();
        logger.info(aliCursor);
        if (aliCursor != null) {
            logger.info("point" + new Point(aliCursor.x, aliCursor.y));
            Point pointInPaneCoord = this.alignmentPane.matrixCoordToPaneCoord(new Point(aliCursor.x, aliCursor.y));
            Rectangle visiRect = new Rectangle(pointInPaneCoord);
            visiRect.grow(40, 40);
            logger.info("alignmentPane.getVisibleRect()" + this.alignmentPane.getVisibleRect());
            logger.info("alignmentPane.getVisibleRect().contains(visiRect)" + this.alignmentPane.getVisibleRect().contains(visiRect));
            if (!this.alignmentPane.getVisibleRect().contains(visiRect)) {
                this.alignmentPane.scrollRectToVisible(visiRect);
            }
        }
    }

    private AliCursor getAliCursor() {
        if (this.aliCursor == null) {
            this.aliCursor = this.createNewAliCursor();
        }
        return this.aliCursor;
    }

    public void moveCursorUp(boolean isShiftDown) {
        logger.info("Before Up Time from last endTim " + (System.currentTimeMillis() - this.alignmentPane.getEndTime()) + " milliseconds");
        this.getAliCursor().moveUp(isShiftDown);
        logger.info("DoneUp Time from last endTim " + (System.currentTimeMillis() - this.alignmentPane.getEndTime()) + " milliseconds");
    }

    public void moveCursorDown(boolean isShiftDown) {
        this.getAliCursor().moveDown(isShiftDown);
    }

    public void moveCursorLeft(boolean isShiftDown) {
        this.getAliCursor().moveLeft(isShiftDown);
    }

    public void moveCursorRight(boolean isShiftDown) {
        this.getAliCursor().moveRight(isShiftDown);
    }

    public void editAlignerALLSettings() {
        SettingsFrame settingsFrame = new SettingsFrame((Component)this);
        settingsFrame.selectTab("Align ALL program");
        settingsFrame.setVisible(true);
    }

    public void editAlignerADDSettings() {
        SettingsFrame settingsFrame = new SettingsFrame((Component)this);
        settingsFrame.selectTab("Align ADD program");
        settingsFrame.setVisible(true);
    }

    public void editExternalCommands() {
        SettingsFrame settingsFrame = new SettingsFrame((Component)this);
        settingsFrame.selectTab("External commands");
        settingsFrame.setVisible(true);
    }

    public void findPrimerSettings() {
        SettingsFrame settingsFrame = new SettingsFrame((Component)this);
        settingsFrame.selectTab("Primer");
        settingsFrame.setVisible(true);
    }

    public void openPreferencesGeneral() {
        SettingsFrame settingsFrame = new SettingsFrame((Component)this);
        settingsFrame.selectTab("General");
        settingsFrame.setVisible(true);
    }

    public void runExternalCommand(CommandItem cmdItem) {
        cmdItem.reParseCommand();
        this.runExternalCommandImplementation(cmdItem);
    }

    public void runExternalCommandImplementation(final CommandItem cmdItem) {
        final SubProcessWindow subProcessWin = new SubProcessWindow(this.aliViewWindow);
        subProcessWin.setTitle(cmdItem.getName());
        subProcessWin.setAlwaysOnTop(false);
        subProcessWin.placeFrameupperLeftLocationOfThis(this.aliViewWindow);
        if (cmdItem.isShowCommandWindow()) {
            subProcessWin.show();
        }
        try {
            FileFormat currentTempFileFormat = cmdItem.getCurrentAlignmentFileFormat();
            AlignmentFile currentAlignmentTempFile = AlignmentFile.createAliViewTempFile("current-alignment", currentTempFileFormat.getSuffix());
            this.alignment.saveAlignmentAsFile(currentAlignmentTempFile, currentTempFileFormat, true);
            AlignmentFile emptyTempFile = AlignmentFile.createAliViewTempFile("tempfile-for-new-alignment", ".tmp");
            cmdItem.setParameterCurrentFile(currentAlignmentTempFile);
            cmdItem.setParameterOutputFile(emptyTempFile);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExternalCommandExecutor.executeMultiple(cmdItem, subProcessWin);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Messenger.showOKOnlyMessage(Messenger.ERROR_RUNNING_EXTERNAL_COMMAND, LF + e.getLocalizedMessage(), AliViewWindow.this.aliViewWindow);
                    }
                    logger.info("done external");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean wasProcessInterruptedByUser = subProcessWin.wasSubProcessDestrouedByUser();
                            AliViewWindow.this.aliViewWindow.externalCommandCallback(cmdItem);
                            subProcessWin.dispose();
                        }
                    });
                }
            });
            thread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void externalCommandCallback(CommandItem cmdItem) {
        logger.info("this method is not implemented yet");
    }

    public boolean isEditMode() {
        return this.alignment.isEditMode();
    }

    public boolean requestEditMode() {
        boolean allowEdit;
        if (!this.isEditMode() && (allowEdit = Messenger.askAllowEditMode())) {
            this.aliViewWindow.setEditMode(true);
        }
        return this.isEditMode();
    }

    public void printAlignment() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setJobName("Printing alignment from AliView");
        PageFormat pf = job.defaultPage();
        job.setPrintable(this);
        boolean ok = job.printDialog();
        if (ok) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                Messenger.showOKOnlyMessage(Messenger.ERROR_PRINTING, LF + ex.getLocalizedMessage(), this.aliViewWindow);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void newSequences(AlignmentEvent alignmentEvent) {
        logger.debug("New sequences");
    }

    @Override
    public void alignmentMetaChanged(AlignmentEvent alignmentEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    public void contentsChanged(AlignmentDataEvent e) {
        logger.info("selectionChanged");
        this.requestRepaintRect(e.getBounds());
    }

    @Override
    public void selectionChanged(AlignmentSelectionEvent e) {
        logger.info("selectionChanged");
        this.requestRepaintRect(e.getBounds());
    }

    public void requestRepaintRect(Rectangle rect) {
        int dx = (int)(this.alignmentPane.getCharWidth() * 3.0);
        int dy = (int)(this.alignmentPane.getCharHeight() * 1.0);
        if (dx < 3 || dy < 1) {
            dx = 6;
            dy = 2;
        }
        Rectangle paneBounds = this.alignmentPane.matrixCoordToPaneCoord(rect);
        Rectangle grown = new Rectangle(paneBounds.x - dx, paneBounds.y - dy, paneBounds.getBounds().width + 2 * dx, paneBounds.getBounds().height + 2 * dy);
        this.alignmentPane.validateSize();
        this.alignmentPane.validateSequenceOrder();
        this.alignmentPane.repaint(grown);
        Rectangle visiRect = this.sequenceJList.getVisibleRect();
        Rectangle drawListBounds = new Rectangle(visiRect.x, grown.y, visiRect.width, grown.height);
        logger.info("drawListBounds" + drawListBounds);
        this.sequenceJList.repaint(drawListBounds);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        double dpi = 72.0;
        double pixPerMM = PrintUtils.mmToPixel(1.0, dpi);
        double imagableX = pageFormat.getImageableX();
        double imagableY = pageFormat.getImageableY();
        double pgHeight = pageFormat.getImageableHeight();
        double pgWidth = pageFormat.getImageableWidth();
        Dimension pageSize = new Dimension();
        pageSize.setSize(pgWidth, pgHeight);
        logger.info("x" + imagableX);
        logger.info("y" + imagableY);
        logger.info("width" + pgWidth);
        logger.info("height" + pgHeight);
        logger.info("thiswidth" + this.getWidth());
        logger.info("thisheight" + this.getHeight());
        double scaleFactor = PrintUtils.getScaleFactorToFit(this.getSize(), pageSize);
        logger.info(scaleFactor);
        Graphics2D g2 = (Graphics2D)graphics.create();
        AffineTransform savedTrans = (AffineTransform)g2.getTransform().clone();
        Rectangle rulerRect = this.alignmentPane.getRulerComponent().getVisibleRect();
        double rulerHeight = rulerRect.getHeight();
        logger.info("rulerHeight" + rulerHeight);
        Rectangle listVisible = this.listScrollPane.getViewport().getVisibleRect();
        listVisible.setSize(listVisible.width + 5, listVisible.height);
        logger.info("listVisible.width" + listVisible.width);
        g2.translate(imagableX, imagableY + rulerHeight * scaleFactor);
        g2.scale(scaleFactor, scaleFactor);
        g2.setClip(listVisible);
        this.listScrollPane.getViewport().paint(g2);
        double extraSpaceBTWListAndPane = 2.0;
        g2.setTransform((AffineTransform)savedTrans.clone());
        g2.translate(((double)listVisible.width + extraSpaceBTWListAndPane) * scaleFactor + imagableX, imagableY);
        g2.scale(scaleFactor, scaleFactor);
        g2.setClip(rulerRect);
        this.alignmentPane.getRulerComponent().paint(g2);
        g2.setTransform((AffineTransform)savedTrans.clone());
        g2.translate(((double)listVisible.width + extraSpaceBTWListAndPane) * scaleFactor + imagableX, imagableY + rulerHeight * scaleFactor);
        g2.scale(scaleFactor, scaleFactor);
        g2.setClip(this.alignmentScrollPane.getViewport().getVisibleRect());
        this.alignmentScrollPane.getViewport().paintAll(g2);
        logger.info(pageIndex);
        g2.dispose();
        if (pageIndex > 0) {
            return 1;
        }
        return 0;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void showAbout() {
        String version = AliView.getVersion();
        logger.info("version=" + version);
        String message = "AliView version: " + version;
        JOptionPane.showMessageDialog(this.aliViewWindow, message, "About", 1);
    }

    public void checkNewVersion() {
        String version = AliView.getVersion();
        HelpUtils.displayVersionDownload(version);
    }

    public void displayVersionHistory() {
        HelpUtils.displayVersionHistory();
    }

    public void openBugReportPage() {
        HelpUtils.display("BUG_OR_FEATURE", this);
    }

    public void openHelp() {
        HelpUtils.display("TOP_HELP", this);
    }

    public void countStopCodons() {
        int count = this.alignment.countStopCodons();
        Messenger.showCountStopCodonMessage(count, this);
    }

    public void startDebug() {
        Logger.getRootLogger().setLevel(Level.ALL);
    }

    public void requestGB() {
        System.gc();
    }

    public void saveFastaIndex() {
        this.alignment.saveFastaIndex();
    }

    public void expandSelectionRight() {
        this.alignment.selectionExtendRight();
    }

    public void expandSelectionLeft() {
        this.alignment.selectionExtendLeft();
    }

    public void expandSelectionDown() {
        this.alignment.selectionExtendDown();
    }

    public void expandSelectionTop() {
        this.alignment.selectionExtendTop();
    }

    public void phenotype2genotype() {
        String suggestedDir = Settings.getLoadAlignmentDirectory();
        File suggestedFile = new File(suggestedDir);
        File selectedFile = FileUtilities.selectOpenFileViaChooser(suggestedFile, this.aliViewWindow.getParent());
        if (selectedFile != null) {
            try {
                File fastaGenResultFile = new File(selectedFile.getParentFile(), selectedFile.getName() + "_genotype." + FileFormat.FASTA.getSuffix());
                Phenotype2Genootype gen2phen = new Phenotype2Genootype();
                gen2phen.createGenotypeFasta(selectedFile, fastaGenResultFile);
                AliView.openAlignmentFile(fastaGenResultFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                Messenger.showOKOnlyMessage(Messenger.PHENOTYPE_IMAGE_OPEN_ERROR, LF + e.getLocalizedMessage(), this);
            }
        }
    }

    public void addNewSequence() {
        this.alignment.addNewSequence();
    }

    public void setFontCaseUpper(boolean selected) {
        int fontCase = 0;
        if (selected) {
            fontCase = 1;
        }
        this.alignmentPane.setFontCase(fontCase);
        Settings.getFontCase().putIntValue(fontCase);
        this.requestRepaintAndRevalidateALL();
    }

    public void showCharsetsRuler(boolean selected) {
        this.alignmentPane.setShowCharsetRuler(selected);
        Settings.getShowCharsetRuler().putBooleanValue(selected);
        this.requestRepaintAndRevalidateALL();
    }

    public void editCharsets() {
        TextEditFrame frame = new TextEditFrame((Component)this);
        TextEditPanelCharsets panel2 = new TextEditPanelCharsets(frame, this);
        frame.init(panel2);
        frame.setVisible(true);
    }

    public void goToPos() {
        TextEditDialog goToPosDlg = new TextEditDialog();
        goToPosDlg.showOKCancelTextEditor(this.goToPosTextFieldValue, "Go to position (x) or (,y) or (x,y)", this);
        if (goToPosDlg.getSelectedValue() == 0) {
            String posText;
            this.goToPosTextFieldValue = posText = goToPosDlg.getEditText();
            Point currentPos = this.alignmentPane.getVisibleCenterMatrixPos();
            int newX = currentPos.x;
            int newY = currentPos.y;
            try {
                String xPos = StringUtils.substringBefore(posText, ",");
                newX = Integer.parseInt(xPos);
            }
            catch (NumberFormatException xPos) {
                // empty catch block
            }
            try {
                String yPos = StringUtils.substringAfter(posText, ",");
                newY = Integer.parseInt(yPos);
            }
            catch (NumberFormatException yPos) {
                // empty catch block
            }
            Point newPos = new Point(newX, newY);
            this.scrollToPos(newPos);
        }
    }

    public void adjustReadingFrameMinimizeStop() {
        AlignmentListModel origModel = this.alignment.getSequences();
        for (Sequence origSequence : origModel) {
            Sequence seq = origSequence.getCopy();
            ArrayList<Sequence> newSeqs = new ArrayList<Sequence>(1);
            AlignmentListModel model = new AlignmentListModel(newSeqs);
            Alignment newAliment = new Alignment(model);
            int minStops = Integer.MAX_VALUE;
            GeneticCode bestCode = GeneticCode.DEFAULT;
            int bestFrame = 0;
            for (int frame = 0; frame < 3; ++frame) {
                seq.insertGapAt(0);
                for (GeneticCode genCode : GeneticCode.allCodesArray) {
                    newAliment.setGeneticCode(genCode);
                    int stops = seq.countStopCodon();
                    if (stops >= minStops) continue;
                    minStops = stops;
                    bestCode = genCode;
                    bestFrame = frame;
                }
            }
            logger.info("stops = " + minStops + " genCode = " + bestCode.name + " readingFrame = " + bestFrame);
            for (int n = 0; n < bestFrame; ++n) {
                origSequence.insertGapAt(0);
            }
        }
        this.repaint();
    }

    public void terminalGAPtoMissing() {
        this.getUndoControler().pushUndoState();
        this.alignment.terminalGAPtoMissing();
    }

    public void missingToGAP() {
        this.getUndoControler().pushUndoState();
        this.alignment.missingToGAP();
    }

    private class AliCursor {
        int x;
        int y;
        Sequence cursorSeq;
        int posInSeq;

        public AliCursor(int x, int y) {
            this.setPosition(x, y);
        }

        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            this.savePosition();
        }

        public void restorePosition() {
            if (this.cursorSeq != null) {
                int xFromSeq = this.cursorSeq.getPosOfSelectedIndex(this.posInSeq);
                int yFromSeq = AliViewWindow.this.alignment.getSequenceIndex(this.cursorSeq);
                if (AliViewWindow.this.alignment.isPositionValid(xFromSeq, yFromSeq)) {
                    this.x = xFromSeq;
                    this.y = yFromSeq;
                }
            }
        }

        public void savePosition() {
            if (AliViewWindow.this.alignment != null && AliViewWindow.this.alignment.getSequences() != null && AliViewWindow.this.alignment.isPositionValid(this.x, this.y)) {
                logger.info("savepos");
                this.cursorSeq = AliViewWindow.this.alignment.getSequences().get(this.y);
                this.posInSeq = (int)this.cursorSeq.countSelectedPositions(0, this.x);
            }
        }

        public void moveLeft(boolean isShiftDown) {
            this.restorePosition();
            if (AliViewWindow.this.alignment.isPositionValid(this.x - 1, this.y)) {
                if (isShiftDown) {
                    if (AliViewWindow.this.alignment.getSelectionAt(this.x - 1, this.y)) {
                        AliViewWindow.this.alignment.clearColumnSelection(this.x);
                    } else {
                        AliViewWindow.this.alignment.copySelectionFromPosX1toX2(this.x, this.x - 1);
                    }
                } else {
                    AliViewWindow.this.alignment.setSelectionAt(this.x - 1, this.y, true);
                }
                --this.x;
            }
            this.savePosition();
        }

        public void moveRight(boolean isShiftDown) {
            this.restorePosition();
            if (AliViewWindow.this.alignment.isPositionValid(this.x + 1, this.y)) {
                if (isShiftDown) {
                    if (AliViewWindow.this.alignment.getSelectionAt(this.x + 1, this.y)) {
                        AliViewWindow.this.alignment.clearColumnSelection(this.x);
                    } else {
                        AliViewWindow.this.alignment.copySelectionFromPosX1toX2(this.x, this.x + 1);
                    }
                } else {
                    AliViewWindow.this.alignment.setSelectionAt(this.x + 1, this.y, true);
                }
                ++this.x;
            }
            this.savePosition();
        }

        public void moveUp(boolean isShiftDown) {
            this.restorePosition();
            if (AliViewWindow.this.alignment.isPositionValid(this.x, this.y - 1)) {
                if (isShiftDown) {
                    if (AliViewWindow.this.alignment.getSelectionAt(this.x, this.y - 1)) {
                        AliViewWindow.this.alignment.setAllHorizontalSelectionAt(this.y, false);
                    } else {
                        AliViewWindow.this.alignment.copySelectionFromSequenceTo(this.y, this.y - 1);
                    }
                } else {
                    AliViewWindow.this.alignment.setSelectionAt(this.x, this.y - 1, true);
                }
                --this.y;
            }
            this.savePosition();
        }

        public void moveDown(boolean isShiftDown) {
            this.restorePosition();
            if (AliViewWindow.this.alignment.isPositionValid(this.x, this.y + 1)) {
                if (isShiftDown) {
                    if (AliViewWindow.this.alignment.getSelectionAt(this.x, this.y + 1)) {
                        AliViewWindow.this.alignment.setAllHorizontalSelectionAt(this.y, false);
                    } else {
                        AliViewWindow.this.alignment.copySelectionFromSequenceTo(this.y, this.y + 1);
                    }
                } else {
                    AliViewWindow.this.alignment.setSelectionAt(this.x, this.y + 1, true);
                }
                ++this.y;
            }
            this.savePosition();
        }
    }

    private class AlignmentPaneMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Point startPoint;
        private Point startPointScreen;
        private Point startPaneVisibleRectLocation;
        private Point dragPointStart;
        private boolean isDragging;
        private Rectangle lastRect;
        private Rectangle maxRepaintRect;

        private AlignmentPaneMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AliViewWindow.this.alignmentPane.requestFocus();
            if (e.getButton() == 3) {
                return;
            }
            logger.info("mouse pressed" + e.getClickCount());
            this.startPoint = e.getPoint();
            this.startPointScreen = e.getLocationOnScreen();
            this.startPaneVisibleRectLocation = AliViewWindow.this.alignmentPane.getVisibleRect().getLocation();
            this.lastRect = new Rectangle(e.getPoint());
            logger.info("points done");
            if (AliViewWindow.this.alignmentPane.isWithinExistingSelection(e.getPoint())) {
                this.dragPointStart = e.getPoint();
            } else if (!e.isShiftDown()) {
                AliViewWindow.this.sequenceJList.clearSelection();
                AliViewWindow.this.alignmentPane.requestFocus();
                AliViewWindow.this.alignment.clearSelection();
                AliViewWindow.this.sequenceJList.clearSelection();
                try {
                    AliViewWindow.this.alignmentPane.selectBaseAt(this.startPoint);
                }
                catch (InvalidAlignmentPositionException e1) {
                    e1.printStackTrace();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            logger.info("mouseReleased e.getPoint=" + e.getPoint());
            if (e.getButton() == 3) {
                return;
            }
            if (this.startPoint == null) {
                logger.info("nostartpos");
            } else {
                if (AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(e.getPoint()).distance(AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(this.startPoint)) == 0.0) {
                    if (e.isShiftDown()) {
                        Point clickPoint = AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(e.getPoint());
                        Rectangle clickRect = new Rectangle(clickPoint);
                        logger.info(clickRect);
                        Rectangle currentSelection = AliViewWindow.this.alignment.getSelectionAsMinRect();
                        logger.info(currentSelection);
                        Rectangle newSelection = Utils.addRects(clickRect, currentSelection);
                        logger.info(newSelection);
                        AliViewWindow.this.alignment.clearSelection();
                        AliViewWindow.this.alignment.setSelectionWithin(newSelection);
                    } else {
                        logger.info("mouse released");
                        AliViewWindow.this.alignment.clearSelection();
                        AliViewWindow.this.alignment.clearTempSelection();
                        if (e.getComponent() == AliViewWindow.this.alignmentPane.getRulerComponent()) {
                            AliViewWindow.this.alignmentPane.selectColumnAt(this.startPoint);
                            int x = AliViewWindow.this.alignmentPane.getColumnAt(e.getPoint());
                            AliViewWindow.this.aliCursor.setPosition(x, 0);
                        } else {
                            try {
                                AliViewWindow.this.alignmentPane.selectBaseAt(this.startPoint);
                            }
                            catch (InvalidAlignmentPositionException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                } else if (this.isDragging) {
                    this.isDragging = false;
                    AliViewWindow.this.alignment.clearSelectionOffset();
                    this.dragPointStart = null;
                } else {
                    logger.info("select Within");
                    Rectangle selectRect = new Rectangle(e.getPoint());
                    selectRect.add(this.startPoint);
                    logger.info("selectRect" + selectRect);
                    if (!e.isControlDown()) {
                        int selectionSize = 0;
                        AliViewWindow.this.alignment.clearSelection();
                        selectionSize = e.getComponent() == AliViewWindow.this.alignmentPane.getRulerComponent() ? AliViewWindow.this.alignmentPane.selectColumnsWithin(selectRect) : AliViewWindow.this.alignmentPane.selectWithin(selectRect);
                        logger.info(AliViewWindow.this.alignment.getSelectionAsMinRect());
                    }
                    AliViewWindow.this.alignment.clearTempSelection();
                }
                this.startPoint = null;
                this.startPointScreen = null;
                this.isDragging = false;
                AliViewWindow.this.alignment.clearSelectionOffset();
                this.dragPointStart = null;
            }
            this.maxRepaintRect = null;
            if (!e.isShiftDown()) {
                Point clickPos = AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(e.getPoint());
                logger.info(clickPos);
                AliViewWindow.this.aliCursor.setPosition(clickPos.x, clickPos.y);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            logger.info("mouse clicked" + e.getClickCount());
            if (e.getButton() == 3) {
                return;
            }
            if (e.getClickCount() == 2) {
                Point matrixCoord = AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(e.getPoint());
                logger.info(matrixCoord);
                AliViewWindow.this.selectEverythingWithinGaps(matrixCoord);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Rectangle preferredVisisble = new Rectangle(e.getPoint());
            if (!AliViewWindow.this.alignmentPane.getVisibleRect().contains(e.getPoint())) {
                preferredVisisble.grow(30, 30);
                AliViewWindow.this.alignmentPane.scrollRectToVisible(preferredVisisble);
            }
            if (this.startPoint != null) {
                if (this.dragPointStart != null) {
                    if (!this.isDragging) {
                        this.isDragging = true;
                        AliViewWindow.this.getUndoControler().pushUndoState();
                    }
                    Rectangle selectRect = AliViewWindow.this.alignment.getSelectionAsMinRect();
                    Rectangle selectInPaneCoord = AliViewWindow.this.alignmentPane.matrixCoordToPaneCoord(selectRect);
                    int diff = e.getPoint().x - this.dragPointStart.x;
                    double diffInSeqPositons = (double)diff / AliViewWindow.this.alignmentPane.getCharWidth();
                    int intDiffInseqPos = (int)diffInSeqPositons;
                    if ((AliViewWindow.this.alignment.isMoveSelectionRightPossible() || AliViewWindow.this.alignment.isMoveSelectionLeftPossible()) && AliViewWindow.this.requestEditMode()) {
                        AliViewWindow.this.alignment.moveSelection(intDiffInseqPos, AliViewWindow.this.isUndoable());
                    }
                    selectInPaneCoord.grow(4 + 3 * Math.abs(diff), 0);
                } else {
                    Rectangle selectRect = new Rectangle(e.getPoint());
                    selectRect.add(this.startPoint);
                    Rectangle selectRectMatrixCoords = AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(selectRect);
                    AliViewWindow.this.alignment.setTempSelection(selectRectMatrixCoords);
                    if (this.maxRepaintRect == null) {
                        this.maxRepaintRect = new Rectangle(selectRect);
                    } else {
                        this.maxRepaintRect.add(selectRect);
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getModifiersEx() == OSNativeUtils.getMouseWheelZoomModifierMask()) {
                if (e.getWheelRotation() > 0) {
                    AliViewWindow.this.aliViewWindow.zoomOutAt(e.getPoint());
                } else if (e.getWheelRotation() < 0) {
                    AliViewWindow.this.aliViewWindow.zoomInAt(e.getPoint());
                }
            } else if (e.isShiftDown()) {
                int wheelRotation = e.getWheelRotation();
                if (AliViewWindow.this.aliViewWindow.isReverseHorizontalRotation()) {
                    wheelRotation *= -1;
                }
                if (wheelRotation > 0) {
                    Rectangle preferedVisible = AliViewWindow.this.alignmentPane.getVisibleRect();
                    preferedVisible.setLocation((int)((double)preferedVisible.x - (double)Settings.getHorizontalScrollModifier().getIntValue() / 200.0 * preferedVisible.getWidth()), preferedVisible.y);
                    AliViewWindow.this.alignmentPane.scrollRectToVisible(preferedVisible);
                    AliViewWindow.this.alignmentPane.revalidate();
                    return;
                }
                if (wheelRotation < 0) {
                    Rectangle preferedVisible = AliViewWindow.this.alignmentPane.getVisibleRect();
                    preferedVisible.setLocation((int)((double)preferedVisible.x + (double)Settings.getHorizontalScrollModifier().getIntValue() / 200.0 * preferedVisible.getWidth()), preferedVisible.y);
                    AliViewWindow.this.alignmentPane.scrollRectToVisible(preferedVisible);
                    AliViewWindow.this.alignmentPane.revalidate();
                    return;
                }
            } else {
                int wheelRotation = e.getWheelRotation();
                if (AliViewWindow.this.aliViewWindow.isReverseVerticalRotation()) {
                    wheelRotation *= -1;
                }
                if (wheelRotation > 0) {
                    Rectangle preferedVisible = AliViewWindow.this.alignmentPane.getVisibleRect();
                    preferedVisible.setLocation(preferedVisible.x, (int)((double)preferedVisible.y + (double)Settings.getVerticalScrollModifier().getIntValue() / 200.0 * preferedVisible.getHeight()));
                    AliViewWindow.this.alignmentPane.scrollRectToVisible(preferedVisible);
                    AliViewWindow.this.alignmentPane.revalidate();
                    return;
                }
                if (wheelRotation < 0) {
                    Rectangle preferedVisible = AliViewWindow.this.alignmentPane.getVisibleRect();
                    preferedVisible.setLocation(preferedVisible.x, (int)((double)preferedVisible.y - (double)Settings.getVerticalScrollModifier().getIntValue() / 200.0 * preferedVisible.getHeight()));
                    AliViewWindow.this.alignmentPane.scrollRectToVisible(preferedVisible);
                    AliViewWindow.this.alignmentPane.revalidate();
                    return;
                }
            }
        }
    }

    private class AlignmentRulerMouseListener
    implements MouseListener,
    MouseMotionListener {
        private Point startPoint;
        private Point startPointOnAlignmentPane;
        private Rectangle maxRepaintRect;

        private AlignmentRulerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startPoint = e.getPoint();
            this.startPointOnAlignmentPane = new Point(AliViewWindow.this.alignmentPane.getVisibleRect().x + e.getPoint().x, 0);
            if (!e.isShiftDown()) {
                AliViewWindow.this.alignment.clearTempSelection();
                AliViewWindow.this.sequenceJList.clearSelection();
                AliViewWindow.this.alignment.clearSelection();
                AliViewWindow.this.alignmentPane.selectColumnAt(this.startPointOnAlignmentPane);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.startPoint != null) {
                if (e.isShiftDown()) {
                    Point firstPos = AliViewWindow.this.alignment.getFirstSelectedPosition();
                    Point paneFirstPoint = AliViewWindow.this.alignmentPane.matrixCoordToPaneCoord(firstPos);
                    Rectangle selectRect = new Rectangle(paneFirstPoint);
                    Point endPointOnAlignmentPane = new Point(AliViewWindow.this.alignmentPane.getVisibleRect().x + e.getPoint().x, AliViewWindow.this.alignmentPane.getHeight());
                    selectRect.add(endPointOnAlignmentPane);
                    int n = AliViewWindow.this.alignmentPane.selectWithin(selectRect);
                } else {
                    Point endPointOnAlignmentPane = new Point(AliViewWindow.this.alignmentPane.getVisibleRect().x + e.getPoint().x, AliViewWindow.this.alignmentPane.getHeight());
                    Rectangle selectRect = new Rectangle(this.startPointOnAlignmentPane);
                    selectRect.add(endPointOnAlignmentPane);
                    logger.info(selectRect);
                    int selectionSize = 0;
                    AliViewWindow.this.alignment.clearSelection();
                    if (this.startPointOnAlignmentPane.x == endPointOnAlignmentPane.x) {
                        AliViewWindow.this.alignmentPane.selectColumnAt(endPointOnAlignmentPane);
                        int x = AliViewWindow.this.alignmentPane.getColumnAt(e.getPoint());
                        logger.info(AliViewWindow.this.aliCursor);
                        logger.info(((AliViewWindow)AliViewWindow.this).aliCursor.x);
                        logger.info(((AliViewWindow)AliViewWindow.this).aliCursor.y);
                        AliViewWindow.this.aliCursor.setPosition(x, 0);
                    } else {
                        selectionSize = AliViewWindow.this.alignmentPane.selectColumnsWithin(selectRect);
                        int x = AliViewWindow.this.alignmentPane.getColumnAt(e.getPoint());
                        logger.info(AliViewWindow.this.aliCursor);
                        logger.info(((AliViewWindow)AliViewWindow.this).aliCursor.x);
                        logger.info(((AliViewWindow)AliViewWindow.this).aliCursor.y);
                        AliViewWindow.this.aliCursor.setPosition(x, 0);
                    }
                    AliViewWindow.this.alignment.clearTempSelection();
                }
            }
            Point posOnPaneNotRuler = new Point(AliViewWindow.this.alignmentPane.getVisibleRect().x + e.getPoint().x, 0);
            Point matrixPoint = AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(posOnPaneNotRuler);
            logger.info("x=" + matrixPoint.x);
            AliViewWindow.this.aliCursor.setPosition(matrixPoint.x, 0);
            AliViewWindow.this.alignmentPane.requestFocus();
            this.startPoint = null;
            this.startPointOnAlignmentPane = null;
            this.maxRepaintRect = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int alignmentYPos = AliViewWindow.this.alignmentPane.getVisibleRect().y;
            int alignmentXPos = AliViewWindow.this.alignmentPane.getVisibleRect().x + e.getPoint().x;
            Rectangle preferredVisisble = new Rectangle(new Point(alignmentXPos, alignmentYPos));
            if (!AliViewWindow.this.alignmentPane.getVisibleRect().contains(e.getPoint())) {
                preferredVisisble.grow(30, 0);
                AliViewWindow.this.alignmentPane.scrollRectToVisible(preferredVisisble);
            }
            if (this.startPoint != null) {
                Point endPointOnAlignmentPane = new Point(AliViewWindow.this.alignmentPane.getVisibleRect().x + e.getPoint().x, AliViewWindow.this.alignmentPane.getHeight());
                Rectangle selectRect = new Rectangle(this.startPointOnAlignmentPane);
                selectRect.add(endPointOnAlignmentPane);
                Rectangle selectRectMatrixCoords = AliViewWindow.this.alignmentPane.paneCoordToMatrixCoord(selectRect);
                AliViewWindow.this.alignment.setTempSelection(selectRectMatrixCoords);
                if (this.maxRepaintRect == null) {
                    this.maxRepaintRect = new Rectangle(selectRect);
                } else {
                    this.maxRepaintRect.add(selectRect);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class AlignmentKeyListener
    implements KeyListener {
        private AlignmentKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char typed;
            String allowedChars;
            logger.info("is typed");
            if (!(e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown() || (allowedChars = "QWERTYUIOPASDFGHJKLZXCVBNM?qwertyuiopasdfghjklzxcvbnm").indexOf(typed = e.getKeyChar()) <= -1 || !AliViewWindow.this.aliViewWindow.requestEditMode())) {
                AliViewWindow.this.replaceSelectedWithChar(typed);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() || e.isAltDown() || e.isAltGraphDown() || e.isMetaDown()) {
                return;
            }
            if (AliViewWindow.this.alignment.hasSelection()) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                    e.consume();
                    AliViewWindow.this.scrollToCursor(38);
                    AliViewWindow.this.moveCursorUp(e.isShiftDown());
                }
                if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                    e.consume();
                    AliViewWindow.this.scrollToCursor(40);
                    AliViewWindow.this.moveCursorDown(e.isShiftDown());
                }
                if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                    e.consume();
                    AliViewWindow.this.scrollToCursor(37);
                    AliViewWindow.this.moveCursorLeft(e.isShiftDown());
                }
                if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                    e.consume();
                    AliViewWindow.this.scrollToCursor(39);
                    AliViewWindow.this.moveCursorRight(e.isShiftDown());
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

