/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import aliview.GeneticCode;
import aliview.NucleotideUtilities;
import org.apache.log4j.Logger;

public class AminoAcid {
    private static final Logger logger = Logger.getLogger(AminoAcid.class);
    private static final String TEXT_FILE_BYTE_ENCODING = "ASCII";
    public static final AminoAcid A = new AminoAcid("Alanine", "Ala", "A", 0);
    public static final AminoAcid C = new AminoAcid("Cysteine", "Cys", "C", 1);
    public static final AminoAcid D = new AminoAcid("Aspartic acid", "Asp", "D", 2);
    public static final AminoAcid E = new AminoAcid("Glutamic acid", "Glu", "E", 3);
    public static final AminoAcid F = new AminoAcid("Phenylalanine", "Phe", "F", 4);
    public static final AminoAcid G = new AminoAcid("Glycine", "Gly", "G", 5);
    public static final AminoAcid H = new AminoAcid("Histidine", "His", "H", 6);
    public static final AminoAcid I = new AminoAcid("Isoleucine", "Ile", "I", 7);
    public static final AminoAcid K = new AminoAcid("Lysine", "Lys", "K", 8);
    public static final AminoAcid L = new AminoAcid("Leucine", "Leu", "L", 9);
    public static final AminoAcid M = new AminoAcid("Methionine", "Met", "M", 10);
    public static final AminoAcid N = new AminoAcid("Asparagine", "Asn", "N", 11);
    public static final AminoAcid P = new AminoAcid("Proline", "Pro", "P", 12);
    public static final AminoAcid Q = new AminoAcid("Glutamine", "Gln", "Q", 13);
    public static final AminoAcid R = new AminoAcid("Arginine", "Arg", "R", 14);
    public static final AminoAcid S = new AminoAcid("Serine", "Ser", "S", 15);
    public static final AminoAcid T = new AminoAcid("Threonine", "Thr", "T", 16);
    public static final AminoAcid V = new AminoAcid("Valine", "Val", "V", 17);
    public static final AminoAcid W = new AminoAcid("Tryptophan", "Trp", "W", 18);
    public static final AminoAcid Y = new AminoAcid("Tyrosine", "Tyr", "Y", 19);
    public static final AminoAcid X = new AminoAcid("Unknown amino acid", "Xaa", "X", 25);
    public static final AminoAcid STOP = new AminoAcid("Stop codon", " * ", "X", 27);
    public static final AminoAcid GAP = new AminoAcid("Gap", " - ", "-", 29);
    public static final int HIGEST_AA_INT_VAL = 29;
    public static final AminoAcid[] GROUP_ALL = new AminoAcid[]{A, C, D, E, F, G, H, I, K, L, M, N, P, Q, R, S, T, V, W, Y, X, STOP, GAP};
    public static final AminoAcid[] GROUP_ACFHILMVWY = new AminoAcid[]{A, C, F, H, I, L, M, V, W, Y};
    public static final AminoAcid[] GROUP_WLVIMAFCHP = new AminoAcid[]{W, L, V, I, M, A, F, C, H, P};
    public static final AminoAcid[] GROUP_KR = new AminoAcid[]{K, R};
    public static final AminoAcid[] GROUP_QE = new AminoAcid[]{Q, E};
    public static final AminoAcid[] GROUP_ED = new AminoAcid[]{E, D};
    public static final AminoAcid[] GROUP_TS = new AminoAcid[]{T, S};
    private String name;
    private String threeLeterName;
    private String code;
    private char codeCharVal;
    public int intVal;
    private byte codeByteVal;
    private byte[] codeByteArray;

    public static void main(String[] args) {
        long startTime = System.nanoTime();
        StringBuilder b = new StringBuilder(1000000);
        for (int n = 0; n < 1000000; ++n) {
            b.append(A.getCodeCharVal());
            b.append(E.getCodeCharVal());
            b.append(C.getCodeCharVal());
        }
        b.toString();
        long endTime = System.nanoTime();
        long timeSpent = endTime - startTime;
        double timeSpentMS = (double)timeSpent / 1.0E9;
        logger.info("getCode took " + timeSpentMS + " millisec");
    }

    public AminoAcid(String name, String threeLetterName, String code, int intVal) {
        this.name = name;
        this.threeLeterName = threeLetterName;
        this.code = code;
        this.intVal = intVal;
        this.codeByteArray = code.getBytes();
        this.codeByteVal = (byte)code.charAt(0);
        this.codeCharVal = code.charAt(0);
    }

    public static AminoAcid getAminoAcidFromCodon(byte[] codon) {
        return AminoAcid.getAminoAcidFromCodon(codon, GeneticCode.DEFAULT);
    }

    public static AminoAcid getAminoAcidFromCodon(byte[] codon, GeneticCode geneticCode) {
        if (codon == null || codon.length < 3) {
            return GAP;
        }
        int baseVal0 = NucleotideUtilities.baseValFromChar((char)codon[0]);
        int baseVal1 = NucleotideUtilities.baseValFromChar((char)codon[1]);
        int baseVal2 = NucleotideUtilities.baseValFromChar((char)codon[2]);
        int position1Val = baseVal0 == 8 ? 0 : (baseVal0 == 2 ? 1 : (baseVal0 == 1 ? 2 : (baseVal0 == 4 ? 3 : -1)));
        int position2Val = baseVal1 == 8 ? 0 : (baseVal1 == 2 ? 1 : (baseVal1 == 1 ? 2 : (baseVal1 == 4 ? 3 : -1)));
        int position3Val = baseVal2 == 8 ? 0 : (baseVal2 == 2 ? 1 : (baseVal2 == 1 ? 2 : (baseVal2 == 4 ? 3 : -1)));
        AminoAcid acid = X;
        if (position1Val == -1 || position2Val == -1 || position3Val == -1) {
            acid = X;
        } else {
            int acidVal = position1Val * 16 + position2Val * 4 + position3Val;
            acid = geneticCode.acidTranslation[acidVal];
        }
        if (baseVal0 == 0 && baseVal1 == 0 && baseVal2 == 0) {
            acid = GAP;
        }
        return acid;
    }

    public byte getCodeByteVal() {
        return this.codeByteVal;
    }

    public static final AminoAcid getAminoAcidFromByte(byte base) {
        return AminoAcid.getAminoAcidFromChar((char)base);
    }

    public static final AminoAcid getAminoAcidFromChar(char base) {
        AminoAcid acid;
        switch (base) {
            case 'A': 
            case 'a': {
                acid = A;
                break;
            }
            case 'C': 
            case 'c': {
                acid = C;
                break;
            }
            case 'D': 
            case 'd': {
                acid = D;
                break;
            }
            case 'E': 
            case 'e': {
                acid = E;
                break;
            }
            case 'F': 
            case 'f': {
                acid = F;
                break;
            }
            case 'G': 
            case 'g': {
                acid = G;
                break;
            }
            case 'H': 
            case 'h': {
                acid = H;
                break;
            }
            case 'I': 
            case 'i': {
                acid = I;
                break;
            }
            case 'K': 
            case 'k': {
                acid = K;
                break;
            }
            case 'L': 
            case 'l': {
                acid = L;
                break;
            }
            case 'M': 
            case 'm': {
                acid = M;
                break;
            }
            case 'N': 
            case 'n': {
                acid = N;
                break;
            }
            case 'P': 
            case 'p': {
                acid = P;
                break;
            }
            case 'Q': 
            case 'q': {
                acid = Q;
                break;
            }
            case 'R': 
            case 'r': {
                acid = R;
                break;
            }
            case 'S': 
            case 's': {
                acid = S;
                break;
            }
            case 'T': 
            case 't': {
                acid = T;
                break;
            }
            case 'V': 
            case 'v': {
                acid = V;
                break;
            }
            case 'W': 
            case 'w': {
                acid = W;
                break;
            }
            case '?': 
            case 'X': 
            case 'x': {
                acid = X;
                break;
            }
            case 'Y': 
            case 'y': {
                acid = Y;
                break;
            }
            case '*': {
                acid = STOP;
                break;
            }
            case '-': 
            case '_': {
                acid = GAP;
                break;
            }
            default: {
                acid = X;
            }
        }
        return acid;
    }

    public char getCodeCharVal() {
        return this.codeCharVal;
    }

    public String getCodeStringVal() {
        return this.code;
    }

    public byte[] getCodeByteArray() {
        return this.codeByteArray;
    }

    public static boolean isGap(byte byteVal) {
        return GAP == AminoAcid.getAminoAcidFromByte(byteVal);
    }

    public static byte getConsensusFromByteVal(byte byteVal1, byte byteVal2) {
        if (AminoAcid.getAminoAcidFromByte(byteVal1) == AminoAcid.getAminoAcidFromByte(byteVal2)) {
            return byteVal1;
        }
        if (AminoAcid.isGap(byteVal1) || AminoAcid.isGap(byteVal2)) {
            if (AminoAcid.isGap(byteVal1)) {
                return byteVal2;
            }
            return byteVal1;
        }
        return X.getCodeByteVal();
    }
}

