/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import java.util.Stack;
import org.apache.log4j.Logger;

public class LimitedStack<T> {
    private static final Logger logger = Logger.getLogger(LimitedStack.class);
    Stack<T> stack = new Stack();
    int maxSize;
    int pointer = -1;

    public LimitedStack(int maxSize) {
        this.maxSize = maxSize;
    }

    public T push(T obj) {
        int diff = Math.abs(this.pointer - (this.stack.size() - 1));
        T retVal = this.stack.push(obj);
        if (this.stack.size() > this.maxSize) {
            this.stack.removeElementAt(0);
        }
        this.pointer = this.stack.size() - 1;
        return retVal;
    }

    public T pop() {
        T popObj = this.stack.pop();
        this.pointer = this.stack.size() - 1;
        return popObj;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int size() {
        return this.stack.size();
    }

    private boolean rangeCheck(int index) {
        return index > -1 && index <= this.stack.size();
    }

    public boolean hasPrevious() {
        return this.rangeCheck(this.pointer - 1);
    }

    public boolean hasNext() {
        return this.rangeCheck(this.pointer + 1);
    }

    public T getPreviousState() {
        --this.pointer;
        return (T)this.stack.elementAt(this.pointer);
    }

    public T getNextState() {
        ++this.pointer;
        return (T)this.stack.elementAt(this.pointer);
    }

    public void clear() {
        this.stack.clear();
    }
}

