/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import org.apache.log4j.Logger;

public class MemoryUtils {
    private static final Logger logger = Logger.getLogger(MemoryUtils.class);
    static final int MB = 0x100000;

    public static long getMaxMem() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory();
    }

    public static long getMaxMemMB() {
        return MemoryUtils.getMaxMem() / 0x100000L;
    }

    public static long getTotalMemMB() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() / 0x100000L;
    }

    public static long getFreeMemMB() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.freeMemory() / 0x100000L;
    }

    public static long getUsedMemMB() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
    }

    public static void logMem() {
        logger.info("getMaxMemMB()" + MemoryUtils.getMaxMemMB());
        logger.info("getTotalMemMB()" + MemoryUtils.getTotalMemMB());
        logger.info("getFreeMemMB()" + MemoryUtils.getFreeMemMB());
        logger.info("getUsedMemMB()" + MemoryUtils.getUsedMemMB());
    }

    public static double getPresumableFreeMemoryMB() {
        double presumableFreeMemory = (double)Runtime.getRuntime().maxMemory() - MemoryUtils.getAllocatedMemory();
        return presumableFreeMemory / 1048576.0;
    }

    public static double getAllocatedMemory() {
        double allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return allocatedMemory;
    }
}

