/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import java.awt.Dimension;

public class PrintUtils {
    public static final double CM_PER_INCH = 0.393700787;
    public static final double INCH_PER_CM = 2.545;
    public static final double INCH_PER_MM = 25.45;

    public static double pixelsToCms(double pixels, double dpi) {
        return PrintUtils.inchesToCms(pixels / dpi);
    }

    public static double cmsToPixel(double cms, double dpi) {
        return PrintUtils.cmToInches(cms) * dpi;
    }

    public static double mmToPixel(double mm, double dpi) {
        return PrintUtils.cmToInches(mm * 10.0) * dpi;
    }

    public static double cmToInches(double cms) {
        return cms * 0.393700787;
    }

    public static double inchesToCms(double inch) {
        return inch * 2.545;
    }

    public static double getScaleFactorToFit(Dimension original, Dimension toFit) {
        double dScale = 1.0;
        if (original != null && toFit != null) {
            double dScaleWidth = PrintUtils.getScaleFactor(original.width, toFit.width);
            double dScaleHeight = PrintUtils.getScaleFactor(original.height, toFit.height);
            dScale = Math.min(dScaleHeight, dScaleWidth);
        }
        return dScale;
    }

    public static double getScaleFactor(int iMasterSize, int iTargetSize) {
        double dScale = 1.0;
        dScale = iMasterSize > iTargetSize ? (double)iTargetSize / (double)iMasterSize : (double)iTargetSize / (double)iMasterSize;
        return dScale;
    }
}

