/*
 * Decompiled with CFR 0.152.
 */
package aliview.aligner;

import aliview.AliViewWindow;
import aliview.aligner.AliItemPanel;
import aliview.externalcommands.CommandItem;
import aliview.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class AlignerADDItemsFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(AlignerADDItemsFrame.class);
    JPanel mainPanel;

    public AlignerADDItemsFrame(AliViewWindow aliViewWin) {
        final AlignerADDItemsFrame alignItemsFrame = this;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        final ArrayList<CommandItem> alignItems = Settings.getAlignADDCommands();
        ButtonGroup bg = new ButtonGroup();
        for (CommandItem alignItem : alignItems) {
            AliItemPanel itemPanel = new AliItemPanel(alignItem);
            bg.add(itemPanel.getRadioIsActivated());
        }
        JPanel bottomButtonPanel = new JPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        bottomButtonPanel.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                alignItemsFrame.dispose();
            }
        });
        bottomButtonPanel.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.putAlignALLCommands(alignItems);
                alignItemsFrame.dispose();
            }
        });
        bottomButtonPanel.add(okButton);
        this.mainPanel.add(bottomButtonPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                alignItemsFrame.dispose();
            }
        });
        this.setTitle("Alignment program settings");
        this.setPreferredSize(new Dimension(650, 600));
        this.pack();
        this.centerLocationToThisComponent(aliViewWin);
        this.setVisible(true);
    }

    public void centerLocationToThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2;
            int newY = parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2;
            if (newX > parent.getX() && newX > parent.getY()) {
                this.setLocation(newX, newY);
            }
        }
    }
}

