/*
 * Decompiled with CFR 0.152.
 */
package aliview.aligner;

import aliview.HelpUtils;
import aliview.aligner.AliItemPanel;
import aliview.externalcommands.CommandItem;
import aliview.settings.Settings;
import aliview.settings.SettingsFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class AlignerADDItemsPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(AlignerADDItemsPanel.class);
    JPanel mainPanel;

    public AlignerADDItemsPanel(final JFrame parentFrame) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel itemsPanel = new JPanel();
        itemsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        itemsPanel.setLayout(new BoxLayout(itemsPanel, 1));
        JScrollPane scrollPane = new JScrollPane(itemsPanel, 20, 30);
        scrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        mainPanel.add((Component)scrollPane, "Center");
        final ArrayList<CommandItem> alignItems = Settings.getAlignADDCommands();
        ButtonGroup bg = new ButtonGroup();
        for (CommandItem alignItem : alignItems) {
            AliItemPanel itemPanel = new AliItemPanel(alignItem);
            itemsPanel.add(itemPanel);
            bg.add(itemPanel.getRadioIsActivated());
        }
        JPanel bottomButtonPanel = new JPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        bottomButtonPanel.add(Box.createHorizontalStrut(20));
        JButton helpButton = new JButton("Help");
        helpButton.setPreferredSize(new Dimension(100, 30));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpUtils.display("ALIGNER_SETTINS_ADD", parentFrame);
            }
        });
        bottomButtonPanel.add(helpButton);
        bottomButtonPanel.add(Box.createHorizontalGlue());
        JButton resetButton = new JButton("Reset defaults");
        resetButton.setPreferredSize(new Dimension(100, 30));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.clearAlignADDCommands();
                if (parentFrame instanceof SettingsFrame) {
                    ((SettingsFrame)parentFrame).reload();
                }
            }
        });
        bottomButtonPanel.add(resetButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(new Dimension(70, 30));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parentFrame.dispose();
            }
        });
        bottomButtonPanel.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(70, 30));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.putAlignADDCommands(alignItems);
                parentFrame.dispose();
            }
        });
        bottomButtonPanel.add(okButton);
        bottomButtonPanel.add(Box.createHorizontalStrut(20));
        mainPanel.add((Component)bottomButtonPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }
}

