/*
 * Decompiled with CFR 0.152.
 */
package aliview.alignment;

import aliview.AminoAcid;
import aliview.alignment.AliHistogram;
import aliview.sequences.Sequence;

public class AAHistogram
extends AliHistogram {
    public AAHistogram(int length) {
        super(length);
    }

    @Override
    public void addSequence(Sequence seq) {
        for (int n = 0; n < seq.getLength(); ++n) {
            int[] nArray = this.hist[n];
            int n2 = AminoAcid.getAminoAcidFromByte((byte)seq.getBaseAtPos((int)n)).intVal;
            nArray[n2] = nArray[n2] + 1;
        }
    }

    public void addAminoAcid(int pos, AminoAcid acid) {
        int[] nArray = this.hist[pos];
        int n = acid.intVal;
        nArray[n] = nArray[n] + 1;
    }

    @Override
    public double getSumNonGap(int x) {
        int sum = 0;
        for (int n = 0; n < this.hist[x].length; ++n) {
            sum += this.hist[x][n];
        }
        return sum -= this.hist[x][AminoAcid.GAP.intVal];
    }
}

