/*
 * Decompiled with CFR 0.152.
 */
package aliview.alignment;

import aliview.AliViewExtraNexusUtilities;
import aliview.AminoAcid;
import aliview.GeneticCode;
import aliview.NucleotideUtilities;
import aliview.alignment.AliHistogram;
import aliview.alignment.AlignmentEvent;
import aliview.alignment.AlignmentFile;
import aliview.alignment.AlignmentListener;
import aliview.alignment.AlignmentMeta;
import aliview.importer.AlignmentImportException;
import aliview.importer.FileFormat;
import aliview.importer.MSFImporter;
import aliview.importer.SequencesFactory;
import aliview.messenges.Messenger;
import aliview.primer.Dimer;
import aliview.primer.Primer;
import aliview.sequencelist.AlignmentDataListener;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.AlignmentSelectionListener;
import aliview.sequencelist.FileSequenceAlignmentListModel;
import aliview.sequencelist.FileSequenceLoadListener;
import aliview.sequencelist.FindObject;
import aliview.sequencelist.MemorySequenceAlignmentListModel;
import aliview.sequences.FastaFileSequence;
import aliview.sequences.InMemorySequence;
import aliview.sequences.Sequence;
import aliview.sequences.SequenceUtils;
import aliview.settings.Settings;
import aliview.utils.ArrayUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import utils.nexus.CharSet;
import utils.nexus.CharSets;
import utils.nexus.NexusRange;
import utils.nexus.NexusUtilities;

public class Alignment
implements FileSequenceLoadListener {
    private static final Logger logger = Logger.getLogger(Alignment.class);
    private static final String LF = System.getProperty("line.separator");
    private static final SequencesFactory seqFactory = new SequencesFactory();
    AlignmentListModel sequences;
    protected int nextFindSequenceNumber;
    protected int nextFindStartPos;
    private AlignmentFile alignmentFile;
    private int PRIMER_MAX_DEGENERATE_SCORE = 1000;
    private boolean isEditedAfterLastSave = false;
    private AlignmentMeta alignmentMeta;
    private int readingFrame = 1;
    private boolean editMode;
    private ArrayList<AlignmentListener> alignmentListeners = new ArrayList();
    private boolean isSelectable;

    public Alignment() {
        this(null, new MemorySequenceAlignmentListModel(), new AlignmentMeta());
    }

    public Alignment(AlignmentListModel sequences) {
        this(null, sequences, new AlignmentMeta());
    }

    public Alignment(File file, AlignmentListModel sequences, AlignmentMeta aliMeta) {
        this.setAlignmentFile(file);
        this.sequences = sequences;
        this.sequences.setAlignment(this);
        this.alignmentMeta = aliMeta;
        this.setEditedAfterLastSave(false);
        this.fireAllSequencesAreNew();
    }

    public void setNewSequencesFromUndo(AlignmentListModel seqs) {
        this.sequences.setSequences(seqs.getDelegateSequences());
        this.alignmentMeta = new AlignmentMeta();
        this.fireAllSequencesAreNew();
    }

    public double getApproximateMemorySizeMB() {
        double seqSize = this.sequences.getSize() * this.sequences.getLongestSequenceLength();
        double MB = 1000000.0;
        return seqSize / MB;
    }

    public void addAlignmentListener(AlignmentListener l) {
        this.alignmentListeners.add(l);
    }

    public void addAlignmentDataListener(AlignmentDataListener l) {
        this.sequences.addAlignmentDataListener(l);
    }

    public void addAlignmentSelectionListener(AlignmentSelectionListener l) {
        this.sequences.addAlignmentSelectionListener(l);
    }

    private void fireAlignmentMetaOnlyChanged() {
        for (AlignmentListener alignmentListener : this.alignmentListeners) {
        }
    }

    private void fireAllSequencesAreNew() {
        for (AlignmentListener listener : this.alignmentListeners) {
            listener.newSequences(new AlignmentEvent(this));
        }
    }

    public int getMaxY() {
        return this.sequences.getSize();
    }

    public byte getBaseAt(int x, int y) {
        return this.sequences.getBaseAt(x, y);
    }

    public AminoAcid getTranslatedAminoAcidAtNucleotidePos(int x, int y) {
        return this.sequences.getTranslatedAminoAcidAtNucleotidePos(x, y);
    }

    public int getLengthAt(int y) {
        return this.sequences.getLengthAt(y);
    }

    public AlignmentListModel getSequences() {
        return this.sequences;
    }

    public int getMaxX() {
        return this.sequences.getLongestSequenceLength();
    }

    public int getMaximumSequenceLength() {
        return this.getMaxX();
    }

    public int getLongestSequenceLength() {
        return this.getMaxX();
    }

    public int getSize() {
        return this.sequences.getSize();
    }

    public void clearSelection() {
        this.sequences.clearSequenceSelection();
    }

    public int getSequenceIndex(Sequence seq) {
        return this.sequences.indexOf(seq);
    }

    public AlignmentFile getAlignmentFile() {
        return this.alignmentFile;
    }

    public String getFileName() {
        if (this.alignmentFile == null) {
            return null;
        }
        return this.alignmentFile.getName();
    }

    public void setAlignmentFile(File alignmentFile) {
        if (alignmentFile != null && alignmentFile.exists()) {
            this.alignmentFile = new AlignmentFile(alignmentFile);
        }
    }

    public void storeAlignmetAsFasta(Writer out) throws IOException {
        int longest = this.sequences.getLongestSequenceLength();
        for (Sequence seq : this.sequences) {
            String name = seq.getName();
            out.write(62);
            out.write(seq.getName());
            out.write(LF);
            seq.writeBases(out);
            out.write(LF);
        }
        out.flush();
        out.close();
    }

    private void storeAlignmetAsClustal(Writer out) throws IOException {
        out.write("CLUSTAL W (1.99) multiple sequence alignment" + LF);
        out.write(LF);
        out.write(LF);
        int longSeq = this.sequences.getLongestSequenceLength();
        int namePadSize = this.sequences.getLongestSequenceName() + 1;
        for (int pos = 0; pos < longSeq; pos += 60) {
            int endPos = pos + 59;
            endPos = Math.min(endPos, longSeq - 1);
            for (int n = 0; n < this.sequences.getSize(); ++n) {
                Sequence seq = this.sequences.get(n);
                String paddedName = StringUtils.rightPad(seq.getName(), namePadSize);
                out.write(paddedName);
                seq.writeBasesBetween(pos, endPos, out);
                out.write(LF);
            }
            out.write(LF);
            out.write(LF);
            out.flush();
        }
        out.flush();
        out.close();
    }

    private void storeAlignmetAsMSF(Writer out) throws IOException {
        int longSeq = this.sequences.getLongestSequenceLength();
        int namePadSize = this.sequences.getLongestSequenceName() + 1;
        String type = "P";
        String type2 = "!!AA";
        if (this.isNucleotideAlignment()) {
            type = "N";
            type2 = "!!NA";
        }
        out.write("" + type2 + "_MULTIPLE_ALIGNMENT" + LF);
        out.write(LF);
        out.write(LF);
        int checkTotal = 0;
        for (int n = 0; n < this.sequences.getSize(); ++n) {
            Sequence seq = this.sequences.get(n);
            String paddedName = StringUtils.rightPad(seq.getName(), namePadSize);
            int check = MSFImporter.GCGchecksum(seq);
            checkTotal += check;
            checkTotal %= 10000;
        }
        String totalMeta = "   MSF: " + longSeq + "  Type: " + type + "  Check: " + checkTotal + "  ..";
        out.write(totalMeta);
        out.write(LF);
        out.write(LF);
        for (int n = 0; n < this.sequences.getSize(); ++n) {
            Sequence seq = this.sequences.get(n);
            String paddedName = StringUtils.rightPad(seq.getName(), namePadSize);
            int check = MSFImporter.GCGchecksum(seq);
            String seqMeta = " Name: " + paddedName + "  Len: " + seq.getLength() + "  Check: " + check + "  Weight: 1.00";
            out.write(seqMeta);
            out.write(LF);
        }
        out.write(LF);
        out.write(LF);
        out.write("//");
        out.write(LF);
        out.write(LF);
        for (int pos = 0; pos < longSeq; pos += 50) {
            int endPos = pos + 50;
            endPos = Math.min(endPos, longSeq);
            for (int n = 0; n < this.sequences.getSize(); ++n) {
                Sequence seq = this.sequences.get(n);
                String paddedName = StringUtils.rightPad(seq.getName(), namePadSize);
                out.write(paddedName);
                byte[] bases = seq.getBasesBetween(pos, endPos - 1);
                bases = ArrayUtilities.replaceAll(bases, '-', (byte)46);
                for (int delPos = 0; delPos < bases.length; delPos += 10) {
                    int maxLen = 10;
                    maxLen = Math.min(maxLen, bases.length - delPos);
                    out.write(new String(bases, delPos, maxLen));
                    if (delPos + 10 >= bases.length) continue;
                    out.write(32);
                }
                out.write(LF);
            }
            out.write(LF);
            out.write(LF);
        }
        out.flush();
        out.close();
    }

    private void storeAlignmetAsPhyFile(Writer out, FileFormat fileFormat) throws IOException {
        out.write("" + this.sequences.getSize() + " " + this.getMaximumSequenceLength() + LF);
        if (fileFormat == FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED) {
            int longSeq = this.sequences.getLongestSequenceLength();
            int namePadSize = this.sequences.getLongestSequenceName() + 1;
            int residuesPerLine = 80;
            for (int n = 0; n < this.sequences.getSize(); ++n) {
                Sequence seq = this.sequences.get(n);
                String seqName = seq.getName();
                seqName = this.escapeSeqName(seqName);
                String paddedName = StringUtils.rightPad(seqName, namePadSize);
                out.write(paddedName);
                seq.writeBasesBetween(0, residuesPerLine - 1, out);
                out.write(LF);
            }
            out.write(LF);
            out.write(LF);
            for (int pos = residuesPerLine; pos < longSeq; pos += residuesPerLine) {
                int endPos = pos + residuesPerLine;
                endPos = Math.min(endPos, longSeq);
                for (int n = 0; n < this.sequences.getSize(); ++n) {
                    Sequence seq = this.sequences.get(n);
                    seq.writeBasesBetween(pos, endPos - 1, out);
                    out.write(LF);
                }
                out.write(LF);
                out.write(LF);
            }
        } else {
            for (Sequence seq : this.sequences) {
                int longSeqName;
                String seqName = seq.getName();
                seqName = this.escapeSeqName(seqName);
                if (fileFormat == FileFormat.PHYLIP_RELAXED) {
                    longSeqName = this.sequences.getLongestSequenceName();
                    seqName = seqName + ' ';
                } else if (fileFormat == FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL) {
                    if (seqName.length() > 10) {
                        seqName = StringUtils.substring(seqName, 0, 10);
                    }
                    seqName = StringUtils.rightPad(seqName, 10);
                } else {
                    longSeqName = this.sequences.getLongestSequenceName();
                    seqName = StringUtils.rightPad(seqName, longSeqName + 1);
                }
                out.write(seqName);
                seq.writeBases(out);
                out.write(LF);
            }
        }
        out.flush();
        out.close();
    }

    private String escapeSeqName(String name) {
        if (name != null && name.indexOf(32) > -1) {
            name = StringUtils.replace(name, " ", "_");
        }
        return name;
    }

    private void storeMetaData(BufferedWriter outMeta) throws IOException {
        outMeta.write("" + NexusUtilities.getExcludesAsNexusBlock(this.alignmentMeta.getExcludes()));
        outMeta.write(LF);
        outMeta.write("" + NexusUtilities.getCodonPosAsNexusBlock(this.alignmentMeta.getCodonPositions(), 0, this.getMaximumSequenceLength()));
        outMeta.write(LF);
        outMeta.write("" + NexusUtilities.getCharsetsBlockAsNexus(this.alignmentMeta.getCharsets()));
        outMeta.write(LF);
        outMeta.flush();
        outMeta.close();
    }

    private void storeTranslatedMetaData(BufferedWriter outMeta, AlignmentMeta translatedMeta) throws IOException {
        outMeta.write("" + NexusUtilities.getExcludesAsNexusBlock(translatedMeta.getExcludes()));
        outMeta.write(LF);
        outMeta.write("" + NexusUtilities.getCharsetsBlockAsNexus(translatedMeta.getCharsets()));
        outMeta.write(LF);
        outMeta.flush();
        outMeta.close();
    }

    public void saveSelectionAsFastaFile(File selectedFile) {
        try {
            BufferedWriter buffOut = new BufferedWriter(new FileWriter(selectedFile));
            this.sequences.writeSelectionAsFasta(buffOut);
            buffOut.flush();
            buffOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exportPartitionsFileRaxMLFormat(File outFile) throws IOException {
        String datatypeModel = "";
        datatypeModel = this.isAAAlignment() ? "JTT" : "DNA";
        String partitionsAsText = "";
        CharSets charsets = this.getAlignmentMeta().getCharsets();
        for (CharSet charSet : charsets) {
            String charsetRangeText = "";
            ArrayList<NexusRange> ranges = charSet.getAsContinousNexusRanges();
            int rangeCount = 0;
            for (NexusRange range : ranges) {
                charsetRangeText = charsetRangeText + range.toString() + ",";
                ++rangeCount;
            }
            if (rangeCount > 0) {
                charsetRangeText = StringUtils.removeEnd(charsetRangeText, ",");
            }
            partitionsAsText = partitionsAsText + datatypeModel + "," + charSet.getName() + " = " + charsetRangeText + LF;
        }
        FileUtils.writeStringToFile(outFile, partitionsAsText);
    }

    public void saveAlignmentAsFile(File outFile, FileFormat fileFormat, boolean rightPadOrTrimIfNeeded) throws IOException {
        logger.info("fileFormat" + fileFormat);
        if (rightPadOrTrimIfNeeded && this.sequences.isEditable()) {
            this.sequences.rightPadWithGapUntilEqualLength();
            this.sequences.rightTrimSequencesRemoveGapsUntilEqualLength();
        }
        boolean wasTranslated = this.isTranslatedOnePos();
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        int nexusDatatype = 7;
        if (this.sequences.getSequenceType() == SequenceUtils.TYPE_AMINO_ACID) {
            nexusDatatype = 1;
        }
        if (fileFormat == FileFormat.FASTA) {
            this.setTranslationOnePos(false);
            this.storeAlignmetAsFasta(out);
            if (this.alignmentMeta.isMetaOutputNeeded()) {
                BufferedWriter outMeta = new BufferedWriter(new FileWriter(new File(outFile.getAbsoluteFile() + ".meta")));
                this.storeMetaData(outMeta);
            }
        } else if (fileFormat == FileFormat.PHYLIP || fileFormat == FileFormat.PHYLIP_RELAXED || fileFormat == FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL || fileFormat == FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL || fileFormat == FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED) {
            this.setTranslationOnePos(false);
            this.storeAlignmetAsPhyFile(out, fileFormat);
            if (this.alignmentMeta.isMetaOutputNeeded()) {
                BufferedWriter outMeta = new BufferedWriter(new FileWriter(new File(outFile.getAbsoluteFile() + ".meta")));
                this.storeMetaData(outMeta);
            }
        } else if (fileFormat == FileFormat.PHYLIP_TRANSLATED_AMINO_ACID) {
            this.setTranslationOnePos(true);
            this.storeAlignmetAsPhyFile(out, FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL);
            if (this.alignmentMeta.isMetaOutputNeeded()) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(outFile.getAbsoluteFile() + ".meta")));
            }
        } else if (fileFormat == FileFormat.FASTA_TRANSLATED_AMINO_ACID) {
            this.setTranslationOnePos(true);
            this.storeAlignmetAsFasta(out);
            if (this.alignmentMeta.isMetaOutputNeeded()) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(outFile.getAbsoluteFile() + ".meta")));
            }
        } else if (fileFormat == FileFormat.CLUSTAL) {
            this.setTranslationOnePos(false);
            this.storeAlignmetAsClustal(out);
        } else if (fileFormat == FileFormat.MSF) {
            this.setTranslationOnePos(false);
            this.storeAlignmetAsMSF(out);
        } else if (fileFormat == FileFormat.NEXUS) {
            this.setTranslationOnePos(false);
            AliViewExtraNexusUtilities.exportAlignmentAsNexus(new BufferedWriter(new FileWriter(outFile)), this, false, nexusDatatype);
        } else if (fileFormat == FileFormat.NEXUS_TRANSLATED_AMINO_ACID) {
            this.setTranslationOnePos(true);
            AliViewExtraNexusUtilities.exportAlignmentAsNexus(new BufferedWriter(new FileWriter(outFile)), this, false, 1);
        } else if (fileFormat == FileFormat.NEXUS_SIMPLE) {
            this.setTranslationOnePos(false);
            AliViewExtraNexusUtilities.exportAlignmentAsNexus(new BufferedWriter(new FileWriter(outFile)), this, true, nexusDatatype);
        } else if (fileFormat == FileFormat.NEXUS_CODONPOS_CHARSET) {
            this.setTranslationOnePos(false);
            AliViewExtraNexusUtilities.exportAlignmentAsNexusCodonpos(new BufferedWriter(new FileWriter(outFile)), this, 7);
        }
        this.setTranslationOnePos(wasTranslated);
    }

    public boolean mergeTwoSequences(List<Sequence> seqs, boolean allowOverlap) {
        boolean isMerged = false;
        if (seqs.size() == 2) {
            isMerged = this.mergeTwoSequences(seqs.get(0), seqs.get(1), allowOverlap);
        }
        return isMerged;
    }

    public boolean mergeTwoSequences(Sequence seq1, Sequence seq2, boolean allowOverlap) {
        if (seq1 instanceof InMemorySequence && seq2 instanceof InMemorySequence) {
            boolean wasMerged = this.sequences.mergeTwoSequences((InMemorySequence)seq1, (InMemorySequence)seq2, allowOverlap);
            return wasMerged;
        }
        return false;
    }

    public void deleteAllExsetBases() {
        boolean[] deleteMask = new boolean[this.alignmentMeta.getExcludes().getMaximumEndPos()];
        for (int n = 0; n < deleteMask.length; ++n) {
            if (!this.alignmentMeta.isExcluded(n)) continue;
            deleteMask[n] = true;
        }
        this.sequences.deleteBasesInAllSequencesFromMask(deleteMask);
        this.alignmentMeta.deleteFromMask(deleteMask);
    }

    public ArrayList<Primer> findPrimerInSelection() {
        ArrayList<Primer> allPrimers = new ArrayList<Primer>();
        if (!this.sequences.hasSelection()) {
            return allPrimers;
        }
        String selection = this.getSelectionAsNucleotides();
        String[] selectionSeq = selection.split("\\n");
        int[] consensusVal = new int[selectionSeq[0].length()];
        for (String seq : selectionSeq) {
            for (int n = 0; n < consensusVal.length; ++n) {
                int baseVal = NucleotideUtilities.baseValFromChar(seq.charAt(n));
                consensusVal[n] = consensusVal[n] | baseVal;
            }
        }
        StringBuilder consensusBuilder = new StringBuilder();
        for (int n = 0; n < consensusVal.length; ++n) {
            consensusBuilder.append(NucleotideUtilities.charFromBaseVal(consensusVal[n]));
        }
        String consensus = consensusBuilder.toString();
        logger.info(consensus.length());
        consensus = consensus.replaceAll("\\-", "");
        int primerMinLen = Settings.getMinPrimerLength().getIntValue();
        int primerMaxLen = Settings.getMaxPrimerLength().getIntValue();
        int primerMinTM = Settings.getPrimerMinTM().getIntValue();
        int primerMaxTM = Settings.getPrimerMaxTM().getIntValue();
        Dimer.setDimerLengthThreashold(Settings.getDimerReportThreashold().getIntValue());
        long nCount = 0L;
        int selectionStartPos = this.getFirstSelectedPositionX();
        for (int winSize = primerMinLen; winSize <= primerMaxLen; ++winSize) {
            int offset;
            int startPos = offset = 0;
            int endPos = offset + winSize;
            logger.info(consensus.length());
            logger.info(endPos);
            while (endPos <= consensus.length()) {
                String primerSeq = consensus.substring(startPos, endPos);
                Primer aPrimer = new Primer(primerSeq, selectionStartPos + startPos);
                long degenFold = aPrimer.getDegenerateFold();
                double baseStackTM = aPrimer.getBaseStackingAvgTm();
                if (degenFold <= (long)this.PRIMER_MAX_DEGENERATE_SCORE && baseStackTM >= (double)primerMinTM && baseStackTM <= (double)primerMaxTM) {
                    allPrimers.add(aPrimer);
                }
                startPos = ++offset;
                endPos = offset + winSize;
                ++nCount;
            }
            logger.info("winSize=" + winSize);
        }
        logger.info("Primers tested:" + nCount);
        Collections.sort(allPrimers);
        return allPrimers;
    }

    private String getSelectionAsNucleotides() {
        return this.sequences.getSelectionAsNucleotides();
    }

    public void copySelectionToClipboardAsFasta() {
        StringWriter writer = new StringWriter();
        this.sequences.writeSelectionAsFasta(writer);
        StringSelection ss = new StringSelection(writer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public void copySelectionToClipboardAsNucleotides() {
        StringSelection ss = new StringSelection(this.getSelectionAsNucleotides());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public void copySelectionNames() {
        logger.info("copy sel names");
        String names = this.sequences.getSelectionNames();
        StringSelection ss = new StringSelection(names);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
        Toolkit.getDefaultToolkit().getSystemSelection().setContents(ss, null);
    }

    public boolean isBaseSelected(int x, int y) {
        return this.sequences.isBaseSelected(x, y);
    }

    public void setSelectionAt(int xPos, int yPos) {
        this.setSelectionAt(xPos, yPos, false);
    }

    public void setSelectionAt(int xPos, int yPos, boolean clearFirst) {
        this.sequences.setSelectionAt(xPos, yPos, clearFirst);
    }

    public void setSelectionWithin(Rectangle bounds) {
        this.sequences.setSelectionWithin(bounds);
    }

    public void reverseComplementAlignment() {
        this.sequences.reverseComplement();
        this.alignmentMeta.reverse(this.getMaximumSequenceLength());
    }

    public void reverseComplementFullySelectedSequences() {
        this.sequences.reverseComplementFullySelectedSequences();
    }

    public FindObject findInNames(FindObject findObj) {
        findObj = this.sequences.findInNames(findObj);
        return findObj;
    }

    public void clearFindLastPos() {
        this.nextFindSequenceNumber = 0;
        this.nextFindStartPos = 0;
    }

    public FindObject findAndSelectInSequences(FindObject findObj) {
        findObj = this.sequences.findAndSelect(findObj);
        return findObj;
    }

    public Sequence getSequenceByName(String name) {
        return this.sequences.getSequenceByName(name);
    }

    public Sequence getSequenceByID(int id) {
        return this.sequences.getSequenceByID(id);
    }

    public void incReadingFrame() {
        int newReadFrame = this.getReadingFrame();
        if (++newReadFrame > 3) {
            newReadFrame = 1;
        }
        this.setReadingFrame(newReadFrame);
    }

    public int getReadingFrame() {
        return this.readingFrame;
    }

    public void decReadingFrame() {
        int newReadFrame = this.getReadingFrame();
        if (--newReadFrame < 1) {
            newReadFrame = 3;
        }
        this.setReadingFrame(newReadFrame);
    }

    public List<Sequence> clearSelectedBases(boolean undoable) {
        List<Sequence> affected = this.sequences.replaceSelectedBasesWithGap(undoable);
        return affected;
    }

    public void deleteFullySelectedSequences() {
        this.sequences.deleteFullySelectedSequences();
    }

    public void deleteSelectedBases() {
        int first = this.sequences.getFirstSelectedWholeColumn();
        if (first != -1) {
            int last = this.sequences.getLastSelectedWholeColumn();
            logger.info("first" + first);
            logger.info("last" + last);
            boolean[] deleteMask = new boolean[this.getMaxX()];
            for (int n = first; n <= last; ++n) {
                deleteMask[n] = true;
            }
            this.sequences.deleteBasesInAllSequencesFromMask(deleteMask);
            this.alignmentMeta.deleteFromMask(deleteMask);
        } else {
            List<Sequence> list = this.sequences.deleteSelectedBases();
        }
    }

    public String getConsensus() {
        return this.sequences.getConsensus();
    }

    public void deleteVerticalGaps() {
        String cons = this.getConsensus();
        logger.info("done cons" + cons);
        if (cons.indexOf(45) >= 0) {
            logger.info("there is a gap in cons");
            boolean[] deleteMask = new boolean[cons.length()];
            for (int n = 0; n < deleteMask.length; ++n) {
                if (cons.charAt(n) != '-') continue;
                deleteMask[n] = true;
            }
            this.sequences.deleteBasesInAllSequencesFromMask(deleteMask);
            this.alignmentMeta.deleteFromMask(deleteMask);
        }
    }

    public void addFasta(String clipboardSelection) {
        try {
            AlignmentListModel sequencesFromClipboard = seqFactory.createFastaSequences(new StringReader(clipboardSelection));
            this.sequences.addAll(sequencesFromClipboard, true);
        }
        catch (AlignmentImportException e) {
            e.printStackTrace();
        }
    }

    public void addNewSequence() {
        int minLen = this.sequences.getShortestSequenceLength();
        int maxLen = this.sequences.getLongestSequenceLength();
        int len = maxLen == minLen ? maxLen : 1;
        String seqName = "New_sequence";
        byte[] bases = new byte[len];
        Arrays.fill(bases, (byte)45);
        InMemorySequence newSeq = new InMemorySequence(seqName, bases);
        Point lastSel = this.sequences.getLastSelectedPos();
        if (lastSel != null && lastSel.y + 1 < this.sequences.getSize()) {
            this.sequences.add(lastSel.y + 1, newSeq);
        } else {
            this.sequences.add(newSeq);
        }
    }

    public void addSequences(File additionalFile) {
        this.addSequences(additionalFile, 0);
    }

    public void addSequences(File additionalFile, int index) {
        try {
            AlignmentListModel additionalSequences = seqFactory.createSequences(additionalFile);
            this.sequences.addAll(index, additionalSequences);
        }
        catch (AlignmentImportException e) {
            e.printStackTrace();
        }
    }

    public void clearSelectionOffset() {
        this.sequences.setSelectionOffset(0);
    }

    public List<Sequence> moveSelectionRight(boolean undoable) {
        logger.info("move");
        List<Sequence> previousState = this.sequences.moveSelectedResiduesRightIfGapIsPresent(undoable);
        return previousState;
    }

    public List<Sequence> moveSelectionLeft(boolean undoable) {
        List<Sequence> previousState = this.sequences.moveSelectedResiduesLeftIfGapIsPresent(undoable);
        return previousState;
    }

    public List<Sequence> moveSelection(int diff, boolean undoable) {
        List<Sequence> previousState = this.sequences.moveSelectedResiduesIfGapIsPresent(diff, undoable);
        return previousState;
    }

    public boolean isMoveSelectionLeftPossible() {
        return this.sequences.isGapPresentLeftOfSelection();
    }

    public boolean isMoveSelectionRightPossible() {
        return this.sequences.isGapPresentRightOfSelection();
    }

    public List<Sequence> deleteGapMoveLeft(boolean undoable) {
        List<Sequence> previousState = this.sequences.deleteGapMoveLeft(undoable);
        if (previousState.size() > 0) {
            this.rightPadSequencesWithGapUntilEqualLength();
        }
        return previousState;
    }

    public List<Sequence> deleteGapMoveRight(boolean undoable) {
        List<Sequence> previousState = this.sequences.deleteGapMoveRight(undoable);
        if (previousState.size() > 0) {
            this.rightPadSequencesWithGapUntilEqualLength();
        }
        return previousState;
    }

    public List<Sequence> insertGapLeftOfSelectionMoveRight(boolean undoable) {
        List<Sequence> previousState = this.sequences.insertGapLeftOfSelectedBase(undoable);
        if (previousState.size() > 0) {
            this.rightPadSequencesWithGapUntilEqualLength();
        }
        return previousState;
    }

    public List<Sequence> insertGapRightOfSelectionMoveLeft(boolean undoable) {
        List<Sequence> previousState = this.sequences.insertGapRightOfSelectedBase(undoable);
        if (previousState.size() > 0) {
            this.leftPadSequencesWithGapUntilEqualLength();
        }
        return previousState;
    }

    public boolean rightPadSequencesWithGapUntilEqualLength() {
        boolean wasPadded = this.sequences.rightPadWithGapUntilEqualLength();
        return wasPadded;
    }

    public boolean leftPadSequencesWithGapUntilEqualLength() {
        boolean wasPadded = this.sequences.leftPadWithGapUntilEqualLength();
        return wasPadded;
    }

    public long getSelectedBasesCount() {
        return this.sequences.getSelectionSize();
    }

    public Rectangle getSelectionAsMinRect() {
        if (!this.hasSelection()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean seqIndex = false;
        for (int n = 0; n < this.sequences.getSize(); ++n) {
            int[] selection = this.sequences.get(n).getSelectedPositions();
            if (selection.length <= 0) continue;
            minY = Math.min(minY, n);
            maxY = Math.max(maxY, n);
            minX = Math.min(minX, selection[0]);
            maxX = Math.max(minX, selection[selection.length - 1]);
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public void addOrRemoveSelectionToExcludes() {
        Rectangle selection = this.getSelectionAsMinRect();
        if (this.isTranslatedOnePos()) {
            selection = this.getAlignmentMeta().reTranslatePositions(selection);
        }
        boolean containsExcludedAlready = this.getAlignmentMeta().excludesIntersectsPositions(selection.x, selection.x + selection.width);
        logger.info("containsExcludedAlready" + containsExcludedAlready);
        if (containsExcludedAlready) {
            this.removeSelectionFromExcludes();
        } else {
            this.addSelectionToExcludes();
        }
    }

    public void addSelectionToExcludes() {
        Rectangle selection = this.getSelectionAsMinRect();
        if (this.isTranslatedOnePos()) {
            selection = this.getAlignmentMeta().reTranslatePositions(selection);
        }
        this.getAlignmentMeta().excludeRange(selection.x, selection.x + selection.width);
    }

    public void removeSelectionFromExcludes() {
        Rectangle selection = this.getSelectionAsMinRect();
        if (this.isTranslatedOnePos()) {
            selection = this.getAlignmentMeta().reTranslatePositions(selection);
        }
        this.getAlignmentMeta().removeExcludeRange(selection.x, selection.x + selection.width);
    }

    public void setSelectionAsCoding(int startOffset) {
        Rectangle bounds = this.sequences.getSelectionBounds();
        if (this.sequences.isTranslated()) {
            bounds = this.getAlignmentMeta().reTranslatePositions(bounds);
        }
        if (bounds != null) {
            this.alignmentMeta.getCodonPositions().addRange(bounds.x, bounds.x + bounds.width, startOffset);
        }
    }

    public void setSelectionAsNonCoding() {
        this.setSelectionAsCoding(0);
    }

    public void complementAlignment() {
        this.sequences.complement();
    }

    public boolean isEditedAfterLastSave() {
        return this.isEditedAfterLastSave;
    }

    public void setEditedAfterLastSave(boolean isEditedAfterLastSave) {
        this.isEditedAfterLastSave = isEditedAfterLastSave;
    }

    public String getFirstAlignmentProgInvalidCharacter() {
        String testChars = "?\u00c5\u00c4\u00d6*";
        String invalidCharsInAlignment = "";
        block0: for (int n = 0; n < testChars.length(); ++n) {
            char testChar = testChars.charAt(n);
            for (Sequence seq : this.getSequences()) {
                if (!seq.contains(testChar)) continue;
                invalidCharsInAlignment = invalidCharsInAlignment + testChar;
                continue block0;
            }
        }
        return invalidCharsInAlignment;
    }

    public void setAlignmentFormat(FileFormat fileFormat) {
        this.sequences.setFileFormat(fileFormat);
    }

    public FileFormat getFileFormat() {
        return this.sequences.getFileFormat();
    }

    public int getLongestSequenceName() {
        return this.sequences.getLongestSequenceName();
    }

    public int getCodonPosAt(int x) {
        return this.alignmentMeta.getCodonPosAt(x);
    }

    public void setReadingFrame(int readingFrame) {
        if (readingFrame > 0 && readingFrame <= 3) {
            this.readingFrame = readingFrame;
            this.alignmentMeta.setReadingFrame(readingFrame);
        }
    }

    public boolean isFullCodonStartingAt(int x) {
        return this.alignmentMeta.isFullCodonStartingAt(x);
    }

    public boolean isExcluded(int x) {
        return this.alignmentMeta.isExcluded(x);
    }

    public AlignmentMeta getAlignentMetaCopy() {
        return this.alignmentMeta.getCopy();
    }

    public void setAlignentMeta(AlignmentMeta aliMeta) {
        this.alignmentMeta = aliMeta;
    }

    public AlignmentMeta getAlignmentMeta() {
        return this.alignmentMeta;
    }

    public ArrayList<Integer> getAllCodonPositions(int i, boolean removeExcluded, int startPos, int endPosInclusive) {
        return this.alignmentMeta.getAllCodonPositions(i, removeExcluded, startPos, endPosInclusive);
    }

    public void selectDuplicates() {
        this.sequences.findAndSelectDuplicates();
    }

    public HashSet<String> findDuplicateNames() {
        if (this.sequences != null) {
            return this.sequences.findDuplicateNames();
        }
        return null;
    }

    public void selectDuplicateNamesSequences() {
        this.sequences.selectDuplicateNamesSequences();
    }

    public void getStats() {
        for (CharSet charSet : this.alignmentMeta.getCharsets()) {
            int[] consensusVal = new int[this.sequences.getLongestSequenceLength()];
            int missingCount = 0;
            int nonemptySeqCount = 0;
            for (Sequence seq : this.sequences) {
                boolean sequenceIsAllEmpty = true;
                int sequenceMissingCount = 0;
                for (int n = 0; n < consensusVal.length; ++n) {
                    if (!charSet.contains(n)) continue;
                    int baseVal = NucleotideUtilities.baseValFromBase(seq.getBaseAtPos(n));
                    if (baseVal == 15 || baseVal == 32 || baseVal == 0) {
                        ++sequenceMissingCount;
                        continue;
                    }
                    consensusVal[n] = consensusVal[n] | baseVal;
                    sequenceIsAllEmpty = false;
                }
                if (sequenceIsAllEmpty) continue;
                ++nonemptySeqCount;
                missingCount += sequenceMissingCount;
            }
            StringBuilder consensusBuilder = new StringBuilder();
            int invaribleCount = 0;
            int varibleCount = 0;
            for (int n = 0; n < consensusVal.length; ++n) {
                if (!charSet.contains(n)) continue;
                consensusBuilder.append(NucleotideUtilities.charFromBaseVal(consensusVal[n]));
                if (consensusVal[n] == 1 || consensusVal[n] == 2 || consensusVal[n] == 4 || consensusVal[n] == 8) {
                    ++invaribleCount;
                    continue;
                }
                ++varibleCount;
            }
            String consensus = consensusBuilder.toString();
            logger.info(charSet.getName());
            logger.info("consensus" + consensus);
            logger.info("invaribleCount" + invaribleCount);
            logger.info("variableCount" + varibleCount);
            logger.info("totalCount" + (invaribleCount + varibleCount));
            logger.info("missingCount" + missingCount);
            logger.info("nonemptySeqCount" + nonemptySeqCount);
            double totalBases = (invaribleCount + varibleCount) * nonemptySeqCount;
            double missingPercent = (double)missingCount / totalBases;
            logger.info("missingPercent" + missingPercent);
        }
    }

    public ArrayList<Sequence> deleteEmptySequences() {
        ArrayList<Sequence> deleted = this.sequences.deleteEmptySequences();
        return deleted;
    }

    public void deleteSequence(Sequence sequence) {
        this.sequences.deleteSequence(sequence);
    }

    public int getFirstSelectedSequenceIndex() {
        int selectedIndex = -1;
        int n = 0;
        for (Sequence seq : this.sequences) {
            if (seq.hasSelection()) {
                selectedIndex = n;
                break;
            }
            ++n;
        }
        return selectedIndex;
    }

    public void selectSequencesWithIndex(List<Integer> selectedIndex) {
        this.sequences.selectSequencesWithIndex(selectedIndex);
    }

    public void selectSequencesWithIndex(int[] selectedIndex) {
        this.sequences.selectSequencesWithIndex(selectedIndex);
    }

    public GeneticCode getGeneticCode() {
        return this.alignmentMeta.getGeneticCode();
    }

    public void setGeneticCode(GeneticCode genCode) {
        this.alignmentMeta.setGeneticCode(genCode);
    }

    public boolean isUndoable() {
        boolean isUndoable = true;
        if (this.getSequences() != null && this.getSequences() instanceof FileSequenceAlignmentListModel) {
            isUndoable = false;
        }
        return isUndoable;
    }

    public boolean isNucleotideAlignment() {
        return this.sequences.getSequenceType() == SequenceUtils.TYPE_NUCLEIC_ACID;
    }

    public boolean isAAAlignment() {
        return this.sequences.getSequenceType() == SequenceUtils.TYPE_AMINO_ACID;
    }

    public boolean isUnknownAlignment() {
        return this.sequences.getSequenceType() == SequenceUtils.TYPE_UNKNOWN;
    }

    public boolean replaceSelectedWithChar(char newChar) {
        List<Sequence> replacedSeqs = this.sequences.replaceSelectedWithChar(newChar, this.isUndoable());
        return replacedSeqs.size() > 0;
    }

    public void selectEverythingWithinGaps(Point point) {
        this.sequences.selectEverythingWithinGaps(point);
    }

    public void realignNucleotidesUseThisAAAlignmentAsTemplate(Alignment realignment) throws Exception {
        this.sequences.realignNucleotidesUseTheseAASequenceAsTemplate(realignment.getSequences());
    }

    public void deleteAllGaps() {
        this.sequences.deleteAllGaps();
    }

    public void padAndTrimSequences() {
        boolean wasPadded = this.sequences.rightPadWithGapUntilEqualLength();
        boolean wasTrimed = this.sequences.rightTrimSequencesRemoveGapsUntilEqualLength();
    }

    public void trimSequences() {
        boolean wasTrimed = this.sequences.rightTrimSequencesRemoveGapsUntilEqualLength();
    }

    public void selectAll() {
        this.sequences.selectAll();
    }

    public void selectionExtendRight() {
        this.sequences.selectionExtendRight();
    }

    public void selectionExtendLeft() {
        this.sequences.selectionExtendLeft();
    }

    public void selectionExtendDown() {
        this.sequences.selectionExtendDown();
    }

    public void selectionExtendTop() {
        this.sequences.selectionExtendTop();
    }

    public void invertSelection() {
        long startTime = System.currentTimeMillis();
        this.sequences.invertSelection();
        long endTime = System.currentTimeMillis();
        logger.info("Invert took" + (endTime - startTime) + " milliseconds");
    }

    public boolean isPositionValid(int x, int y) {
        return this.sequences.isPositionValid(x, y);
    }

    public boolean getSelectionAt(int x, int y) {
        return this.sequences.isBaseSelected(x, y);
    }

    public void setAllHorizontalSelectionAt(int y, boolean selection) {
        if (selection) {
            this.sequences.selectSequenceWithIndex(y);
        } else {
            this.sequences.clearAllSelectionInSequenceWithIndex(y);
        }
    }

    public void copySelectionFromSequenceTo(int indexFrom, int indexTo) {
        this.sequences.copySelectionFromInto(indexFrom, indexTo);
    }

    public void selectColumn(int columnIndex) {
        this.sequences.selectColumn(columnIndex);
    }

    public void clearColumnSelection(int columnIndex) {
        this.sequences.clearColumnSelection(columnIndex);
    }

    public void copySelectionFromPosX1toX2(int x1, int x2) {
        this.sequences.copySelectionFromPosX1toX2(x1, x2);
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public Point getFirstSelectedPosition() {
        return this.sequences.getFirstSelectedPos();
    }

    public int getFirstSelectedPositionX() {
        Point pos = this.sequences.getFirstSelectedPos();
        if (pos == null) {
            return 0;
        }
        return pos.x;
    }

    public int getFirstSelectedUngapedPositionX() {
        Point pos = this.sequences.getFirstSelectedUngapedPos();
        if (pos == null) {
            logger.info("pos == null");
            return -1;
        }
        logger.info("pos == " + pos.x);
        return pos.x;
    }

    public void sortSequencesByName() {
        this.sequences.sortSequencesByName();
    }

    public void sortSequencesByCharInSelectedColumn() {
        this.sequences.sortSequencesByCharInSelectedColumn(this.getHistogram());
    }

    public AliHistogram getHistogram() {
        return this.sequences.getHistogram();
    }

    public boolean hasSelection() {
        return this.sequences.hasSelection();
    }

    public List<Sequence> replaceSelectedCharactersWithThis(Alignment realignment) {
        boolean undoable = true;
        List<Sequence> affected = this.sequences.replaceSelectedCharactersWithThis(realignment.getSequences(), undoable);
        return affected;
    }

    public void saveSelectedSequencesAsFastaFile(File outFile, boolean useIDAsName) throws IOException {
        BufferedWriter buffWriter = new BufferedWriter(new FileWriter(outFile));
        this.sequences.writeSelectedSequencesAsFasta(buffWriter, useIDAsName);
        buffWriter.flush();
        buffWriter.close();
    }

    public void saveUnSelectedSequencesAsFastaFile(File outFile, boolean useIDAsName) throws IOException {
        BufferedWriter buffWriter = new BufferedWriter(new FileWriter(outFile));
        this.sequences.writeUnSelectedSequencesAsFasta(buffWriter, useIDAsName);
        buffWriter.flush();
        buffWriter.close();
    }

    public boolean isEditable() {
        boolean isEditable = false;
        if (this.sequences != null) {
            isEditable = this.sequences.isEditable();
        }
        return isEditable;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public long getSelectionSize() {
        return this.sequences.getSelectionSize();
    }

    @Override
    public void fileSequenceContentsChanged() {
        logger.info("fileSequenceContChanged");
    }

    public void setTranslationOnePos(boolean showTranslationOnePos) {
        if (this.isNucleotideAlignment()) {
            this.sequences.setTranslation(showTranslationOnePos);
            this.alignmentMeta.setTranslation(showTranslationOnePos);
        }
    }

    public boolean isTranslatedOnePos() {
        return this.sequences.isTranslated();
    }

    public boolean hasFullySelectedSequences() {
        return this.sequences.hasFullySelectedSequences();
    }

    public void sortSequencesByThisModel(AlignmentListModel prevSeqOrder) {
        this.sequences.sortSequencesByThisModel(prevSeqOrder);
    }

    public int getSelectedColumnCount() {
        return this.sequences.getSelectedColumnCount();
    }

    public int getSelectedSequencesCount() {
        return this.sequences.getSelectedSequencesCount();
    }

    public List<Sequence> getSelectedSequences() {
        return this.sequences.getSelectedSequences();
    }

    public String getFirstSelectedSequenceName() {
        return this.sequences.getFirstSelectedName();
    }

    public List<Sequence> setFirstSelectedSequenceName(String newName) {
        List<Sequence> previous = this.sequences.setFirstSelectedName(newName);
        return previous;
    }

    public ArrayList<CharSet> getSelectedCharsets() {
        Rectangle selection = this.sequences.getSelectionBounds();
        if (selection == null) {
            return new ArrayList<CharSet>();
        }
        ArrayList<CharSet> intersected = this.alignmentMeta.getCharsets().getIntersected(selection);
        return intersected;
    }

    public void selectAll(CharSet aCharSet) {
        this.sequences.selectAll(aCharSet);
    }

    public int countStopCodons() {
        int totalCount = 0;
        if (this.isNucleotideAlignment()) {
            for (Sequence seq : this.sequences) {
                totalCount += seq.countStopCodon();
            }
        } else {
            for (Sequence seq : this.sequences) {
                totalCount += seq.countChar('*');
            }
        }
        return totalCount;
    }

    public void saveFastaIndex() {
        logger.info("this.fileFormat");
        if (this.getFileFormat() == FileFormat.FASTA && this.sequences instanceof FileSequenceAlignmentListModel) {
            FileSequenceAlignmentListModel model = (FileSequenceAlignmentListModel)this.getSequences();
            String indexName = this.getAlignmentFile().getAbsolutePath();
            indexName = indexName + ".fai";
            File indexFile = new File(indexName);
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(indexFile));
                Sequence firstSeq = this.sequences.get(0);
                int charsPerLine = 0;
                int newlinePos = firstSeq.indexOf('\n');
                charsPerLine = newlinePos == -1 ? firstSeq.getLength() + 2 : newlinePos + 1 + 1;
                int spacePerLine = firstSeq.countChar(' ', 0, newlinePos);
                logger.info("newlinePos" + newlinePos);
                logger.info("spacePerLine" + spacePerLine);
                int residuesPerLine = charsPerLine - ++spacePerLine;
                for (Sequence seq : this.sequences) {
                    FastaFileSequence fileSeq = (FastaFileSequence)seq;
                    String name = fileSeq.getName();
                    out.write(name);
                    out.write(9);
                    int length = fileSeq.getLength();
                    logger.info("length" + length);
                    int fullRows = length / charsPerLine;
                    logger.info("fullRows" + fullRows);
                    int diff = charsPerLine - residuesPerLine;
                    logger.info("diff" + diff);
                    double decimalPart = (double)length / (double)charsPerLine - (double)fullRows;
                    int remindDiff = (int)(decimalPart * (double)diff);
                    logger.info("remindDiff" + remindDiff);
                    diff *= fullRows;
                    logger.info("diff" + (diff += remindDiff));
                    int lengthWithoutWhite = length - diff + 1;
                    out.write("" + lengthWithoutWhite);
                    out.write(9);
                    out.write("" + (fileSeq.getSequenceAfterNameStartPointer() - 1L));
                    out.write(9);
                    out.write("" + residuesPerLine);
                    out.write(9);
                    out.write("" + charsPerLine);
                    out.write(LF);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Messenger.showOKOnlyMessage(Messenger.NO_FASTA_INDEX_COULD_BE_SAVED);
        }
    }

    public void setTempSelection(Rectangle selectRectMatrixCoords) {
        this.getSequences().setTempSelection(selectRectMatrixCoords);
    }

    public Rectangle getTempSelection() {
        return this.getSequences().getTempSelection();
    }

    public void clearTempSelection() {
        this.getSequences().clearTempSelection();
    }

    public void moveSelectedSequencesToBottom() {
        this.getSequences().moveSelectedSequencesToBottom();
    }

    public void moveSelectedSequencesToTop() {
        this.getSequences().moveSelectedSequencesToTop();
    }

    public void moveSelectedSequencesUp() {
        this.getSequences().moveSelectedSequencesUp();
    }

    public void moveSelectedSequencesDown() {
        this.getSequences().moveSelectedSequencesDown();
    }

    public void moveSelectedSequencesTo(int index) {
        this.getSequences().moveSelectedSequencesTo(index);
    }

    public void selectIndices(List<Integer> allFoundIndices) {
        this.getSequences().getAlignmentSelectionModel().selectSequencesWithIndex(allFoundIndices);
    }

    public boolean isFileSequences() {
        return this.getSequences() instanceof FileSequenceAlignmentListModel;
    }

    public boolean isEmptyAlignment() {
        return this.getSequences() == null || this.getSequences().size() == 0;
    }

    public void terminalGAPtoMissing() {
        this.sequences.terminalGAPtoMissing();
    }

    public void missingToGAP() {
        this.sequences.missingToGAP();
    }

    public boolean isSequencesEqualLength() {
        return this.sequences.isEqualLength();
    }
}

