/*
 * Decompiled with CFR 0.152.
 */
package aliview.alignment;

import aliview.GeneticCode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import utils.nexus.CharSets;
import utils.nexus.CodonPos;
import utils.nexus.CodonPositions;
import utils.nexus.Excludes;

public class AlignmentMeta {
    private static final Logger logger = Logger.getLogger(AlignmentMeta.class);
    private Excludes excludes;
    private CodonPositions codonPositions;
    private CharSets charsets;
    private GeneticCode geneticCode;
    private boolean isTranslated;

    public AlignmentMeta() {
        this(GeneticCode.DEFAULT);
    }

    public AlignmentMeta(GeneticCode genCode) {
        this(new Excludes(), new CodonPositions(), new CharSets(), genCode);
    }

    public AlignmentMeta(Excludes excludes, CodonPositions codonPos, CharSets charsets, GeneticCode genCode) {
        this.excludes = excludes;
        this.codonPositions = codonPos;
        this.charsets = charsets;
        this.geneticCode = genCode;
    }

    public boolean isMetaOutputNeeded() {
        boolean isMetaNeeded = false;
        if (this.excludes.containsAnyPosition()) {
            isMetaNeeded = true;
        }
        if (this.codonPositions.isAnythingButDefault()) {
            isMetaNeeded = true;
        }
        if (this.charsets.size() > 0) {
            isMetaNeeded = true;
        }
        return isMetaNeeded;
    }

    public Excludes getExcludes() {
        return this.excludes;
    }

    public CodonPositions getCodonPositions() {
        return this.codonPositions;
    }

    public boolean isFullCodonStartingAt(int x) {
        return this.codonPositions.isFullCodonStartingAt(x);
    }

    public void reverse(int length) {
        this.getExcludes().reverse(length);
        this.getCodonPositions().reverse(length);
    }

    public int countIncludedPositionsBefore(int minimumInteger) {
        int count = 0;
        for (int n = 0; n < minimumInteger; ++n) {
            if (this.excludes.isExcluded(n)) continue;
            ++count;
        }
        return count;
    }

    public void setReadingFrame(int readingFrame) {
        this.codonPositions.setReadingFrame(readingFrame);
    }

    public boolean isExcluded(int x) {
        boolean isExcluded = false;
        if (this.isTranslated) {
            CodonPos codonPos = this.codonPositions.getCodonInTranslatedPos(x);
            boolean isStartExcluded = this.excludes.isExcluded(codonPos.startPos);
            boolean isEndExcluded = this.excludes.isExcluded(codonPos.endPos);
            isExcluded = isStartExcluded || isEndExcluded;
        } else {
            isExcluded = this.excludes.isExcluded(x);
        }
        return isExcluded;
    }

    public int getCodonPosAt(int x) {
        return this.codonPositions.getPosAt(x);
    }

    public AlignmentMeta getCopy() {
        return new AlignmentMeta(this.excludes.getCopy(), this.codonPositions.getCopy(), this.charsets.getCopy(), this.geneticCode);
    }

    public ArrayList<Integer> getAllCodonPositions(int wanted, boolean removeExcluded, int startPos, int endPosInclusive) {
        ArrayList<Integer> positions = this.codonPositions.getAllPositions(wanted, startPos, endPosInclusive);
        if (removeExcluded) {
            Iterator<Integer> iter = positions.iterator();
            while (iter.hasNext()) {
                Integer pos = iter.next();
                if (!this.isExcluded(pos)) continue;
                iter.remove();
            }
        }
        return positions;
    }

    public void deleteFromMask(boolean[] deleteMask) {
        if (deleteMask == null || deleteMask.length == 0) {
            return;
        }
        for (int n = deleteMask.length - 1; n >= 0; --n) {
            if (!deleteMask[n]) continue;
            this.deletePosition(n);
        }
    }

    public void deletePosition(int n) {
        this.excludes.deletePosition(n);
        this.codonPositions.deletePosition(n);
        this.charsets.deletePosition(n);
    }

    public void insertPosition(int n) {
        this.excludes.insertPosition(n);
        this.codonPositions.insertPosition(n);
        this.charsets.insertPosition(n);
    }

    public void excludePositions(int start, int end) {
        for (int n = start; n <= end; ++n) {
            this.excludes.set(n, true);
        }
    }

    public void excludeRange(int start, int stop) {
        this.excludes.addRange(start, stop);
    }

    public void removeExcludeRange(int start, int stop) {
        this.excludes.clearRange(start, stop);
    }

    public boolean excludesIntersectsPositions(int start, int end) {
        for (int n = start; n <= end; ++n) {
            if (!this.excludes.isExcluded(n)) continue;
            return true;
        }
        return false;
    }

    public CharSets getCharsets() {
        return this.charsets;
    }

    public int[] translatePositions(int[] selection) {
        return this.codonPositions.translatePositions(selection);
    }

    public int[] reTranslatePositions(int[] selection) {
        return this.codonPositions.reTranslatePositions(selection);
    }

    public Rectangle reTranslatePositions(Rectangle bounds) {
        return this.codonPositions.reTranslatePositions(bounds);
    }

    public GeneticCode getGeneticCode() {
        return this.geneticCode;
    }

    public void setGeneticCode(GeneticCode genCode) {
        this.geneticCode = genCode;
    }

    public void setCharsets(CharSets charsets) {
        this.charsets = charsets;
    }

    public void setTranslation(boolean shouldTrans) {
        if (shouldTrans != this.isTranslated) {
            this.isTranslated = shouldTrans;
        }
    }
}

