/*
 * Decompiled with CFR 0.152.
 */
package aliview.alignment;

import aliview.NucleotideUtilities;
import aliview.alignment.AliHistogram;
import aliview.sequences.Sequence;

public class NucleotideHistogram
extends AliHistogram {
    public NucleotideHistogram(int length) {
        super(length);
    }

    @Override
    public void addSequence(Sequence seq) {
        for (int pos = 0; pos < seq.getLength(); ++pos) {
            int[] nArray = this.hist[pos];
            int n = NucleotideUtilities.baseValFromBase(seq.getBaseAtPos(pos));
            nArray[n] = nArray[n] + 1;
        }
    }

    @Override
    public double getSumNonGap(int x) {
        int sum = 0;
        for (int n = 0; n < this.hist[x].length; ++n) {
            sum += this.hist[x][n];
        }
        return sum -= this.hist[x][0];
    }
}

