/*
 * Decompiled with CFR 0.152.
 */
package aliview.color;

import aliview.color.ClustalXColorScheme;
import aliview.color.ColorScheme;
import aliview.color.DefaultColorScheme;
import aliview.color.DefaultColorSchemeFast;
import aliview.color.SeaViewColorScheme;
import java.util.ArrayList;
import java.util.List;

public class ColorSchemeFactory {
    private static ColorScheme DEFAULT_COLOR_SCHEME = new DefaultColorScheme();
    private static ColorScheme DEFAULT_COLOR_SCHEME_FAST = new DefaultColorSchemeFast();
    private static ColorScheme SEAVIEW_COLOR_SCHEME = new SeaViewColorScheme();
    private static ColorScheme CLUSTAL_X_COLOR_SCHEME = new ClustalXColorScheme();
    private static List<ColorScheme> nucleotideColorSchemes = new ArrayList<ColorScheme>();
    private static List<ColorScheme> aaColorSchemes = new ArrayList<ColorScheme>();
    private static List<ColorScheme> allColorSchemes = new ArrayList<ColorScheme>();

    public static ColorScheme getColorScheme(String name) {
        ColorScheme selectedScheme = DEFAULT_COLOR_SCHEME;
        for (ColorScheme aScheme : allColorSchemes) {
            if (!aScheme.getName().equals(name)) continue;
            selectedScheme = aScheme;
        }
        return selectedScheme;
    }

    public static List<ColorScheme> getNucleotideColorSchemes() {
        return nucleotideColorSchemes;
    }

    public static List<ColorScheme> getAAColorSchemes() {
        return aaColorSchemes;
    }

    public static ColorScheme getDefaultColorScheme() {
        return DEFAULT_COLOR_SCHEME;
    }

    static {
        nucleotideColorSchemes.add(DEFAULT_COLOR_SCHEME);
        nucleotideColorSchemes.add(DEFAULT_COLOR_SCHEME_FAST);
        nucleotideColorSchemes.add(SEAVIEW_COLOR_SCHEME);
        aaColorSchemes.add(DEFAULT_COLOR_SCHEME);
        aaColorSchemes.add(SEAVIEW_COLOR_SCHEME);
        aaColorSchemes.add(CLUSTAL_X_COLOR_SCHEME);
        allColorSchemes.add(DEFAULT_COLOR_SCHEME);
        allColorSchemes.add(DEFAULT_COLOR_SCHEME_FAST);
        allColorSchemes.add(SEAVIEW_COLOR_SCHEME);
        allColorSchemes.add(CLUSTAL_X_COLOR_SCHEME);
    }
}

