/*
 * Decompiled with CFR 0.152.
 */
package aliview.color;

import java.awt.Color;

public class ColorUtils {
    public static int getGolorVal(int r, int g, int b, int a) {
        int rgba = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return rgba;
    }

    public static int grayFromRGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int gray = (r + g + b) / 3;
        return gray;
    }

    public static int darkerRGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new Color((int)((double)r * 0.7), (int)((double)g * 0.7), (int)((double)b * 0.7)).getRGB();
    }

    public static int addTranspGrey(int inVal, double transp) {
        int a = 255;
        int r = (int)((double)ColorUtils.getRed(inVal) * transp);
        int g = (int)((double)ColorUtils.getGreen(inVal) * transp);
        int b = (int)((double)ColorUtils.getBlue(inVal) * transp);
        int rgba = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return rgba;
    }

    public static int getRed(int colVal) {
        return colVal >> 16 & 0xFF;
    }

    public static int getGreen(int colVal) {
        return colVal >> 8 & 0xFF;
    }

    public static int getBlue(int colVal) {
        return colVal >> 0 & 0xFF;
    }

    public static int getAlpha(int colVal) {
        return colVal >> 24 & 0xFF;
    }
}

