/*
 * Decompiled with CFR 0.152.
 */
package aliview.externalcommands;

import aliview.aligner.MuscleWrapper;
import aliview.importer.FileFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CommandItem {
    private static final String LF = System.getProperty("line.separator");
    public static final String CURRENT_ALIGNMENT = "CURRENT_ALIGNMENT";
    public static final String CURRENT_ALIGNMENT_TEMP = "CURRENT_ALIGNMENT_TEMP";
    public static final String CURRENT_ALIGNMENT_FASTA = "CURRENT_ALIGNMENT_FASTA";
    public static final String CURRENT_ALIGNMENT_PHYLIP = "CURRENT_ALIGNMENT_PHYLIP";
    public static final String NEW_ALIGNMENT_TEMP_FILE = "NEW_ALIGNMENT_TEMP_FILE";
    public static final String OUTPUT_FILE = "TEMP_OUT_FILE";
    public static final String CURRENT_ALIGNMENT_FASTA_TRANSLATED_AA = "CURRENT_ALIGNMENT_FASTA_TRANSLATED_AA";
    public static final String SECOND_FILE = "SECOND_FILE";
    public static final String SECOND_SEQUENCES = "SECOND_SEQUENCES";
    private String name;
    private String programPath;
    private String command;
    private String commandAlternative;
    private boolean isActivated;
    private boolean showCommandWindow;
    private ArrayList<String[]> parsedCommand = new ArrayList();

    public CommandItem(String name, String programPath, String command, boolean isActivated, boolean showCommandWindow) {
        this.setName(name);
        this.setProgramPath(programPath);
        this.setCommand(command);
        this.isActivated = isActivated;
        this.showCommandWindow = showCommandWindow;
    }

    public void setProgramPath(String programPath) {
        this.programPath = programPath;
    }

    public String getProgramPath() {
        return this.programPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
        this.parseCommand();
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public boolean isShowCommandWindow() {
        return this.showCommandWindow;
    }

    public void setShowCommandWindow(boolean showCommandWindow) {
        this.showCommandWindow = showCommandWindow;
    }

    public FileFormat getCurrentAlignmentFileFormat() {
        if (this.getCommand().contains(CURRENT_ALIGNMENT_TEMP)) {
            return FileFormat.FASTA;
        }
        if (this.getCommand().contains(CURRENT_ALIGNMENT_FASTA)) {
            return FileFormat.FASTA;
        }
        if (this.getCommand().contains(CURRENT_ALIGNMENT_PHYLIP)) {
            return FileFormat.PHYLIP;
        }
        if (this.getCommand().contains(CURRENT_ALIGNMENT)) {
            return FileFormat.FASTA;
        }
        return FileFormat.FASTA;
    }

    public void reParseCommand() {
        this.parseCommand();
    }

    public void parseCommand() {
        this.parseCommandIncludingProgramAsFirstParameter();
    }

    private void parseCommandIncludingProgramAsFirstParameter() {
        if (this.getCommand() == null) {
            return;
        }
        this.parsedCommand = new ArrayList();
        String commandInclProgram = "";
        if (this.getProgramPath() != null && this.getProgramPath().length() > 0) {
            String stripped = StringUtils.strip(this.getProgramPath(), "\"'");
            commandInclProgram = "\"" + stripped + "\" " + this.getCommand();
        } else {
            commandInclProgram = this.getCommand();
        }
        String[] splitted = commandInclProgram.split("[\r\n]+");
        for (int n = 0; n < splitted.length; ++n) {
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(splitted[n]);
            while (regexMatcher.find()) {
                String arg = regexMatcher.group();
                arg = StringUtils.strip(arg, "\"'");
                matchList.add(arg);
            }
            String[] splitline = matchList.toArray(new String[matchList.size()]);
            this.parsedCommand.add(splitline);
        }
    }

    public void replaceInCommand(String find, String replace) {
        for (String[] line : this.parsedCommand) {
            for (int i = 0; i < line.length; ++i) {
                line[i] = StringUtils.replace(line[i], find, replace);
            }
        }
    }

    public void replaceParametersInCommand() {
        this.replaceInCommand("LOCAL_ALIVIEW_DIR", MuscleWrapper.getAliViewUserDataDirectory());
    }

    public void setParameterSecondFile(File secondFile) {
        this.replaceInCommand(SECOND_FILE, secondFile.getAbsolutePath());
        this.replaceInCommand(SECOND_SEQUENCES, secondFile.getAbsolutePath());
    }

    public void setParameterCurrentFile(File currentFile) {
        this.replaceInCommand(CURRENT_ALIGNMENT_TEMP, currentFile.getAbsolutePath());
        this.replaceInCommand(CURRENT_ALIGNMENT_FASTA, currentFile.getAbsolutePath());
        this.replaceInCommand(CURRENT_ALIGNMENT_PHYLIP, currentFile.getAbsolutePath());
        this.replaceInCommand(CURRENT_ALIGNMENT_FASTA_TRANSLATED_AA, currentFile.getAbsolutePath());
        this.replaceInCommand(CURRENT_ALIGNMENT, currentFile.getAbsolutePath());
    }

    public void setParameterOutputFile(File outputFile) {
        this.replaceInCommand(OUTPUT_FILE, outputFile.getAbsolutePath());
    }

    public boolean commandContainsIgnoreCase(String target) {
        return this.getCommand().toLowerCase().contains(target.toLowerCase());
    }

    public ArrayList<String[]> getParsedCommands() {
        return this.parsedCommand;
    }
}

