/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import aliview.AliViewWindow;
import aliview.gui.AppIcons;
import aliview.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class MessageLogFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(MessageLogFrame.class);
    private static final String LF = System.getProperty("line.separator");
    private JTextArea messageArea;
    private AliViewWindow aliViewWindow;

    public MessageLogFrame(AliViewWindow aliViewWin) {
        this.aliViewWindow = aliViewWin;
        this.messageArea = new JTextArea();
        this.refreshLog();
        JScrollPane scrollPane = new JScrollPane(this.messageArea, 20, 30);
        this.getContentPane().add((Component)scrollPane, "Center");
        JButton btnLogStatistics = new JButton("Log statistics");
        btnLogStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageLogFrame.this.aliViewWindow.createStats();
                MessageLogFrame.this.refreshLog();
            }
        });
        JButton btnRequestGC = new JButton("Request GC");
        btnRequestGC.setToolTipText("Request Java Garbage Collection");
        btnRequestGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageLogFrame.this.aliViewWindow.requestGB();
                MessageLogFrame.this.refreshLog();
            }
        });
        JButton refreshButton = new JButton("Refresh log");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageLogFrame.this.refreshLog();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(btnLogStatistics);
        buttonPanel.add(btnRequestGC);
        buttonPanel.add(refreshButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setPreferredSize(new Dimension(600, 400));
        this.pack();
        this.setTitle("log");
        this.setIconImage(AppIcons.getProgramIconImage());
        this.centerLocationToThisComponent(this.aliViewWindow);
    }

    protected void refreshLog() {
        try {
            MessageLogFrame messageLogFrame = this;
            messageLogFrame.aliViewWindow.flushAllLogs();
            File logFile = new File(System.getProperty("user.home"), File.separator + Settings.getAliViewUserDataSubdir() + File.separator + Settings.getLogfileName());
            logger.info("logFile=" + logFile);
            String message = FileUtils.readFileToString(logFile);
            this.messageArea.setText(logFile.getAbsolutePath() + LF + message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void placeFrameupperLeftLocationOfThis(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + 150;
            int newY = parent.getY() + 100;
            this.setLocation(newX, newY);
        }
    }

    public void centerLocationToThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2;
            int newY = parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2;
            this.setLocation(newX, newY);
        }
    }
}

