/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;

public class RepeatingKeyEventsFixer
implements AWTEventListener {
    public static final int RELEASED_LAG_MILLIS = 1;
    private Map<Integer, ReleasedAction> _releasedMap = new HashMap<Integer, ReleasedAction>();
    private Set<Integer> _pressed = new HashSet<Integer>();
    private Set<Character> _typed = new HashSet<Character>();

    private static boolean assertEDT() {
        if (!EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)("Not EDT, but [" + Thread.currentThread() + "]."));
        }
        return true;
    }

    public void install() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    public void remove() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        assert (event instanceof KeyEvent) : "Shall only listen to KeyEvents, so no other events shall come here";
        assert (RepeatingKeyEventsFixer.assertEDT());
        if (event instanceof Reposted) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyEvent.isConsumed()) {
            return;
        }
        if (event.getID() == 400) {
            if (this._typed.contains(Character.valueOf(keyEvent.getKeyChar()))) {
                keyEvent.consume();
            } else {
                this._typed.add(Character.valueOf(keyEvent.getKeyChar()));
            }
            return;
        }
        if (keyEvent.getID() == 402) {
            Timer timer = new Timer(1, null);
            ReleasedAction action = new ReleasedAction(keyEvent, timer);
            timer.addActionListener(action);
            timer.start();
            ReleasedAction oldAction = this._releasedMap.put(keyEvent.getKeyCode(), action);
            if (oldAction != null) {
                oldAction.cancel();
            }
            keyEvent.consume();
            return;
        }
        if (keyEvent.getID() == 401) {
            if (this._pressed.contains(keyEvent.getKeyCode())) {
                keyEvent.consume();
            } else {
                ReleasedAction action = this._releasedMap.get(keyEvent.getKeyCode());
                if (action != null) {
                    action.cancel();
                }
                this._pressed.add(keyEvent.getKeyCode());
            }
            return;
        }
        throw new AssertionError((Object)"All IDs should be covered.");
    }

    public static interface Reposted {
    }

    protected class ReleasedAction
    implements ActionListener {
        private final KeyEvent _originalKeyEvent;
        private Timer _timer;

        ReleasedAction(KeyEvent originalReleased, Timer timer) {
            this._timer = timer;
            this._originalKeyEvent = originalReleased;
        }

        void cancel() {
            assert (RepeatingKeyEventsFixer.assertEDT());
            this._timer.stop();
            this._timer = null;
            RepeatingKeyEventsFixer.this._releasedMap.remove(this._originalKeyEvent.getKeyCode());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (RepeatingKeyEventsFixer.assertEDT());
            if (this._timer == null) {
                return;
            }
            this.cancel();
            RepostedKeyEvent newEvent = new RepostedKeyEvent((Component)this._originalKeyEvent.getSource(), this._originalKeyEvent.getID(), this._originalKeyEvent.getWhen(), this._originalKeyEvent.getModifiers(), this._originalKeyEvent.getKeyCode(), this._originalKeyEvent.getKeyChar(), this._originalKeyEvent.getKeyLocation());
            RepeatingKeyEventsFixer.this._pressed.remove(this._originalKeyEvent.getKeyCode());
            RepeatingKeyEventsFixer.this._typed.remove(Character.valueOf(this._originalKeyEvent.getKeyChar()));
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(newEvent);
        }
    }

    public static class RepostedKeyEvent
    extends KeyEvent
    implements Reposted {
        public RepostedKeyEvent(Component source, int id, long when, int modifiers, int keyCode, char keyChar, int keyLocation) {
            super(source, id, when, modifiers, keyCode, keyChar, keyLocation);
        }
    }
}

