/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import aliview.alignment.Alignment;
import aliview.alignment.AlignmentEvent;
import aliview.alignment.AlignmentListener;
import aliview.gui.pane.AlignmentPane;
import aliview.sequencelist.AlignmentDataEvent;
import aliview.sequencelist.AlignmentDataListener;
import aliview.sequencelist.AlignmentSelectionEvent;
import aliview.sequencelist.AlignmentSelectionListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import utils.nexus.CharSet;

public class StatusPanel
extends JPanel
implements AlignmentListener,
AlignmentDataListener,
AlignmentSelectionListener {
    private static final Logger logger = Logger.getLogger(StatusPanel.class);
    private Alignment alignment;
    private AlignmentPane aliPane;
    private Point pointerPos;
    private JLabel lblInfo;
    private JLabel lblTxtPos;
    private long selectionSize;
    private int posInSeq;
    private int posInUngapedSeq;
    private int selectedColumnCount;
    private int selectedSeqCount;
    private String firstSelectedSequenceName = "";
    private String firstSelectedCharsetName = "";
    private JLabel lblTotalSelectedChars;
    private JLabel lblCols;
    private JLabel lblSelectedSeqCount;
    private JLabel lblPosUngaped;
    private JLabel lblPos;
    private JLabel lblSelectedName;
    private JLabel lblAlignmentInfo;
    private JLabel lblTxtCharset;
    private JLabel lblCharset;
    Thread updateThread;

    public StatusPanel(AlignmentPane alignmentPane, Alignment alignment) {
        this.aliPane = alignmentPane;
        this.alignment = alignment;
        this.setLayout(new BoxLayout(this, 0));
        this.lblInfo = new JLabel();
        this.lblInfo.setText("  Selected: ");
        this.add(this.lblInfo);
        this.lblInfo.setPreferredSize(this.lblInfo.getPreferredSize());
        this.lblInfo.setMinimumSize(this.lblInfo.getPreferredSize());
        this.lblSelectedName = new JLabel("Woodsia macrolaena and more...");
        this.lblSelectedName.setHorizontalAlignment(10);
        this.lblSelectedName.setPreferredSize(new Dimension(Short.MAX_VALUE, 0));
        this.lblSelectedName.setMinimumSize(new Dimension(0, 0));
        this.add(this.lblSelectedName);
        this.lblSelectedName.setText("");
        this.add(this.createStatusPanelSeparator());
        if (alignment.getAlignmentMeta().getCharsets().size() > 0) {
            this.lblTxtCharset = new JLabel("Charset:");
            this.add(this.lblTxtCharset);
            this.lblTxtCharset.setPreferredSize(this.lblTxtCharset.getPreferredSize());
            this.lblCharset = new JLabel("CharsetNameIsThis_1");
            this.add(this.lblCharset);
            this.lblCharset.setHorizontalAlignment(10);
            this.lblCharset.setPreferredSize(this.lblCharset.getPreferredSize());
            this.lblCharset.setMinimumSize(this.lblCharset.getPreferredSize());
            this.lblCharset.setText("");
            this.add(this.createStatusPanelSeparator());
        }
        this.lblTxtPos = new JLabel("Pos:");
        this.add(this.lblTxtPos);
        this.lblTxtPos.setPreferredSize(this.lblTxtPos.getPreferredSize());
        this.lblPos = new JLabel("01234567890");
        this.add(this.lblPos);
        this.lblPos.setHorizontalAlignment(0);
        this.lblPos.setPreferredSize(this.lblPos.getPreferredSize());
        this.lblPos.setMinimumSize(this.lblPos.getPreferredSize());
        this.lblPos.setText("");
        this.add(this.createStatusPanelSeparator());
        JLabel lblNewLabel_3 = new JLabel("Pos (ungaped):");
        this.add(lblNewLabel_3);
        lblNewLabel_3.setPreferredSize(lblNewLabel_3.getPreferredSize());
        this.lblPosUngaped = new JLabel("0123456789");
        this.add(this.lblPosUngaped);
        this.lblPosUngaped.setHorizontalAlignment(0);
        this.lblPosUngaped.setPreferredSize(this.lblPosUngaped.getPreferredSize());
        this.lblPosUngaped.setMinimumSize(this.lblPosUngaped.getPreferredSize());
        this.lblPosUngaped.setText("");
        this.add(this.createStatusPanelSeparator());
        JLabel lblNewLabel_5 = new JLabel("Selected seqs:");
        this.add(lblNewLabel_5);
        lblNewLabel_5.setPreferredSize(lblNewLabel_5.getPreferredSize());
        this.lblSelectedSeqCount = new JLabel("3987920");
        this.add(this.lblSelectedSeqCount);
        this.lblSelectedSeqCount.setHorizontalAlignment(0);
        this.lblSelectedSeqCount.setPreferredSize(this.lblSelectedSeqCount.getPreferredSize());
        this.lblSelectedSeqCount.setMinimumSize(this.lblSelectedSeqCount.getPreferredSize());
        this.lblSelectedSeqCount.setText("");
        this.add(this.createStatusPanelSeparator());
        JLabel lblNewLabel_1 = new JLabel("Cols:");
        lblNewLabel_1.setPreferredSize(lblNewLabel_1.getPreferredSize());
        lblNewLabel_1.setMinimumSize(lblNewLabel_1.getPreferredSize());
        lblNewLabel_1.setMaximumSize(lblNewLabel_1.getPreferredSize());
        this.add(lblNewLabel_1);
        this.lblCols = new JLabel("0123456789");
        this.add(this.lblCols);
        this.lblCols.setHorizontalAlignment(0);
        this.lblCols.setPreferredSize(this.lblCols.getPreferredSize());
        this.lblCols.setMinimumSize(this.lblCols.getPreferredSize());
        this.lblCols.setText("");
        this.add(this.createStatusPanelSeparator());
        JLabel lblNewLabel_8 = new JLabel("Total selected chars:");
        this.add(lblNewLabel_8);
        lblNewLabel_8.setPreferredSize(lblNewLabel_8.getPreferredSize());
        lblNewLabel_8.setMaximumSize(lblNewLabel_8.getPreferredSize());
        lblNewLabel_8.setMinimumSize(lblNewLabel_8.getPreferredSize());
        lblNewLabel_8.setOpaque(true);
        this.lblTotalSelectedChars = new JLabel("0123456789");
        this.add(this.lblTotalSelectedChars);
        this.lblTotalSelectedChars.setHorizontalAlignment(0);
        this.lblTotalSelectedChars.setPreferredSize(this.lblTotalSelectedChars.getPreferredSize());
        this.lblTotalSelectedChars.setMinimumSize(this.lblTotalSelectedChars.getPreferredSize());
        this.lblTotalSelectedChars.setText("");
        this.add(this.createStatusPanelSeparator());
        JLabel lblNewLabel_10 = new JLabel("Alignment:");
        this.add(lblNewLabel_10);
        lblNewLabel_10.setPreferredSize(lblNewLabel_10.getPreferredSize());
        lblNewLabel_10.setMinimumSize(lblNewLabel_10.getPreferredSize());
        logger.info(this.getPreferredSize());
        this.lblAlignmentInfo = new JLabel("_133009 sequences 5509309pos.__");
        this.add(this.lblAlignmentInfo);
        this.lblAlignmentInfo.setHorizontalAlignment(0);
        this.lblAlignmentInfo.setPreferredSize(this.lblAlignmentInfo.getPreferredSize());
        this.lblAlignmentInfo.setMaximumSize(this.lblAlignmentInfo.getPreferredSize());
        this.lblAlignmentInfo.setMinimumSize(this.lblAlignmentInfo.getPreferredSize());
        this.lblAlignmentInfo.setText("");
        logger.info(this.getPreferredSize());
        this.updateAll();
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    private Component createStatusPanelSeparator() {
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(7, 18));
        sep.setMaximumSize(sep.getPreferredSize());
        sep.setMinimumSize(sep.getPreferredSize());
        return sep;
    }

    private void updateAlignmentValuesAndLabels() {
        if (this.alignment == null) {
            this.lblAlignmentInfo.setText("no alignmnet loaded");
        } else {
            String seqCount = StringUtils.leftPad("" + this.alignment.getMaxY(), 6);
            String width = StringUtils.leftPad("" + this.alignment.getMaxX(), 6);
            this.lblAlignmentInfo.setText("" + seqCount + " sequences " + width + " pos.  ");
        }
    }

    private void updateSelectionValuesAndLabels() {
        if (this.updateThread != null && this.updateThread.isAlive()) {
            this.updateThread.interrupt();
        }
        this.posInSeq = -2;
        this.posInUngapedSeq = -1;
        this.updateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<CharSet> selectedCharsets;
                StatusPanel.this.selectionSize = StatusPanel.this.alignment.getSelectionSize();
                StatusPanel.this.selectedColumnCount = StatusPanel.this.alignment.getSelectedColumnCount();
                StatusPanel.this.selectedSeqCount = StatusPanel.this.alignment.getSelectedSequencesCount();
                StatusPanel.this.firstSelectedSequenceName = StatusPanel.this.alignment.getFirstSelectedSequenceName();
                if (StatusPanel.this.firstSelectedSequenceName == null) {
                    StatusPanel.this.firstSelectedSequenceName = "";
                }
                if ((selectedCharsets = StatusPanel.this.alignment.getSelectedCharsets()).size() == 0) {
                    StatusPanel.this.firstSelectedCharsetName = "";
                } else {
                    for (CharSet charset : selectedCharsets) {
                        StatusPanel.this.firstSelectedCharsetName = StatusPanel.this.firstSelectedCharsetName + (charset.getName() + ",");
                    }
                    StatusPanel.this.firstSelectedCharsetName = StringUtils.removeEnd(StatusPanel.this.firstSelectedCharsetName, ",");
                }
                StatusPanel.this.posInSeq = StatusPanel.this.alignment.getFirstSelectedPositionX();
                StatusPanel.this.posInUngapedSeq = StatusPanel.this.alignment.getFirstSelectedUngapedPositionX();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatusPanel.this.updateSelectionLabels();
                        logger.info("Update selection from thread done");
                    }
                });
            }
        });
        this.updateThread.start();
    }

    private void updateSelectionLabels() {
        if (this.alignment != null && this.selectionSize > 0L) {
            String firstSelSeqName = StringUtils.substring(this.firstSelectedSequenceName, 0, 40);
            if (this.selectedSeqCount > 1) {
                firstSelSeqName = firstSelSeqName + "...";
            }
            String ungapPos = "" + this.posInUngapedSeq;
            String posInSeqTxt = "" + (this.posInSeq + 1);
            if (this.selectionSize == 0L) {
                ungapPos = "";
                posInSeqTxt = "";
            }
            this.lblSelectedName.setText(firstSelSeqName);
            if (this.lblCharset != null) {
                this.lblCharset.setText(StringUtils.substring(this.firstSelectedCharsetName, 0, 40));
            }
            this.lblPos.setText(posInSeqTxt);
            this.lblPosUngaped.setText(ungapPos);
            this.lblSelectedSeqCount.setText("" + this.selectedSeqCount);
            this.lblCols.setText("" + this.selectedColumnCount);
            this.lblTotalSelectedChars.setText("" + this.selectionSize);
        } else {
            this.lblSelectedName.setText("");
            if (this.lblCharset != null) {
                this.lblCharset.setText("");
            }
            this.lblPos.setText("");
            this.lblPosUngaped.setText("");
            this.lblSelectedSeqCount.setText("");
            this.lblCols.setText("");
            this.lblTotalSelectedChars.setText("");
        }
    }

    public void updateAll() {
        this.updateAlignmentValuesAndLabels();
        this.updateSelectionValuesAndLabels();
    }

    @Override
    public void selectionChanged(AlignmentSelectionEvent e) {
        this.updateSelectionValuesAndLabels();
    }

    @Override
    public void newSequences(AlignmentEvent alignmentEvent) {
        this.updateAll();
    }

    @Override
    public void alignmentMetaChanged(AlignmentEvent alignmentEvent) {
        this.updateAll();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    public void contentsChanged(AlignmentDataEvent e) {
        this.updateAll();
    }
}

