/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import aliview.AliViewWindow;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextEditDialog {
    private static final String LF = System.getProperty("line.separator");
    public static final String TITLE_EDIT_SEQUENCE_NAME = "Rename sequence";
    public static final String TITLE_GO_TO_POS = "Go to position (x) or (,y) or (x,y)";
    private static JTextField textEdit;
    protected Integer selectedValue = -1;
    private Point preferredPos;

    public TextEditDialog() {
    }

    public TextEditDialog(Point pos) {
        this.preferredPos = pos;
    }

    public void showOKCancelTextEditor(String editString, String title, AliViewWindow aliViewWindow) {
        final JDialog dialog = new JDialog(aliViewWindow);
        dialog.setTitle(title);
        dialog.setModal(true);
        dialog.setAlwaysOnTop(true);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        textEdit = new JTextField(editString);
        textEdit.setEditable(true);
        textEdit.setMaximumSize(new Dimension(800, 30));
        textEdit.setPreferredSize(new Dimension(350, 30));
        JPanel messagePanel = new JPanel();
        Object[] messageAndEditor = new Object[]{messagePanel, textEdit};
        JOptionPane optPane = new JOptionPane(messageAndEditor, -1, 2);
        optPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("value")) {
                    TextEditDialog.this.selectedValue = (Integer)e.getNewValue();
                    switch (TextEditDialog.this.selectedValue) {
                        case 0: {
                            break;
                        }
                    }
                    dialog.dispose();
                }
            }
        });
        dialog.setContentPane(optPane);
        dialog.pack();
        if (this.preferredPos != null) {
            dialog.setLocation(this.preferredPos);
            this.makeSureWithinBounds(dialog, aliViewWindow);
        } else {
            dialog.setLocationRelativeTo(aliViewWindow);
        }
        textEdit.selectAll();
        dialog.setVisible(true);
    }

    private void makeSureWithinBounds(JDialog dialog, AliViewWindow aliViewWindow) {
        Rectangle smaller = dialog.getBounds();
        Rectangle larger = aliViewWindow.getBounds();
        int topDiff = larger.x - smaller.x;
        int bottomDiff = larger.y + larger.height - (smaller.y + smaller.height);
        if (topDiff > 0) {
            dialog.setLocation(smaller.x, larger.y);
        }
        if (bottomDiff < 0) {
            dialog.setLocation(smaller.x, smaller.y + bottomDiff);
        }
    }

    public Integer getSelectedValue() {
        return this.selectedValue;
    }

    public String getEditText() {
        return textEdit.getText();
    }
}

