/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.AliView;
import aliview.Base;
import aliview.alignment.Alignment;
import aliview.color.ColorScheme;
import aliview.gui.pane.AACharPixelsContainer;
import aliview.gui.pane.CharPixelsContainer;
import aliview.gui.pane.CompoundCharPixelsContainer;
import aliview.gui.pane.InvalidAlignmentPositionException;
import aliview.gui.pane.RGBArray;
import aliview.gui.pane.SequencePainter;
import aliview.gui.pane.SequencePainterAminoAcid;
import aliview.gui.pane.SequencePainterAminoAcidTranslated;
import aliview.gui.pane.SequencePainterAminoAcidTranslatedIgnoreGap;
import aliview.gui.pane.SequencePainterNucleotide;
import aliview.gui.pane.SequencePainterNucleotideTranslatedShowNucAndAcid;
import aliview.gui.pane.TranslationCharPixelsContainer;
import aliview.messenges.Messenger;
import aliview.sequences.Sequence;
import aliview.settings.Settings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.MemoryImageSource;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;
import utils.nexus.CharSet;
import utils.nexus.CharSets;

public class AlignmentPane
extends JPanel {
    private static final long serialVersionUID = 601195400946835871L;
    private static final Logger logger = Logger.getLogger(AlignmentPane.class);
    private static final double MIN_CHAR_SIZE = 0.0;
    private static final int MAX_CHAR_SIZE = 100;
    private static final double CHAR_HEIGHT_RATIO = 1.4;
    public static final int MAX_CHARSIZE_TO_DRAW = 6;
    double charWidth = 10.0;
    double charHeight = 12.0;
    private Font baseFont = new Font(OSNativeUtils.getMonospacedFontName(), 0, (int)this.charWidth);
    private Font highDPIFont = new Font(OSNativeUtils.getMonospacedFontName(), 0, (int)this.charWidth);
    private int highDPIScaleFactor = 1;
    private Alignment alignment;
    private ColorScheme colorSchemeAminoAcid = Settings.getColorSchemeAminoAcid();
    private ColorScheme colorSchemeNucleotide = Settings.getColorSchemeNucleotide();
    int differenceTraceSequencePosition = 0;
    private boolean showTranslation = false;
    private boolean showTranslationAndNuc = false;
    private AlignmentRuler alignmentRuler;
    private CharsetRuler charsetRuler;
    private boolean drawAminoAcidCode;
    private boolean drawCodonPosOnRuler;
    private Rectangle lastClip = new Rectangle();
    private boolean rulerIsDirty;
    boolean highlightDiffTrace = false;
    boolean highlightNonCons;
    boolean highlightCons;
    private boolean ignoreGapInTranslation;
    private byte byteToDraw;
    private long endTime;
    private int drawCounter = 0;
    private int DRAWCOUNT_LOF_INTERVAL = 1;
    private int fontCase = Settings.getFontCase().getIntValue();
    CharPixelsContainer charPixDefaultNuc;
    CharPixelsContainer charPixSelectedNuc;
    CharPixelsContainer charPixConsensusNuc;
    AACharPixelsContainer charPixDefaultAA;
    AACharPixelsContainer charPixSelectedAA;
    AACharPixelsContainer charPixConsensusAA;
    TranslationCharPixelsContainer charPixTranslationDefault;
    TranslationCharPixelsContainer charPixTranslationSelected;
    TranslationCharPixelsContainer charPixTranslationLetter;
    TranslationCharPixelsContainer charPixTranslationSelectedLetter;
    TranslationCharPixelsContainer charPixTranslationAndNucDefault;
    TranslationCharPixelsContainer charPixTranslationAndNucSelected;
    TranslationCharPixelsContainer charPixTranslationAndNucDefaultNoAALetter;
    TranslationCharPixelsContainer charPixTranslationAndNucSelectedNoAALetter;
    TranslationCharPixelsContainer charPixTranslationAndNucDominantNuc;
    TranslationCharPixelsContainer charPixTranslationAndNucDominantNucNoAALetter;
    TranslationCharPixelsContainer charPixTranslationAndNucDominantNucSelected;
    TranslationCharPixelsContainer charPixTranslationAndNucDominantNucNoAALetterSelected;
    private double smallCharsSizeNumber = 0.0;
    private int CHARSET_LINE_HEIGHT = 5;

    public AlignmentPane() {
        this.highDPIScaleFactor = (int)OSNativeUtils.getHighDPIScaleFactor(this);
        this.createAdjustedDerivedBaseFont();
        this.createAdjustedDerivedHighDPIFont();
        this.createCharPixelsContainers();
        logger.info("highDPIScaleFactor" + this.highDPIScaleFactor);
        this.setOpaque(true);
        this.alignmentRuler = new AlignmentRuler(this);
        this.charsetRuler = new CharsetRuler(this);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isOnlyDrawDiff() {
        return this.highlightDiffTrace;
    }

    public void setHighlightDiffTrace(boolean highlightDiff) {
        this.highlightDiffTrace = highlightDiff;
    }

    public void setHighlightNonCons(boolean b) {
        this.highlightNonCons = b;
    }

    public boolean isHighlightNonCons() {
        return this.highlightNonCons;
    }

    public void setHighlightCons(boolean b) {
        this.highlightCons = b;
    }

    public boolean isHighlightCons() {
        return this.highlightCons;
    }

    public void setDrawCodonPosOnRuler(boolean drawCodonPosOnRuler) {
        this.drawCodonPosOnRuler = drawCodonPosOnRuler;
    }

    public boolean getDrawCodonPosOnRuler() {
        return this.drawCodonPosOnRuler;
    }

    public void setShowCharsetRuler(boolean selected) {
        this.charsetRuler.setVisible(selected);
    }

    public boolean decCharSize() {
        boolean didDecrease = false;
        if (this.getSize().width > this.getVisibleRect().width || this.getSize().height > this.getVisibleRect().height || this.charWidth >= 1.0) {
            double preferredWidth = this.charWidth;
            double preferredHeight = this.charHeight;
            if (this.charWidth > 1.0) {
                preferredWidth = this.charWidth >= 18.0 ? (double)((int)(this.charWidth - 0.12 * this.charWidth)) : this.charWidth - 1.0;
                preferredHeight = (int)(preferredWidth * 1.4);
            } else {
                this.smallCharsSizeNumber = this.charWidth == 1.0 ? 1.0 : (this.smallCharsSizeNumber += 1.0);
                preferredHeight = preferredWidth = Math.pow(0.85, this.smallCharsSizeNumber);
            }
            if (preferredWidth >= 0.0) {
                this.charWidth = preferredWidth;
                this.charHeight = preferredHeight;
            }
            this.createAdjustedDerivedBaseFont();
            this.createAdjustedDerivedHighDPIFont();
            this.createCharPixelsContainers();
            this.validateSize();
            didDecrease = true;
        }
        return didDecrease;
    }

    public void incCharSize() {
        if (this.charWidth >= 1.0) {
            this.charWidth = this.charWidth >= 16.0 ? (double)((int)(this.charWidth + 0.12 * this.charWidth)) : (double)((int)this.charWidth + 1);
            this.charHeight = (int)(this.charWidth * 1.4);
        } else {
            this.smallCharsSizeNumber -= 1.0;
            this.charWidth = this.smallCharsSizeNumber <= 0.0 ? 1.0 : Math.pow(0.85, this.smallCharsSizeNumber);
            this.charHeight = this.charWidth;
        }
        if (this.charWidth > 100.0) {
            this.charWidth = 100.0;
            this.charHeight = (int)(this.charWidth * 1.4);
        }
        this.createAdjustedDerivedBaseFont();
        this.createAdjustedDerivedHighDPIFont();
        this.createCharPixelsContainers();
        this.validateSize();
    }

    private void createCharPixelsContainers() {
        CharPixelsContainer container;
        CompoundCharPixelsContainer compContainer;
        long startTime = System.currentTimeMillis();
        Font charFont = this.highDPIFont;
        int charPixWidth = Math.max(1, (int)this.getCharWidth());
        int charPixHeight = Math.max(1, (int)this.getCharHeight());
        int charMaxSizeToDraw = 6 * this.highDPIScaleFactor;
        logger.info("charFont" + charFont.getSize());
        logger.info("charPixWidth" + (charPixWidth *= this.highDPIScaleFactor));
        this.charPixDefaultNuc = CharPixelsContainer.createDefaultNucleotideContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight *= this.highDPIScaleFactor, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixSelectedNuc = CharPixelsContainer.createSelectedNucleotideContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixConsensusNuc = CharPixelsContainer.createConsensusNucleotideContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationDefault = TranslationCharPixelsContainer.createDefaultTranslationPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationSelected = TranslationCharPixelsContainer.createSelectedTranslationPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationLetter = TranslationCharPixelsContainer.createLetterTranslationPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationSelectedLetter = TranslationCharPixelsContainer.createSelectedLetterTranslationPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucDefault = TranslationCharPixelsContainer.createDefaultTranslationAndNucPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucDefaultNoAALetter = TranslationCharPixelsContainer.createDefaultTranslationAndNucPixelsContainerNoAALetter(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucSelected = TranslationCharPixelsContainer.createSelectedTranslationAndNucPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucSelectedNoAALetter = TranslationCharPixelsContainer.createSelectedTranslationAndNucPixelsContainerNoAALetter(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucDominantNuc = TranslationCharPixelsContainer.createDominantNucTranslationAndNucPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucDominantNucNoAALetter = TranslationCharPixelsContainer.createDominantNucTranslationAndNucPixelsContainerNoAALetter(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucDominantNucSelected = TranslationCharPixelsContainer.createSelectedDominantNucTranslationAndNucPixelsContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixTranslationAndNucDominantNucNoAALetterSelected = TranslationCharPixelsContainer.createSelectedDominantNucTranslationAndNucPixelsContainerNoAALetter(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeNucleotide, this.getFontCase());
        this.charPixDefaultAA = new AACharPixelsContainer();
        if (this.colorSchemeAminoAcid.getALLCompundColors() != null) {
            compContainer = CompoundCharPixelsContainer.createDefaultCompoundColorContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeAminoAcid, this.getFontCase());
            this.charPixDefaultAA.setCompoundContainer(compContainer);
        } else {
            container = CharPixelsContainer.createDefaultAAContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeAminoAcid, this.getFontCase());
            this.charPixDefaultAA.setContainer(container);
        }
        this.charPixSelectedAA = new AACharPixelsContainer();
        if (this.colorSchemeAminoAcid.getALLCompundColors() != null) {
            compContainer = CompoundCharPixelsContainer.createSelectedCompoundColorContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeAminoAcid, this.getFontCase());
            this.charPixSelectedAA.setCompoundContainer(compContainer);
        } else {
            container = CharPixelsContainer.createSelectedAAContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeAminoAcid, this.getFontCase());
            this.charPixSelectedAA.setContainer(container);
        }
        this.charPixConsensusAA = new AACharPixelsContainer();
        if (this.colorSchemeAminoAcid.getALLCompundColors() != null) {
            compContainer = CompoundCharPixelsContainer.createDefaultCompoundColorContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeAminoAcid, this.getFontCase());
            this.charPixConsensusAA.setCompoundContainer(compContainer);
        } else {
            container = CharPixelsContainer.createConsensusAAContainer(charFont, charMaxSizeToDraw, charPixWidth, charPixHeight, this.colorSchemeAminoAcid, this.getFontCase());
            this.charPixConsensusAA.setContainer(container);
        }
        this.endTime = System.currentTimeMillis();
        logger.info("Creating charPixContainers took " + (this.endTime - startTime) + " milliseconds");
    }

    private int getFontCase() {
        return this.fontCase;
    }

    @Override
    public Font getFont() {
        return this.baseFont;
    }

    private void createAdjustedDerivedBaseFont() {
        Font spacedFont;
        HashMap<TextAttribute, Number> attributes = new HashMap<TextAttribute, Number>();
        attributes.put(TextAttribute.TRACKING, 0);
        attributes.put(TextAttribute.SIZE, (int)this.charWidth);
        Font calcFont = this.baseFont.deriveFont(attributes);
        FontMetrics metrics = this.getFontMetrics(calcFont);
        int fontActualWidth = metrics.stringWidth("X");
        double sizeDiff = this.charWidth - (double)fontActualWidth;
        double tracking = sizeDiff / this.charWidth;
        logger.info("tracking" + tracking);
        attributes.put(TextAttribute.TRACKING, tracking);
        attributes.put(TextAttribute.SIZE, (int)this.charWidth);
        this.baseFont = spacedFont = this.baseFont.deriveFont(attributes);
    }

    private void createAdjustedDerivedHighDPIFont() {
        Font spacedFont;
        HashMap<TextAttribute, Number> attributes = new HashMap<TextAttribute, Number>();
        attributes.put(TextAttribute.TRACKING, 0);
        attributes.put(TextAttribute.SIZE, (int)this.charWidth * this.highDPIScaleFactor);
        Font calcFont = this.baseFont.deriveFont(attributes);
        FontMetrics metrics = this.getFontMetrics(calcFont);
        int fontActualWidth = metrics.stringWidth("X");
        double sizeDiff = this.charWidth * (double)this.highDPIScaleFactor - (double)fontActualWidth;
        double tracking = sizeDiff / this.charWidth * (double)this.highDPIScaleFactor;
        logger.info("tracking" + tracking);
        attributes.put(TextAttribute.TRACKING, tracking);
        attributes.put(TextAttribute.SIZE, (int)this.charWidth * this.highDPIScaleFactor);
        this.highDPIFont = spacedFont = this.baseFont.deriveFont(attributes);
    }

    private void logFontMetrics(Font font) {
        FontMetrics metrics = this.getGraphics().getFontMetrics(font);
        logger.info("font.getSize()" + font.getSize());
        logger.info("font.getSize2D()" + font.getSize2D());
        logger.info("font.getSize2D()" + font.getSize2D());
        int hgt = metrics.getHeight();
        logger.info("metrics.getHeight()" + metrics.getHeight());
        logger.info("metrics.getMaxAdvance()" + metrics.getMaxAdvance());
        logger.info("metrics.getLeading()" + metrics.getLeading());
        int adv = metrics.stringWidth("A");
        logger.info("metrics.stringWidth(\"A\")" + metrics.stringWidth("AAAAAAAAAA"));
        logger.info("metrics.stringWidth(\"T\")" + metrics.stringWidth("T"));
        logger.info("metrics.stringWidth(\"c\")" + metrics.stringWidth("c"));
        logger.info("font.getAttributes().get(WIDTH_REGULAR)" + font.getAttributes().get(TextAttribute.WIDTH_REGULAR));
    }

    public Point getBasePosition(Base base) {
        if (base == null) {
            return null;
        }
        int x = (int)((double)base.getPosition() * this.charWidth);
        int y = (int)((double)this.alignment.getSequenceIndex(base.getSequence()) * this.charHeight);
        Point pos = new Point(x, y);
        return pos;
    }

    public Base selectBaseAt(Point pos) throws InvalidAlignmentPositionException {
        Base base = null;
        base = this.getBaseAt(pos);
        if (base != null) {
            base.getPosition();
            base.getSequence();
            this.alignment.getSequenceIndex(base.getSequence());
            this.alignment.setSelectionAt(base.getPosition(), this.alignment.getSequenceIndex(base.getSequence()), true);
        }
        return base;
    }

    public int getUngapedPositionInSequenceAt(Point pos) throws InvalidAlignmentPositionException {
        int ungapedPos = 0;
        Base base = this.getBaseAt(pos);
        if (base != null) {
            ungapedPos = base.getUngapedPosition();
        }
        return ungapedPos;
    }

    public int getPositionInSequenceAt(Point pos) throws InvalidAlignmentPositionException {
        int xPos = 0;
        Base base = this.getBaseAt(pos);
        if (base != null) {
            xPos = base.getPosition();
        }
        return xPos;
    }

    public void selectColumnAt(Point pos) {
        int columnIndex = this.getColumnAt(pos);
        this.getAlignment().selectColumn(columnIndex);
    }

    public Base getBaseAt(Point pos) throws InvalidAlignmentPositionException {
        Point matrixPoint = this.paneCoordToMatrixCoord(pos);
        Base base = null;
        if (this.alignment.isPositionValid(matrixPoint.x, matrixPoint.y)) {
            Sequence seq = this.alignment.getSequences().get(matrixPoint.y);
            base = new Base(seq, matrixPoint.x);
        } else {
            base = null;
        }
        return base;
    }

    public Base getClosestBaseAt(Point pos) {
        Point matrixPoint = this.paneCoordToMatrixCoord(pos);
        Base base = null;
        if (this.alignment.isPositionValid(matrixPoint.x, matrixPoint.y)) {
            Sequence seq = this.alignment.getSequences().get(matrixPoint.y);
            base = new Base(seq, matrixPoint.x);
        } else {
            Sequence seq = this.alignment.getSequences().get(this.alignment.getSequences().getSize() - 1);
            base = new Base(seq, matrixPoint.x);
        }
        return base;
    }

    public int getColumnAt(Point pos) {
        Point matrixPoint = this.paneCoordToMatrixCoord(pos);
        return matrixPoint.x;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
        this.validateSize();
    }

    public void repaintAndForceRuler() {
        this.rulerIsDirty = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintAlignment(g);
    }

    public void paintAlignment(Graphics g) {
        ++this.drawCounter;
        long startTime = System.currentTimeMillis();
        if (AliView.isDebugMode() && this.drawCounter % this.DRAWCOUNT_LOF_INTERVAL == 0) {
            logger.info("Inside paintAlignment: Time from last endTim " + (startTime - this.endTime) + " milliseconds");
            System.out.println("Inside paintAlignment: Time from last endTim " + (startTime - this.endTime) + " milliseconds");
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clip = g2d.getClipBounds();
        Rectangle matrixClip = this.paneCoordToMatrixCoord(clip);
        int xMin = matrixClip.x - 1;
        int yMin = matrixClip.y - 1;
        int xMax = (int)matrixClip.getMaxX() + 1;
        int yMax = (int)matrixClip.getMaxY() + 1;
        if (this.showTranslation) {
            --xMin;
            ++xMax;
        }
        xMin = Math.min(this.alignment.getMaxX(), xMin);
        xMin = Math.max(0, xMin);
        yMin = Math.min(this.alignment.getMaxY(), yMin);
        yMin = Math.max(0, yMin);
        xMax = Math.min(this.alignment.getMaxX(), xMax);
        yMax = Math.min(this.alignment.getMaxY(), yMax);
        int height = (yMax - yMin) * (int)this.charHeight;
        int width = (xMax - xMin) * (int)this.charWidth;
        if (this.charWidth < 1.0) {
            height = clip.height;
            width = clip.width;
        }
        int[] pixArray = new int[width * this.highDPIScaleFactor * height * this.highDPIScaleFactor];
        RGBArray clipRGB = new RGBArray(pixArray, width * this.highDPIScaleFactor, height * this.highDPIScaleFactor);
        this.fillRGBArrayAndPaintMultithreaded(xMin, xMax, yMin, yMax, clipRGB, clip, g2d);
        if (this.drawCounter % this.DRAWCOUNT_LOF_INTERVAL == 0) {
            this.endTime = System.currentTimeMillis();
            logger.info("Alignment pane PaintComponent took " + (this.endTime - startTime) + " milliseconds");
        }
        if (clip.x != this.lastClip.x || clip.width != this.lastClip.width || this.rulerIsDirty) {
            this.alignmentRuler.repaint();
            this.charsetRuler.repaint();
            this.rulerIsDirty = false;
        }
        this.lastClip = clip;
    }

    private void fillRGBArrayAndPaintMultithreaded(int xMin, int xMax, int yMin, int yMax, RGBArray clipRGB, Rectangle clip, Graphics2D g2d) {
        int drawExcludesHeight;
        SequencePainter seqPainter;
        int xPosEnd;
        int xPosStart;
        int clipYPos;
        ExecutorService executor;
        boolean isNucleotideAlignment = this.alignment.isNucleotideAlignment();
        double seqPerPixX = 1.0 / this.charWidth;
        double seqPerPixY = 1.0 / this.charWidth;
        logger.info("Runtime.getRuntime().availableProcessors()" + Runtime.getRuntime().availableProcessors());
        int nThreads = 1;
        if (this.alignment.isFileSequences()) {
            nThreads = 1;
        } else {
            if (Runtime.getRuntime().availableProcessors() > 2) {
                nThreads = 2;
            }
            if (Runtime.getRuntime().availableProcessors() > 4) {
                nThreads = 3;
            }
        }
        if (this.charWidth < 1.0) {
            executor = Executors.newFixedThreadPool(nThreads);
            clipYPos = 0;
            int y = clip.y;
            while ((double)y < clip.getMaxY()) {
                int ySeq = (int)((double)y * seqPerPixY);
                if (ySeq <= yMax && ySeq >= 0) {
                    int seqYPos = ySeq;
                    Sequence seq = this.alignment.getSequences().get(seqYPos);
                    xPosStart = clip.x;
                    xPosEnd = (int)clip.getMaxX();
                    if (isNucleotideAlignment) {
                        if (this.isShowTranslationOnePos()) {
                            seqPainter = new SequencePainterAminoAcid(seq, seqYPos, clipYPos, xPosStart, xPosEnd, seqPerPixX, 1.0, 1.0, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                            executor.execute(seqPainter);
                        } else if (this.showTranslation && !this.isShowTranslationOnePos() && this.ignoreGapInTranslation) {
                            seqPainter = new SequencePainterAminoAcidTranslatedIgnoreGap(seq, seqYPos, clipYPos, xPosStart, xPosEnd, seqPerPixX, 1.0, 1.0, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                            executor.execute(seqPainter);
                        } else if (this.showTranslation) {
                            if (this.showTranslationAndNuc) {
                                seqPainter = new SequencePainterNucleotideTranslatedShowNucAndAcid(seq, seqYPos, clipYPos, xPosStart, xPosEnd, seqPerPixX, 1.0, 1.0, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                                executor.execute(seqPainter);
                            } else {
                                seqPainter = new SequencePainterAminoAcidTranslated(seq, seqYPos, clipYPos, xPosStart, xPosEnd, seqPerPixX, 1.0, 1.0, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                                executor.execute(seqPainter);
                            }
                        } else {
                            seqPainter = new SequencePainterNucleotide(seq, seqYPos, clipYPos, xPosStart, xPosEnd, seqPerPixX, 1.0, 1.0, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                            executor.execute(seqPainter);
                        }
                    } else {
                        seqPainter = new SequencePainterAminoAcid(seq, seqYPos, clipYPos, xPosStart, xPosEnd, seqPerPixX, 1.0, 1.0, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                        executor.execute(seqPainter);
                    }
                } else {
                    logger.info("outside");
                }
                ++clipYPos;
                ++y;
            }
            executor.shutdown();
            try {
                executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            executor = Executors.newFixedThreadPool(nThreads);
            clipYPos = 0;
            for (int y = yMin; y < yMax; ++y) {
                int seqYPos = y;
                Sequence seq = this.alignment.getSequences().get(seqYPos);
                boolean normalCharSeqPerPix = true;
                xPosStart = xMin;
                xPosEnd = xMax;
                if (isNucleotideAlignment) {
                    if (this.isShowTranslationOnePos()) {
                        seqPainter = new SequencePainterAminoAcid(seq, seqYPos, clipYPos, xPosStart, xPosEnd, (double)normalCharSeqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                        executor.execute(seqPainter);
                    } else if (this.showTranslation && !this.isShowTranslationOnePos() && this.ignoreGapInTranslation) {
                        seqPainter = new SequencePainterAminoAcidTranslatedIgnoreGap(seq, seqYPos, clipYPos, xPosStart, xPosEnd, (double)normalCharSeqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                        executor.execute(seqPainter);
                    } else if (this.showTranslation) {
                        if (this.showTranslationAndNuc) {
                            seqPainter = new SequencePainterNucleotideTranslatedShowNucAndAcid(seq, seqYPos, clipYPos, xPosStart, xPosEnd, (double)normalCharSeqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                            executor.execute(seqPainter);
                        } else {
                            seqPainter = new SequencePainterAminoAcidTranslated(seq, seqYPos, clipYPos, xPosStart, xPosEnd, (double)normalCharSeqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                            executor.execute(seqPainter);
                        }
                    } else {
                        seqPainter = new SequencePainterNucleotide(seq, seqYPos, clipYPos, xPosStart, xPosEnd, (double)normalCharSeqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                        executor.execute(seqPainter);
                    }
                } else {
                    seqPainter = new SequencePainterAminoAcid(seq, seqYPos, clipYPos, xPosStart, xPosEnd, (double)normalCharSeqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, clipRGB, this, this.alignment);
                    executor.execute(seqPainter);
                }
                ++clipYPos;
            }
            executor.shutdown();
            try {
                executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Image img = this.createImage(new MemoryImageSource(clipRGB.getScanWidth(), clipRGB.getHeight(), clipRGB.getBackend(), 0, clipRGB.getScanWidth()));
        g2d.setColor(this.getBackground());
        g2d.fill(clip);
        int clipRGBXPos = clip.x;
        int clipRGBYPos = clip.y;
        if (this.charWidth > 1.0) {
            clipRGBXPos = (int)((double)xMin * this.charWidth);
            clipRGBYPos = (int)((double)yMin * this.charHeight);
        }
        if (img != null) {
            if (this.highDPIScaleFactor > 1) {
                int dx1 = clipRGBXPos;
                int dx2 = dx1 + clipRGB.getScanWidth() / this.highDPIScaleFactor;
                int dy1 = clipRGBYPos;
                int dy2 = dy1 + clipRGB.getHeight() / this.highDPIScaleFactor;
                int sx1 = 0;
                int sx2 = sx1 + clipRGB.getScanWidth();
                int sy1 = 0;
                int sy2 = sy1 + clipRGB.getHeight();
                g2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
            } else {
                g2d.drawImage(img, clipRGBXPos, clipRGBYPos, null);
            }
        }
        if (this.isShowTranslationOnePos()) {
            drawExcludesHeight = (int)Math.min(this.getVisibleRect().getHeight(), (double)this.alignment.getSize() * this.charHeight);
            if (this.charWidth < 1.0) {
                int x = clip.x;
                while ((double)x < clip.getMaxX()) {
                    int xPos = (int)((double)x * (1.0 / this.charWidth));
                    if (this.alignment.isExcluded(xPos)) {
                        g2d.setColor(ColorScheme.GREY_TRANSPARENT);
                        g2d.fillRect(x, this.getVisibleRect().y, 1, drawExcludesHeight);
                    }
                    ++x;
                }
            } else {
                for (int x = xMin; x < xMax; ++x) {
                    if (!this.alignment.isExcluded(x)) continue;
                    g2d.setColor(ColorScheme.GREY_TRANSPARENT);
                    g2d.fillRect((int)((double)x * this.charWidth), this.getVisibleRect().y, (int)this.charWidth, drawExcludesHeight);
                }
            }
        } else {
            drawExcludesHeight = (int)Math.min(this.getVisibleRect().getHeight(), (double)this.alignment.getSize() * this.charHeight);
            if (this.charWidth < 1.0) {
                int x = clip.x;
                while ((double)x < clip.getMaxX()) {
                    int xPos = (int)((double)x * (1.0 / this.charWidth));
                    if (this.alignment.isExcluded(xPos)) {
                        g2d.setColor(ColorScheme.GREY_TRANSPARENT);
                        g2d.fillRect(x, this.getVisibleRect().y, 1, drawExcludesHeight);
                    }
                    ++x;
                }
            } else {
                for (int x = xMin; x < xMax; ++x) {
                    if (!this.alignment.isExcluded(x)) continue;
                    g2d.setColor(ColorScheme.GREY_TRANSPARENT);
                    g2d.fillRect((int)((double)x * this.charWidth), this.getVisibleRect().y, (int)this.charWidth, drawExcludesHeight);
                }
            }
        }
        logger.info("done");
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void validateSequenceOrder() {
        if (this.differenceTraceSequencePosition >= this.alignment.getSize()) {
            this.differenceTraceSequencePosition = 0;
        }
    }

    public int selectWithin(Rectangle rect) {
        int selectionSize = this.addSelectionWithin(rect);
        return selectionSize;
    }

    public int selectColumnsWithin(Rectangle rect) {
        int selectionSize = this.addColumnSelectionWithin(rect);
        return selectionSize;
    }

    public int addColumnSelectionWithin(Rectangle rect) {
        boolean nSelection = false;
        Rectangle columns = new Rectangle(rect.x, 0, rect.width, this.getHeight());
        return this.addSelectionWithin(columns);
    }

    public int addSelectionWithin(Rectangle rect) {
        int nSelection = 0;
        Rectangle bounds = this.paneCoordToMatrixCoord(rect);
        this.alignment.setSelectionWithin(bounds);
        return nSelection;
    }

    public Rectangle paneCoordToMatrixCoord(Rectangle rect) {
        int matrixMinX = (int)Math.floor(rect.getMinX() / this.charWidth);
        int matrixMaxX = (int)Math.floor(rect.getMaxX() / this.charWidth);
        int matrixMinY = (int)Math.floor(rect.getMinY() / this.charHeight);
        int matrixMaxY = (int)Math.floor(rect.getMaxY() / this.charHeight);
        matrixMinX = Math.max(0, matrixMinX);
        matrixMaxX = Math.max(0, matrixMaxX);
        matrixMinY = Math.max(0, matrixMinY);
        matrixMaxY = Math.max(0, matrixMaxY);
        Rectangle converted = new Rectangle(matrixMinX, matrixMinY, matrixMaxX - matrixMinX, matrixMaxY - matrixMinY);
        return converted;
    }

    public void updateStatisticsLabel() {
    }

    public void validateSize() {
        Dimension current = this.getSize();
        Dimension prefSize = this.getCalculatedPreferredSize();
        if (current.width != prefSize.width || current.height != prefSize.height) {
            this.setPreferredSize(prefSize);
            this.rulerIsDirty = true;
            this.revalidate();
        }
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getCalculatedPreferredSize();
    }

    private Dimension getCalculatedPreferredSize() {
        Dimension newDim = new Dimension((int)(this.charWidth * (double)this.alignment.getMaximumSequenceLength()), (int)(this.charHeight * (double)this.alignment.getSize()));
        if (newDim.width == Integer.MAX_VALUE || newDim.height == Integer.MAX_VALUE) {
            Messenger.showMaxJPanelSizeMessageOnceThisSession();
        }
        return newDim;
    }

    public Point paneCoordToMatrixCoord(Point pos) {
        int matrixX = (int)Math.floor(pos.getX() / this.charWidth);
        int matrixY = (int)Math.floor(pos.getY() / this.charHeight);
        Point converted = new Point(matrixX, matrixY);
        return converted;
    }

    public Point matrixCoordToPaneCoord(Point pos) {
        int paneX = (int)(pos.getX() * this.charWidth);
        int paneY = (int)(pos.getY() * this.charHeight);
        Point converted = new Point(paneX, paneY);
        return converted;
    }

    public Rectangle matrixCoordToPaneCoord(Rectangle rect) {
        Point min = new Point((int)rect.getMinX(), (int)rect.getMinY());
        Point max = new Point((int)rect.getMaxX(), (int)rect.getMaxY());
        Rectangle converted = new Rectangle(this.matrixCoordToPaneCoord(min));
        converted.add(this.matrixCoordToPaneCoord(max));
        return converted;
    }

    public boolean isPointWithinMatrix(Point pos) {
        Point matrixPoint = this.paneCoordToMatrixCoord(pos);
        return this.alignment.isPositionValid(matrixPoint.x, matrixPoint.y);
    }

    public double getCharHeight() {
        return this.charHeight;
    }

    public double getCharWidth() {
        return this.charWidth;
    }

    public void setDifferenceTraceSequence(Point pos) throws InvalidAlignmentPositionException {
        Point matrixPoint = this.paneCoordToMatrixCoord(pos);
        Object seq = null;
        if (!this.alignment.isPositionValid(matrixPoint.x, matrixPoint.y)) {
            throw new InvalidAlignmentPositionException("Position is out of range" + pos);
        }
        this.differenceTraceSequencePosition = matrixPoint.y;
    }

    public void setDifferenceTraceSequence(int nIndex) {
        this.differenceTraceSequencePosition = nIndex;
    }

    public Sequence getSequenceAt(Point pos) throws InvalidAlignmentPositionException {
        Point matrixPoint = this.paneCoordToMatrixCoord(pos);
        Sequence seq = null;
        if (!this.alignment.isPositionValid(matrixPoint.x, matrixPoint.y)) {
            throw new InvalidAlignmentPositionException("Position is out of range" + pos);
        }
        seq = this.alignment.getSequences().get(matrixPoint.y);
        return seq;
    }

    public boolean isWithinExistingSelection(Point point) {
        boolean isSelected = false;
        try {
            Base base = this.getBaseAt(point);
            if (base != null) {
                isSelected = base.isSelected();
            }
        }
        catch (InvalidAlignmentPositionException e) {
            e.printStackTrace();
        }
        return isSelected;
    }

    public void setShowTranslation(boolean showTranslation) {
        this.showTranslation = showTranslation;
    }

    public boolean isShowTranslation() {
        return this.showTranslation;
    }

    public boolean isShowTranslationOnePos() {
        return this.alignment.isTranslatedOnePos();
    }

    public JComponent getRulerComponent() {
        return this.alignmentRuler;
    }

    public JComponent getCharsetRulerComponent() {
        return this.charsetRuler;
    }

    public void setDrawAminoAcidCode(boolean drawCode) {
        this.drawAminoAcidCode = drawCode;
    }

    public boolean isDrawAminoAcidCode() {
        return this.drawAminoAcidCode;
    }

    public void setColorSchemeAminoAcid(ColorScheme aScheme) {
        this.colorSchemeAminoAcid = aScheme;
        this.createCharPixelsContainers();
    }

    public void setColorSchemeNucleotide(ColorScheme aScheme) {
        this.colorSchemeNucleotide = aScheme;
        this.createCharPixelsContainers();
    }

    public Point getVisibleUpperLeftMatrixPos() {
        Rectangle rect = this.getVisibleRect();
        Point ulPanePos = rect.getLocation();
        Point ulMatrixPos = this.paneCoordToMatrixCoord(ulPanePos);
        return ulMatrixPos;
    }

    public Point getVisibleCenterMatrixPos() {
        Rectangle rect = this.getVisibleRect();
        Point centerPanePos = new Point((int)rect.getCenterX(), (int)rect.getCenterY());
        Point centerMatrixPos = this.paneCoordToMatrixCoord(centerPanePos);
        return centerMatrixPos;
    }

    public void scrollToVisibleUpperLeftMatrixPos(Point ulPos) {
        Point ulPanePos = this.matrixCoordToPaneCoord(ulPos);
        Rectangle rect = new Rectangle(ulPanePos, this.getVisibleRect().getSize());
        rect.grow(-10, -10);
        logger.info("ulPanePos" + ulPanePos);
        logger.info("currentVisibleRect " + this.getVisibleRect());
        logger.info("Scroll to rect" + rect);
        this.setLocation(0, 0);
        this.scrollRectToVisible(rect);
        logger.info("after this.getVisibleRect()" + this.getVisibleRect());
    }

    public void scrollMatrixX(int offset) {
        int offsetPane = (int)((double)offset * this.charWidth);
        this.setLocation(this.getLocation().x + offsetPane, this.getLocation().y);
    }

    public boolean getIgnoreGapInTranslation() {
        return this.ignoreGapInTranslation;
    }

    public void setIgnoreGapInTranslation(boolean ignoreGapInTranslation) {
        this.ignoreGapInTranslation = ignoreGapInTranslation;
    }

    public void setFontCase(int fontCase) {
        this.fontCase = fontCase;
        this.createCharPixelsContainers();
    }

    public void scrollRectToSelection() {
        Rectangle selectRect = this.alignment.getSelectionAsMinRect();
        if (selectRect != null) {
            Rectangle grown1xtra = new Rectangle(selectRect.x - 1, selectRect.y - 1, selectRect.width + 3, selectRect.height + 3);
            Rectangle paneCoord = this.matrixCoordToPaneCoord(grown1xtra);
            if (!this.getVisibleRect().contains(selectRect)) {
                logger.info("not visible");
                this.scrollRectToVisible(paneCoord);
            }
        }
    }

    public void scrollRectToSelectionCenter() {
        Rectangle selectRect = this.alignment.getSelectionAsMinRect();
        if (selectRect != null) {
            Rectangle grown1xtra = new Rectangle(selectRect.x - 1, selectRect.y - 1, selectRect.width + 3, selectRect.height + 3);
            Rectangle paneCoord = this.matrixCoordToPaneCoord(grown1xtra);
            if (!this.getVisibleRect().contains(selectRect)) {
                logger.info("not visible");
                this.scrollRectToVisible(paneCoord);
            }
        }
    }

    public void scrollToPos(Point matrixPos) {
        logger.info("newMatrixPos" + matrixPos);
        Point paneCoord = this.matrixCoordToPaneCoord(matrixPos);
        Rectangle newVisible = new Rectangle(paneCoord);
        newVisible.grow(this.getVisibleRect().width / 2, this.getVisibleRect().height / 2);
        this.scrollRectToVisible(newVisible);
    }

    public boolean getShowTranslationAndNuc() {
        return this.showTranslationAndNuc;
    }

    public void setShowTranslationAndNuc(boolean b) {
        this.showTranslationAndNuc = b;
    }

    public int getDifferenceTraceSequencePosition() {
        return this.differenceTraceSequencePosition;
    }

    public boolean isHighlightDiffTrace() {
        return this.highlightDiffTrace;
    }

    private class AlignmentRuler
    extends JPanel {
        private AlignmentPane alignmentPane;

        public AlignmentRuler(AlignmentPane alignmentPane2) {
            this.alignmentPane = alignmentPane2;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintRuler(g);
        }

        public void paintRuler(Graphics g) {
            long startTime = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            Rectangle paneClip = this.alignmentPane.getVisibleRect();
            Rectangle matrixClip = AlignmentPane.this.paneCoordToMatrixCoord(paneClip);
            double charCenterXOffset = 0.9997;
            int rulerCharWidth = 11;
            Font rulerFont = new Font(this.alignmentPane.getFont().getName(), this.alignmentPane.getFont().getStyle(), rulerCharWidth);
            g2d.setFont(rulerFont);
            Rectangle rulerRect = new Rectangle(this.getVisibleRect());
            g2d.setColor(this.getBackground());
            g2d.fill(rulerRect);
            int offsetDueToScrollPanePosition = 0;
            if (AlignmentPane.this.charWidth >= 1.0) {
                offsetDueToScrollPanePosition = paneClip.x % (int)AlignmentPane.this.charWidth;
                --offsetDueToScrollPanePosition;
                int posTick = 0;
                int count = 0;
                int maxY = AlignmentPane.this.alignment.getMaxY();
                int maxX = AlignmentPane.this.alignment.getMaxX();
                int x = matrixClip.x;
                while ((double)x < matrixClip.getMaxX() + 1.0) {
                    if (maxY > 0 && x >= 0 && x < maxX) {
                        if (AlignmentPane.this.drawCodonPosOnRuler && !AlignmentPane.this.isShowTranslationOnePos()) {
                            int codonPos = AlignmentPane.this.alignment.getCodonPosAt(x);
                            Color codonPosColor = Color.GREEN;
                            if (codonPos == 0) {
                                codonPosColor = Color.LIGHT_GRAY;
                            } else if (codonPos == 1) {
                                codonPosColor = Color.GREEN;
                            } else if (codonPos == 2) {
                                codonPosColor = Color.orange;
                            } else if (codonPos == 3) {
                                codonPosColor = Color.red;
                            }
                            g2d.setColor(codonPosColor);
                            int boxHeight = 5;
                            g2d.fillRect((int)((double)posTick * charCenterXOffset * AlignmentPane.this.charWidth - (double)offsetDueToScrollPanePosition), (int)(rulerRect.getMaxY() - (double)boxHeight), (int)AlignmentPane.this.charWidth, boxHeight);
                        }
                        g2d.setColor(Color.DARK_GRAY);
                        if (x % 5 == 4 && AlignmentPane.this.charWidth > 0.6) {
                            g2d.drawLine((int)((double)posTick * charCenterXOffset * AlignmentPane.this.charWidth + AlignmentPane.this.charWidth / 2.0 - (double)offsetDueToScrollPanePosition), (int)(rulerRect.getMaxY() - 2.0), (int)((double)posTick * charCenterXOffset * AlignmentPane.this.charWidth + AlignmentPane.this.charWidth / 2.0 - (double)offsetDueToScrollPanePosition), (int)rulerRect.getMaxY() - 5);
                        } else if (AlignmentPane.this.charWidth > 4.0) {
                            g2d.drawLine((int)((double)posTick * charCenterXOffset * AlignmentPane.this.charWidth + AlignmentPane.this.charWidth / 2.0 - (double)offsetDueToScrollPanePosition), (int)(rulerRect.getMaxY() - 2.0), (int)((double)posTick * charCenterXOffset * AlignmentPane.this.charWidth + AlignmentPane.this.charWidth / 2.0 - (double)offsetDueToScrollPanePosition), (int)rulerRect.getMaxY() - 3);
                        }
                        ++posTick;
                    }
                    ++count;
                    ++x;
                }
                int drawEveryNpos = 10;
                if (AlignmentPane.this.charWidth < 4.0) {
                    drawEveryNpos = 50;
                } else if (AlignmentPane.this.charWidth < 5.0) {
                    drawEveryNpos = 20;
                }
                int lastTextEndPos = 0;
                int pos = 0;
                int x2 = matrixClip.x;
                while ((double)x2 < matrixClip.getMaxX() + 1.0) {
                    if (x2 % drawEveryNpos == 0) {
                        String posText = Integer.toString(x2);
                        int stringSizeOffset = g2d.getFontMetrics().stringWidth(posText) / 2;
                        int textPosX = (int)((double)(pos - 1) * charCenterXOffset * AlignmentPane.this.charWidth + AlignmentPane.this.charWidth / 2.0 - (double)offsetDueToScrollPanePosition) - stringSizeOffset;
                        if (lastTextEndPos < textPosX) {
                            g2d.drawString(posText, textPosX, 10);
                            lastTextEndPos = textPosX + stringSizeOffset + 40;
                        }
                    }
                    ++pos;
                    ++x2;
                }
            } else {
                double seqOffsetVisiblePanePos = matrixClip.getMinX() - 1.0;
                double posPerPix = matrixClip.getWidth() / paneClip.getWidth();
                int xStep = 10;
                if (posPerPix < 2.5) {
                    xStep = 10;
                } else {
                    xStep = 100000000;
                    for (int posPixRange = 5; posPixRange < Integer.MAX_VALUE; posPixRange *= 2) {
                        if (!(posPerPix < (double)posPixRange)) continue;
                        xStep = posPixRange * 5;
                        break;
                    }
                }
                double startPosSeq = this.roundToClosestUpper((int)seqOffsetVisiblePanePos, xStep);
                int startPosPane = (int)(AlignmentPane.this.charWidth * startPosSeq);
                int maxY = AlignmentPane.this.alignment.getMaxY();
                int maxX = AlignmentPane.this.alignment.getMaxX();
                int maxVisibleSeq = (int)matrixClip.getMaxX();
                logger.info("maxVisibleSeq" + maxVisibleSeq + 200);
                int lastTextEndPos = 0;
                int countTicks = 0;
                g2d.setColor(Color.DARK_GRAY);
                for (int xSeq = (int)startPosSeq; xSeq < maxVisibleSeq; xSeq += xStep) {
                    int tickSize;
                    int xPane = (int)((double)xSeq / posPerPix);
                    if (maxY <= 0 || xSeq < 0 || xSeq >= maxX) continue;
                    int tickPosX = xPane - paneClip.x;
                    int largerInterval = xStep * 10;
                    if (xSeq % largerInterval == 0) {
                        String posText = Integer.toString(xSeq);
                        int stringSizeOffset = g2d.getFontMetrics().stringWidth(posText) / 2;
                        int textPosX = tickPosX - stringSizeOffset;
                        if (textPosX >= 0 && lastTextEndPos < textPosX) {
                            g2d.drawString(posText, textPosX, 10);
                            lastTextEndPos = textPosX + stringSizeOffset + 40;
                        }
                        tickSize = 3;
                    } else {
                        tickSize = 1;
                    }
                    g2d.drawLine(tickPosX, (int)(rulerRect.getMaxY() - 2.0), tickPosX, (int)rulerRect.getMaxY() - 2 - tickSize);
                    ++countTicks;
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info("Ruler PaintComponent took " + (endTime - startTime) + " milliseconds");
        }

        private int roundToClosestUpper(int inval, int roundTo) {
            int rounded = (inval + roundTo - 1) / roundTo * roundTo;
            return rounded;
        }
    }

    private class CharsetRuler
    extends JPanel {
        private AlignmentPane alignmentPane;
        private Color[] charsetColors = new Color[]{new Color(107, 215, 204), new Color(239, 189, 93), new Color(215, 127, 163), new Color(210, 213, 102), new Color(127, 107, 215), new Color(203, 241, 136)};

        public CharsetRuler(AlignmentPane alignmentPane2) {
            this.alignmentPane = alignmentPane2;
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isVisible() && !AlignmentPane.this.isShowTranslationOnePos()) {
                this.paintCharsetRuler(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            logger.info("get pref size");
            if (!this.isVisible()) {
                return new Dimension(0, 0);
            }
            Dimension superSize = super.getPreferredSize();
            int preferredHeight = this.calculatePreferredHeight();
            return new Dimension(superSize.width, preferredHeight);
        }

        private int calculatePreferredHeight() {
            int maxCharsetOverlapCount = AlignmentPane.this.alignment.getAlignmentMeta().getCharsets().getMaxOverlapCount();
            int preferredHeight = AlignmentPane.this.CHARSET_LINE_HEIGHT * (maxCharsetOverlapCount + 1);
            return preferredHeight;
        }

        public void paintCharsetRuler(Graphics g) {
            long startTime = System.currentTimeMillis();
            Graphics2D g2d = (Graphics2D)g;
            Rectangle paneClip = this.alignmentPane.getVisibleRect();
            Rectangle matrixClip = AlignmentPane.this.paneCoordToMatrixCoord(paneClip);
            Rectangle rulerRect = new Rectangle(this.getVisibleRect());
            g2d.setColor(AlignmentPane.this.colorSchemeNucleotide.getBaseBackgroundColor(0));
            g2d.fill(rulerRect);
            int offsetDueToScrollPanePosition = paneClip.x;
            CharSets charsets = AlignmentPane.this.alignment.getAlignmentMeta().getCharsets();
            int maxCharsetOverlapCount = charsets.getMaxOverlapCount();
            logger.info("maxCharsetOverlapCount" + maxCharsetOverlapCount);
            int maxX = Math.min(AlignmentPane.this.alignment.getMaxX(), (int)matrixClip.getMaxX());
            int minX = (int)matrixClip.getMinX();
            int colorIndex = 0;
            int charsetIndex = 0;
            for (CharSet charSet : charsets) {
                if (charSet.intersects(minX, maxX)) {
                    logger.info("intersects" + charSet.getName());
                    int lineHeight = AlignmentPane.this.CHARSET_LINE_HEIGHT;
                    int charsetLineYPos = charsetIndex % (maxCharsetOverlapCount + 1) * lineHeight;
                    logger.info("charsetLineYPos" + charsetLineYPos);
                    int charSetMinX = charSet.getMinimumStartPos();
                    int charSetMaxX = charSet.getMaximumEndPos();
                    Point charSetMinXPanePos = this.alignmentPane.matrixCoordToPaneCoord(new Point(charSetMinX, 0));
                    Point charSetMaxXPanePos = this.alignmentPane.matrixCoordToPaneCoord(new Point(charSetMaxX, 0));
                    int width = charSetMaxXPanePos.x - charSetMinXPanePos.x + (int)(1.0 * AlignmentPane.this.charWidth);
                    Rectangle charsetRect = new Rectangle(charSetMinXPanePos.x - offsetDueToScrollPanePosition, charsetLineYPos, width, lineHeight);
                    Color charsetColor = this.charsetColors[colorIndex % this.charsetColors.length];
                    g2d.setColor(charsetColor);
                    g2d.fill(charsetRect);
                }
                ++charsetIndex;
                ++colorIndex;
            }
            long endTime = System.currentTimeMillis();
            logger.info("CharsetRuler PaintComponent took " + (endTime - startTime) + " milliseconds");
        }

        private int roundToClosestUpper(int inval, int roundTo) {
            int rounded = (inval + roundTo - 1) / roundTo * roundTo;
            return rounded;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            logger.info("ToolTipLoc:" + event.getPoint());
            Rectangle paneClip = this.alignmentPane.getVisibleRect();
            int offsetDueToScrollPanePosition = paneClip.x;
            int xPosPane = offsetDueToScrollPanePosition + event.getPoint().x;
            Point posMatrix = AlignmentPane.this.paneCoordToMatrixCoord(new Point(xPosPane, 0));
            String toolTip = "<html>";
            CharSets charsets = AlignmentPane.this.alignment.getAlignmentMeta().getCharsets();
            for (CharSet charSet : charsets) {
                if (!charSet.contains(posMatrix.x)) continue;
                toolTip = toolTip + charSet.getName() + "<br>";
            }
            toolTip = toolTip + "</html>";
            return toolTip;
        }
    }
}

