/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.color.ColorUtils;
import aliview.gui.pane.RGBArray;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public class ImageUtils {
    private static final Logger logger = Logger.getLogger(ImageUtils.class);

    public static void insertRGBArrayAt(int targetX, int targetY, RGBArray newPiece, RGBArray origPiece) throws Exception {
        try {
            int offset = targetY * origPiece.getScanWidth() + targetX;
            int counter = 0;
            for (int scanCount = 0; scanCount < newPiece.getHeight(); ++scanCount) {
                for (int n = 0; n < newPiece.getScanWidth(); ++n) {
                    int posOrig = offset + scanCount * origPiece.getScanWidth() + n;
                    int posNewPiece = scanCount * newPiece.getScanWidth() + n;
                    origPiece.backend[posOrig] = newPiece.backend[posNewPiece];
                    ++counter;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static void darkerRGBArrayColumn(RGBArray clipRGB, int colPos) {
        for (int posInArray = colPos; posInArray < clipRGB.getLength(); posInArray += clipRGB.getScanWidth()) {
            int colVal = clipRGB.getBackend()[posInArray];
            clipRGB.getBackend()[posInArray] = ColorUtils.darkerRGB(colVal);
        }
    }
}

