/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.alignment.Alignment;
import aliview.gui.pane.AlignmentPane;
import aliview.gui.pane.RGBArray;
import aliview.sequences.Sequence;
import org.apache.log4j.Logger;

public abstract class SequencePainter
implements Runnable {
    private static final Logger logger = Logger.getLogger(SequencePainter.class);
    private Sequence seq;
    private int seqYPos;
    private int clipPosY;
    private int xMinSeqPos;
    private int xMaxSeqPos;
    private double seqPerPix;
    private double charWidth;
    private double charHeight;
    private double highDPIScaleFactor;
    private RGBArray clipRGB;
    private AlignmentPane aliPane;
    private Alignment alignment;

    public SequencePainter(Sequence seq, int seqYPos, int clipPosY, int xMinSeqPos, int xMaxSeqPos, double seqPerPix, double charWidth, double charHeight, double highDPIScaleFactor, RGBArray clipRGB, AlignmentPane aliPane, Alignment alignment) {
        this.seq = seq;
        this.seqYPos = seqYPos;
        this.clipPosY = clipPosY;
        this.xMinSeqPos = xMinSeqPos;
        this.xMaxSeqPos = xMaxSeqPos;
        this.seqPerPix = seqPerPix;
        this.charWidth = charWidth;
        this.charHeight = charHeight;
        this.highDPIScaleFactor = highDPIScaleFactor;
        this.clipRGB = clipRGB;
        this.aliPane = aliPane;
        this.alignment = alignment;
    }

    @Override
    public void run() {
        if (this.seq != null) {
            this.drawSequence(this.seq, this.seqYPos, this.clipPosY, this.xMinSeqPos, this.xMaxSeqPos, this.seqPerPix, this.charWidth, this.charHeight, this.highDPIScaleFactor, this.clipRGB, this.aliPane, this.alignment);
        }
    }

    public void drawSequence(Sequence seq, int seqYPos, int clipPosY, int xMin, int xMax, double seqPerPix, double charWidth, double charHeight, double highDPIScaleFactor, RGBArray clipRGB, AlignmentPane aliPane, Alignment alignment) {
        int seqLength = seq.getLength();
        int clipPosX = 0;
        for (int x = xMin; x < xMax && x >= 0; ++x) {
            int seqXPos = (int)((double)x * seqPerPix);
            if (seqXPos >= 0 && seqXPos < seqLength) {
                int pixelPosX = (int)((double)clipPosX * charWidth * highDPIScaleFactor);
                int pixelPosY = (int)((double)clipPosY * charHeight * highDPIScaleFactor);
                if (pixelPosX < clipRGB.getScanWidth() && pixelPosY < clipRGB.getHeight()) {
                    this.copyPixels(seq, clipRGB, seqXPos, seqYPos, pixelPosX, pixelPosY, aliPane, alignment);
                }
            }
            ++clipPosX;
        }
    }

    abstract void copyPixels(Sequence var1, RGBArray var2, int var3, int var4, int var5, int var6, AlignmentPane var7, Alignment var8);
}

