/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.AminoAcid;
import aliview.alignment.Alignment;
import aliview.gui.pane.AACharPixelsContainer;
import aliview.gui.pane.AlignmentPane;
import aliview.gui.pane.ImageUtils;
import aliview.gui.pane.RGBArray;
import aliview.gui.pane.SequencePainter;
import aliview.sequences.Sequence;
import org.apache.log4j.Logger;

public class SequencePainterAminoAcid
extends SequencePainter {
    private static final Logger logger = Logger.getLogger(SequencePainterAminoAcid.class);

    public SequencePainterAminoAcid(Sequence seq, int seqYPos, int clipPosY, int xMinSeqPos, int xMaxSeqPos, double seqPerPix, double charWidth, double charHeight, double highDPIScaleFactor, RGBArray clipRGB, AlignmentPane aliPane, Alignment alignment) {
        super(seq, seqYPos, clipPosY, xMinSeqPos, xMaxSeqPos, seqPerPix, charWidth, charHeight, highDPIScaleFactor, clipRGB, aliPane, alignment);
    }

    @Override
    protected void copyPixels(Sequence seq, RGBArray clipRGB, int seqXPos, int seqYPos, int pixelPosX, int pixelPosY, AlignmentPane aliPane, Alignment alignment) {
        byte residue = seq.getBaseAtPos(seqXPos);
        if (residue == 0) {
            residue = 32;
        }
        AACharPixelsContainer pixContainerToUse = aliPane.charPixDefaultAA;
        byte byteToDraw = residue;
        AminoAcid acid = AminoAcid.getAminoAcidFromByte(residue);
        if (aliPane.isHighlightDiffTrace() && seqYPos != aliPane.getDifferenceTraceSequencePosition() && acid == AminoAcid.getAminoAcidFromByte(alignment.getBaseAt(seqXPos, aliPane.getDifferenceTraceSequencePosition()))) {
            byteToDraw = 46;
            pixContainerToUse = aliPane.charPixDefaultAA;
        }
        if (aliPane.isHighlightNonCons() && acid != AminoAcid.GAP && alignment.getHistogram().isMajorityRuleConsensus(seqXPos, acid.intVal)) {
            pixContainerToUse = aliPane.charPixConsensusAA;
        }
        if (aliPane.isHighlightCons() && acid != AminoAcid.GAP && !alignment.getHistogram().isMajorityRuleConsensus(seqXPos, acid.intVal)) {
            pixContainerToUse = aliPane.charPixConsensusAA;
        }
        boolean isPointWithinSelectionRect = false;
        if (alignment.getTempSelection() != null && (double)seqXPos <= alignment.getTempSelection().getMaxX() && (double)seqXPos >= alignment.getTempSelection().getMinX() && (double)seqYPos <= alignment.getTempSelection().getMaxY() && (double)seqYPos >= alignment.getTempSelection().getMinY()) {
            isPointWithinSelectionRect = true;
        }
        if (seq.isBaseSelected(seqXPos) || alignment.getTempSelection() != null && isPointWithinSelectionRect) {
            pixContainerToUse = aliPane.charPixSelectedAA;
        }
        RGBArray newPiece = pixContainerToUse.getRGBArray(byteToDraw, seqXPos, alignment);
        try {
            ImageUtils.insertRGBArrayAt(pixelPosX, pixelPosY, newPiece, clipRGB);
        }
        catch (Exception e) {
            logger.info("clipX" + pixelPosX);
            logger.info("clipY" + pixelPosY);
            logger.info("clipRGB.getHeight()" + clipRGB.getHeight());
            logger.info("clipRGB.getWidth()" + clipRGB.getScanWidth());
        }
    }
}

