/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui.pane;

import aliview.AminoAcid;
import aliview.alignment.Alignment;
import aliview.gui.pane.AlignmentPane;
import aliview.gui.pane.ImageUtils;
import aliview.gui.pane.RGBArray;
import aliview.gui.pane.SequencePainter;
import aliview.gui.pane.TranslationCharPixelsContainer;
import aliview.sequences.Sequence;
import org.apache.log4j.Logger;

public class SequencePainterNucleotideTranslatedShowNucAndAcid
extends SequencePainter {
    private static final Logger logger = Logger.getLogger(SequencePainterNucleotideTranslatedShowNucAndAcid.class);

    public SequencePainterNucleotideTranslatedShowNucAndAcid(Sequence seq, int seqYPos, int clipPosY, int xMinSeqPos, int xMaxSeqPos, double seqPerPix, double charWidth, double charHeight, double highDPIScaleFactor, RGBArray clipRGB, AlignmentPane aliPane, Alignment alignment) {
        super(seq, seqYPos, clipPosY, xMinSeqPos, xMaxSeqPos, seqPerPix, charWidth, charHeight, highDPIScaleFactor, clipRGB, aliPane, alignment);
    }

    @Override
    protected void copyPixels(Sequence seq, RGBArray clipArray, int seqXPos, int seqYPos, int pixelPosX, int pixelPosY, AlignmentPane aliPane, Alignment alignment) {
        byte residue = seq.getBaseAtPos(seqXPos);
        AminoAcid acid = seq.getTranslatedAminoAcidAtNucleotidePos(seqXPos);
        if (residue == 0) {
            residue = 32;
        }
        boolean isPointWithinSelectionRect = false;
        if (alignment.getTempSelection() != null && (double)seqXPos <= alignment.getTempSelection().getMaxX() && (double)seqXPos >= alignment.getTempSelection().getMinX() && (double)seqYPos <= alignment.getTempSelection().getMaxY() && (double)seqYPos >= alignment.getTempSelection().getMinY()) {
            isPointWithinSelectionRect = true;
        }
        boolean isSelected = false;
        if (seq.isBaseSelected(seqXPos) || alignment.getTempSelection() != null && isPointWithinSelectionRect) {
            isSelected = true;
        }
        boolean isSecondPos = false;
        if (seq.isCodonSecondPos(seqXPos)) {
            isSecondPos = true;
        }
        TranslationCharPixelsContainer pixContainerToUse = aliPane.charPixTranslationAndNucDefault;
        pixContainerToUse = !aliPane.isDrawAminoAcidCode() ? (isSecondPos ? (isSelected ? aliPane.charPixTranslationAndNucSelected : aliPane.charPixTranslationAndNucDefault) : (isSelected ? aliPane.charPixTranslationAndNucSelectedNoAALetter : aliPane.charPixTranslationAndNucDefaultNoAALetter)) : (isSecondPos ? (isSelected ? aliPane.charPixTranslationAndNucDominantNucSelected : aliPane.charPixTranslationAndNucDominantNuc) : (isSelected ? aliPane.charPixTranslationAndNucDominantNucNoAALetterSelected : aliPane.charPixTranslationAndNucDominantNucNoAALetter));
        RGBArray newPiece = pixContainerToUse.getRGBArray(acid, residue);
        try {
            ImageUtils.insertRGBArrayAt(pixelPosX, pixelPosY, newPiece, clipArray);
        }
        catch (Exception e) {
            logger.info("clipX" + pixelPosX);
            logger.info("clipY" + pixelPosY);
        }
    }
}

