/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ByteBufferAutogrow {
    private static final Logger logger = Logger.getLogger(ByteBufferAutogrow.class);
    private ByteBuffer backend;
    private double ALLOCATE_MULTIPLIER = 1.5;
    private double ALLOCATE_MULTIPLIER_AFTER_100MB = 1.1;
    private double MB = 1000000.0;
    private boolean DIRECT_BUFF = false;

    public ByteBufferAutogrow(int initialCapacity) {
        this.backend = this.DIRECT_BUFF ? ByteBuffer.allocateDirect(initialCapacity) : ByteBuffer.allocate(initialCapacity);
    }

    public void append(String more) {
        if (more == null || more.length() == 0) {
            return;
        }
        byte[] moreBytes = more.getBytes();
        if (this.backend.remaining() < moreBytes.length) {
            int exactSize = this.backend.position() + moreBytes.length;
            double multiplier = this.ALLOCATE_MULTIPLIER;
            if ((double)exactSize > 100.0 * this.MB) {
                multiplier = this.ALLOCATE_MULTIPLIER_AFTER_100MB;
            }
            int newCapacity = (int)((double)exactSize * multiplier);
            logger.info("newCap=" + newCapacity);
            this.reallocate(newCapacity);
        }
        this.backend.put(moreBytes);
    }

    public void ensureCapacity(int requestCapacity) {
        if (requestCapacity > this.backend.limit()) {
            this.reallocate(requestCapacity);
        }
    }

    public void clear() {
        this.backend.clear();
    }

    private void reallocate(int newCapacity) {
        int oldPosition = this.backend.position();
        if (this.backend.hasArray()) {
            byte[] newBuffer = new byte[newCapacity];
            System.arraycopy(this.backend.array(), 0, newBuffer, 0, this.backend.position());
            this.backend = ByteBuffer.wrap(newBuffer);
            this.backend.position(oldPosition);
        } else {
            ByteBuffer newOne = ByteBuffer.allocateDirect(newCapacity);
            int endPos = this.backend.position();
            for (int n = 0; n < endPos; ++n) {
                newOne.put(this.backend.get(n));
            }
            this.backend.clear();
            this.backend = newOne;
        }
    }

    public byte[] getBytes() {
        if (this.backend.hasArray()) {
            return Arrays.copyOfRange(this.backend.array(), 0, this.backend.position());
        }
        int length = this.backend.position();
        byte[] retVal = new byte[length];
        for (int n = 0; n < retVal.length; ++n) {
            retVal[n] = this.backend.get(n);
        }
        return retVal;
    }

    public String toString() {
        return new String(this.getBytes());
    }

    public int position() {
        return this.backend.position();
    }
}

