/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.FileFormat;
import aliview.importer.MappedBuffReaderHelper;
import aliview.sequencelist.FileSequenceAlignmentListModel;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.ClustalFileSequence;
import aliview.sequences.PositionToPointer;
import aliview.sequences.Sequence;
import aliview.subprocesses.SubThreadProgressWindow;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClustalFileIndexer {
    private static final Logger logger = Logger.getLogger(ClustalFileIndexer.class);
    private static final String LF = System.getProperty("line.separator");
    public static int INTERLEAVED_OR_SINGLELINE_SEQUENTIAL = 0;

    public static void main(String[] args) throws AlignmentImportException, IOException {
        File alignmentFile = new File("/home/anders/projekt/alignments/testseq1.aln");
        FileSequenceAlignmentListModel model = new FileSequenceAlignmentListModel(alignmentFile, FileFormat.CLUSTAL);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<Sequence> findSequencesInFile(MemoryMappedSequencesFile sequencesFile, long filePointerStart, int seqOffset, int nSeqsToRetrieve, SubThreadProgressWindow progressWin) throws AlignmentImportException {
        block10: {
            startTime = System.currentTimeMillis();
            mappedBuff = sequencesFile.getMappedBuff();
            sequences = new ArrayList<Sequence>();
            try {
                fileSize = mappedBuff.length();
                longestSequenceLength = false;
                mappedBuff.position(filePointerStart);
                readerHelper = new MappedBuffReaderHelper(mappedBuff);
                firstLine = readerHelper.readLine();
                newlineLen = 1;
                newlineLen = firstLine.endsWith("\r\n") != false ? 2 : 1;
                isRightFormat = ClustalFileIndexer.isStringValidFirstLine(firstLine);
                if (!isRightFormat) {
                    throw new AlignmentImportException("Could not read first line as clustal format");
                }
                ClustalFileIndexer.logger.info("inside clustal importer");
                formatType = ClustalFileIndexer.INTERLEAVED_OR_SINGLELINE_SEQUENTIAL;
                if (formatType != ClustalFileIndexer.INTERLEAVED_OR_SINGLELINE_SEQUENTIAL) break block10;
                try {
                    seqNames = new ArrayList<E>();
                    seqBuffers = new ArrayList<E>();
                    readerHelper.skipUntilNextNonWhiteCharInFirstPosAfterNewLine();
                    nameStartPointer = readerHelper.position();
                    readerHelper.setPosition(nameStartPointer);
                    lineCount = 0;
                    seqCount = 0;
                    seqPos = 0;
                    do {
                        readerHelper.setPosition(nameStartPointer);
                        seqStartPointer = readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                        seqEndPointer = readerHelper.posOfNextWhitespaceOrLF() - 1L;
                        seq = new ClustalFileSequence(sequencesFile, nameStartPointer);
                        name = readerHelper.readString(nameStartPointer, seqStartPointer - 1L);
                        name = name.trim();
                        seq.setName(name);
                        seqSeqmentLen = (int)(seqEndPointer - seqStartPointer + 1L);
                        seq.add(new PositionToPointer(seqPos, seqPos + seqSeqmentLen - 1, seqStartPointer, seqEndPointer));
                        sequences.add(seq);
                        ++seqCount;
                        if (++lineCount % 100000 == 0) {
                            progressWin.setMessage("Indexing interleaved Phylip file" + ClustalFileIndexer.LF + "line:" + lineCount);
                            if (progressWin.wasSubThreadInterruptedByUser()) break;
                        }
                        linebreaks = readerHelper.skipUntilNextNonWhiteCharInFirstPosAfterNewLine();
                        nameStartPointer = readerHelper.position();
                    } while (linebreaks <= 1);
                    block5: while (true) {
                        n = 0;
                        while (true) {
                            if (n >= seqCount) continue block5;
                            readerHelper.setPosition(nameStartPointer);
                            interleavedStartPointer = readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                            interleavedEndPointer = readerHelper.posOfNextWhitespaceOrLF() - 1L;
                            mappedBuff.position(interleavedEndPointer);
                            seqSeqmentLen = (int)(interleavedEndPointer - interleavedStartPointer + 1L);
                            appendSeq = (ClustalFileSequence)sequences.get(n);
                            appendSeqPosition = appendSeq.getLength();
                            appendSeq.add(new PositionToPointer(appendSeqPosition, interleavedStartPointer, interleavedEndPointer));
                            linebreaks = readerHelper.skipUntilNextNonWhiteCharInFirstPosAfterNewLine();
                            nameStartPointer = readerHelper.position();
                            if (++lineCount % 100000 == 0) {
                                progressWin.setMessage("Indexing interleaved Phylip file" + ClustalFileIndexer.LF + "line:" + lineCount);
                                if (progressWin.wasSubThreadInterruptedByUser()) continue block5;
                            }
                            if (linebreaks <= 1) ** break;
                            continue block5;
                            ++n;
                        }
                        break;
                    }
                }
                catch (EOFException eof) {
                    ClustalFileIndexer.logger.info("hit EOF hopefully file is read OK");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public static boolean isStringValidFirstLine(String firstLine) {
        return StringUtils.containsIgnoreCase(firstLine, "CLUSTAL");
    }
}

