/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.MemoryUtils;
import aliview.importer.AlignmentImportException;
import aliview.importer.ByteBufferAutogrow;
import aliview.importer.ReaderHelper;
import aliview.sequences.ClustalSequence;
import aliview.sequences.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClustalImporter {
    private static final Logger logger = Logger.getLogger(ClustalImporter.class);
    private Reader reader;
    public static final int UNKNOWN = -1;
    public static int INTERLEAVED_OR_SINGLELINE_SEQUENTIAL = 0;
    public int formatType;
    private long fileSize;

    public static void main(String[] args) throws FileNotFoundException, AlignmentImportException {
        File alignmentFile = new File("/home/anders/projekt/alignments/testseq1.aln");
        ClustalImporter importer = new ClustalImporter(new FileReader(alignmentFile), INTERLEAVED_OR_SINGLELINE_SEQUENTIAL);
        importer.importSequences();
    }

    public ClustalImporter(Reader reader, int formatType, long fileSize) {
        this.reader = reader;
        this.formatType = formatType;
        this.fileSize = fileSize;
    }

    public ClustalImporter(Reader reader, long fileSize) {
        this(reader, INTERLEAVED_OR_SINGLELINE_SEQUENTIAL, fileSize);
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            String sequenceString = "";
            BufferedReader r = new BufferedReader(this.reader);
            ReaderHelper helper = new ReaderHelper(r);
            helper.readNextLine();
            String firstLine = helper.getNextLine();
            firstLine = firstLine.trim();
            boolean isRightFormat = ClustalImporter.isStringValidFirstLine(firstLine);
            if (!isRightFormat) {
                throw new AlignmentImportException("Could not read first line as clustal format");
            }
            logger.info("inside clustal importer");
            if (this.formatType == INTERLEAVED_OR_SINGLELINE_SEQUENTIAL) {
                ArrayList<String> seqNames = new ArrayList<String>();
                ArrayList<Object> seqBuffers = new ArrayList<Object>();
                helper.readUntilNextNonBlankLine();
                int seqCount = 0;
                int longestName = 0;
                int seqPartLen = 0;
                while (helper.isNextLineStartingWithNonBlankChar()) {
                    String seqChars;
                    String line = helper.getNextLine();
                    int index = ReaderHelper.indexOfFirstNonWhiteCharAfterWhiteChar(line);
                    String name = line.substring(0, index).trim();
                    seqNames.add(name);
                    longestName = Math.max(longestName, name.length());
                    int endIndex = line.indexOf(32, index);
                    if (endIndex == -1) {
                        endIndex = line.length();
                    }
                    if ((seqChars = line.substring(index, endIndex)).indexOf(32) > -1) {
                        seqChars = StringUtils.remove(seqChars, ' ');
                    }
                    seqPartLen = Math.max(seqPartLen, seqChars.length());
                    int capacity = 1000;
                    ByteBufferAutogrow seqBuff = new ByteBufferAutogrow(capacity);
                    seqBuff.append(seqChars);
                    seqBuffers.add(seqBuff);
                    ++seqCount;
                    helper.readNextLine();
                }
                helper.readUntilNextNonBlankLine();
                int interleaveSize = (longestName + seqPartLen) * seqCount;
                long nInterleaves = this.fileSize / (long)interleaveSize;
                long guessedLength = nInterleaves * (long)seqPartLen;
                int guessedCapacity = (int)((double)guessedLength * 1.05);
                logger.info("guessedCapacity" + guessedCapacity);
                MemoryUtils.logMem();
                for (ByteBufferAutogrow byteBufferAutogrow : seqBuffers) {
                    byteBufferAutogrow.ensureCapacity(guessedCapacity);
                }
                MemoryUtils.logMem();
                logger.info("seqCount * guessedCapacity=" + seqCount * guessedCapacity);
                while (helper.isNextLineStartingWithNonBlankChar()) {
                    for (int lineCount = 0; lineCount < seqCount && helper.isNextLineStartingWithNonBlankChar(); ++lineCount) {
                        String moreChars;
                        String string = helper.getNextLine();
                        int seqStart = ReaderHelper.indexOfFirstNonWhiteCharAfterWhiteChar(string);
                        int endIndex = string.indexOf(32, seqStart);
                        if (endIndex == -1) {
                            endIndex = string.length();
                        }
                        if ((moreChars = string.substring(seqStart, endIndex)).indexOf(32) > -1) {
                            moreChars = StringUtils.remove(moreChars, ' ');
                        }
                        ByteBufferAutogrow seqBuff = (ByteBufferAutogrow)seqBuffers.get(lineCount);
                        seqBuff.append(moreChars);
                        helper.readNextLine();
                    }
                    helper.readUntilNextNonBlankLine();
                }
                logger.info("before convert");
                for (int n = 0; n < seqCount; ++n) {
                    sequences.add(new ClustalSequence((String)seqNames.get(n), ((ByteBufferAutogrow)seqBuffers.get(n)).getBytes()));
                    seqNames.set(n, null);
                    seqBuffers.set(n, null);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public static boolean isStringValidFirstLine(String firstLine) {
        return StringUtils.containsIgnoreCase(firstLine, "CLUSTAL");
    }
}

