/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.MemoryUtils;
import aliview.importer.AlignmentImportException;
import aliview.importer.ByteBufferAutogrow;
import aliview.importer.FileImportUtils;
import aliview.sequences.FastFastaSequence;
import aliview.sequences.Sequence;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FastFastaImporter {
    private static final Logger logger = Logger.getLogger(FastFastaImporter.class);
    private Reader reader;
    private int longestSequenceLength;

    public FastFastaImporter(Reader reader) {
        this.reader = reader;
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        int nextSeqEstSize = 5000;
        double maxMem = MemoryUtils.getMaxMem();
        try {
            byte[] bytes;
            String line;
            StringBuilder sequence = new StringBuilder(nextSeqEstSize);
            BufferedReader r = new BufferedReader(this.reader);
            String name = null;
            int nLine = 0;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                if (nLine == 0 && line.length() > 0 && line.charAt(0) != '>') {
                    throw new AlignmentImportException("Fasta file should start with > character");
                }
                if (line.length() > 0) {
                    if (line.charAt(0) == '>') {
                        if (name != null && name.length() > 0) {
                            if (sequence.indexOf(" ") > -1) {
                                sequence = FileImportUtils.removeAll(sequence, " ");
                            }
                            bytes = this.getBytesFromBuffer(sequence);
                            sequences.add(new FastFastaSequence(name, bytes));
                            this.longestSequenceLength = Math.max(this.longestSequenceLength, sequence.length());
                            sequence = new StringBuilder(nextSeqEstSize + 10);
                            name = null;
                        }
                        name = line.substring(1);
                    } else {
                        sequence.append(line);
                    }
                    if ((double)sequence.length() > maxMem / 8.0) {
                        throw new AlignmentImportException("Sequence to long for memory");
                    }
                }
                ++nLine;
            }
            if (name != null && name.length() > 0) {
                if (sequence.indexOf(" ") > -1) {
                    sequence = FileImportUtils.removeAll(sequence, " ");
                }
                bytes = this.getBytesFromBuffer(sequence);
                sequences.add(new FastFastaSequence(name, bytes));
                this.longestSequenceLength = Math.max(this.longestSequenceLength, sequence.length());
            }
        }
        catch (Exception e) {
            logger.error(e);
            throw new AlignmentImportException("could not import as fasta file because: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public List<Sequence> importSequencesBB() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        int nextSeqEstSize = 5000;
        try {
            byte[] bytes;
            String line;
            ByteBufferAutogrow seqBuff = new ByteBufferAutogrow(nextSeqEstSize);
            BufferedReader r = new BufferedReader(this.reader);
            String name = null;
            int nLine = 0;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                if (nLine == 0 && line.length() > 0 && line.charAt(0) != '>') {
                    throw new AlignmentImportException("Fasta file should start with > character");
                }
                if (line.length() > 0) {
                    if (line.charAt(0) == '>') {
                        if (name != null && name.length() > 0) {
                            bytes = seqBuff.getBytes();
                            sequences.add(new FastFastaSequence(name, bytes));
                            this.longestSequenceLength = Math.max(this.longestSequenceLength, seqBuff.position());
                            seqBuff.ensureCapacity(this.longestSequenceLength);
                            seqBuff.clear();
                            name = null;
                        }
                        name = line.substring(1);
                    } else {
                        line = FileImportUtils.removeAll(line, ' ');
                        seqBuff.append(line);
                    }
                }
                ++nLine;
            }
            if (name != null && name.length() > 0) {
                line = FileImportUtils.removeAll(line, ' ');
                bytes = seqBuff.getBytes();
                sequences.add(new FastFastaSequence(name, bytes));
                this.longestSequenceLength = Math.max(this.longestSequenceLength, seqBuff.position());
            }
        }
        catch (Exception e) {
            logger.error(e);
            throw new AlignmentImportException("could not import as fasta file because: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    private boolean bufferContains(StringBuilder sequence, char target) {
        for (int n = 0; n < sequence.length(); ++n) {
            if (sequence.charAt(n) != target) continue;
            return true;
        }
        return false;
    }

    private byte[] getBytesFromBuffer(StringBuilder sequence) {
        byte[] bytes = new byte[sequence.length()];
        for (int n = 0; n < bytes.length; ++n) {
            bytes[n] = (byte)sequence.charAt(n);
        }
        return bytes;
    }

    public int getLongestSequenceLength() {
        return this.longestSequenceLength;
    }
}

