/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.ClustalImporter;
import aliview.importer.MSFImporter;
import aliview.importer.PhylipImporter;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bitbucket.kienerj.io.OptimizedRandomAccessFile;
import utils.OSNativeUtils;

public class FileFormat {
    private static final Logger logger = Logger.getLogger(FileFormat.class);
    private String name;
    private String suffix;
    private String suffixWin;
    public static final FileFormat UNKNOWN = new FileFormat("Unknown", "", "");
    public static final FileFormat FILE_FASTA = new FileFormat("Fasta", "fasta", "fas");
    public static final FileFormat FASTA = new FileFormat("Fasta", "fasta", "fas");
    public static final FileFormat FASTQ = new FileFormat("FastQ", "fastq", "fq");
    public static final FileFormat NEXUS = new FileFormat("Nexus", "nexus", "nex");
    public static final FileFormat NEXUS_CODONPOS_CHARSET = new FileFormat("NexusCodonposCharset", "codonpos.nexus", "codonpos.nex");
    public static final FileFormat NEXUS_SIMPLE = new FileFormat("NexusSimple", "nexus", "nex");
    public static final FileFormat PHYLIP = new FileFormat("Phylip", "phy", "phy");
    public static final FileFormat PHYLIP_RELAXED = new FileFormat("Phylip", "phy", "phy");
    public static final FileFormat PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL = new FileFormat("Phylip", "phy", "phy");
    public static final FileFormat PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED = new FileFormat("Phylip", "phy", "phy");
    public static final FileFormat PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL = new FileFormat("Phylip", "phy", "phy");
    public static final FileFormat PHYLIP_SHORT_NAME_INTERLEAVED = new FileFormat("Phylip", "phy", "phy");
    public static final FileFormat MSF = new FileFormat("MSF", "msf", "msf");
    public static final FileFormat CLUSTAL = new FileFormat("Clustal", "aln", "aln");
    public static final FileFormat IMAGE_PNG = new FileFormat("png-image", "png", "png");
    public static final FileFormat PHYLIP_TRANSLATED_AMINO_ACID = new FileFormat("PhylipAminoAcid", "translated.phy", "translated.phy");
    public static final FileFormat NEXUS_TRANSLATED_AMINO_ACID = new FileFormat("NexusTranslated", "translated.nexus", "translated.nex");
    public static final FileFormat FASTA_TRANSLATED_AMINO_ACID = new FileFormat("FastaTranslated", "translated.fasta", "translated.fas");

    public static void main(String[] args) {
    }

    public FileFormat(String name, String suffix, String suffixWin) {
        this.name = name;
        this.suffix = suffix;
        this.suffixWin = suffixWin;
    }

    public static final String stripFileSuffixFromName(String name) {
        String strippedName = StringUtils.substringBeforeLast(name, ".");
        return strippedName;
    }

    public String getSuffix() {
        if (OSNativeUtils.isWindows()) {
            return this.suffixWin;
        }
        return this.suffix;
    }

    public String toString() {
        return this.name;
    }

    public static boolean isThisFasta(String seq) {
        boolean isFasta = false;
        if (seq != null && seq.startsWith(">")) {
            isFasta = true;
        }
        return isFasta;
    }

    public static FileFormat isFileOfAlignmentFormat(File seqFile) {
        if (seqFile == null || !seqFile.exists()) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        FileFormat foundFormat = null;
        try {
            StringBuilder sequence = new StringBuilder();
            OptimizedRandomAccessFile raf = new OptimizedRandomAccessFile(seqFile, "r");
            String line = "";
            Object name = null;
            boolean nLine = false;
            long nSeqCount = 0L;
            byte[] buffer = new byte[200];
            if (raf.read(buffer) > 0) {
                String filestart = new String(buffer);
                filestart = StringUtils.trim(filestart);
                String[] splitted = filestart.split("\n");
                String firstLine = splitted[0];
                logger.info("firstLine" + firstLine);
                if (firstLine.startsWith(">")) {
                    foundFormat = FASTA;
                } else if (firstLine.startsWith("@")) {
                    foundFormat = FASTQ;
                } else if (StringUtils.containsIgnoreCase(firstLine, "NEXUS")) {
                    foundFormat = NEXUS;
                } else if (ClustalImporter.isStringValidFirstLine(firstLine)) {
                    foundFormat = CLUSTAL;
                } else if (MSFImporter.isStringValidFirstLine(firstLine)) {
                    foundFormat = MSF;
                } else if (PhylipImporter.isStringValidFirstLine(firstLine)) {
                    foundFormat = PHYLIP;
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info("check fileformat took " + (endTime - startTime) + " milliseconds, found:" + foundFormat);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return foundFormat;
    }

    public static boolean isThisSequenceFile(String fileName) {
        File testFile;
        FileFormat format;
        boolean isSequenceFile = false;
        if (fileName != null && (format = FileFormat.isFileOfAlignmentFormat(testFile = new File(fileName))) != null) {
            isSequenceFile = true;
        }
        return isSequenceFile;
    }
}

