/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.FileFormat;
import aliview.importer.MappedBuffReaderHelper;
import aliview.sequencelist.FileSequenceAlignmentListModel;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.MSFFileSequence;
import aliview.sequences.PositionToPointer;
import aliview.sequences.Sequence;
import aliview.subprocesses.SubThreadProgressWindow;
import it.unimi.dsi.io.ByteBufferInpStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MSFFileIndexer {
    private static final Logger logger = Logger.getLogger(MSFFileIndexer.class);
    private static final String LF = System.getProperty("line.separator");
    public static int INTERLEAVED_OR_SINGLELINE_SEQUENTIAL = 0;

    public static void main(String[] args) throws AlignmentImportException, IOException {
        File alignmentFile = new File("/home/anders/projekt/alignments/MSF_format.example.msf");
        FileSequenceAlignmentListModel model = new FileSequenceAlignmentListModel(alignmentFile, FileFormat.MSF);
    }

    public ArrayList<Sequence> findSequencesInFile(MemoryMappedSequencesFile sequencesFile, long filePointerStart, int seqOffset, int nSeqsToRetrieve, SubThreadProgressWindow progressWin) throws AlignmentImportException {
        ArrayList<Sequence> sequences;
        long startTime;
        block11: {
            startTime = System.currentTimeMillis();
            logger.info("inside MSF importer");
            ByteBufferInpStream mappedBuff = sequencesFile.getMappedBuff();
            sequences = new ArrayList<Sequence>();
            try {
                long fileSize = mappedBuff.length();
                boolean longestSequenceLength = false;
                mappedBuff.position(filePointerStart);
                MappedBuffReaderHelper readerHelper = new MappedBuffReaderHelper(mappedBuff);
                String firstLine = readerHelper.readLine();
                int newlineLen = 1;
                newlineLen = firstLine.endsWith("\r\n") ? 2 : 1;
                boolean isRightFormat = MSFFileIndexer.isStringValidFirstLine(firstLine);
                if (!isRightFormat) {
                    throw new AlignmentImportException("Could not read first line as MSF format");
                }
                String firstNameLine = readerHelper.skipUntilLineContains("Name:");
                logger.info(firstNameLine);
                String firstName = StringUtils.substringBetween(firstNameLine, "Name:", "Len:");
                firstName = firstName.trim();
                logger.info(firstName);
                int formatType = INTERLEAVED_OR_SINGLELINE_SEQUENTIAL;
                if (formatType != INTERLEAVED_OR_SINGLELINE_SEQUENTIAL) break block11;
                try {
                    int seqCount;
                    int lineCount;
                    long nameStartPointer;
                    block12: {
                        int linebreaks;
                        ArrayList seqNames = new ArrayList();
                        ArrayList seqBuffers = new ArrayList();
                        readerHelper.skipUntilLineContains("//");
                        firstNameLine = readerHelper.skipUntilLineContains(firstName);
                        nameStartPointer = readerHelper.position();
                        readerHelper.setPosition(nameStartPointer);
                        lineCount = 0;
                        seqCount = 0;
                        int seqPos = 0;
                        do {
                            readerHelper.setPosition(nameStartPointer);
                            long seqStartPointer = readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                            long seqEndPointer = readerHelper.posOfNextNewline() - (long)newlineLen;
                            MSFFileSequence seq = new MSFFileSequence(sequencesFile, nameStartPointer);
                            String name = readerHelper.readString(nameStartPointer, seqStartPointer - 1L);
                            name = name.trim();
                            seq.setName(name);
                            int seqSeqmentLen = (int)(seqEndPointer - seqStartPointer + 1L);
                            seq.add(new PositionToPointer(seqPos, seqPos + seqSeqmentLen - 1, seqStartPointer, seqEndPointer));
                            sequences.add(seq);
                            ++seqCount;
                            if (++lineCount % 10000 == 0) {
                                progressWin.setMessage("Indexing interleaved MSF file" + LF + "line:" + lineCount);
                                if (progressWin.wasSubThreadInterruptedByUser()) break block12;
                            }
                            linebreaks = readerHelper.skipUntilNextNonWhiteCharOnNextLine();
                            nameStartPointer = readerHelper.position();
                        } while (linebreaks <= 1);
                        readerHelper.skipUntilLineContains(firstName);
                        readerHelper.skipUntilNextNonWhiteChar();
                        nameStartPointer = readerHelper.position();
                    }
                    block5: while (true) {
                        int n = 0;
                        while (true) {
                            if (n >= seqCount) continue block5;
                            readerHelper.setPosition(nameStartPointer);
                            long interleavedStartPointer = readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                            long interleavedEndPointer = readerHelper.posOfNextNewline() - (long)newlineLen;
                            mappedBuff.position(interleavedEndPointer);
                            int seqSeqmentLen = (int)(interleavedEndPointer - interleavedStartPointer + 1L);
                            MSFFileSequence appendSeq = (MSFFileSequence)sequences.get(n);
                            int appendSeqPosition = appendSeq.getLength();
                            appendSeq.add(new PositionToPointer(appendSeqPosition, interleavedStartPointer, interleavedEndPointer));
                            int linebreaks = readerHelper.skipUntilNextNonWhiteCharOnNextLine();
                            nameStartPointer = readerHelper.position();
                            if (++lineCount % 10000 == 0) {
                                progressWin.setMessage("Indexing interleaved MSF file" + LF + "line:" + lineCount);
                                if (progressWin.wasSubThreadInterruptedByUser()) continue block5;
                            }
                            if (linebreaks > 1) {
                                firstNameLine = readerHelper.skipUntilLineContains(firstName);
                                readerHelper.skipUntilNextNonWhiteChar();
                                nameStartPointer = readerHelper.position();
                                continue block5;
                            }
                            ++n;
                        }
                        break;
                    }
                }
                catch (EOFException eof) {
                    logger.info("hit EOF hopefully file is read OK");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public static boolean isStringValidFirstLine(String firstLine) {
        return StringUtils.contains(firstLine, "!!") || StringUtils.containsIgnoreCase(firstLine, "PileUp");
    }
}

