/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.FileIndexer;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.Sequence;
import aliview.subprocesses.SubThreadProgressWindow;
import it.unimi.dsi.io.ByteBufferInpStream;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NexusFileIndexer
implements FileIndexer {
    private static final Logger logger = Logger.getLogger(NexusFileIndexer.class);
    long estimateTotalSeqInFile = 0L;
    long fileSize = -1L;

    public ArrayList<Sequence> findSequencesInFile(MemoryMappedSequencesFile sequencesFile, long filePointerStart, int seqOffset, int nSeqsToRetrieve, SubThreadProgressWindow progressWin) throws AlignmentImportException {
        ByteBufferInpStream mappedBuff = sequencesFile.getMappedBuff();
        ArrayList<Sequence> allSeqs = new ArrayList<Sequence>();
        try {
            this.fileSize = mappedBuff.length();
            boolean longestSequenceLength = false;
            mappedBuff.position(filePointerStart);
            logger.info("Nexus file ix");
        }
        catch (Exception exc) {
            logger.info("could not read as nexus");
            exc.printStackTrace();
            throw new AlignmentImportException("Could not read nexus format");
        }
        return allSeqs;
    }

    private int tokenIndex(ArrayList<String> allTokens, String target) {
        for (int n = 0; n < allTokens.size(); ++n) {
            String token = allTokens.get(n);
            if (!StringUtils.equalsIgnoreCase(token, target)) continue;
            return n;
        }
        return -1;
    }

    private boolean tokenExists(ArrayList<String> allTokens, String target) {
        return this.tokenIndex(allTokens, target) > -1;
    }

    private String tokenAfter(ArrayList<String> allTokens, String target) {
        int index = this.tokenIndex(allTokens, target);
        if (index > -1 && allTokens.size() > index) {
            return allTokens.get(index + 1);
        }
        return null;
    }
}

