/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.FileFormat;
import aliview.importer.FileIndexer;
import aliview.importer.MappedBuffReaderHelper;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.FileSequence;
import aliview.sequences.PhylipFileSequence;
import aliview.sequences.PositionToPointer;
import aliview.sequences.Sequence;
import aliview.subprocesses.SubThreadProgressWindow;
import it.unimi.dsi.io.ByteBufferInpStream;
import java.util.ArrayList;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class PhylipFileIndexer
implements FileIndexer {
    private static final String LF = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger(PhylipFileIndexer.class);
    long estimateTotalSeqInFile = 0L;
    long fileSize = -1L;
    private MappedBuffReaderHelper readerHelper;
    public FileFormat formatType;

    public ArrayList<Sequence> findSequencesInFile(MemoryMappedSequencesFile sequencesFile, long filePointerStart, int seqOffset, int nSeqsToRetrieve, SubThreadProgressWindow progressWin) throws AlignmentImportException {
        ArrayList<Sequence> allSeqs;
        block30: {
            ByteBufferInpStream mappedBuff = sequencesFile.getMappedBuff();
            allSeqs = new ArrayList<Sequence>();
            try {
                long sequentialEndPointer;
                long seqStartPointer;
                PhylipFileSequence appendSeq;
                int n;
                int seqSeqmentLen;
                int nextSeqPartStartPos;
                long lengthBetweenTwoInterleaveStartPointer;
                long interleavedNextStartPointer;
                long interleavedEndLinePointer;
                long interleavedStartPointer;
                int seqSeqmentLen2;
                PhylipFileSequence seq;
                long firstNewlinePointer;
                long seqStartPointer2;
                this.fileSize = mappedBuff.length();
                int longestSequenceLength = 0;
                mappedBuff.position(filePointerStart);
                this.readerHelper = new MappedBuffReaderHelper(mappedBuff);
                String firstLine = this.readerHelper.readLine();
                int newlineLen = 1;
                newlineLen = firstLine.endsWith("\r") ? 2 : 1;
                firstLine = firstLine.trim();
                int seqCount = 0;
                String[] lineSplitted = firstLine.split("\\s+");
                logger.info("splitSize" + lineSplitted.length);
                if (lineSplitted == null || lineSplitted.length != 2 || !NumberUtils.isNumber(lineSplitted[0]) || !NumberUtils.isNumber(lineSplitted[1])) {
                    throw new AlignmentImportException("Could not read first line as phylip format");
                }
                seqCount = Integer.parseInt(lineSplitted[0]);
                longestSequenceLength = Integer.parseInt(lineSplitted[1]);
                long firstNameStartPointer = mappedBuff.position();
                FileFormat formatType = FileFormat.UNKNOWN;
                if (formatType == FileFormat.UNKNOWN) {
                    try {
                        mappedBuff.position(firstNameStartPointer);
                        long seqStartPointer3 = this.readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                        long seqEndPointerIfSequential = this.readerHelper.posAtNSequenceCharacters(seqStartPointer3, longestSequenceLength);
                        if (this.readerHelper.isNextLF()) {
                            formatType = FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL;
                            logger.info("probably long name sequential");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (formatType == FileFormat.UNKNOWN) {
                    try {
                        long seqEndPointerIfTenPosSequential = this.readerHelper.posAtNSequenceCharacters(firstNameStartPointer + 10L, longestSequenceLength);
                        if (this.readerHelper.isNextLF()) {
                            formatType = FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL;
                            logger.info("probably short name sequential");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (formatType == FileFormat.UNKNOWN) {
                    try {
                        mappedBuff.position(firstNameStartPointer);
                        if (this.readerHelper.hasLineOnlyOneContinousSpace()) {
                            formatType = FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (formatType == FileFormat.UNKNOWN) {
                    formatType = FileFormat.PHYLIP_SHORT_NAME_INTERLEAVED;
                    logger.info("probably short name interleaved");
                }
                if (formatType == FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED) {
                    long nameStartPointer = firstNameStartPointer;
                    this.readerHelper.setPosition(nameStartPointer);
                    int lineCount = 0;
                    for (int n2 = 0; n2 < seqCount; ++n2) {
                        int seqPos = 0;
                        this.readerHelper.setPosition(nameStartPointer);
                        seqStartPointer2 = this.readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                        firstNewlinePointer = this.readerHelper.posOfNextNewline();
                        seq = new PhylipFileSequence(sequencesFile, nameStartPointer);
                        String name = this.readerHelper.readString(nameStartPointer, seqStartPointer2 - 1L);
                        name = name.trim();
                        seq.setName(name);
                        seqSeqmentLen2 = (int)(firstNewlinePointer - (long)newlineLen - seqStartPointer2 + 1L);
                        seq.add(new PositionToPointer(seqPos, seqPos + seqSeqmentLen2 - 1, seqStartPointer2, firstNewlinePointer - (long)newlineLen));
                        nameStartPointer = firstNewlinePointer + (long)newlineLen;
                        allSeqs.add(seq);
                        if (++lineCount % 1000 != 0) continue;
                        progressWin.setMessage("Indexing interleaved Phylip file" + LF + "line:" + lineCount);
                        if (progressWin.wasSubThreadInterruptedByUser()) break;
                    }
                    FileSequence lastPhylSeq = (FileSequence)allSeqs.get(allSeqs.size() - 1);
                    mappedBuff.position(lastPhylSeq.getEndPointer() + 1L);
                    while (true) {
                        interleavedStartPointer = this.readerHelper.posOfNextNonWhiteChar();
                        interleavedEndLinePointer = this.readerHelper.posOfNextNewline() - (long)newlineLen;
                        interleavedNextStartPointer = this.readerHelper.posOfNextNonWhiteChar();
                        lengthBetweenTwoInterleaveStartPointer = interleavedNextStartPointer - interleavedStartPointer - 1L;
                        nextSeqPartStartPos = allSeqs.get(0).getLength();
                        seqSeqmentLen = (int)(interleavedEndLinePointer - interleavedStartPointer + 1L);
                        for (n = 0; n < seqCount; ++n) {
                            appendSeq = (PhylipFileSequence)allSeqs.get(n);
                            appendSeq.add(new PositionToPointer(nextSeqPartStartPos, nextSeqPartStartPos + seqSeqmentLen - 1, interleavedStartPointer, interleavedEndLinePointer));
                            interleavedStartPointer = interleavedStartPointer + lengthBetweenTwoInterleaveStartPointer + 1L;
                            interleavedEndLinePointer = interleavedStartPointer + (long)(seqSeqmentLen - 1);
                        }
                        if (allSeqs.get(0).getLength() >= longestSequenceLength) {
                            logger.info("done indexing");
                            break;
                        }
                        FileSequence lastSeq = (FileSequence)allSeqs.get(allSeqs.size() - 1);
                        mappedBuff.position(lastSeq.getEndPointer() + 1L);
                        if (++lineCount % 1000 != 0) continue;
                        progressWin.setMessage("Indexing interleaved Phylip file" + LF + "line:" + lineCount);
                        if (progressWin.wasSubThreadInterruptedByUser()) break;
                    }
                }
                if (formatType == FileFormat.PHYLIP_SHORT_NAME_INTERLEAVED) {
                    long nameStartPointer = firstNameStartPointer;
                    this.readerHelper.setPosition(nameStartPointer);
                    int lineCount = 0;
                    for (int n3 = 0; n3 < seqCount; ++n3) {
                        int seqPos = 0;
                        this.readerHelper.setPosition(nameStartPointer);
                        seqStartPointer2 = nameStartPointer + 10L;
                        firstNewlinePointer = this.readerHelper.posOfNextNewline();
                        seq = new PhylipFileSequence(sequencesFile, nameStartPointer);
                        String name = this.readerHelper.readString(nameStartPointer, seqStartPointer2 - 1L);
                        name = name.trim();
                        seq.setName(name);
                        seqSeqmentLen2 = (int)(firstNewlinePointer - (long)newlineLen - seqStartPointer2 + 1L);
                        seq.add(new PositionToPointer(seqPos, seqPos + seqSeqmentLen2 - 1, seqStartPointer2, firstNewlinePointer - (long)newlineLen));
                        nameStartPointer = firstNewlinePointer + (long)newlineLen;
                        allSeqs.add(seq);
                        if (++lineCount % 1000 != 0) continue;
                        progressWin.setMessage("Indexing interleaved Phylip file" + LF + "line:" + lineCount);
                        if (progressWin.wasSubThreadInterruptedByUser()) break;
                    }
                    FileSequence lastSeq = (FileSequence)allSeqs.get(allSeqs.size() - 1);
                    mappedBuff.position(lastSeq.getEndPointer() + 1L);
                    while (true) {
                        interleavedStartPointer = this.readerHelper.posOfNextNonWhiteChar();
                        interleavedEndLinePointer = this.readerHelper.posOfNextNewline() - (long)newlineLen;
                        interleavedNextStartPointer = this.readerHelper.posOfNextNonWhiteChar();
                        lengthBetweenTwoInterleaveStartPointer = interleavedNextStartPointer - interleavedStartPointer - 1L;
                        nextSeqPartStartPos = allSeqs.get(0).getLength();
                        seqSeqmentLen = (int)(interleavedEndLinePointer - interleavedStartPointer + 1L);
                        for (n = 0; n < seqCount; ++n) {
                            appendSeq = (PhylipFileSequence)allSeqs.get(n);
                            appendSeq.add(new PositionToPointer(nextSeqPartStartPos, nextSeqPartStartPos + seqSeqmentLen - 1, interleavedStartPointer, interleavedEndLinePointer));
                            interleavedStartPointer = interleavedStartPointer + lengthBetweenTwoInterleaveStartPointer + 1L;
                            interleavedEndLinePointer = interleavedStartPointer + (long)(seqSeqmentLen - 1);
                        }
                        if (allSeqs.get(0).getLength() >= longestSequenceLength) {
                            logger.info("done indexing");
                            break;
                        }
                        FileSequence theLastSeq = (FileSequence)allSeqs.get(allSeqs.size() - 1);
                        mappedBuff.position(theLastSeq.getEndPointer() + 1L);
                        if (++lineCount % 1000 != 0) continue;
                        progressWin.setMessage("Indexing interleaved Phylip file" + LF + "line:" + lineCount);
                        if (progressWin.wasSubThreadInterruptedByUser()) break;
                    }
                }
                if (formatType == FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL) {
                    logger.info("PhylipImporter.LONG_NAME_SEQUENTIAL");
                    long nameStartPointer = firstNameStartPointer;
                    this.readerHelper.setPosition(nameStartPointer);
                    seqStartPointer = this.readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                    sequentialEndPointer = this.readerHelper.posAtNSequenceCharacters(seqStartPointer, longestSequenceLength);
                    int seqSeqmentLen3 = (int)(sequentialEndPointer - seqStartPointer + 1L);
                    for (int n4 = 0; n4 < seqCount; ++n4) {
                        int seqPos = 0;
                        mappedBuff.position(nameStartPointer);
                        seqStartPointer = this.readerHelper.posOfFirstNonWhiteCharAfterWhiteChar();
                        sequentialEndPointer = seqStartPointer + (long)seqSeqmentLen3 - 1L;
                        seq = new PhylipFileSequence(sequencesFile, nameStartPointer);
                        String name = this.readerHelper.readString(nameStartPointer, seqStartPointer - 1L);
                        name = name.trim();
                        seq.setName(name);
                        seq.add(new PositionToPointer(seqPos, seqPos + seqSeqmentLen3 - 1, seqStartPointer, sequentialEndPointer));
                        allSeqs.add(seq);
                        nameStartPointer = sequentialEndPointer + (long)newlineLen + 1L;
                        if (n4 % 1000 != 0) continue;
                        progressWin.setMessage("Indexing Phylip sequential file" + LF + "seq:" + n4 + "/" + seqCount);
                        if (progressWin.wasSubThreadInterruptedByUser()) break;
                    }
                }
                if (formatType != FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL) break block30;
                logger.info("PhylipImporter.SHORT_NAME_SEQUENTIAL");
                long nameStartPointer = firstNameStartPointer;
                this.readerHelper.setPosition(nameStartPointer);
                seqStartPointer = nameStartPointer + 10L;
                sequentialEndPointer = this.readerHelper.posAtNSequenceCharacters(seqStartPointer, longestSequenceLength);
                int seqSeqmentLen4 = (int)(sequentialEndPointer - seqStartPointer + 1L);
                for (int n5 = 0; n5 < seqCount; ++n5) {
                    int seqPos = 0;
                    mappedBuff.position(nameStartPointer);
                    seqStartPointer = nameStartPointer + 10L;
                    sequentialEndPointer = seqStartPointer + (long)seqSeqmentLen4 - 1L;
                    seq = new PhylipFileSequence(sequencesFile, nameStartPointer);
                    String name = this.readerHelper.readString(nameStartPointer, seqStartPointer - 1L);
                    name = name.trim();
                    seq.setName(name);
                    seq.add(new PositionToPointer(seqPos, seqPos + seqSeqmentLen4 - 1, seqStartPointer, sequentialEndPointer));
                    allSeqs.add(seq);
                    nameStartPointer = sequentialEndPointer + (long)newlineLen + 1L;
                    if (n5 % 1000 != 0) continue;
                    progressWin.setMessage("Indexing Phylip sequential file" + LF + "seq:" + n5 + "/" + seqCount);
                    if (!progressWin.wasSubThreadInterruptedByUser()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                logger.info("could not read as phylip");
                exc.printStackTrace();
                throw new AlignmentImportException("Could not read phylip format");
            }
        }
        return allSeqs;
    }
}

