/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.FileFormat;
import aliview.importer.ReaderHelper;
import aliview.sequences.PhylipSequence;
import aliview.sequences.Sequence;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class PhylipImporter {
    private static final Logger logger = Logger.getLogger(PhylipImporter.class);
    private Reader reader;
    private int longestSequenceLength;
    public FileFormat formatType;

    public static void main(String[] args) throws FileNotFoundException, AlignmentImportException {
        File alignmentFile = new File("/home/anders/projekt/alignments/smalphylipSeqShortName.phy");
        PhylipImporter importer = new PhylipImporter(new FileReader(alignmentFile), FileFormat.PHYLIP_SHORT_NAME_INTERLEAVED);
        importer.importSequences();
    }

    public PhylipImporter(Reader reader, FileFormat formatType) {
        this.reader = reader;
        this.formatType = formatType;
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            String sequenceString = "";
            BufferedReader r = new BufferedReader(this.reader);
            String firstLine = r.readLine();
            firstLine = firstLine.trim();
            int seqCount = 0;
            String[] lineSplitted = firstLine.split("\\s+");
            logger.info("splitSize" + lineSplitted.length);
            if (lineSplitted == null || lineSplitted.length != 2 || !NumberUtils.isNumber(lineSplitted[0]) || !NumberUtils.isNumber(lineSplitted[1])) {
                throw new AlignmentImportException("Could not read first line as phylip format");
            }
            seqCount = Integer.parseInt(lineSplitted[0]);
            this.longestSequenceLength = Integer.parseInt(lineSplitted[1]);
            ReaderHelper helper = new ReaderHelper(r);
            logger.info("inside phy importer");
            try {
                String name;
                String line;
                block22: {
                    if (this.formatType == FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED) {
                        ByteBuffer seqBuff;
                        int index;
                        ArrayList<String> seqNames = new ArrayList<String>();
                        ArrayList<ByteBuffer> seqBuffers = new ArrayList<ByteBuffer>();
                        for (int n = 0; n < seqCount; ++n) {
                            helper.readNextLine();
                            line = helper.getNextLine();
                            index = ReaderHelper.indexOfFirstNonWhiteCharAfterWhiteChar(line);
                            String name2 = line.substring(0, index).trim();
                            seqNames.add(name2);
                            logger.info("name" + name2);
                            logger.info("index" + index);
                            int capacity = this.longestSequenceLength;
                            ByteBuffer seqBuff2 = ByteBuffer.allocate(capacity);
                            String seqChars = line.substring(index);
                            seqChars = ReaderHelper.removeSpaceAndTab(seqChars);
                            logger.info("seqChars" + seqChars);
                            seqBuff2.put(seqChars.getBytes());
                            seqBuffers.add(seqBuff2);
                        }
                        do {
                            int lineCount = 0;
                            while (lineCount < seqCount) {
                                helper.readNextLine();
                                line = helper.getNextLine();
                                index = ReaderHelper.indexOfFirstNonWhiteChar(line);
                                if (index == -1) {
                                    logger.info("skip empty");
                                    continue;
                                }
                                String moreChars = line.substring(index);
                                moreChars = ReaderHelper.removeSpaceAndTab(moreChars);
                                ByteBuffer seqBuff3 = (ByteBuffer)seqBuffers.get(lineCount);
                                seqBuff3.put(moreChars.getBytes());
                                ++lineCount;
                            }
                            seqBuff = (ByteBuffer)seqBuffers.get(seqBuffers.size() - 1);
                            if (seqBuff.position() == this.longestSequenceLength) {
                                logger.info("right length");
                                for (int n = 0; n < seqCount; ++n) {
                                    sequences.add(new PhylipSequence((String)seqNames.get(n), ((ByteBuffer)seqBuffers.get(n)).array()));
                                    seqNames.set(n, null);
                                    seqBuffers.set(n, null);
                                }
                                break block22;
                            }
                            logger.info("seqBuff.position()" + seqBuff.position());
                        } while (seqBuff.position() <= this.longestSequenceLength);
                        logger.info("wrong length");
                        throw new AlignmentImportException("Did not match Phylip.LONG_NAME_INTERLEAVED");
                    }
                }
                if (this.formatType == FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL) {
                    for (int n = 0; n < seqCount; ++n) {
                        name = helper.getStringUntilNextSpaceOrTab();
                        StringBuilder seqBuffer = new StringBuilder(this.longestSequenceLength);
                        while (seqBuffer.length() < this.longestSequenceLength) {
                            helper.readNextLine();
                            line = helper.getNextLine();
                            line = ReaderHelper.removeSpaceAndTab(line);
                            seqBuffer.append(line);
                        }
                        if (seqBuffer.length() != this.longestSequenceLength) {
                            throw new AlignmentImportException("Did not match FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL");
                        }
                        sequences.add(new PhylipSequence(name, seqBuffer.toString()));
                    }
                }
                if (this.formatType == FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL) {
                    for (int n = 0; n < seqCount; ++n) {
                        name = helper.getStringFromNextPositions(10);
                        byte[] sequence = helper.getNonWhiteBytes(this.longestSequenceLength);
                        sequences.add(new PhylipSequence(name, sequence));
                        if (n == seqCount - 1) continue;
                        helper.skipPastNextline();
                    }
                }
                if (this.formatType == FileFormat.PHYLIP_SHORT_NAME_INTERLEAVED) {
                    PhylipSequence seq;
                    for (int n = 0; n < seqCount; ++n) {
                        name = helper.getStringFromNextPositions(10);
                        helper.readNextLine();
                        String line2 = helper.getNextLine();
                        line2 = ReaderHelper.removeSpaceAndTab(line2);
                        sequences.add(new PhylipSequence(name, line2));
                    }
                    do {
                        for (int n = 0; n < seqCount; ++n) {
                            helper.readNextLine();
                            String line3 = helper.getNextLine();
                            line3 = ReaderHelper.removeSpaceAndTab(line3);
                            PhylipSequence seq2 = (PhylipSequence)sequences.get(n);
                            seq2.append(line3);
                        }
                    } while ((seq = (PhylipSequence)sequences.get(sequences.size() - 1)).getLength() != this.longestSequenceLength);
                }
            }
            catch (EOFException eofExc) {
                throw new AlignmentImportException("Premature End of file when importing");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public int getLongestSequenceLength() {
        return this.longestSequenceLength;
    }

    public static boolean isStringValidFirstLine(String firstLine) {
        String[] lineSplitted;
        boolean isValid = false;
        if (firstLine.contains(" ") && NumberUtils.isNumber((lineSplitted = firstLine.split("\\s+"))[0]) && NumberUtils.isNumber(lineSplitted[1])) {
            isValid = true;
        }
        return isValid;
    }

    public FileFormat getFileFormat() {
        return null;
    }
}

