/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.MemoryUtils;
import aliview.importer.AlignmentImportException;
import aliview.importer.ClustalImporter;
import aliview.importer.FastFastQImporter;
import aliview.importer.FastFastaImporter;
import aliview.importer.FastNexusImporterSlow;
import aliview.importer.FileFormat;
import aliview.importer.MSFImporter;
import aliview.importer.PhylipImporter;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.FileSequenceAlignmentListModel;
import aliview.sequencelist.MemorySequenceAlignmentListModel;
import aliview.sequences.ConvertedJEBLSequence;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import jebl.evolution.io.ImportException;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.sequences.Sequence;
import org.apache.log4j.Logger;

public class SequencesFactory {
    private static final String LF = System.getProperty("line.separator");
    private static final Logger logger = Logger.getLogger(SequencesFactory.class);

    public List<aliview.sequences.Sequence> cloneSequences(List<aliview.sequences.Sequence> seqs) {
        ArrayList<aliview.sequences.Sequence> clone = new ArrayList<aliview.sequences.Sequence>();
        for (aliview.sequences.Sequence seq : seqs) {
            clone.add(seq);
        }
        return clone;
    }

    public List<aliview.sequences.Sequence> createEmptyMemorySequencesArrayList() {
        return new ArrayList<aliview.sequences.Sequence>();
    }

    public AlignmentListModel createSequences(File alignmentFile) throws AlignmentImportException {
        FileFormat foundFormat;
        String importErrorMessage = "";
        AlignmentListModel model = null;
        boolean memorySequences = true;
        if (alignmentFile != null && alignmentFile.exists()) {
            double fileSize = alignmentFile.length();
            double maxMem = MemoryUtils.getMaxMem();
            logger.info("maxMem" + maxMem);
            logger.info("fileSize" + fileSize);
            if (maxMem / fileSize < 1.3) {
                logger.info("maxMem/fileSize=" + maxMem / fileSize);
                memorySequences = false;
            }
        }
        logger.info("memorySequences=" + memorySequences);
        if (memorySequences) {
            Object importer;
            FileFormat foundFormat2;
            block43: {
                block42: {
                    logger.info("memorySequence");
                    foundFormat2 = FileFormat.isFileOfAlignmentFormat(alignmentFile);
                    if (foundFormat2 == FileFormat.FASTA) {
                        try {
                            FastFastaImporter fastaImporter = new FastFastaImporter(new FileReader(alignmentFile));
                            List<aliview.sequences.Sequence> sequences = fastaImporter.importSequences();
                            model = new MemorySequenceAlignmentListModel();
                            model.setSequences(sequences);
                            model.setFileFormat(FileFormat.FASTA);
                        }
                        catch (FileNotFoundException e) {
                            importErrorMessage = importErrorMessage + "Tried import as Fasta but: " + e.getMessage() + LF;
                            logger.error(importErrorMessage);
                            logger.error(e);
                        }
                        catch (AlignmentImportException aie) {
                            if (!aie.getMessage().contains("Sequence to long for memory")) break block42;
                            memorySequences = false;
                        }
                    }
                }
                if (foundFormat2 == FileFormat.FASTQ) {
                    try {
                        FastFastQImporter fastqImporter = new FastFastQImporter(new FileReader(alignmentFile));
                        List<aliview.sequences.Sequence> sequences = fastqImporter.importSequences();
                        model = new MemorySequenceAlignmentListModel();
                        model.setSequences(sequences);
                        model.setFileFormat(FileFormat.FASTQ);
                    }
                    catch (FileNotFoundException e) {
                        importErrorMessage = importErrorMessage + "Tried import as FastQ but: " + e.getMessage() + LF;
                        logger.error(importErrorMessage);
                        logger.error(e);
                    }
                    catch (AlignmentImportException aie) {
                        if (!aie.getMessage().contains("Sequence to long for memory")) break block43;
                        memorySequences = false;
                    }
                }
            }
            if (foundFormat2 == FileFormat.MSF) {
                try {
                    importer = new MSFImporter(new FileReader(alignmentFile));
                    List<aliview.sequences.Sequence> sequences = ((MSFImporter)importer).importSequences();
                    model = new MemorySequenceAlignmentListModel();
                    model.setSequences(sequences);
                    model.setFileFormat(FileFormat.MSF);
                }
                catch (FileNotFoundException e) {
                    importErrorMessage = importErrorMessage + "Tried import as MSF but: " + e.getMessage() + LF;
                    logger.error(importErrorMessage);
                    logger.error(e);
                }
            }
            if (foundFormat2 == FileFormat.CLUSTAL) {
                try {
                    importer = new ClustalImporter(new FileReader(alignmentFile), alignmentFile.length());
                    List<aliview.sequences.Sequence> sequences = ((ClustalImporter)importer).importSequences();
                    model = new MemorySequenceAlignmentListModel();
                    model.setSequences(sequences);
                    model.setFileFormat(FileFormat.CLUSTAL);
                }
                catch (FileNotFoundException e) {
                    importErrorMessage = importErrorMessage + "Tried import as CLUSTAL but: " + e.getMessage() + LF;
                    logger.error(importErrorMessage);
                    logger.error(e);
                }
            }
            if (foundFormat2 == FileFormat.PHYLIP) {
                PhylipImporter phylipImporter;
                try {
                    phylipImporter = new PhylipImporter(new FileReader(alignmentFile), FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL);
                    List<aliview.sequences.Sequence> sequences = phylipImporter.importSequences();
                    model = new MemorySequenceAlignmentListModel();
                    model.setSequences(sequences);
                    model.setFileFormat(FileFormat.PHYLIP);
                }
                catch (Exception e) {
                    importErrorMessage = importErrorMessage + "Tried import as Phylip but: " + e.getMessage() + LF;
                    logger.error(importErrorMessage);
                    logger.error(e);
                }
                if (model == null) {
                    try {
                        logger.info("try LONG_NAME_INTERLEAVED");
                        phylipImporter = new PhylipImporter(new FileReader(alignmentFile), FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED);
                        List<aliview.sequences.Sequence> sequences = phylipImporter.importSequences();
                        model = new MemorySequenceAlignmentListModel();
                        model.setSequences(sequences);
                        model.setFileFormat(FileFormat.PHYLIP);
                    }
                    catch (Exception e) {
                        importErrorMessage = importErrorMessage + "Tried import as Phylip but: " + e.getMessage() + LF;
                        logger.error(importErrorMessage);
                        logger.error(e);
                    }
                }
                if (model == null) {
                    try {
                        logger.info("try short name sequential");
                        phylipImporter = new PhylipImporter(new FileReader(alignmentFile), FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL);
                        List<aliview.sequences.Sequence> sequences = phylipImporter.importSequences();
                        model = new MemorySequenceAlignmentListModel();
                        model.setSequences(sequences);
                        model.setFileFormat(phylipImporter.getFileFormat());
                    }
                    catch (Exception e) {
                        importErrorMessage = importErrorMessage + "Tried import as Phylip but: " + e.getMessage() + LF;
                        logger.error(importErrorMessage);
                        logger.error(e);
                    }
                }
                if (model == null) {
                    try {
                        logger.info("try short name interleaved");
                        phylipImporter = new PhylipImporter(new FileReader(alignmentFile), FileFormat.PHYLIP_SHORT_NAME_INTERLEAVED);
                        List<aliview.sequences.Sequence> sequences = phylipImporter.importSequences();
                        model = new MemorySequenceAlignmentListModel();
                        model.setSequences(sequences);
                        model.setFileFormat(FileFormat.PHYLIP);
                    }
                    catch (Exception e) {
                        importErrorMessage = importErrorMessage + "Tried import as Phylip but: " + e.getMessage() + LF;
                        logger.error(importErrorMessage);
                        logger.error(e);
                    }
                }
            }
            if (foundFormat2 == FileFormat.NEXUS) {
                long fileSize = alignmentFile.length();
                if (fileSize < 200000000L) {
                    try {
                        NexusImporter importer2 = new NexusImporter(new FileReader(alignmentFile));
                        List<Sequence> jeblSequences = importer2.importSequences();
                        if (jeblSequences != null && jeblSequences.size() > 0) {
                            model = new MemorySequenceAlignmentListModel();
                            model.setSequences(this.convertJEBLSequences(jeblSequences));
                            model.setFileFormat(FileFormat.NEXUS);
                        }
                    }
                    catch (ImportException impExc) {
                        logger.error(impExc);
                        importErrorMessage = importErrorMessage + "Tried import as Nexus but: " + impExc.userMessage() + LF;
                    }
                    catch (Exception e) {
                        logger.error(e);
                        importErrorMessage = importErrorMessage + "Tried import as Nexus but: " + e.getMessage() + LF;
                    }
                } else {
                    try {
                        FastNexusImporterSlow importer3 = new FastNexusImporterSlow(alignmentFile);
                        List<aliview.sequences.Sequence> sequences = importer3.importSequences();
                        model = new MemorySequenceAlignmentListModel();
                        model.setSequences(sequences);
                        model.setFileFormat(FileFormat.NEXUS);
                    }
                    catch (Exception e) {
                        importErrorMessage = importErrorMessage + "Tried import as Nexus but: " + e.getMessage() + LF;
                        logger.error(importErrorMessage);
                        logger.error(e);
                    }
                }
            }
            if (memorySequences && (foundFormat2 == null || model == null || model.getSize() == 0)) {
                throw new AlignmentImportException("Could not find sequences in file: " + alignmentFile + LF + importErrorMessage);
            }
        }
        if (!(memorySequences || (foundFormat = FileFormat.isFileOfAlignmentFormat(alignmentFile)) != FileFormat.FASTA && foundFormat != FileFormat.PHYLIP && foundFormat != FileFormat.NEXUS && foundFormat != FileFormat.CLUSTAL && foundFormat != FileFormat.MSF)) {
            try {
                model = new FileSequenceAlignmentListModel(alignmentFile, foundFormat);
                logger.info(model.getFileFormat());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    public AlignmentListModel createFastaSequences(StringReader stringReader) throws AlignmentImportException {
        MemorySequenceAlignmentListModel model = new MemorySequenceAlignmentListModel();
        try {
            FastFastaImporter fastaImporter = new FastFastaImporter(stringReader);
            model.setSequences(fastaImporter.importSequences());
            model.setFileFormat(FileFormat.FASTA);
        }
        catch (Exception e) {
            logger.error(e);
        }
        return model;
    }

    private List<aliview.sequences.Sequence> convertJEBLSequences(List<Sequence> jeblSequences) {
        ArrayList<aliview.sequences.Sequence> sequences = new ArrayList<aliview.sequences.Sequence>();
        for (Sequence jeblSequence : jeblSequences) {
            ConvertedJEBLSequence seq = new ConvertedJEBLSequence(jeblSequence);
            sequences.add(seq);
        }
        return sequences;
    }
}

