/*
 * Decompiled with CFR 0.152.
 */
package aliview.old;

import aliview.AliViewWindow;
import aliview.externalcommands.CmdItemPanel;
import aliview.externalcommands.CommandItem;
import aliview.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ExternalCmdFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(ExternalCmdFrame.class);
    JPanel mainPanel;

    public ExternalCmdFrame(AliViewWindow aliViewWin) {
        final ExternalCmdFrame commandFrame = this;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        final ArrayList<CommandItem> cmdItems = Settings.getExternalCommands();
        for (CommandItem cmdItem : cmdItems) {
            this.mainPanel.add(new CmdItemPanel(cmdItem));
        }
        this.mainPanel.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel bottomButtonPanel = new JPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        bottomButtonPanel.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                commandFrame.dispose();
            }
        });
        bottomButtonPanel.add(cancelButton);
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(100, 25));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.putExternalCommands(cmdItems);
                commandFrame.dispose();
            }
        });
        bottomButtonPanel.add(okButton);
        this.mainPanel.add(bottomButtonPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.putExternalCommands(cmdItems);
                commandFrame.dispose();
            }
        });
        this.setTitle("External commands");
        this.setPreferredSize(new Dimension(650, 550));
        this.pack();
        this.centerLocationToThisComponent(aliViewWin);
        this.setVisible(true);
        okButton.requestFocus();
    }

    public void centerLocationToThisComponent(Component parent) {
        if (parent != null) {
            int newX = parent.getX() + parent.getWidth() / 2 - this.getWidth() / 2;
            int newY = parent.getY() + parent.getHeight() / 2 - this.getHeight() / 2;
            this.setLocation(newX, newY);
        }
    }
}

