/*
 * Decompiled with CFR 0.152.
 */
package aliview.primer;

import aliview.NucleotideUtilities;
import aliview.primer.Dimer;
import aliview.primer.OligoCalc;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Primer
implements Comparable<Primer> {
    private static final Logger logger = Logger.getLogger(Primer.class);
    private static final String LF = System.getProperty("line.separator");
    DecimalFormat DEC_FORMAT = new DecimalFormat("#.#");
    String sequence;
    private int position;

    public Primer(String sequence, int position) {
        this.sequence = sequence;
        this.position = position;
    }

    public long getScore() {
        long foldVal;
        long score = 0L;
        score = foldVal = this.getDegenerateFold();
        return score;
    }

    public long getDegenerateFold() {
        long foldVal = 1L;
        for (int n = 0; n < this.sequence.length(); ++n) {
            foldVal *= (long)NucleotideUtilities.degenFoldFromChar(this.sequence.charAt(n));
        }
        return foldVal;
    }

    public String getBaseStackingAvgTmAsString() {
        double tm = this.getBaseStackingAvgTm();
        String tmString = "";
        tmString = tmString + this.DEC_FORMAT.format(tm) + "\u00b0C";
        return tmString;
    }

    public double getBaseStackingAvgTm() {
        double conc_primer = 200.0;
        double conc_salt = 50.0;
        double conc_mg = 0.0;
        ArrayList<String> regenerated = NucleotideUtilities.regenerateDegenerated(this.sequence);
        double minTM = Double.MAX_VALUE;
        double maxTM = Double.MIN_VALUE;
        for (String thisSeq : regenerated) {
            double tm = OligoCalc.getBaseStackingTM(thisSeq, conc_primer, conc_salt, conc_mg);
            minTM = Math.min(tm, minTM);
            maxTM = Math.max(tm, maxTM);
        }
        return minTM / 2.0 + maxTM / 2.0;
    }

    public String getBaseStackingTmAsString() {
        double conc_primer = 200.0;
        double conc_salt = 50.0;
        double conc_mg = 0.0;
        ArrayList<String> regenerated = NucleotideUtilities.regenerateDegenerated(this.sequence);
        double minTM = Double.MAX_VALUE;
        double maxTM = Double.MIN_VALUE;
        for (String thisSeq : regenerated) {
            double tm = OligoCalc.getBaseStackingTM(thisSeq, conc_primer, conc_salt, conc_mg);
            minTM = Math.min(tm, minTM);
            maxTM = Math.max(tm, maxTM);
        }
        String tmString = "";
        tmString = minTM == maxTM ? this.DEC_FORMAT.format(minTM) + "\u00b0C" : tmString + this.DEC_FORMAT.format(minTM) + "\u00b0C to " + this.DEC_FORMAT.format(maxTM) + "\u00b0C";
        return tmString;
    }

    public String getTmAsString() {
        double conc_primer = 200.0;
        double conc_salt = 50.0;
        double conc_mg = 0.0;
        ArrayList<String> regenerated = NucleotideUtilities.regenerateDegenerated(this.sequence);
        double minTM = Double.MAX_VALUE;
        double maxTM = Double.MIN_VALUE;
        for (String thisSeq : regenerated) {
            double tm = OligoCalc.getBaseStackingTM(thisSeq, conc_primer, conc_salt, conc_mg);
            minTM = Math.min(tm, minTM);
            maxTM = Math.max(tm, maxTM);
        }
        String tmString = "baseStack ";
        tmString = minTM == maxTM ? this.DEC_FORMAT.format(minTM) + "\u00b0C" : tmString + "avg=" + this.DEC_FORMAT.format(minTM / 2.0 + maxTM / 2.0) + "\u00b0C " + this.DEC_FORMAT.format(minTM) + "\u00b0C to " + this.DEC_FORMAT.format(maxTM) + "\u00b0C";
        return tmString;
    }

    @Override
    public int compareTo(Primer o) {
        if (this.getScore() == o.getScore()) {
            return 0;
        }
        if (this.getScore() > o.getScore()) {
            return 1;
        }
        return -1;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getPosition() {
        return this.position;
    }

    public double getGCcontent() {
        double ng = StringUtils.countMatches(this.getSequence(), "G");
        double nc = StringUtils.countMatches(this.getSequence(), "C");
        double gc_contents = (ng + nc) / (double)this.getSequence().length();
        return gc_contents;
    }

    public int getLength() {
        return this.getSequence().length();
    }

    public int get3EndDimerMaxLength() {
        Dimer d = new Dimer(this.getSequence(), NucleotideUtilities.revComp(this.getSequence()));
        return d.get3EndDimerMaxLength();
    }

    public int getDimerMaxLength() {
        Dimer d = new Dimer(this.getSequence(), NucleotideUtilities.revComp(this.getSequence()));
        return d.getDimerMaxLength();
    }

    public ArrayList<String> getAllDimersAsText() {
        Dimer d = new Dimer(this.getSequence(), NucleotideUtilities.revComp(this.getSequence()));
        return d.getAllDimersAsText();
    }

    public String getPrimerDetailsAsText() {
        String data = "";
        data = data + ">" + this.getPosition() + LF;
        data = data + "" + this.getSequence() + LF;
        data = data + "revcomp:" + NucleotideUtilities.revComp(this.getSequence()) + LF;
        data = data + "position:" + this.getPosition() + LF;
        data = data + "length:" + this.getSequence().length() + LF;
        data = data + "degenerate-fold:" + this.getScore() + LF;
        boolean isFirstLine = true;
        for (String line : NucleotideUtilities.seqToDeUPACStringArray(this.getSequence())) {
            if (isFirstLine) {
                data = data + "degenerate-view: " + line + LF;
                isFirstLine = false;
                continue;
            }
            data = data + "                 " + line + LF;
        }
        data = data + "Tm(base-stacking):" + this.getBaseStackingTmAsString() + " (avg=" + this.getBaseStackingAvgTmAsString() + ")" + LF;
        data = data + "gc-content:" + this.getGCcontent() + LF;
        data = data + "max 3\"-end-dimer:" + this.get3EndDimerMaxLength() + LF;
        data = data + "max dimer length:" + this.getDimerMaxLength() + LF;
        data = data + "below are all dimers above threshold length (" + this.getDimerLengthThreashold() + "):" + LF;
        data = data + LF;
        for (String line : this.getAllDimersAsText()) {
            data = data + line + LF;
        }
        return data;
    }

    private int getDimerLengthThreashold() {
        return Dimer.getDimerLengthThreashold();
    }
}

