/*
 * Decompiled with CFR 0.152.
 */
package aliview.primer;

import aliview.primer.Primer;
import aliview.primer.PrimerDisplay;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class PrimerResultTableRow {
    private static final Logger logger = Logger.getLogger(PrimerResultTableRow.class);
    private Primer primer;
    private Font baseFont = new Font(OSNativeUtils.getMonospacedFontName(), 0, 10);
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("##.###");

    public PrimerResultTableRow(Primer primer) {
        this.primer = primer;
    }

    public static final ArrayList<Object> getColumnHeaders() {
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add("Degen-fold");
        headers.add("Pos");
        headers.add("Len");
        headers.add("Sequence");
        headers.add("GC-cont");
        headers.add("TM(base-stacking)");
        headers.add("3-end-dimer-len");
        headers.add("dimer-len");
        headers.add("Sequence");
        return headers;
    }

    public static final ArrayList<Integer> getColumnSizes() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        sizes.add(new Integer(30));
        sizes.add(new Integer(30));
        sizes.add(new Integer(30));
        sizes.add(new Integer(150));
        sizes.add(new Integer(30));
        sizes.add(new Integer(150));
        sizes.add(new Integer(30));
        sizes.add(new Integer(30));
        sizes.add(new Integer(100));
        return sizes;
    }

    public ArrayList<Object> getRow() {
        ArrayList<Object> row = new ArrayList<Object>();
        JLabel lblScore = new JLabel("" + this.primer.getDegenerateFold());
        lblScore.setFont(this.baseFont);
        row.add(lblScore);
        JLabel lblPosition = new JLabel("" + this.primer.getPosition());
        lblPosition.setFont(this.baseFont);
        row.add(lblPosition);
        JLabel lblLength = new JLabel("" + this.primer.getLength());
        lblLength.setFont(this.baseFont);
        row.add(lblLength);
        PrimerDisplay primerDisplay = new PrimerDisplay(this.primer.getSequence());
        primerDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                logger.info("MouseEnter");
            }
        });
        row.add(primerDisplay);
        JLabel lblGCcontent = new JLabel("" + DEC_FORMAT.format(this.primer.getGCcontent()));
        lblGCcontent.setFont(this.baseFont);
        row.add(lblGCcontent);
        JLabel lblTm = new JLabel(this.primer.getBaseStackingTmAsString() + " (avg=" + this.primer.getBaseStackingAvgTmAsString() + ")");
        lblTm.setFont(this.baseFont);
        row.add(lblTm);
        JLabel lbl3EndDimer = new JLabel("" + this.primer.get3EndDimerMaxLength());
        lbl3EndDimer.setFont(this.baseFont);
        row.add(lbl3EndDimer);
        JLabel lblDimer = new JLabel("" + this.primer.getDimerMaxLength());
        lblDimer.setFont(this.baseFont);
        row.add(lblDimer);
        JLabel lblSequence = new JLabel(this.primer.getSequence());
        lblSequence.setFont(this.baseFont);
        row.add(lblSequence);
        return row;
    }
}

