/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AliView;
import aliview.alignment.AlignmentMeta;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.AlignmentSelectionEvent;
import aliview.sequencelist.AlignmentSelectionListener;
import aliview.sequencelist.Interval;
import aliview.sequencelist.SequenceListSelectionModel;
import aliview.sequences.Sequence;
import aliview.utils.Utils;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AlignmentSelectionModel {
    private static final Logger logger = Logger.getLogger(AlignmentSelectionModel.class);
    private static final String LF = System.getProperty("line.separator");
    private AlignmentListModel sequences;
    protected EventListenerList listenerList = new EventListenerList();
    private Rectangle tempSelectionRect;
    private Rectangle tempSelectionMaxRect;
    private SequenceListSelectionModel sequenceListSelectionModel;

    public AlignmentSelectionModel(AlignmentListModel sequenceListModel) {
        this.sequences = sequenceListModel;
        this.sequenceListSelectionModel = new SequenceListSelectionModel(this);
    }

    public SequenceListSelectionModel getSequenceListSelectionModel() {
        return this.sequenceListSelectionModel;
    }

    public ArrayList<Integer> getIndicesOfSequencesWithSelection() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (!this.sequences.get(n).hasSelection()) continue;
            indices.add(new Integer(n));
        }
        return indices;
    }

    public ArrayList<Integer> getIndicesOfSequencesWithAllSelected() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (!this.sequences.get(n).isAllSelected()) continue;
            indices.add(new Integer(n));
        }
        return indices;
    }

    public boolean isBaseSelected(int x, int y) {
        boolean isSel = this.sequences.get(y).isBaseSelected(x);
        return this.sequences.get(y).isBaseSelected(x);
    }

    public void selectSequenceWithIndex(int index) {
        this.setSequenceSelection(index, index);
    }

    public void selectSequencesWithIndex(List<Integer> listVals) {
        Integer[] array = listVals.toArray(new Integer[listVals.size()]);
        int[] intVals = ArrayUtils.toPrimitive(array, 0);
        this.selectSequencesWithIndex(intVals);
    }

    public void selectSequencesWithIndex(int[] selectedIndex) {
        ArrayList<Sequence> seqs = new ArrayList<Sequence>(selectedIndex.length);
        for (int index : selectedIndex) {
            seqs.add(this.sequences.get(index));
        }
        this.changeSelection(seqs, true);
    }

    public void setSelectionAt(int xPos, int yPos) {
        this.setSelectionAt(xPos, yPos, false);
    }

    public void setSelectionAt(int xPos, int yPos, boolean clearFirst) {
        this.changeSelection(xPos, yPos, xPos, yPos, clearFirst);
    }

    private void changeSelection(int x1, int y1, int x2, int y2, boolean clearFirst) {
        Rectangle newRect = new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
        logger.info("newRect" + newRect);
        Rectangle oldSelectRect = this.getSelectionBounds();
        for (int n = 0; n < this.sequences.size(); ++n) {
            if ((double)n >= newRect.getMinY() && (double)n <= newRect.getMaxY()) {
                this.sequences.get(n).setSelection(newRect.x, newRect.x + newRect.width, clearFirst);
                continue;
            }
            this.sequences.get(n).clearAllSelection();
        }
        if (clearFirst && oldSelectRect != null) {
            logger.info("newRect" + newRect);
            logger.info("oldRect" + oldSelectRect);
            if (!Utils.hasSameBounds(newRect, oldSelectRect)) {
                Rectangle both = Utils.addRects(oldSelectRect, newRect);
                this.fireSelectionChanged(both, false);
            }
        } else {
            this.fireSelectionChanged(newRect, false);
        }
    }

    public void setSequenceSelection(int index0, int index1) {
        this.changeSelection(index0, index1, true);
    }

    public void addSequenceSelection(int index0, int index1) {
        this.changeSelection(index0, index1, false);
    }

    public void removeSequenceSelection(int index0, int index1) {
        int minIndex = Math.min(index0, index1);
        int maxIndex = Math.max(index0, index1);
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (n < minIndex || n > maxIndex) continue;
            this.sequences.get(n).clearAllSelection();
        }
        this.fireSelectionChanged(0, this.sequences.size());
    }

    public void setSequenceSelection(List<Sequence> moreSeqs) {
        this.changeSelection(moreSeqs, true);
    }

    private void changeSelection(List<Sequence> toSelect, boolean clearFirst) {
        Rectangle oldSelect = this.getSelectionBounds();
        logger.info("toSelect.size()" + toSelect.size());
        for (Sequence seq : this.sequences) {
            if (toSelect.contains(seq)) {
                logger.debug("select" + seq);
                seq.selectAllBases();
                continue;
            }
            if (!clearFirst) continue;
            seq.clearAllSelection();
        }
        Rectangle newSelect = this.getSelectionBounds();
        logger.info("newSelect" + newSelect);
        Rectangle addedSelection = Utils.addRects(oldSelect, newSelect);
        if (addedSelection != null) {
            this.fireSelectionChanged(addedSelection, false);
        }
    }

    private void changeSelection(int index0, int index1, boolean clearFirst) {
        int minIndex = Math.min(index0, index1);
        int maxIndex = Math.max(index0, index1);
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (n >= minIndex && n <= maxIndex) {
                this.sequences.get(n).selectAllBases();
                continue;
            }
            if (!clearFirst) continue;
            this.sequences.get(n).clearAllSelection();
        }
        this.fireSelectionChanged(0, this.sequences.size());
    }

    public long getSelectionSize() {
        long size = 0L;
        for (Sequence sequence : this.sequences) {
            size += sequence.countSelectedPositions(0, sequence.getLength());
        }
        return size;
    }

    public Rectangle getSelectionBounds() {
        if (!this.hasSelection()) {
            return null;
        }
        Rectangle bounds = new Rectangle(this.getFirstSelectedPos());
        bounds.add(this.getLastSelectedPos());
        return bounds;
    }

    public List<Sequence> getSelectedSequences() {
        ArrayList<Sequence> selection = new ArrayList<Sequence>();
        for (Sequence sequence : this.sequences) {
            if (!sequence.hasSelection()) continue;
            selection.add(sequence);
        }
        return selection;
    }

    public List<Sequence> getUnSelectedSequences() {
        ArrayList<Sequence> selection = new ArrayList<Sequence>();
        for (Sequence sequence : this.sequences) {
            if (sequence.hasSelection()) continue;
            selection.add(sequence);
        }
        return selection;
    }

    public void selectBases(Sequence seq, Interval foundPos) {
        seq.setSelection(foundPos.startPos, foundPos.endPos, false);
        this.fireSelectionChanged(seq, true);
    }

    public void selectAllBasesUntilGapInThisSequence(Sequence sequence, int x) {
        sequence.selectAllBasesUntilGap(x);
        this.fireSelectionChanged(sequence, false);
    }

    public void selectSequences(List<Sequence> seqs) {
        this.changeSelection(seqs, true);
    }

    public String getSelectionAsNucleotides() {
        StringBuilder selection = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            if (sequence.getSelectedBasesAsString() == null || sequence.getSelectedBasesAsString().length() <= 0) continue;
            selection.append(sequence.getSelectedBasesAsString());
            selection.append(LF);
        }
        return selection.toString();
    }

    public String getFirstSelectedName() {
        String name = null;
        if (this.getFirstSelected() != null) {
            name = this.getFirstSelected().getName();
        }
        return name;
    }

    public List<Sequence> setFirstSelectedName(String newName) {
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        if (newName == null) {
            return editedSequences;
        }
        if (this.getFirstSelected() != null) {
            editedSequences.add(this.getFirstSelected().getCopy());
            this.getFirstSelected().setName(newName);
        }
        return editedSequences;
    }

    public Sequence getFirstSelected() {
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (!this.sequences.get(n).hasSelection()) continue;
            return this.sequences.get(n);
        }
        return null;
    }

    public boolean hasSelection() {
        long startTime = System.currentTimeMillis();
        for (Sequence sequence : this.sequences) {
            if (!sequence.hasSelection()) continue;
            return true;
        }
        long endTime = System.currentTimeMillis();
        logger.info("hasSelection false " + (endTime - startTime) + " milliseconds");
        return false;
    }

    public void selectAll() {
        for (Sequence seq : this.sequences) {
            seq.selectAllBases();
        }
        this.fireSelectionChangedAll();
    }

    public void selectionExtendRight() {
        if (!this.hasSelection()) {
            return;
        }
        Rectangle oldSelect = this.getSelectionBounds();
        for (Sequence seq : this.sequences) {
            seq.selectionExtendRight();
        }
        Rectangle newSelect = this.getSelectionBounds();
        newSelect.add(oldSelect);
        this.fireSelectionChanged(newSelect, false);
    }

    public void selectionExtendLeft() {
        if (!this.hasSelection()) {
            return;
        }
        Rectangle oldSelect = this.getSelectionBounds();
        for (Sequence seq : this.sequences) {
            seq.selectionExtendLeft();
        }
        Rectangle newSelect = this.getSelectionBounds();
        newSelect.add(oldSelect);
        this.fireSelectionChanged(newSelect, false);
    }

    public void selectionExtendDown() {
        if (!this.hasSelection()) {
            return;
        }
        Rectangle oldSelect = this.getSelectionBounds();
        for (int n = 0; n < this.sequences.size() - 1; ++n) {
            int[] selected;
            Sequence seq = this.sequences.get(n);
            if (!seq.hasSelection()) continue;
            for (int index : selected = seq.getSelectedPositions()) {
                this.sequences.get(n + 1).setSelection(index, index, false);
            }
        }
        Rectangle newSelect = this.getSelectionBounds();
        newSelect.add(oldSelect);
        this.fireSelectionChanged(newSelect, false);
    }

    public void selectionExtendTop() {
        if (!this.hasSelection()) {
            return;
        }
        Rectangle oldSelect = this.getSelectionBounds();
        for (int n = this.sequences.size() - 1; n > 0; --n) {
            int[] selected;
            Sequence seq = this.sequences.get(n);
            if (!seq.hasSelection()) continue;
            for (int index : selected = seq.getSelectedPositions()) {
                this.sequences.get(n - 1).setSelection(index, index, false);
            }
        }
        Rectangle newSelect = this.getSelectionBounds();
        newSelect.add(oldSelect);
        this.fireSelectionChanged(newSelect, false);
    }

    public void invertSelection() {
        for (Sequence seq : this.sequences) {
            seq.invertSelection();
        }
        this.fireSelectionChangedAll();
    }

    public void copySelectionFromInto(int indexFrom, int indexTo) {
        Sequence seqFrom = this.sequences.get(indexFrom);
        Sequence seqTo = this.sequences.get(indexTo);
        for (int x = 0; x < seqFrom.getLength() || x < seqTo.getLength(); ++x) {
            if (seqFrom.isBaseSelected(x)) {
                seqTo.setSelectionAt(x);
                continue;
            }
            seqTo.clearSelectionAt(x);
        }
        this.fireSelectionChanged(indexFrom, indexTo, false);
    }

    public void selectColumn(int columnIndex) {
        for (Sequence seq : this.sequences) {
            seq.setSelectionAt(columnIndex);
        }
        this.fireSelectionChanged(new Rectangle(columnIndex, 0, columnIndex, this.sequences.size()), false);
    }

    public void selectColumns(List<Integer> columns) {
        int maxIndex = 0;
        int minIndex = this.sequences.getLongestSequenceLength();
        for (Integer col : columns) {
            maxIndex = Math.max(maxIndex, col);
            minIndex = Math.min(minIndex, col);
            for (Sequence seq : this.sequences) {
                seq.setSelectionAt(col);
            }
        }
        this.fireSelectionChanged(new Rectangle(minIndex, 0, maxIndex, this.sequences.size()), false);
    }

    public void clearColumnSelection(int columnIndex) {
        for (Sequence seq : this.sequences) {
            seq.clearSelectionAt(columnIndex);
        }
        this.fireSelectionChanged(new Rectangle(columnIndex, 0, 0, this.sequences.size()), false);
    }

    public void copySelectionFromPosX1toX2(int x1, int x2) {
        for (Sequence seq : this.sequences) {
            if (seq.isBaseSelected(x1)) {
                seq.setSelectionAt(x2);
                continue;
            }
            seq.clearSelectionAt(x2);
        }
        this.fireSelectionChanged(new Rectangle(x1, 0, x2, this.sequences.size()), false);
    }

    public Point getFirstSelectedPos() {
        int n = this.getFirstSelectedSequenceIndex();
        if (n != -1) {
            return new Point(this.sequences.get(n).getFirstSelectedPosition(), n);
        }
        return null;
    }

    public int getFirstSelectedSequenceIndex() {
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (!this.sequences.get(n).hasSelection()) continue;
            return n;
        }
        return -1;
    }

    public int getLastSelectedSequenceIndex() {
        for (int n = this.sequences.size() - 1; n >= 0; --n) {
            if (!this.sequences.get(n).hasSelection()) continue;
            return n;
        }
        return -1;
    }

    public Point getLastSelectedPos() {
        int n = this.getLastSelectedSequenceIndex();
        if (n != -1) {
            return new Point(this.sequences.get(n).getLastSelectedPosition(), n);
        }
        return null;
    }

    public Point getFirstSelectedUngapedPos() {
        for (int n = 0; n < this.sequences.size(); ++n) {
            if (!this.sequences.get(n).hasSelection()) continue;
            Sequence firstSelected = this.sequences.get(n);
            int position = firstSelected.getFirstSelectedPosition();
            int ungaped = firstSelected.getUngapedPos(position);
            return new Point(ungaped, n);
        }
        return null;
    }

    public void setSelectionWithin(Rectangle bounds) {
        this.changeSelection(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, true);
    }

    public boolean hasFullySelectedSequences() {
        for (Sequence seq : this.sequences) {
            if (!seq.isAllSelected()) continue;
            return true;
        }
        return false;
    }

    public int getSelectedColumnCount() {
        BitSet colSelect = new BitSet();
        for (Sequence seq : this.sequences) {
            int[] allSelected;
            if (!seq.hasSelection()) continue;
            for (int nextInt : allSelected = seq.getSelectedPositions()) {
                colSelect.set(nextInt);
            }
        }
        return colSelect.cardinality();
    }

    public int getSelectedSequencesCount() {
        int count = 0;
        for (Sequence seq : this.sequences) {
            if (!seq.hasSelection()) continue;
            ++count;
        }
        return count;
    }

    public String getSelectionNames() {
        String names = "";
        for (Sequence seq : this.sequences) {
            if (!seq.hasSelection()) continue;
            names = names + seq.getName() + LF;
        }
        if (names.length() > 0) {
            names = StringUtils.removeEnd(names, LF);
        }
        return names;
    }

    public int getFirstSelectedWholeColumn() {
        Point pos = this.getFirstSelectedPos();
        if (pos == null) {
            return -1;
        }
        for (Sequence seq : this.sequences) {
            if (seq.getLength() <= pos.x || seq.hasSelection()) continue;
            return -1;
        }
        return pos.x;
    }

    public int getLastSelectedWholeColumn() {
        Point pos = this.getLastSelectedPos();
        if (pos == null) {
            return -1;
        }
        for (Sequence seq : this.sequences) {
            if (seq.getLength() <= pos.x || seq.hasSelection()) continue;
            return -1;
        }
        return pos.x;
    }

    public void clearAllSelectionInSequenceWithIndex(int index) {
        this.sequences.get(index).clearAllSelection();
        this.fireSelectionChanged(index, index);
    }

    public void clearSequenceSelection() {
        Rectangle oldSelectRectangle = this.getSelectionBounds();
        for (Sequence seq : this.sequences) {
            seq.clearAllSelection();
        }
        if (oldSelectRectangle != null) {
            this.fireSelectionChanged(oldSelectRectangle, false);
        }
    }

    public void addAlignmentSelectionListener(AlignmentSelectionListener l) {
        this.listenerList.add(AlignmentSelectionListener.class, l);
    }

    public void removeSequenceListSelectionListener(AlignmentSelectionListener l) {
        this.listenerList.remove(AlignmentSelectionListener.class, l);
    }

    public AlignmentSelectionListener[] getAlignmentSelectionListeners() {
        return (AlignmentSelectionListener[])this.listenerList.getListeners(AlignmentSelectionListener.class);
    }

    protected void fireSelectionChanged(int firstIndex, int lastIndex) {
        this.fireSelectionChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireSelectionChangedAll() {
        this.fireSelectionChanged(0, this.sequences.size(), this.getValueIsAdjusting());
    }

    private boolean getValueIsAdjusting() {
        return false;
    }

    protected void fireSelectionChanged(int index0, int index1, boolean isAdjusting) {
        Rectangle rect = new Rectangle(0, Math.min(index0, index1), this.sequences.getLongestSequenceLength(), Math.abs(index0 - index1));
        this.fireSelectionChanged(rect, isAdjusting);
    }

    private void fireSelectionChanged(Sequence sequence, boolean isAdjusting) {
        int index = this.sequences.indexOf(sequence);
        this.fireSelectionChanged(index, index, isAdjusting);
    }

    private void fireSelectionChanged(Rectangle rect, boolean isAdjusting) {
        logger.info("fire Selection changed + rect" + rect);
        Object[] listeners = this.listenerList.getListenerList();
        AlignmentSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AlignmentSelectionListener.class) continue;
            if (e == null) {
                e = new AlignmentSelectionEvent(this, rect, isAdjusting);
            }
            ((AlignmentSelectionListener)listeners[i + 1]).selectionChanged(e);
        }
        if (AliView.getActiveWindow() != null) {
            logger.info("Time from last endTim " + (System.currentTimeMillis() - AliView.getActiveWindow().getLastPaneEndTime()) + " milliseconds");
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void setTempSelection(Rectangle newSelectRect) {
        if (this.tempSelectionRect == null || this.tempSelectionRect.equals(newSelectRect)) {
            // empty if block
        }
        if (this.tempSelectionRect == null) {
            this.tempSelectionMaxRect = this.tempSelectionRect = newSelectRect;
        } else {
            this.tempSelectionRect = newSelectRect;
            this.tempSelectionMaxRect.add(this.tempSelectionRect);
            this.fireSelectionChanged(this.tempSelectionMaxRect, false);
        }
    }

    public Rectangle getTempSelection() {
        return this.tempSelectionRect;
    }

    public void clearTempSelection() {
        this.tempSelectionRect = null;
    }

    public boolean isSequenceAtLeastPartlyAffectedByTempSelection(int index) {
        if (this.tempSelectionRect == null) {
            return false;
        }
        return (double)index >= this.tempSelectionRect.getMinY() && (double)index <= this.tempSelectionRect.getMaxY();
    }

    public boolean isSequenceAtLeastPartlySelected(int index) {
        if (!this.sequences.rangeCheck(0, index)) {
            return false;
        }
        if (this.isSequenceAtLeastPartlyAffectedByTempSelection(index)) {
            return true;
        }
        return this.sequences.get(index).hasSelection();
    }

    public void translateSelection(AlignmentMeta aliMeta) {
        for (Sequence seq : this.sequences) {
            if (!seq.hasSelection() || seq.isAllSelected()) continue;
            int[] selection = seq.getSelectedPositions();
            int[] translated = aliMeta.translatePositions(selection);
            seq.clearAllSelection();
            for (int pos : translated) {
                seq.setSelectionAt(pos);
            }
        }
        this.fireSelectionChangedAll();
    }

    public void reTranslateSelection(AlignmentMeta aliMeta) {
        for (Sequence seq : this.sequences) {
            if (!seq.hasSelection() || seq.isAllSelected()) continue;
            int[] selection = seq.getSelectedPositions();
            int[] translated = aliMeta.reTranslatePositions(selection);
            seq.clearAllSelection();
            for (int pos : translated) {
                seq.setSelectionAt(pos);
            }
        }
        this.fireSelectionChangedAll();
    }
}

