/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FindObject {
    private static final Logger logger = Logger.getLogger(FindObject.class);
    String searchTerm;
    int nextFindSeqNumber;
    int nextFindStartPos;
    private int position;
    private int seqIndex;
    private boolean isFound;
    private List<Integer> foundIndices = new ArrayList<Integer>();
    private boolean findAll;
    private Point foundPos;
    private boolean findInNames;

    public FindObject(String searchTerm) {
        this(searchTerm, false);
    }

    public FindObject(String searchTerm, boolean findAll) {
        this.searchTerm = searchTerm;
        this.findAll = findAll;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public int getNextFindSeqNumber() {
        return this.nextFindSeqNumber;
    }

    public void setNextFindSeqNumber(int nextFindSeqNumber) {
        this.nextFindSeqNumber = nextFindSeqNumber;
    }

    public void setFoundPos(int position, int sequenceIndex) {
        this.foundPos = new Point(position, sequenceIndex);
    }

    public Point getFoundPos() {
        return this.foundPos;
    }

    public int getNextFindStartPos() {
        return this.nextFindStartPos;
    }

    public void setNextFindStartPos(int pos) {
        this.nextFindStartPos = pos;
    }

    public void setIsFound(boolean isFound) {
        this.isFound = isFound;
    }

    public boolean isFound() {
        return this.isFound;
    }

    public String getRegexSearchTerm() {
        String regex = "";
        for (int n = 0; n < this.searchTerm.length(); ++n) {
            regex = regex + this.searchTerm.charAt(n);
            regex = regex + "\\-*";
        }
        return regex;
    }

    public List<Integer> getFoundIndices() {
        return this.foundIndices;
    }

    public void setFindAll(boolean b) {
        this.findAll = b;
    }

    public boolean isFindAll() {
        return this.findAll;
    }

    public void addFoundNameIndex(int n) {
        this.foundIndices.add(n);
    }

    public void setFoundNameIndex(int n) {
        this.foundIndices.clear();
        this.foundIndices.add(n);
    }

    public int getNextNameFindIndex() {
        logger.info(this.foundIndices.size());
        if (this.foundIndices.isEmpty()) {
            return 0;
        }
        int lastFound = this.foundIndices.get(this.foundIndices.size() - 1);
        return lastFound + 1;
    }

    public void clearIndices() {
        this.foundIndices.clear();
    }

    public boolean findNextInNames() {
        return this.findInNames;
    }

    public boolean findNextInSequences() {
        return !this.findInNames;
    }

    public void setFindNextInNames(boolean b) {
        this.findInNames = b;
    }

    public void setFindNextInSequences(boolean b) {
        this.findInNames = !b;
    }
}

