/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.sequencelist.SequenceJList;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class MyDropTarget
extends DropTarget {
    private static final Logger logger = Logger.getLogger(SequenceJList.class);

    public MyDropTarget() {
        logger.info("Create MyDT");
    }

    @Override
    protected void initializeAutoscrolling(Point p) {
        logger.info("this.getComponent() instanceof Autoscroll" + (this.getComponent() instanceof Autoscroll));
        System.out.println("init Autoscrolling");
        super.initializeAutoscrolling(p);
    }

    @Override
    protected DropTarget.DropTargetAutoScroller createDropTargetAutoScroller(Component c, Point p) {
        logger.info("Create MyDT Autoscroll");
        return new MyDropTargetAutoScroller(c, p);
    }

    protected static class MyDropTargetAutoScroller
    extends DropTarget.DropTargetAutoScroller {
        private Window window;
        private Canvas canvas;
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Point screenLocation;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected MyDropTargetAutoScroller(Component c, Point p) {
            super(c, p);
            super.stop();
            System.out.println("Created Autoscroller");
            this.component = c;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit t = Toolkit.getDefaultToolkit();
            Integer initial = new Integer(100);
            Integer interval = new Integer(100);
            try {
                initial = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interval = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(interval, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(initial);
            this.locn = p;
            this.prev = p;
            this.screenLocation = new Point(p);
            SwingUtilities.convertPointToScreen(this.screenLocation, c);
            try {
                this.hysteresis = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer.start();
        }

        private void updateRegion() {
            Insets i = this.autoScroll.getAutoscrollInsets();
            Dimension size = this.component.getSize();
            if (size.width != this.outer.width || size.height != this.outer.height) {
                this.outer.reshape(0, 0, size.width, size.height);
            }
            if (this.inner.x != i.left || this.inner.y != i.top) {
                this.inner.setLocation(i.left, i.top);
            }
            int newWidth = size.width - (i.left + i.right);
            int newHeight = size.height - (i.top + i.bottom);
            if (newWidth != this.inner.width || newHeight != this.inner.height) {
                this.inner.setSize(newWidth, newHeight);
            }
        }

        @Override
        protected synchronized void updateLocation(Point newLocn) {
            this.prev = this.locn;
            this.locn = newLocn;
            this.screenLocation = new Point(this.locn);
            SwingUtilities.convertPointToScreen(this.screenLocation, this.component);
            if (Math.abs(this.locn.x - this.prev.x) > this.hysteresis || Math.abs(this.locn.y - this.prev.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        @Override
        protected void stop() {
            this.timer.stop();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            Point componentLocation = new Point(this.screenLocation);
            SwingUtilities.convertPointFromScreen(componentLocation, this.component);
            this.autoScroll.autoscroll(componentLocation);
        }
    }
}

