/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import javax.swing.Timer;

public class MyOtherDropTarget
extends DropTarget {
    @Override
    protected DropTarget.DropTargetAutoScroller createDropTargetAutoScroller(Component c, Point p) {
        return new MyOtherDropTargetAutoScroller(c, p);
    }

    protected static class MyOtherDropTargetAutoScroller
    extends DropTarget.DropTargetAutoScroller {
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected MyOtherDropTargetAutoScroller(Component c, Point p) {
            super(c, p);
            this.component = c;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit t = Toolkit.getDefaultToolkit();
            Integer initial = 100;
            Integer interval = 100;
            try {
                initial = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interval = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(interval, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(initial);
            this.locn = p;
            this.prev = p;
            try {
                this.hysteresis = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer.start();
        }

        private void updateRegion() {
            Insets i = this.autoScroll.getAutoscrollInsets();
            Dimension size = this.component.getSize();
            if (size.width != this.outer.width || size.height != this.outer.height) {
                this.outer.reshape(0, 0, size.width, size.height);
            }
            if (this.inner.x != i.left || this.inner.y != i.top) {
                this.inner.setLocation(i.left, i.top);
            }
            int newWidth = size.width - (i.left + i.right);
            int newHeight = size.height - (i.top + i.bottom);
            if (newWidth != this.inner.width || newHeight != this.inner.height) {
                this.inner.setSize(newWidth, newHeight);
            }
        }

        @Override
        protected synchronized void updateLocation(Point newLocn) {
            this.prev = this.locn;
            this.locn = newLocn;
            if (Math.abs(this.locn.x - this.prev.x) > this.hysteresis || Math.abs(this.locn.y - this.prev.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        @Override
        protected void stop() {
            this.timer.stop();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            this.updateRegion();
            if (this.outer.contains(this.locn) && !this.inner.contains(this.locn)) {
                this.autoScroll.autoscroll(this.locn);
            }
        }
    }
}

