/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AliViewWindow;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.FasterTextCellRenderer;
import aliview.sequencelist.MyDropTarget;
import aliview.sequencelist.SequenceTransferHandler;
import aliview.settings.Settings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.util.TooManyListenersException;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicListUI;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class SequenceJList
extends JList
implements Autoscroll {
    private static final Logger logger = Logger.getLogger(SequenceJList.class);
    private static final int MIN_CHAR_SIZE = 2;
    private static final int MAX_CHAR_SIZE = 100;
    private double charHeight;
    private ListCellRenderer storedCellRenderer;
    private BasicListUI builist;
    private JScrollPane alignmentScrollPane;
    private JScrollPane listScrollPane;

    public SequenceJList(AlignmentListModel model, double charHeight, AliViewWindow aliWindow) {
        super(model);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new SequenceTransferHandler(aliWindow));
        DropTarget original = this.getDropTarget();
        MyDropTarget myDropTarget = new MyDropTarget();
        try {
            myDropTarget.addDropTargetListener(original);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        this.setDropTarget(myDropTarget);
        this.setDragEnabled(true);
        this.setSelectionModel(model.getAlignmentSelectionModel().getSequenceListSelectionModel());
        this.setCharSize(charHeight);
        this.setCellRenderer(new FasterTextCellRenderer());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        InputMap map = this.getInputMap();
        map.put(OSNativeUtils.getPasteKeyAccelerator(), "null");
        map.put(OSNativeUtils.getCopyKeyAccelerator(), "null");
        map.put(OSNativeUtils.getCopySelectionAsFastaKeyAccelerator(), "null");
        map.put(OSNativeUtils.getMoveSelectionUpKeyAccelerator(), "null");
        map.put(OSNativeUtils.getMoveSelectionDownKeyAccelerator(), "null");
        map.put(OSNativeUtils.getIncreaseFontSizeKeyAccelerator(), "null");
        map.put(OSNativeUtils.getDecreaseFontSizeKeyAccelerator(), "null");
    }

    public AlignmentListModel getModel() {
        return (AlignmentListModel)super.getModel();
    }

    public void setModel(AlignmentListModel model) {
        super.setModel(model);
    }

    @Override
    public void paintComponent(Graphics g) {
        long startTime = System.currentTimeMillis();
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g);
        long endTime = System.currentTimeMillis();
        logger.info("Draw JList took " + (endTime - startTime) + " milliseconds");
    }

    @Override
    public void validate() {
        long startTime = System.currentTimeMillis();
        super.validate();
        long endTime = System.currentTimeMillis();
        this.synchAlignmentScrollPane();
        logger.info("Validate JList took " + (endTime - startTime) + " milliseconds");
    }

    private void synchAlignmentScrollPane() {
        logger.info("synch ScrollPanes");
        JScrollPane source = this.listScrollPane;
        JScrollPane dest = this.alignmentScrollPane;
        Point viewPos = new Point(dest.getViewport().getViewPosition().x, source.getViewport().getViewPosition().y);
        dest.getViewport().setViewPosition(viewPos);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return super.getPreferredScrollableViewportSize();
    }

    public void setCharSize(double charHeight) {
        this.charHeight = charHeight;
        float listFontSize = (int)(charHeight - 1.0);
        if (listFontSize > 13.0f && !Settings.getUseCustomFontSize().getBooleanValue()) {
            listFontSize = 13.0f;
        }
        this.updateCharSize(listFontSize);
    }

    @Override
    public void revalidate() {
        super.revalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    private void updateCharSize(float listFontSize) {
        this.setFixedCellHeight((int)this.charHeight);
        this.setFixedCellWidth(this.getModel().getLongestSequenceName() * (int)this.charHeight);
        this.setFont(this.getFont().deriveFont(listFontSize));
        if (this.charHeight < 3.0 && this.getCellRenderer() != null) {
            this.storedCellRenderer = this.getCellRenderer();
            this.setCellRenderer(null);
        } else if (this.charHeight >= 3.0 && this.getCellRenderer() == null) {
            this.setCellRenderer(this.storedCellRenderer);
        }
    }

    public void moveSelectedSequencesTo(int index) {
        this.getModel().moveSelectedSequencesTo(index);
    }

    public void addSynchPanes(JScrollPane listScrollPane, JScrollPane alignmentScrollPane) {
        this.listScrollPane = listScrollPane;
        this.alignmentScrollPane = alignmentScrollPane;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return new Insets(2, 100, 2, 100);
    }

    @Override
    public void autoscroll(Point cursor) {
        Rectangle visiRect = this.getVisibleRect();
        int topDist = cursor.y - visiRect.y;
        int bottomDist = visiRect.y + visiRect.height - cursor.y;
        int scrollSpeed = 0;
        if (topDist < 20) {
            scrollSpeed = -1;
        }
        if (topDist < 15) {
            scrollSpeed = -2;
        }
        if (topDist < 10) {
            scrollSpeed = -3;
        }
        if (topDist < 5) {
            scrollSpeed = -4;
        }
        if (topDist < 2) {
            scrollSpeed = -5;
        }
        if (bottomDist < 20) {
            scrollSpeed = 1;
        }
        if (bottomDist < 15) {
            scrollSpeed = 2;
        }
        if (bottomDist < 10) {
            scrollSpeed = 3;
        }
        if (bottomDist < 5) {
            scrollSpeed = 4;
        }
        if (bottomDist < 2) {
            scrollSpeed = 5;
        }
        if (scrollSpeed > 0) {
            int lastVisible = this.getLastVisibleIndex();
            this.ensureIndexIsVisible(lastVisible + scrollSpeed);
        }
        if (scrollSpeed < 0) {
            int firstVisible = this.getFirstVisibleIndex();
            this.ensureIndexIsVisible(firstVisible + scrollSpeed);
        }
    }

    public Point getFirstSelectedCellPos() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return new Point(0, 0);
        }
        Point pos = this.indexToLocation(index);
        SwingUtilities.convertPointToScreen(pos, this);
        return pos;
    }
}

