/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AliViewWindow;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JList;
import org.apache.log4j.Logger;

public class SequenceListMouseListener
implements MouseListener,
MouseMotionListener {
    private static final Logger logger = Logger.getLogger(SequenceListMouseListener.class);
    private int startIndex = -1;
    private long lastReleaseTime;
    private int lastReleaseIndex;
    private long minReleaseInterval = 500L;
    private long maxReleaseInterval = 2000L;
    private AliViewWindow aliWin;

    public SequenceListMouseListener(AliViewWindow aliWin) {
        this.aliWin = aliWin;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int clickIndex;
        logger.info("mousePressed");
        if (e.isAltDown() || e.isControlDown() || e.isShiftDown() || e.isMetaDown()) {
            return;
        }
        JList list = (JList)e.getSource();
        if (list.isSelectedIndex(clickIndex = list.locationToIndex(e.getPoint()))) {
            return;
        }
        list.setSelectedIndex(clickIndex);
        this.startIndex = clickIndex;
        list.requestFocus();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        logger.info("mouseReleased");
        if (e.getButton() != 1) {
            return;
        }
        if (this.isRenameTrigger(e)) {
            this.aliWin.renameFirstSelected();
            e.consume();
        }
        if (this.startIndex != -1) {
            this.startIndex = -1;
            e.consume();
        }
    }

    private boolean isRenameTrigger(MouseEvent e) {
        long timeBetweenReleases;
        long releaseTime = e.getWhen();
        JList list = (JList)e.getSource();
        int releaseIndex = list.locationToIndex(e.getPoint());
        boolean isRenameTrigger = false;
        if (this.lastReleaseIndex == releaseIndex && list.isSelectedIndex(releaseIndex) && (timeBetweenReleases = releaseTime - this.lastReleaseTime) > this.minReleaseInterval && timeBetweenReleases < this.maxReleaseInterval) {
            isRenameTrigger = true;
        }
        this.lastReleaseIndex = releaseIndex;
        this.lastReleaseTime = releaseTime;
        return isRenameTrigger;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        logger.info("mousePressed");
        if (this.startIndex == -1) {
            return;
        }
        if (e.isAltDown() || e.isControlDown() || e.isShiftDown() || e.isMetaDown()) {
            return;
        }
        JList list = (JList)e.getSource();
        int pointerIndex = list.locationToIndex(e.getPoint());
        logger.info(pointerIndex);
        list.getSelectionModel().setSelectionInterval(this.startIndex, pointerIndex);
        list.ensureIndexIsVisible(pointerIndex);
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

