/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AliView;
import aliview.AliViewWindow;
import aliview.settings.Settings;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JList;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class SequenceListMouseWheelListener
implements MouseWheelListener {
    private static final Logger logger = Logger.getLogger(SequenceListMouseWheelListener.class);
    private AliViewWindow aliViewWin;

    public SequenceListMouseWheelListener(AliViewWindow aliViewWindow) {
        this.aliViewWin = aliViewWindow;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getModifiersEx() == OSNativeUtils.getMouseWheelZoomModifierMask()) {
            if (e.getWheelRotation() > 0) {
                AliView.getActiveWindow().zoomOutAt(e.getPoint());
            } else if (e.getWheelRotation() < 0) {
                AliView.getActiveWindow().zoomInAt(e.getPoint());
            }
            return;
        }
        int wheelRotation = e.getWheelRotation();
        if (this.aliViewWin.isReverseVerticalRotation()) {
            wheelRotation *= -1;
        }
        JList list = (JList)e.getSource();
        if (wheelRotation > 0) {
            Rectangle preferedVisible = list.getVisibleRect();
            preferedVisible.setLocation(preferedVisible.x, (int)((double)preferedVisible.y + (double)Settings.getVerticalScrollModifier().getIntValue() / 200.0 * preferedVisible.getHeight()));
            list.scrollRectToVisible(preferedVisible);
            return;
        }
        if (wheelRotation < 0) {
            Rectangle preferedVisible = list.getVisibleRect();
            preferedVisible.setLocation(preferedVisible.x, (int)((double)preferedVisible.y - (double)Settings.getVerticalScrollModifier().getIntValue() / 200.0 * preferedVisible.getHeight()));
            list.scrollRectToVisible(preferedVisible);
        }
    }
}

