/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.sequences.SequenceSelectionModel;
import java.util.BitSet;
import org.apache.log4j.Logger;

public class DefaultSequenceSelectionModel
implements SequenceSelectionModel {
    private static final Logger logger = Logger.getLogger(DefaultSequenceSelectionModel.class);
    BitSet bitSelection;
    boolean allSelected;

    @Override
    public boolean isSelected(int n) {
        if (this.allSelected) {
            return true;
        }
        if (this.bitSelection == null) {
            return false;
        }
        return this.bitSelection.get(n);
    }

    private BitSet createNewSelection() {
        this.allSelected = false;
        return new BitSet();
    }

    @Override
    public void clearAll() {
        this.bitSelection = null;
        this.allSelected = false;
    }

    @Override
    public void selectAll() {
        this.clearAll();
        this.allSelected = true;
    }

    @Override
    public int getFirstSelectedPosition() {
        if (this.allSelected) {
            return 0;
        }
        if (this.bitSelection == null) {
            return -1;
        }
        return this.bitSelection.nextSetBit(0);
    }

    @Override
    public int getLastSelectedPosition(int seqLength) {
        if (this.allSelected) {
            return seqLength - 1;
        }
        if (this.bitSelection == null) {
            return -1;
        }
        return this.bitSelection.length() - 1;
    }

    @Override
    public boolean hasSelection() {
        if (this.allSelected) {
            return true;
        }
        if (this.bitSelection == null) {
            return false;
        }
        return !this.bitSelection.isEmpty();
    }

    @Override
    public int[] getSelectedPositions(int startIndex, int endIndex) {
        if (this.allSelected) {
            int[] pos = new int[endIndex - startIndex + 1];
            for (int n = 0; n < pos.length; ++n) {
                pos[n] = n;
            }
            return pos;
        }
        if (this.bitSelection == null) {
            return new int[0];
        }
        int[] pos = new int[this.countSelectedPositions(startIndex, endIndex)];
        int index = 0;
        int i = this.bitSelection.nextSetBit(startIndex);
        while (i >= 0 && i <= endIndex) {
            pos[index] = i;
            ++index;
            i = this.bitSelection.nextSetBit(i + 1);
        }
        return pos;
    }

    @Override
    public int countPositionsUntilSelectedCount(int selectedCount) {
        if (this.allSelected) {
            return selectedCount - 1;
        }
        if (this.bitSelection == null) {
            logger.info("no bit selection");
            return -1;
        }
        int index = -1;
        int nCount = 0;
        int i = this.bitSelection.nextSetBit(0);
        while (i >= 0 && i <= this.bitSelection.length()) {
            if (++nCount == selectedCount) {
                index = i;
                break;
            }
            i = this.bitSelection.nextSetBit(i + 1);
        }
        return index;
    }

    @Override
    public int countSelectedPositions(int startIndex, int endIndex) {
        if (this.allSelected) {
            return endIndex - startIndex + 1;
        }
        if (this.bitSelection == null) {
            return 0;
        }
        int nCount = 0;
        int i = this.bitSelection.nextSetBit(startIndex);
        while (i >= 0 && i <= endIndex) {
            ++nCount;
            i = this.bitSelection.nextSetBit(i + 1);
        }
        return nCount;
    }

    @Override
    public void clearSelectionAt(int n) {
        this.clearSelection(n, n, false);
    }

    @Override
    public void clearSelection(int startIndex, int endIndex, boolean clearFirst) {
        if (clearFirst) {
            this.clearAll();
        }
        if (this.bitSelection == null) {
            return;
        }
        this.bitSelection.set(startIndex, endIndex + 1, false);
    }

    @Override
    public void setSelectionAt(int n) {
        this.setSelection(n, n, false);
    }

    @Override
    public void setSelection(int startIndex, int endIndex, boolean clearFirst) {
        if (clearFirst) {
            this.clearAll();
        }
        if (this.bitSelection == null) {
            this.bitSelection = this.createNewSelection();
        }
        this.bitSelection.set(startIndex, endIndex + 1, true);
    }

    @Override
    public void rightPad(int length) {
    }

    @Override
    public void leftPad(int length) {
        if (this.hasSelection() && !this.allSelected) {
            for (int n = 0; n < length; ++n) {
                this.insertNewPosAt(0);
            }
        }
    }

    @Override
    public void removePosition(int index) {
        if (this.hasSelection() && !this.allSelected) {
            for (int n = index; n < this.bitSelection.length(); ++n) {
                this.bitSelection.set(n, this.bitSelection.get(n + 1));
            }
        }
    }

    @Override
    public void insertNewPosAt(int index) {
        if (this.hasSelection() && !this.allSelected) {
            for (int n = this.bitSelection.length(); n >= index; --n) {
                this.bitSelection.set(n + 1, this.bitSelection.get(n));
            }
            this.bitSelection.set(index, false);
        }
    }

    @Override
    public boolean isAllSelected() {
        return this.allSelected;
    }

    @Override
    public void invertSelection(int length) {
        if (this.allSelected) {
            this.clearAll();
        } else if (!this.hasSelection()) {
            this.selectAll();
        }
        if (this.hasSelection() && !this.allSelected) {
            logger.info("partial");
            this.bitSelection.flip(0, length);
        }
    }
}

