/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.sequencelist.Interval;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.BasicSequence;
import aliview.sequences.FileSequenceBases;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FileSequence
extends BasicSequence {
    private static final Logger logger = Logger.getLogger(FileSequence.class);

    public FileSequence(MemoryMappedSequencesFile sequencesFile, long startPointer) {
        this(new FileSequenceBases(sequencesFile, startPointer));
    }

    public FileSequence(FileSequenceBases fileSequenceBases) {
        super(fileSequenceBases);
    }

    public FileSequence(FileSequence template) {
        super(template);
    }

    public FileSequence(MemoryMappedSequencesFile sequencesFile, int seqIndex, String name, int seqWithoutWhitespaceLength, long seqAfterNameStartPointer, long endPointer, int lineCharLength, int lineAbsoluteLength) {
        this(new FileSequenceBases(sequencesFile, seqAfterNameStartPointer, endPointer, seqAfterNameStartPointer));
        this.name = name;
    }

    @Override
    public FileSequence getCopy() {
        return new FileSequence(this);
    }

    public long getEndPointer() {
        return this.getFileSequenceBases().getEndPointer();
    }

    public void setEndPointer(long pointer) {
        this.getFileSequenceBases().setEndPointer(pointer);
    }

    public void setSequenceAfterNameStartPointer(long pointer) {
        this.getFileSequenceBases().setSequenceAfterNameStartPointer(pointer);
    }

    public long getSequenceAfterNameStartPointer() {
        return this.getFileSequenceBases().getSequenceAfterNameStartPointer();
    }

    private FileSequenceBases getFileSequenceBases() {
        return (FileSequenceBases)this.bases;
    }

    @Override
    public byte getBaseAtPos(int n) {
        return this.getBases().get(n);
    }

    public int getBaseAsIntAtPos(int n) {
        return this.getBases().get(n);
    }

    @Override
    public byte[] getAllBasesAsByteArray() {
        return this.getBases().toByteArray();
    }

    @Override
    public void writeBases(OutputStream out) throws IOException {
        for (int n = 0; n < this.getLength(); ++n) {
            int base = this.getBaseAsIntAtPos(n);
            if (base == 32 || base == 10 || base == 13) continue;
            out.write(base);
        }
    }

    @Override
    public void writeBases(Writer out) throws IOException {
        for (int n = 0; n < this.getLength(); ++n) {
            int base = this.getBaseAsIntAtPos(n);
            if (base == 32 || base == 10 || base == 13) continue;
            out.write((char)base);
        }
    }

    @Override
    public Interval find(Pattern pattern, int startPos) {
        Interval foundInterval = null;
        int buffSize = 5000000;
        for (int buffStart = startPos; buffStart < this.getLength(); buffStart += buffSize) {
            StringBuilder buff = new StringBuilder();
            for (int n = buffStart; n < this.getLength() && n < buffStart + buffSize; ++n) {
                byte next = (byte)this.getBaseAsIntAtPos(n);
                if (next == 0) continue;
                buff.append((char)next);
            }
            Matcher matcher = pattern.matcher(buff);
            boolean wasFound = matcher.find(0);
            if (!wasFound) continue;
            int foundStart = matcher.start();
            int foundEnd = matcher.end() - 1;
            foundInterval = new Interval(foundStart + buffStart, foundEnd + buffStart);
        }
        return foundInterval;
    }

    @Override
    public void reverseComplement() {
    }

    @Override
    public void complement() {
    }

    @Override
    public void replaceBases(int startReplaceIndex, int stopReplaceIndex, byte[] insertBases) {
    }

    @Override
    public void replaceSelectedBasesWithGap() {
    }

    @Override
    public void deleteSelectedBases() {
    }

    @Override
    public void deleteBasesFromMask(boolean[] deleteMask) {
    }

    @Override
    public void clearBase(int n) {
    }

    @Override
    public void rightPadSequenceWithGaps(int diffLen) {
    }

    @Override
    public void leftPadSequenceWithGaps(int diffLen) {
    }

    public void setSelectionOffset(int selectionOffset) {
    }

    public void moveSelectedResiduesRightIfGapIsPresent() {
    }

    @Override
    public void moveSelectedResiduesLeftIfGapIsPresent() {
    }

    @Override
    public void moveSelectedResiduesRightIfGapOrEndIsPresent() {
    }

    @Override
    public boolean isGapOrEndRightOfSelection() {
        return false;
    }

    @Override
    public boolean isGapRightOfSelection() {
        return false;
    }

    @Override
    public boolean isGapLeftOfSelection() {
        return false;
    }

    @Override
    public void deleteGapLeftOfSelection() {
    }

    @Override
    public void deleteGapRightOfSelection() {
    }

    @Override
    public void replaceSelectedBasesWithChar(char newChar) {
    }

    public void realignNucleotidesUseThisAASequenceAsTemplate(byte[] allBasesAsByteArray) {
    }

    @Override
    public void selectAllBasesUntilGap(int x) {
    }

    @Override
    public int indexOf(char testChar) {
        logger.warn("This might take a long time");
        return super.indexOf(testChar);
    }

    @Override
    public int countChar(char targetChar, int startpos, int endpos) {
        logger.warn("This might take a long time");
        return super.countChar(targetChar, startpos, endpos);
    }

    @Override
    public int getUngapedLength() {
        logger.warn("this could take a lot of time and ruin memory");
        return -1;
    }

    @Override
    public int[] getSequenceAsBaseVals() {
        logger.warn("this could take a lot of time and ruin memory");
        return super.getSequenceAsBaseVals();
    }

    @Override
    public int getUngapedPos(int position) {
        logger.warn("this could take a lot of time");
        return super.getUngapedPos(position);
    }
}

