/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.Bases;
import org.apache.log4j.Logger;

public class FileSequenceBases
implements Bases {
    private static final Logger logger = Logger.getLogger(FileSequenceBases.class);
    private static final String TEXT_FILE_BYTE_ENCODING = "ASCII";
    protected MemoryMappedSequencesFile sequencesFile;
    private long startPointer;
    private long endPointer;
    private long sequenceAfterNameStartPointer;

    public FileSequenceBases(MemoryMappedSequencesFile sequencesFile, long startPointer, long endPointer, long sequenceAfterNameStartPointer) {
        this.sequencesFile = sequencesFile;
        this.startPointer = startPointer;
        this.endPointer = endPointer;
        this.sequenceAfterNameStartPointer = sequenceAfterNameStartPointer;
    }

    public FileSequenceBases(MemoryMappedSequencesFile sequencesFile, long startPointer) {
        this.sequencesFile = sequencesFile;
        this.startPointer = startPointer;
    }

    @Override
    public FileSequenceBases getCopy() {
        return new FileSequenceBases(this.sequencesFile, this.startPointer, this.endPointer, this.sequenceAfterNameStartPointer);
    }

    @Override
    public int getLength() {
        long len = this.getEndPointer() - this.getStartPointer() - (this.getSequenceAfterNameStartPointer() - this.getStartPointer());
        return (int)len;
    }

    protected long getSequenceAfterNameStartPointer() {
        return this.sequenceAfterNameStartPointer;
    }

    protected long getStartPointer() {
        return this.startPointer;
    }

    protected long getEndPointer() {
        return this.endPointer;
    }

    protected void setEndPointer(long end) {
        this.endPointer = end;
    }

    protected void setSequenceAfterNameStartPointer(long seqStartPointer) {
        this.sequenceAfterNameStartPointer = seqStartPointer;
    }

    @Override
    public byte get(int n) {
        return (byte)this.sequencesFile.readInFile(this.getSequenceAfterNameStartPointer() + (long)n);
    }

    @Override
    public char charAt(int n) {
        return (char)this.get(n);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(0, this.getLength() - 1);
    }

    @Override
    public byte[] toByteArray(int startIndexInclusive, int endIndexInclusive) {
        if (this.getLength() > 100000000) {
            return null;
        }
        int subSize = endIndexInclusive - startIndexInclusive + 1;
        if (subSize >= 0) {
            byte[] subarray = new byte[subSize];
            int subIndex = 0;
            for (int n = startIndexInclusive; n <= endIndexInclusive; ++n) {
                subarray[subIndex] = this.get(n);
                ++subIndex;
            }
            return subarray;
        }
        return null;
    }

    @Override
    public String toString() {
        logger.warn("Maybe string could be to big....");
        return super.toString();
    }

    @Override
    public void set(int n, byte newBase) {
    }

    private void assureSize(int n) {
    }

    private void resize(int n) {
    }

    @Override
    public void append(byte[] newBytes) {
    }

    @Override
    public void moveBaseLeft(int n) {
    }

    @Override
    public void moveBaseRight(int n) {
    }

    @Override
    public void insertAt(int n, byte[] newBytes) {
    }

    @Override
    public void replace(int startReplaceIndex, int stopReplaceIndex, byte[] insertBases) {
    }

    @Override
    public void deleteAll(byte target) {
    }

    @Override
    public void delete(int[] toDelete) {
    }

    @Override
    public void complement() {
    }

    @Override
    public void reverse() {
    }

    @Override
    public void set(int n, char c) {
    }

    @Override
    public void delete(int pos) {
    }

    @Override
    public void insertAt(int n, byte newByte) {
    }
}

