/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.FileSequenceBases;
import aliview.sequences.PositionToPointer;
import aliview.sequences.PositionsToPointer;
import org.apache.log4j.Logger;

public class PositionsToPointerFileSequenceBases
extends FileSequenceBases {
    private static final Logger logger = Logger.getLogger(PositionsToPointerFileSequenceBases.class);
    private static final String TEXT_FILE_BYTE_ENCODING = "ASCII";
    PositionsToPointer positionsToPointer = new PositionsToPointer();

    public PositionsToPointerFileSequenceBases(MemoryMappedSequencesFile sequencesFile, long startPointer) {
        super(sequencesFile, startPointer);
    }

    @Override
    public PositionsToPointerFileSequenceBases getCopy() {
        PositionsToPointerFileSequenceBases copy = new PositionsToPointerFileSequenceBases(this.sequencesFile, this.getStartPointer());
        copy.positionsToPointer = this.positionsToPointer.getCopy();
        return copy;
    }

    public void add(PositionToPointer posToPoint) {
        this.positionsToPointer.add(posToPoint);
    }

    @Override
    public long getEndPointer() {
        return this.positionsToPointer.getMaxPointer();
    }

    @Override
    public byte get(int n) {
        long pos = this.positionsToPointer.getPointerFromPos(n);
        return (byte)this.sequencesFile.readInFile(pos);
    }

    @Override
    public int getLength() {
        int length = this.positionsToPointer.getMaxPosition() + 1;
        return length;
    }
}

