/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.AminoAcid;
import aliview.NucleotideUtilities;
import aliview.sequences.Sequence;
import java.util.Arrays;
import org.apache.log4j.Logger;

public final class SequenceUtils {
    private static final Logger logger = Logger.getLogger(SequenceUtils.class);
    public static final byte GAP_SYMBOL = 45;
    public static final byte MISSING_SYMBOL = 63;
    public static int TYPE_AMINO_ACID = 0;
    public static int TYPE_NUCLEIC_ACID = 1;
    public static int TYPE_UNKNOWN = 2;
    public static int id_counter;

    public static byte[] createGapByteArray(int length) {
        byte[] byteSeq = new byte[length];
        Arrays.fill(byteSeq, (byte)45);
        return byteSeq;
    }

    public static int createID() {
        return ++id_counter;
    }

    public static int countExactNucleotideOverlap(Sequence seq1, Sequence seq2) {
        int nExactOverlap = 0;
        int nDifferentOverlap = 0;
        for (int n = 0; n < seq1.getLength(); ++n) {
            if (NucleotideUtilities.isAtLeastOneGap(seq1.getBaseAtPos(n), seq2.getBaseAtPos(n))) continue;
            if (NucleotideUtilities.baseValFromBase(seq1.getBaseAtPos(n)) == NucleotideUtilities.baseValFromBase(seq2.getBaseAtPos(n))) {
                ++nExactOverlap;
                continue;
            }
            ++nDifferentOverlap;
        }
        return nExactOverlap;
    }

    public static boolean isSeqResiduesIdentical(Sequence seq1, Sequence seq2) {
        if (seq1.getLength() != seq2.getLength()) {
            return false;
        }
        for (int n = 0; n < seq1.getLength(); ++n) {
            if (Character.toLowerCase(seq1.getCharAtPos(n)) == Character.toLowerCase(seq2.getCharAtPos(n))) continue;
            return false;
        }
        return true;
    }

    public static int countDifferentNucleotideOverlap(Sequence seq1, Sequence seq2) {
        int nExactOverlap = 0;
        int nDifferentOverlap = 0;
        for (int n = 0; n < seq1.getLength(); ++n) {
            if (NucleotideUtilities.isAtLeastOneGap(seq1.getBaseAtPos(n), seq2.getBaseAtPos(n))) continue;
            if (NucleotideUtilities.baseValFromBase(seq1.getBaseAtPos(n)) == NucleotideUtilities.baseValFromBase(seq2.getBaseAtPos(n))) {
                ++nExactOverlap;
                continue;
            }
            ++nDifferentOverlap;
        }
        return nDifferentOverlap;
    }

    public static int countDifferentAminoAcidOverlap(Sequence seq1, Sequence seq2) {
        int nExactOverlap = 0;
        int nDifferentOverlap = 0;
        for (int n = 0; n < seq1.getLength(); ++n) {
            if (AminoAcid.isGap(seq1.getBaseAtPos(n)) || AminoAcid.isGap(seq2.getBaseAtPos(n))) continue;
            if (AminoAcid.getAminoAcidFromByte(seq1.getBaseAtPos(n)) == AminoAcid.getAminoAcidFromByte(seq2.getBaseAtPos(n))) {
                ++nExactOverlap;
                continue;
            }
            ++nDifferentOverlap;
        }
        return nDifferentOverlap;
    }

    public static int countExactAminoAcidOverlap(Sequence seq1, Sequence seq2) {
        int nExactOverlap = 0;
        int nDifferentOverlap = 0;
        for (int n = 0; n < seq1.getLength(); ++n) {
            if (AminoAcid.isGap(seq1.getBaseAtPos(n)) || AminoAcid.isGap(seq2.getBaseAtPos(n))) continue;
            if (AminoAcid.getAminoAcidFromByte(seq1.getBaseAtPos(n)) == AminoAcid.getAminoAcidFromByte(seq2.getBaseAtPos(n))) {
                ++nExactOverlap;
                continue;
            }
            ++nDifferentOverlap;
        }
        return nExactOverlap;
    }
}

