/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.AminoAcid;
import aliview.GeneticCode;
import aliview.NucleotideUtilities;
import aliview.sequences.AminoAcidAndPosition;
import aliview.sequences.Bases;
import aliview.sequences.Sequence;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import utils.nexus.CodonPos;
import utils.nexus.CodonPositions;

public class TranslatedBases
implements Bases {
    private static final Logger logger = Logger.getLogger(TranslatedBases.class);
    private static final String TEXT_FILE_BYTE_ENCODING = "ASCII";
    private Bases delegate;
    private Sequence parentSequence;
    private int cachedClosestTranslatedNucleotideStartPos = -1;
    private int cachedAminoTripletAcidPos = -1;
    private AminoAcid cachedAminoAcid;

    public TranslatedBases(Bases delegate, Sequence sequence) {
        this.delegate = delegate;
        this.parentSequence = sequence;
    }

    @Override
    public TranslatedBases getCopy() {
        logger.debug("delegate.getLength()" + this.delegate.getLength());
        logger.debug("delegate.getCopy().getLength()" + this.delegate.getCopy().getLength());
        return new TranslatedBases(this.delegate.getCopy(), this.parentSequence);
    }

    @Override
    public int getLength() {
        return this.getTranslatedAminAcidSequenceLength();
    }

    @Override
    public byte get(int n) {
        return this.getAAinTranslatedPos(n).getCodeByteVal();
    }

    @Override
    public void moveBaseLeft(int n) {
        int nTrans = this.getCodonPosInTranslatedPos((int)n).startPos;
        this.delegate.set(nTrans - 3, this.delegate.get(nTrans));
        this.delegate.set(nTrans - 2, this.delegate.get(nTrans + 1));
        this.delegate.set(nTrans - 1, this.delegate.get(nTrans + 2));
    }

    @Override
    public void moveBaseRight(int n) {
        int nTrans = this.getCodonPosInTranslatedPos((int)n).startPos;
        this.delegate.set(nTrans + 3, this.delegate.get(nTrans));
        this.delegate.set(nTrans + 4, this.delegate.get(nTrans + 1));
        this.delegate.set(nTrans + 5, this.delegate.get(nTrans + 2));
    }

    @Override
    public char charAt(int n) {
        return this.getAAinTranslatedPos(n).getCodeCharVal();
    }

    @Override
    public byte[] toByteArray() {
        return this.getTranslatedAsString().getBytes();
    }

    @Override
    public byte[] toByteArray(int startIndexInclusive, int endIndexInclusive) {
        byte[] subArray = ArrayUtils.subarray(this.toByteArray(), startIndexInclusive, endIndexInclusive + 1);
        return subArray;
    }

    @Override
    public String toString() {
        Object asString = null;
        return this.getTranslatedAsString();
    }

    @Override
    public void set(int n, byte aaAsByte) {
        this.replace(n, n, new byte[]{aaAsByte});
    }

    private byte[] getTripletsFromAA(byte[] inAAs) {
        StringBuilder triplets = new StringBuilder(inAAs.length * 3);
        for (byte aaAsByte : inAAs) {
            byte[] triplet = this.getTripletFromAA(aaAsByte);
            triplets.append(new String(triplet));
        }
        return triplets.toString().getBytes();
    }

    private byte[] getTripletFromAA(byte aaAsByte) {
        byte[] bytes = "---".getBytes();
        return bytes;
    }

    @Override
    public void insertAt(int n, byte[] aminoAAs) {
        byte[] triplets = this.getTripletsFromAA(aminoAAs);
        int nucleotidePos = this.getCodonPosInTranslatedPos((int)n).startPos;
        this.delegate.insertAt(nucleotidePos, triplets);
    }

    @Override
    public void replace(int startReplaceIndex, int stopReplaceIndex, byte[] insertAAs) {
        byte[] triplets = this.getTripletsFromAA(insertAAs);
        int nucleotidePos = this.getCodonPosInTranslatedPos((int)startReplaceIndex).startPos;
        this.delegate.replace(nucleotidePos, nucleotidePos + triplets.length - 1, triplets);
    }

    @Override
    public void delete(int[] toDeletePos) {
        int[] toDeleteArray;
        ArrayList<Integer> toDeleteNucleotidePos = new ArrayList<Integer>();
        for (int aaPos : toDeletePos) {
            CodonPos codon = this.getCodonPosInTranslatedPos(aaPos);
            for (int n = codon.startPos; n <= codon.endPos; ++n) {
                toDeleteNucleotidePos.add(new Integer(n));
            }
        }
        for (int toDel : toDeleteArray = ArrayUtils.toPrimitive(toDeleteNucleotidePos.toArray(new Integer[0]))) {
            logger.info("toDel" + toDel);
        }
        this.delegate.delete(toDeleteArray);
    }

    @Override
    public void deleteAll(byte val) {
    }

    @Override
    public void complement() {
        this.delegate.complement();
    }

    @Override
    public void reverse() {
        this.delegate.reverse();
    }

    @Override
    public void set(int n, char c) {
        this.set(n, (byte)c);
    }

    @Override
    public void delete(int pos) {
        this.delete(new int[]{pos});
    }

    @Override
    public void insertAt(int n, byte newByte) {
        this.insertAt(n, new byte[]{newByte});
    }

    @Override
    public void append(byte[] newBytes) {
        this.insertAt(this.getLength(), newBytes);
    }

    private CodonPositions getCodonPositions() {
        return this.parentSequence.getAlignmentModel().getAlignmentMeta().getCodonPositions();
    }

    private GeneticCode getGeneticCode() {
        return this.parentSequence.getAlignmentModel().getAlignmentMeta().getGeneticCode();
    }

    private boolean isFullCodonStartingAt(int x) {
        return this.getCodonPositions().isFullCodonStartingAt(x);
    }

    public AminoAcid getAminoAcidAtNucleotidePos(int x) {
        if (this.isFullCodonStartingAt(x)) {
            return this.getAminoAcidFromTripletStartingAt(x);
        }
        if (this.isFullCodonStartingAt(x - 1)) {
            return this.getAminoAcidFromTripletStartingAt(x - 1);
        }
        if (this.isFullCodonStartingAt(x - 2)) {
            return this.getAminoAcidFromTripletStartingAt(x - 2);
        }
        return AminoAcid.GAP;
    }

    public boolean isCodonSecondPos(int x) {
        return this.isFullCodonStartingAt(x - 1);
    }

    public byte[] getTripletAt(int x) {
        byte[] codon = new byte[3];
        for (int n = 0; n < 3; ++n) {
            codon[n] = x + n < this.delegate.getLength() ? this.delegate.get(x + n) : (byte)45;
        }
        return codon;
    }

    public int getCachedClosestStartPos() {
        return this.cachedClosestTranslatedNucleotideStartPos;
    }

    public AminoAcidAndPosition getNoGapAminoAcidAtNucleotidePos(int target) {
        int tripCount = 0;
        byte[] triplet = new byte[3];
        int seqLen = this.delegate.getLength();
        int startPos = 0;
        if (this.cachedClosestTranslatedNucleotideStartPos == -1 || target < this.cachedClosestTranslatedNucleotideStartPos) {
            int skipCount = 0;
            int readingFrame = this.getCodonPositions().getReadingFrame();
            if (readingFrame > 1) {
                for (int n = 0; n < seqLen; ++n) {
                    byte base = this.delegate.get(n);
                    if (!NucleotideUtilities.isGap(base) && this.getCodonPositions().isCoding(n)) {
                        ++skipCount;
                    }
                    if (skipCount != readingFrame) continue;
                    startPos = n;
                }
            }
        } else {
            startPos = this.cachedClosestTranslatedNucleotideStartPos;
        }
        if (target >= startPos) {
            for (int n = startPos; n < seqLen; ++n) {
                byte base = this.delegate.get(n);
                if (NucleotideUtilities.isGap(base) || this.getCodonPositions().isNonCoding(n)) {
                    if (n < target || tripCount != 0) continue;
                    return new AminoAcidAndPosition(AminoAcid.GAP, startPos);
                }
                triplet[++tripCount - 1] = base;
                if (tripCount == 1) {
                    this.cachedClosestTranslatedNucleotideStartPos = n;
                }
                if (tripCount != 3) continue;
                if (n >= target) {
                    AminoAcid aa = AminoAcid.getAminoAcidFromCodon(triplet, this.getGeneticCode());
                    return new AminoAcidAndPosition(aa, startPos);
                }
                triplet = new byte[3];
                tripCount = 0;
            }
            return new AminoAcidAndPosition(AminoAcid.X, startPos);
        }
        return new AminoAcidAndPosition(AminoAcid.GAP, startPos);
    }

    public AminoAcid getAminoAcidFromTripletStartingAt(int x) {
        if (this.cachedAminoTripletAcidPos != x) {
            this.cachedAminoTripletAcidPos = x;
            this.cachedAminoAcid = AminoAcid.getAminoAcidFromCodon(this.getTripletAt(this.cachedAminoTripletAcidPos), this.getGeneticCode());
        }
        return this.cachedAminoAcid;
    }

    public String getTranslatedAsString() {
        StringWriter out = new StringWriter(this.delegate.getLength() / 3);
        this.writeTranslation(out);
        return out.toString();
    }

    public void writeTranslation(Writer out) {
        int x = 0;
        int gap = 0;
        try {
            while (x < this.delegate.getLength()) {
                if (this.isFullCodonStartingAt(x)) {
                    byte[] codon = this.getTripletAt(x);
                    out.append(AminoAcid.getAminoAcidFromCodon(codon).getCodeCharVal());
                    gap = 0;
                    x += 3;
                    continue;
                }
                if (++gap % 3 == 1) {
                    out.append(AminoAcid.X.getCodeCharVal());
                }
                ++x;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getTranslatedAminAcidSequenceLength() {
        if (this.delegate.getLength() == 0) {
            return 0;
        }
        int lastPos = this.getCodonPositions().getAminoAcidPosFromNucleotidePos(this.delegate.getLength() - 1);
        return lastPos + 1;
    }

    public AminoAcid getAAinTranslatedPos(int x) {
        CodonPos codonPos = this.getCodonPositions().getCodonInTranslatedPos(x);
        if (codonPos == null) {
            return null;
        }
        if (!codonPos.isCoding()) {
            return AminoAcid.X;
        }
        byte[] codon = this.getTripletAt(codonPos.startPos);
        AminoAcid aa = AminoAcid.getAminoAcidFromCodon(codon, this.getGeneticCode());
        return aa;
    }

    public byte[] getGapPaddedCodonInTranslatedPos(int x) {
        byte[] codon = this.getCodonInTranslatedPos(x);
        if (codon.length != 3) {
            byte[] padded = new byte[3];
            Arrays.fill(padded, (byte)45);
            for (int n = 0; n < codon.length; ++n) {
                padded[n] = codon[n];
            }
            codon = padded;
        }
        return codon;
    }

    private CodonPos getCodonPosInTranslatedPos(int x) {
        return this.getCodonPositions().getCodonInTranslatedPos(x);
    }

    public byte[] getCodonInTranslatedPos(int x) {
        CodonPos codonPos = this.getCodonPositions().getCodonInTranslatedPos(x);
        byte[] codon = this.getNucleotidesAtCodon(codonPos);
        return codon;
    }

    private byte[] getNucleotidesAtCodon(CodonPos codonPos) {
        if (codonPos == null || codonPos.startPos >= this.delegate.getLength()) {
            return new byte[]{45};
        }
        int start = codonPos.startPos;
        int end = Math.min(codonPos.endPos, this.delegate.getLength() - 1);
        byte[] codonBytes = new byte[end - start + 1];
        for (int n = start; n <= end; ++n) {
            codonBytes[n - start] = this.delegate.get(n);
        }
        return codonBytes;
    }

    public int countStopCodon() {
        int counter = 0;
        int transLen = this.getTranslatedAminAcidSequenceLength();
        for (int n = 0; n < transLen; ++n) {
            AminoAcid aa = this.getAAinTranslatedPos(n);
            if (aa != AminoAcid.STOP) continue;
            ++counter;
        }
        return counter;
    }
}

